/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.xml.sax.SAXException;

public class OracleXMLDocGenLob
extends OracleXMLDocGen {
    static final int MAX_CHUNK_SIZE = 32512;
    Hashtable namespaces;
    OracleConnection conn;
    char[] buf;
    int buflen;
    int currSize;
    long currPos = 1L;
    private int append_len;
    private int append_spaceLeft;
    private static final char[] LPAREN_WQMARK = new char[]{'<', '?'};
    private static final char[] LPAREN_WSLASH = new char[]{'<', '/'};
    private static final char[] RPAREN_WQMARK = new char[]{'?', '>', '\n'};
    private static final char[] RPAREN_WSLASH = new char[]{'/', '>', '\n'};
    private static final char[] SYMB = new char[]{'=', '\"'};
    private static final char[] WSPCS = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] LESS_THEN_REP = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER_THEN_REP = new char[]{'&', 'g', 't', ';'};
    private static final char[] AMP_REP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOTE_REP = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private int level;
    private int entryLevel;
    private CLOB clb;
    static final int UNINITIALIZED_STATE = 0;
    static final int NEWELEMENT_STATE = 1;
    static final int ENDELEMENT_STATE = 2;
    static final int ADDTEXTVALUE_STATE = 3;
    static final int ADDATTRIBUTE_STATE = 4;
    private int docState = 0;
    private boolean isFragment = false;

    public OracleXMLDocGenLob(Connection connection, CLOB cLOB, int n) {
        this.conn = (OracleConnection)connection;
        this.clb = cLOB;
        this.buflen = n;
        this.buf = new char[this.buflen];
    }

    public OracleXMLDocGenLob(Connection connection, CLOB cLOB) {
        try {
            this.conn = (OracleConnection)connection;
            this.clb = cLOB;
            this.buflen = this.getBufferSize();
            this.buf = new char[this.buflen];
            return;
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private int getBufferSize() throws SQLException {
        int n = this.clb.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public void createNewDocument(boolean bl) {
        if (bl) {
            this.level = 0;
            this.docState = 0;
            this.currSize = 0;
            if (this.currPos == 1L) {
                return;
            }
            OracleCallableStatement oracleCallableStatement = null;
            try {
                try {
                    oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall("begin dbms_lob.trim(?,0); end;");
                    oracleCallableStatement.setCLOB(1, this.clb);
                    oracleCallableStatement.execute();
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {
                    throw new OracleXMLSQLException(exception);
                }
                Object var4_4 = null;
                oracleCallableStatement = null;
                return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                oracleCallableStatement = null;
                throw throwable;
            }
        }
    }

    public void createProcessingInstruction(String string, String string2) {
        if (this.isFragment) {
            return;
        }
        this.append(LPAREN_WQMARK);
        this.append(string);
        this.append(WSPCS, 0, 1);
        this.append(string2);
        this.append(RPAREN_WQMARK);
    }

    public void setVersion(String string) {
        if (this.isFragment) {
            return;
        }
        if (this.encoding == null) {
            this.createProcessingInstruction("xml", "version = '" + string + "'");
            return;
        }
        this.createProcessingInstruction("xml", "version = '" + string + "' " + "encoding = '" + this.encoding + "'");
    }

    public Object startNewElement(String string) {
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WQMARK, 1, 3);
        }
        this.addIndent(this.level);
        this.append(LPAREN_WQMARK, 0, 1);
        this.append(string);
        ++this.level;
        this.docState = 1;
        return string;
    }

    public void addTextValue(String string, boolean bl) {
        this.append(RPAREN_WQMARK, 1, 2);
        if (string != null) {
            if (bl) {
                this.convertString(string);
            } else {
                this.append(string);
            }
        }
        this.docState = 3;
    }

    private void convertString(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '&' || c == '<' || c == '>' || c == '\"') {
                this.append(string, n, n3);
                n = n3 + 1;
                switch (c) {
                    case '<': {
                        this.append(LESS_THEN_REP);
                        break;
                    }
                    case '>': {
                        this.append(GREATER_THEN_REP);
                        break;
                    }
                    case '&': {
                        this.append(AMP_REP);
                        break;
                    }
                    case '\"': {
                        this.append(QUOTE_REP);
                        break;
                    }
                }
            }
            ++n3;
        }
        if (n < n2) {
            this.append(string, n, n2);
        }
    }

    public void endElement(Object object) {
        String string = (String)object;
        --this.level;
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WSLASH);
        } else {
            if (this.docState != 3) {
                this.addIndent(this.level);
            }
            this.append(LPAREN_WSLASH);
            this.append(string);
            this.append(RPAREN_WSLASH, 1, 3);
        }
        this.docState = 2;
    }

    public void addAttribute(String string, String string2) {
        this.append(WSPCS, 0, 1);
        this.append(string);
        this.append(SYMB, 0, 2);
        this.append(string2);
        this.append(SYMB, 1, 2);
    }

    public String getXMLDocumentString() {
        try {
            return this.clb.getSubString(1L, (int)this.clb.length());
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception.getMessage());
        }
    }

    private void addIndent(int n) {
        if (n <= 9) {
            this.append(WSPCS, 0, 3 * n);
            return;
        }
        int n2 = n / 9;
        while (n2 > 0) {
            this.append(WSPCS);
            --n2;
        }
        this.append(WSPCS, 0, 3 * (n % 9));
    }

    public void appendDTD(String string) {
        this.append(string);
    }

    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        this.append(RPAREN_WSLASH, 1, 3);
        if (reader == null) {
            return;
        }
        this.append(reader);
        this.docState = 3;
    }

    public Object getDocFragment() {
        if (!this.isFragment) {
            return null;
        }
        return new String(this.buf);
    }

    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        return null;
    }

    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.isFragment) {
            return;
        }
        if (this.docState == 4 || this.docState == 1) {
            this.append(RPAREN_WSLASH, 1, 3);
            this.docState = 2;
        }
        this.append((String)oracleXMLDocGen.getDocFragment());
    }

    public String addNamespace(String string, String string2) {
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    public void flush() {
        try {
            if (this.currSize > 0) {
                char[] cArray = new char[this.currSize];
                System.arraycopy(this.buf, 0, cArray, 0, this.currSize);
                this.clb.putChars(this.currPos, cArray);
                this.currPos += (long)this.currSize;
                this.currSize = 0;
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private void append(char[] cArray) {
        this.append(cArray, 0, cArray.length);
    }

    private void append(Reader reader) {
        try {
            int n;
            this.flush();
            while ((n = reader.read(this.buf)) != -1) {
                this.currSize += n;
                if (this.currSize != this.buflen) continue;
                this.clb.putChars(this.currPos, this.buf);
                this.currPos += (long)this.buflen;
                this.currSize = 0;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new OracleXMLSQLException(exception);
        }
    }

    private void append(char[] cArray, int n, int n2) {
        this.append_len = n2 - n;
        if (this.append_len <= 0) {
            return;
        }
        this.append_spaceLeft = this.buflen - this.currSize;
        try {
            if (this.append_len > this.append_spaceLeft) {
                if (this.buflen != this.currSize) {
                    System.arraycopy(cArray, n, this.buf, this.currSize, this.append_spaceLeft);
                }
                this.clb.putChars(this.currPos, this.buf);
                this.currPos += (long)this.buflen;
                this.currSize = this.append_len - this.append_spaceLeft;
                System.arraycopy(cArray, n + this.append_spaceLeft, this.buf, 0, this.currSize);
                return;
            }
            System.arraycopy(cArray, n, this.buf, this.currSize, this.append_len);
            this.currSize += this.append_len;
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new OracleXMLSQLException(sQLException);
        }
    }

    private void append(String string) {
        this.append(string, 0, string.length());
    }

    private void append(String string, int n, int n2) {
        try {
            this.append_len = n2 - n;
            if (this.append_len <= 0) {
                return;
            }
            this.append_spaceLeft = this.buflen - this.currSize;
            if (this.append_len > this.append_spaceLeft) {
                if (this.buflen != this.currSize) {
                    string.getChars(n, n + this.append_spaceLeft, this.buf, this.currSize);
                }
                this.clb.putChars(this.currPos, this.buf);
                this.currPos += (long)this.buflen;
                this.currSize = this.append_len - this.append_spaceLeft;
                string.getChars(n + this.append_spaceLeft, n2, this.buf, 0);
                return;
            }
            string.getChars(n, n2, this.buf, this.currSize);
            this.currSize += this.append_len;
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new OracleXMLSQLException(sQLException);
        }
    }

    public boolean supportMetatype(int n) {
        return n == 1;
    }
}

