/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.query;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.gss.util.NLSLocale;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.CLOB;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenDOM;
import oracle.xml.sql.docgen.OracleXMLDocGenLob;
import oracle.xml.sql.query.OracleXMLQuery;

public class OracleXMLStaticQuery {
    private static final String DBENCODING = "_";
    private static Connection conn = null;
    private static String connEnc = null;
    private static Hashtable ctxPool = new Hashtable(10);
    private static int ctxHdlSeq;
    private static MutableInt ctxHdlWrap;
    private static XSUMesg msg;

    public static int newContext(String string) throws SQLException {
        return OracleXMLStaticQuery.newContext(new StringReader(string));
    }

    public static int newContext(CLOB cLOB) throws SQLException {
        return OracleXMLStaticQuery.newContext(cLOB.getCharacterStream());
    }

    private static int newContext(Reader reader) throws SQLException {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
            connEnc = System.getProperty("file.encoding");
            connEnc = NLSLocale.getInstance().getIANACharset(1, connEnc);
        }
        QueryCtx queryCtx = new QueryCtx(reader);
        OracleXMLStaticQuery.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, queryCtx);
        return ctxHdlSeq++;
    }

    public static void closeContext(int n) throws SQLException {
        OracleXMLStaticQuery.ctxHdlWrap.value = n;
        QueryCtx queryCtx = (QueryCtx)ctxPool.remove(ctxHdlWrap);
        if (queryCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        queryCtx.close();
    }

    private static QueryCtx getCtx(int n) {
        OracleXMLStaticQuery.ctxHdlWrap.value = n;
        QueryCtx queryCtx = (QueryCtx)ctxPool.get(ctxHdlWrap);
        if (queryCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        return queryCtx;
    }

    public static void setRowsetTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowsetTag(string);
    }

    public static void setRowTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowTag(string);
    }

    public static void setErrorTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setErrorTag(string);
    }

    public static void setRowIdAttrName(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowIdAttrName(string);
    }

    public static void setRowIdAttrValue(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowIdAttrValue(string);
    }

    public static void setCollIdAttrName(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setCollIdAttrName(string);
    }

    public static void useNullAttributeIndicator(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.useNullAttributeIndicator(by != 0);
    }

    public static void setTagCase(int n, byte by) {
        if (by == 1) {
            OracleXMLStaticQuery.getCtx(n).query.useLowerCaseTagNames();
            return;
        }
        if (by == 2) {
            OracleXMLStaticQuery.getCtx(n).query.useUpperCaseTagNames();
        }
    }

    public static void setDateFormat(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setDateFormat(string);
    }

    public static void setMaxRows(int n, int n2) {
        OracleXMLStaticQuery.getCtx(n).query.setMaxRows(n2);
    }

    public static void setSkipRows(int n, int n2) {
        OracleXMLStaticQuery.getCtx(n).query.setSkipRows(n2);
    }

    public static void setStylesheetHeader(int n, String string, String string2) {
        OracleXMLStaticQuery.getCtx(n).query.setStylesheetHeader(string, string2);
    }

    public static void setXSLT(int n, String string, String string2) {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        queryCtx.xsltSet = string != null;
        queryCtx.query.setXSLT(string, string2);
    }

    public static void setXSLT(int n, CLOB cLOB, String string) throws SQLException {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Reader reader = null;
        if (cLOB != null) {
            reader = cLOB.getCharacterStream();
            queryCtx.xsltSet = true;
        } else {
            queryCtx.xsltSet = false;
            reader = null;
        }
        OracleXMLStaticQuery.getCtx(n).query.setXSLT(reader, string);
    }

    public static void setEncodingTag(int n, String string) {
        if (string != null && string.compareTo(DBENCODING) == 0) {
            OracleXMLStaticQuery.getCtx(n).query.setEncoding(connEnc);
            return;
        }
        OracleXMLStaticQuery.getCtx(n).query.setEncoding(string);
    }

    public static void setBindValue(int n, String string, String string2) {
        Exception exception = null;
        try {
            OracleXMLStaticQuery.getCtx(n).dset.bindValue(string, string2);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            OracleXMLStaticQuery.getCtx(n).query.setException(exception);
        }
    }

    public static void setMetaHeader(int n, CLOB cLOB) throws SQLException {
        OracleXMLStaticQuery.getCtx(n).query.setMetaHeader(cLOB.getCharacterStream());
    }

    public static void setDataHeader(int n, CLOB cLOB, String string) throws SQLException {
        OracleXMLStaticQuery.getCtx(n).query.setDataHeader(cLOB.getCharacterStream(), string);
    }

    public static void setRaiseException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.setRaiseException(by != 0);
    }

    public static void setRaiseNoRowsException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.setRaiseNoRowsException(by != 0);
    }

    public static void propagateOriginalException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).propOriginalExc = by != 0;
    }

    public static void getExceptionContent(int n, int[] nArray, String[] stringArray) {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        nArray[0] = queryCtx.errCode;
        stringArray[0] = queryCtx.errMsg;
    }

    public static void getDTD(int n, CLOB cLOB, byte by) throws Exception {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        try {
            queryCtx.dset.refreshDataSet();
            OracleXMLDocGenLob oracleXMLDocGenLob = new OracleXMLDocGenLob(conn, cLOB);
            queryCtx.query.getXMLMetaData(1, by != 0, oracleXMLDocGenLob);
            oracleXMLDocGenLob.flush();
            return;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            queryCtx.errCode = oracleXMLSQLException.getErrorCode();
            queryCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw queryCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static void getXML(int n, CLOB cLOB, byte by) throws Exception {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Writer writer = null;
        try {
            OracleXMLDocGen oracleXMLDocGen;
            queryCtx.dset.refreshDataSet();
            if (queryCtx.xsltSet) {
                oracleXMLDocGen = new OracleXMLDocGenDOM();
                writer = cLOB.getCharacterOutputStream();
            } else {
                oracleXMLDocGen = new OracleXMLDocGenLob(conn, cLOB);
            }
            queryCtx.query.getXML(oracleXMLDocGen, by);
            if (!queryCtx.xsltSet) {
                ((OracleXMLDocGenLob)oracleXMLDocGen).flush();
                return;
            }
            ((OracleXMLDocGenDOM)oracleXMLDocGen).print(writer);
            return;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            queryCtx.errCode = oracleXMLSQLException.getErrorCode();
            queryCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw queryCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static String getXML(int n, byte by) throws Exception {
        OracleXMLDocGen oracleXMLDocGen;
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Writer writer = null;
        CLOB cLOB = OracleXMLDataSetExtJdbc.createTempCLOBFromString(conn, "hi:  \n", null);
        queryCtx.dset.refreshDataSet();
        if (queryCtx.xsltSet) {
            oracleXMLDocGen = new OracleXMLDocGenDOM();
            writer = cLOB.getCharacterOutputStream();
        } else {
            oracleXMLDocGen = new OracleXMLDocGenLob(conn, cLOB);
        }
        queryCtx.query.getXML(oracleXMLDocGen, by);
        if (!queryCtx.xsltSet) {
            ((OracleXMLDocGenLob)oracleXMLDocGen).flush();
        } else {
            ((OracleXMLDocGenDOM)oracleXMLDocGen).print(writer);
        }
        return cLOB.getSubString(1L, (int)cLOB.length());
    }

    public static int newContext(Connection connection, String string) throws SQLException {
        conn = connection;
        if (connEnc == null) {
            connEnc = System.getProperty("file.encoding");
            connEnc = NLSLocale.getInstance().getIANACharset(1, connEnc);
        }
        QueryCtx queryCtx = new QueryCtx(new StringReader(string));
        OracleXMLStaticQuery.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, queryCtx);
        return ctxHdlSeq++;
    }

    static {
        ctxHdlWrap = new MutableInt();
        msg = new XSUMesg();
    }

    private static class MutableInt {
        public int value;

        public int hashCode() {
            return this.value;
        }

        MutableInt() {
        }
    }

    private static class QueryCtx {
        private OracleXMLQuery query;
        private OracleXMLDataSetExtJdbc dset;
        private boolean propOriginalExc = false;
        private int errCode;
        private String errMsg;
        private boolean xsltSet = false;

        QueryCtx(Reader reader) {
            Exception exception = null;
            try {
                this.dset = new OracleXMLDataSetExtJdbc(conn, new BufferedReader(reader));
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            this.query = new OracleXMLQuery(this.dset);
            if (exception != null) {
                this.query.setException(exception);
            }
        }

        private void close() throws SQLException {
            this.query.close();
            this.dset.close();
        }
    }
}

