/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.ACPAttrList;
import oracle.ldap.admin.ACPStructList;
import oracle.ldap.admin.AccessCtrlPoints;
import oracle.ldap.admin.AttrAccessItem;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AccessCtrlPoint
extends Entry {
    static final int PR_ACP_DN = 1462273;
    static final int PR_ACP_NAME = 1462274;
    String m_dispName;
    String m_desc = "";
    IAdminProp[] m_cmdList;
    AccessCtrlPoints m_container;
    AccessCtrlPoint m_replacement;

    public AccessCtrlPoint() {
    }

    public AccessCtrlPoint(Root root, String string, String string2, Object[] objectArray, AccessCtrlPoints accessCtrlPoints) {
        super(root, null, string, objectArray, true);
        if (string2 == null || string2.equals("")) {
            string2 = LDAPLang.getStrDefaultAcp();
        }
        this.init(string2, accessCtrlPoints);
    }

    public AccessCtrlPoint(Root root, String string, String string2, Object[] objectArray, boolean bl, AccessCtrlPoints accessCtrlPoints) {
        super(root, null, string, objectArray, bl);
        if (string2 == null || string2.equals("")) {
            string2 = LDAPLang.getStrDefaultAcp();
        }
        this.init(string2, accessCtrlPoints);
    }

    void init(String string, AccessCtrlPoints accessCtrlPoints) {
        this.m_dispName = string;
        this.m_container = accessCtrlPoints;
        this.m_orclACI.setAccessCtrlPoint(this);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(1462274, LDAPLang.getStrNamePlbl(), LDAPLang.getStrNamePdsc1());
        this.registerProp(1462273, LDAPLang.getStrDnPlbl(), LDAPLang.getStrNamePdsc1());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "browsing_access_control_policy_points_acps_";
            }
            case 4785229: {
                return this.m_replacement;
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle1();
            }
            case 0x110001: {
                return this.m_dispName;
            }
            case 0x103000: {
                return this.m_desc;
            }
            case 1638408: {
                return "images/msques.gif";
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(0x8004 | this.m_status);
            }
            case 2163790: {
                return new Integer(0);
            }
            case 273612805: {
                return this.m_orclACI.getProp(273219601);
            }
            case 2687386: {
                return new Integer(48);
            }
            case 275776081: {
                return this.getAccessCntrlLayout(true);
            }
            case 272630352: {
                if (!this.m_parseAttr && this.m_dn != null) {
                    try {
                        String[] stringArray = new String[]{"orclACI"};
                        this.m_parent.m_serverAccess.findObjectSync(this.m_dn, stringArray, this);
                        this.m_container.update();
                        this.m_parseAttr = true;
                    }
                    catch (Exception exception) {
                        throw new PropertyException(exception);
                    }
                }
                return this.getAccessCntrlChildren(true);
            }
            case 1458176: 
            case 1462274: {
                return this.m_dispName;
            }
            case 1458177: 
            case 1462273: {
                if (this.getDn() != null && this.getDn().equals("")) {
                    return LDAPLang.getStrRoot();
                }
                return this.getDn();
            }
            case 273613313: {
                if (this.m_cmdList == null) {
                    IAdminProp[] iAdminPropArray = this.getDn() == null || this.getDn().equals("") ? new IAdminProp[3] : new IAdminProp[4];
                    int n2 = 0;
                    iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrCreateLabel(), LDAPLang.getStrCmdDecpNew(), "images/create.gif");
                    if (!this.hasSubSchema()) {
                        iAdminPropArray[n2 - 1].setProp(8978948, new Boolean(false));
                    }
                    iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -10, LDAPLang.getStrCreateLikeLabel1(), LDAPLang.getStrCreateLikeDescp7(), "images/createlike.gif");
                    if (!this.hasSubSchema()) {
                        iAdminPropArray[n2 - 1].setProp(8978948, new Boolean(false));
                    }
                    if (this.getDn() != null && !this.getDn().equals("")) {
                        iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrCmdDecpDelete(), "images/delete.gif");
                        iAdminPropArray[n2 - 1].setProp(1639168, LDAPLang.getStrDeleteConfirm());
                    }
                    iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), String.valueOf(LDAPLang.getStrRefreshDescp()) + "...", "images/refresh.gif");
                    iAdminPropArray[n2 - 1].setProp(2687509, new Integer(4));
                    this.m_cmdList = iAdminPropArray;
                }
                return this.m_cmdList;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1458176: 
            case 1462274: {
                this.m_dispName = ((String)object).trim();
                return;
            }
            case 0x103000: {
                this.m_desc = ((String)object).trim();
                return;
            }
        }
        super.setProp(n, object);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -5: {
                this.refresh(iAdminProp);
                return null;
            }
            case -10: {
                if (!this.m_parseAttr && this.m_attributes != null) {
                    this.parseSearchResult(this.m_attributes);
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this};
                iAdminProp.setProp(273220105, iAdminPropArray);
                return this.m_container.doCommand(iAdminProp);
            }
            case -8: {
                return this.m_container.doCommand(iAdminProp);
            }
            case -9: {
                this.delete(true);
            }
        }
        return null;
    }

    public void delete(boolean bl) throws PropertyException {
        this.removeOrclACI();
        this.m_container.removeChild(this);
        if (bl) {
            this.m_container.update();
        }
        this.m_bValid = false;
        this.makeInvalid();
    }

    public void refresh(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        try {
            String[] stringArray = new String[]{"orclACI"};
            this.m_parent.m_serverAccess.findObjectSync(this.m_dn, stringArray, this);
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
    }

    public void update(Object[] objectArray) {
        this.m_orclACI.removeAllChildren();
        this.m_orclEntryACI.removeAllChildren();
        this.m_attributes = objectArray;
        this.parseSearchResult(objectArray);
        this.m_orclACI.update();
        this.m_orclEntryACI.update();
    }

    public void reset() {
        if (this.m_structList == null) {
            this.m_structList = new ACPStructList(null, this);
        } else {
            this.m_structList.getChildren().removeAllElements();
        }
        if (this.m_attrList == null) {
            this.m_attrList = new ACPAttrList(null, this);
            return;
        }
        this.m_attrList.getChildren().removeAllElements();
    }

    public void copyTo(IAdminProp iAdminProp) throws PropertyException {
        if (iAdminProp instanceof AccessCtrlPoint) {
            AccessCtrlPoint accessCtrlPoint = (AccessCtrlPoint)iAdminProp;
            try {
                accessCtrlPoint.reset();
                if (this.m_structList == null) {
                    this.m_structList = new ACPStructList(this.m_orclACI, this);
                }
                int n = this.m_structList.countChildren();
                int n2 = 0;
                while (n2 < n) {
                    StructAccessItem structAccessItem = (StructAccessItem)this.m_structList.nthChild(n2);
                    accessCtrlPoint.m_structList.addChild(accessCtrlPoint.m_structList.createLike(structAccessItem));
                    accessCtrlPoint.m_structList.setDirty(true);
                    ++n2;
                }
                if (this.m_attrList == null) {
                    this.m_attrList = new ACPAttrList(this.m_orclACI, this);
                }
                n = this.m_attrList.countChildren();
                int n3 = 0;
                while (n3 < n) {
                    AttrAccessItem attrAccessItem = (AttrAccessItem)this.m_attrList.nthChild(n3);
                    accessCtrlPoint.m_attrList.addChild(accessCtrlPoint.m_attrList.createLike(attrAccessItem));
                    accessCtrlPoint.m_attrList.setDirty(true);
                    ++n3;
                }
                return;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            this.updateSubtreeAccessInfo();
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
        super.saveChanges(n);
    }

    public int[] getVisibleProps() {
        int[] nArray = new int[]{1462273};
        return nArray;
    }

    public void cleanup() {
        super.cleanup();
        this.m_dispName = null;
        this.m_desc = null;
        this.m_cmdList = null;
        this.m_container = null;
        this.m_replacement = null;
    }
}

