/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.ACPsSearch;
import oracle.ldap.admin.AccessCtrlPoint;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewAccessCtrlPoint;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class AccessCtrlPoints
extends AdminList
implements ICommandParent {
    static final int PR_BASE_DN = 0x103000;
    static final int PR_ACPS_COUNT = 2109441;
    static final int PR_SEARCH_TYPE = 1060866;
    static final int PR_SIZELIMIT_ERR = 0x803003;
    static final int PR_TIMELIMIT_ERR = 8400900;
    static final int CMD_CONFIGURE = -8197;
    static final String DN_OF_SUBSCHEMA = "cn=subschemasubentry";
    static final String DN_OF_REGISTRY = "cn=subregistrysubentry";
    static final String DN_OF_CONFIG = "cn=subconfigsubentry";
    static final String DN_OF_REPLAGREE = "cn=orclreplagreements";
    String m_basedn = "";
    String m_displayMsg;
    Object[] m_attrs;
    int m_sizeLimit = 200;
    int m_timeLimit = 360;
    String m_searchType;
    boolean m_sizeLimit_err = false;
    boolean m_timeLimit_err = false;
    int acpoption;

    public AccessCtrlPoints() {
    }

    public AccessCtrlPoints(Root root, String string, String string2, int n, int n2, String string3) {
        super(root);
        this.setDisplayName(string);
        this.m_basedn = string2;
        this.m_sizeLimit = n;
        this.m_timeLimit = n2;
        this.m_searchType = string3;
        this.init();
        this.acpoption = ((Root)this.m_parent).getAcpoption();
    }

    public AccessCtrlPoints(Root root) {
        super(root);
        this.setDisplayName(LDAPLang.getStrAccessCtrlMgmt());
        this.init();
        this.acpoption = ((Root)this.m_parent).getAcpoption();
    }

    void init() {
        this.setIconName("images/msques.gif");
        this.setSampleChild(new AccessCtrlPoint());
        this.m_children = null;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103000, LDAPLang.getStrSearchRootPath(), LDAPLang.getStrSearchRootPathDescp());
        this.registerProp(2109441, LDAPLang.getStrACPsCount(), LDAPLang.getStrACPsCountDescp());
        this.registerProp(1060866, LDAPLang.getStrSearchTypePlbl(), LDAPLang.getStrSearchTypePdsc());
        this.registerProp(0x803003, LDAPLang.getStrErrSizeLimitExceeded(), LDAPLang.getStrSizeLimitExceededDescp());
        this.registerProp(8400900, LDAPLang.getStrErrTimeLimitExceeded(), LDAPLang.getStrTimeLimitExceededDescp());
    }

    public boolean hasSubSchema() {
        IAdminProp iAdminProp = this.getParent();
        SubSchema subSchema = null;
        if (iAdminProp instanceof Root) {
            subSchema = ((Root)iAdminProp).getSubSchema();
        }
        return subSchema != null && subSchema.countChildren() != 0;
    }

    /*
     * Unable to fully structure code
     */
    public Object getProp(int var1_1) throws PropertyException {
        var2_2 = 0;
        switch (var1_1) {
            case 1048745: {
                return "browsing_access_control_policy_points_acps_";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3080204: {
                return new Integer(0x300044);
            }
            case 0x1F000F: {
                if (this.m_children != null) {
                    return String.valueOf(this.m_children.size()) + " " + LDAPLang.getStrACPsFound();
                }
                return "0 " + LDAPLang.getStrACPsFound();
            }
            case 282001422: {
                var3_3 = new int[]{0x103000, 2109441, 1060866, 0x803003, 8400900};
                return var3_3;
            }
            case 2109441: {
                if (this.m_children == null) {
                    return new Integer(0);
                }
                return new Integer(this.m_children.size());
            }
            case 0x103000: {
                if (this.m_basedn == null || this.m_basedn.length() == 0) {
                    return "DSE Root";
                }
                return this.m_basedn;
            }
            case 1060866: {
                return this.m_searchType;
            }
            case 0x803003: {
                return new Boolean(this.m_sizeLimit_err);
            }
            case 8400900: {
                return new Boolean(this.m_timeLimit_err);
            }
            case 273219601: 
            case 273612805: {
                if (this.m_children != null) ** GOTO lbl38
                try {
                    this.loadACPs();
                }
                catch (PropertyException v0) {
                    if (this.m_children != null) ** GOTO lbl38
                    throw new PropertyException(LDAPLang.getStrNoAcp());
                }
lbl38:
                // 3 sources

                if (this.m_children != null && this.m_children.size() > 0) {
                    return AdminProp.vectorToObjectArray(this.m_children);
                }
                return null;
            }
            case 273220108: {
                var4_4 = this.acpoption == 1 ? new IAdminProp[6] : new IAdminProp[5];
                var2_2 = 0;
                if (this.acpoption == 1) {
                    var4_4[var2_2++] = new CommandProp((IAdminProp)this, -8197, LDAPLang.getStrConfigure(), LDAPLang.getStrConfigureDescp(), "images/msdir.gif");
                }
                var4_4[var2_2++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrCreateLabel(), LDAPLang.getStrCreateDesc(), "images/create.gif");
                if (!this.hasSubSchema()) {
                    var4_4[var2_2 - 1].setProp(8978948, new Boolean(false));
                }
                var4_4[var2_2++] = new CommandProp(this, -10, LDAPLang.getStrCreateLikeLabel(), LDAPLang.getStrCreateLikeDescp7(), "images/createlike.gif", 1, 1);
                if (!this.hasSubSchema()) {
                    var4_4[var2_2 - 1].setProp(8978948, new Boolean(false));
                }
                var4_4[var2_2++] = new CommandProp(this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc(), "images/delete.gif", 1, 0);
                var4_4[var2_2 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
                var4_4[var2_2++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), String.valueOf(LDAPLang.getStrCmdDecpRefresh()) + "...", "images/refresh.gif");
                var4_4[var2_2 - 1].setProp(2687509, new Integer(4));
                var4_4[var2_2++] = new CommandProp(this, -51, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc(), "images/edit.gif", 1, 1);
                return var4_4;
            }
        }
        return super.getProp(var1_1);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1060866: {
                this.m_searchType = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void loadACPs() throws PropertyException {
        String[] stringArray = new String[]{"*"};
        int[] nArray = new int[]{7};
        String[] stringArray2 = new String[]{"orclACI"};
        String[] stringArray3 = new String[]{"dn", "objectclass"};
        int n = this.m_sizeLimit;
        int n2 = this.m_timeLimit;
        boolean bl = true;
        if (this.acpoption == 1 && this.m_searchType.equals(ACPsSearch.m_searchTypes[0])) {
            bl = false;
        }
        ((AdminProp)this.m_parent).setErrorMessage("");
        try {
            int n3;
            if (this.m_basedn == "") {
                ((Root)this.m_parent).findDSE("", null, this);
                n3 = 0;
                while (n3++ < 30 && this.m_children == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
            String[] stringArray4 = new String[]{DN_OF_SUBSCHEMA, DN_OF_REGISTRY, DN_OF_CONFIG, DN_OF_REPLAGREE};
            int n4 = 0;
            while (n4 < stringArray4.length) {
                n3 = ((Root)this.m_parent).m_serverAccess.findEntry(stringArray, nArray, stringArray4[n4], 1, null, (Object)this, n, n2, stringArray2) ? 1 : 0;
                ++n4;
            }
            n3 = ((Root)this.m_parent).m_serverAccess.findEntry(stringArray, nArray, this.m_basedn, bl, stringArray3, (Object)this, n, n2, stringArray2) ? 1 : 0;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        String string = ((AdminProp)this.m_parent).getErrorMessage();
        this.m_timeLimit_err = false;
        this.m_sizeLimit_err = false;
        if (!string.equals("") && !Root.SSLEnabled && string.indexOf("=3\n") > 0) {
            this.m_timeLimit_err = true;
            return;
        }
        if (!string.equals("") && !Root.SSLEnabled && string.indexOf("=4\n") > 0) {
            this.m_sizeLimit_err = true;
            return;
        }
        if (!string.equals("") && Root.SSLEnabled && string.indexOf("=106\n") < 0) {
            throw new PropertyException(string);
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -8197: {
                return new ACPsSearch((Root)this.m_parent, this);
            }
            case -9: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                int n2 = 0;
                while (n2 < iAdminPropArray.length) {
                    AccessCtrlPoint accessCtrlPoint;
                    if (iAdminPropArray[n2] instanceof AccessCtrlPoint && (accessCtrlPoint = (AccessCtrlPoint)iAdminPropArray[n2]).getDn() != null && !accessCtrlPoint.getDn().equals("")) {
                        accessCtrlPoint.delete(n2 + 1 == iAdminPropArray.length);
                    }
                    ++n2;
                }
                break;
            }
            case -10: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                NewAccessCtrlPoint newAccessCtrlPoint = new NewAccessCtrlPoint((Root)this.m_parent, this);
                ((AdminProp)iAdminPropArray[0]).copyTo(newAccessCtrlPoint);
                newAccessCtrlPoint.setDn(((Entry)iAdminPropArray[0]).getDn());
                return newAccessCtrlPoint;
            }
            case -51: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                return iAdminPropArray[0];
            }
            case -5: {
                this.refresh(iAdminProp);
                break;
            }
            case -8: {
                return this.createChild();
            }
        }
        return null;
    }

    public void refresh(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        this.refresh();
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
    }

    public void refresh() throws PropertyException {
        if (this.m_children != null) {
            int n = 0;
            while (n < this.m_children.size()) {
                ((AccessCtrlPoint)this.m_children.elementAt(n)).cleanup();
                ++n;
            }
            this.m_children.removeAllElements();
        }
        this.m_children = null;
        this.loadACPs();
        this.update();
        Runtime.getRuntime().gc();
    }

    public NewAccessCtrlPoint createChild() {
        return new NewAccessCtrlPoint((Root)this.m_parent, this);
    }

    public void saveEntry(Entry entry) throws PropertyException {
        if (entry instanceof AccessCtrlPoint) {
            return;
        }
        int n = this.countChildren();
        String string = entry.getDn();
        int n2 = ((Root)this.m_parent).getAttrPropId("orclaci");
        int n3 = 0;
        while (n3 < n) {
            AccessCtrlPoint accessCtrlPoint = (AccessCtrlPoint)this.nthChild(n3);
            if (string.equalsIgnoreCase(accessCtrlPoint.getDn())) {
                if (!entry.propertyIsModified(n2)) {
                    return;
                }
                this.removeChild(accessCtrlPoint);
                break;
            }
            ++n3;
        }
        if (this.m_children != null) {
            try {
                if (entry.getProp(n2) != null) {
                    ((Root)this.m_parent).m_serverAccess.findObjectSync(string, null, this);
                    this.update();
                    return;
                }
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
    }

    public void removeEntry(Entry entry) {
        if (entry instanceof AccessCtrlPoint) {
            return;
        }
        int n = this.countChildren();
        String string = entry.getDn();
        int n2 = 0;
        while (n2 < n) {
            AccessCtrlPoint accessCtrlPoint = (AccessCtrlPoint)this.nthChild(n2);
            if (string.equalsIgnoreCase(accessCtrlPoint.getDn())) {
                this.removeChild(accessCtrlPoint);
                this.update();
            }
            ++n2;
        }
    }

    public void update() {
        super.update();
        if (this.m_children != null) {
            this.setStatusMessage(String.valueOf(this.m_children.size()) + LDAPLang.getStrACPsFound());
        }
    }

    public String getBasedn() {
        return this.m_basedn;
    }

    public int getSizeLimit() {
        return this.m_sizeLimit;
    }

    public void setSizeLimit(int n) {
        this.m_sizeLimit = n;
    }

    public int getTimeLimit() {
        return this.m_timeLimit;
    }

    public void setTimeLimit(int n) {
        this.m_timeLimit = n;
    }

    public void cleanup() {
        this.m_basedn = null;
        this.m_displayMsg = null;
        this.m_attrs = null;
        this.m_parent = null;
        int n = 0;
        while (n < this.countChildren()) {
            ((AccessCtrlPoint)this.nthChild(n)).cleanup();
            ++n;
        }
        this.m_children = null;
    }

    public String toLine() {
        if (this.m_basedn == null || this.m_basedn.length() == 0) {
            return "DSE Root:" + this.m_searchType + ":" + this.m_sizeLimit + ":" + this.m_timeLimit + ":";
        }
        return String.valueOf(this.m_basedn) + ":" + this.m_searchType + ":" + this.m_sizeLimit + ":" + this.m_timeLimit + ":";
    }
}

