/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AgreementDN;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcBases;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;

public class AgreementDNs
extends ProcBases {
    String[] m_DNs;

    public AgreementDNs(Root root, String[] stringArray, Proc proc) {
        super(root, "", proc);
        this.m_DNs = stringArray;
        this.m_tabName = LDAPLang.getStrGroupLabel();
        this.setQueryBase(this);
        this.setDisplayName(LDAPLang.getStrGroupLabel());
        this.setIconName("images/msrules.gif");
        this.setSampleChild(new AgreementDN(root));
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 2032714: {
                return "\n";
            }
            case 2032706: {
                return LDAPLang.getStrGroupLabel();
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    void execFunc() throws PropertyException {
        if (this.debug) {
            this.debugMessageLn("AgreementDNs::execFunc() starting....");
        }
        int n = 0;
        while (n < this.m_DNs.length) {
            String string = this.m_DNs[n];
            try {
                boolean bl = ((Root)this.m_parent).m_serverAccess.findObjectSync(string, null, this);
            }
            catch (Exception exception) {
                if (this.debug) {
                    this.debugMessageLn(exception.getMessage());
                }
                throw new PropertyException(exception);
            }
            String string2 = ((AdminProp)this.m_parent).getErrorMessage();
            if (!string2.equals("") && this.debug) {
                this.debugMessageLn(string2);
            }
            ++n;
        }
    }
}

