/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.AttributeSample;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.NewAttribute;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.Syntax;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.TableSelector;

public class Attribute
extends SchemaObject
implements ICommandParent {
    static final int PR_ATTR_DISPLAY_NAME = 0x103001;
    static final int CMD_CREATE_SUP = 6;
    static final int CMD_DELETE_SUP = 7;
    static final int CMD_EDIT_SUP = 8;
    static final int CMD_DECATALOGE = 9;
    static Attribute m_sampleAttr = new AttributeSample();
    AdminList m_supObjs;
    TableSelector m_supSelector;
    static final int[] m_readOnlyProps2 = new int[]{0x103000, 0x103013};
    boolean m_serverModified = false;
    int dnValuedState;
    boolean m_isCataloged = true;

    public void registerMessages() {
        super.registerMessages();
        this.registerPropOnTabPage(0x103013, LDAPLang.getStrOidPlbl(), LDAPLang.getStrOidPdsc(), LDAPLang.getStrGeneral());
        this.registerPropOnTabPage(0x103000, LDAPLang.getStrDisplayNamePlbl(), LDAPLang.getStrNamePdsc2(), LDAPLang.getStrGeneral());
        this.registerPropOnTabPage(1060866, LDAPLang.getStrDescPlbl(), LDAPLang.getStrDescPdsc(), LDAPLang.getStrGeneral());
        this.registerProp(8466448, LDAPLang.getStrObsoletePlbl(), LDAPLang.getStrObsoletePdsc());
        if (Root.isClientCommandLine()) {
            this.registerPropOnTabPage(269496329, LDAPLang.getStrSupPlbl(), LDAPLang.getStrSupPdsc(), LDAPLang.getStrAdvanced());
        } else {
            this.setPropHidden(269496329, true, false);
            this.registerPropOnTabPage(4206619, LDAPLang.getStrSupPlbl(), LDAPLang.getStrSupPdsc(), LDAPLang.getStrAdvanced());
            this.setPropertyLabelHidden(4206619, true, false);
        }
        this.registerPropOnTabPage(1060871, LDAPLang.getStrEqualityPlbl(), LDAPLang.getStrEqualityPdsc(), LDAPLang.getStrAdvanced());
        this.registerPropOnTabPage(1060870, LDAPLang.getStrOrderingPlbl(), LDAPLang.getStrOrderingPdsc(), LDAPLang.getStrAdvanced());
        this.registerPropOnTabPage(1060872, LDAPLang.getStrSubstrPlbl(), LDAPLang.getStrSubstrPdsc(), LDAPLang.getStrAdvanced());
        this.registerPropOnTabPage(0x103003, LDAPLang.getStrSyntaxPlbl(), LDAPLang.getStrSyntaxPdsc(), LDAPLang.getStrGeneral());
        this.registerPropOnTabPage(2109444, LDAPLang.getStrSizePlbl(), LDAPLang.getStrSizePdsc(), LDAPLang.getStrGeneral());
        this.registerPropRange(2109444, 0, 65534);
        this.registerPropOnTabPage(8400913, LDAPLang.getStrSingleValuePlbl(), LDAPLang.getStrSingleValuePdsc(), LDAPLang.getStrGeneral());
        this.registerProp(8466444, LDAPLang.getStrNoUserModPlbl(), LDAPLang.getStrNoUserModPdsc());
        this.registerPropOnTabPage(1060869, LDAPLang.getStrUsagePlbl(), LDAPLang.getStrUsagePdsc(), LDAPLang.getStrAdvanced());
        this.registerProp(8466452, LDAPLang.getStrExistingPlbl(), LDAPLang.getStrExistingPdsc());
        this.registerProp(8466453, LDAPLang.getStrIndexPlbl(), LDAPLang.getStrIndexPdsc());
        if (Names.USE_DISPLAY_NAME) {
            this.registerProp(0x103001, LDAPLang.getStrAttrDisplayNamePlbl(), LDAPLang.getStrAttrDisplayNamePdsc());
        }
        this.registerPropOnTabPage(8794113, LDAPLang.getStrIsCatalogedPlbl(), LDAPLang.getStrIsCatalogedPdsc(), LDAPLang.getStrAdvanced());
    }

    public Attribute() {
    }

    public Attribute(String string, int[] nArray, SubSchema subSchema) {
        super(string, nArray, subSchema);
        this.m_originalString = string;
        this.m_subSchema = subSchema;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 281609325: {
                if (!this.isExisting()) break;
                return m_readOnlyProps2;
            }
            case 1048745: {
                return "modifying_attribute_types";
            }
            case 269550752: {
                String[] stringArray = new String[]{"attribute_properties_general", "attribute_properties_advanced"};
                return stringArray;
            }
            case 269550753: {
                String[] stringArray = new String[]{RootList.getHelpBaseFileName(), RootList.getHelpBaseFileName()};
                return stringArray;
            }
            case 1638408: {
                if (this.isReadonly()) {
                    return "images/ldapattrro.gif";
                }
                return "images/ldapattr.gif";
            }
            case 2031768: {
                return LDAPLang.getStrPartialEntry();
            }
            case 2686979: {
                if (!this.isReadonly()) break;
                return new Integer(1);
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(4 | (this.m_subSchema.findAttributeType(269496329, this.getName()) != null ? 0x100000 : 0) | (this.isModified() ? 2 : 0) | 0x200000 | 0x2000);
            }
            case 0x103001: {
                return this.m_subSchema.getAttrDisplayName((String)this.getProp(0x103000));
            }
            case 273612805: {
                return this.m_subSchema.findAttributeTypes(269496329, this.getName());
            }
            case 4206619: {
                if (this.m_supObjs == null) {
                    this.m_supObjs = new AdminList((IAdminProp)this, new Vector());
                    this.m_supObjs.setSampleChild(m_sampleAttr);
                    this.m_supObjs.setDisplayNameProp(0x103000);
                    String[] stringArray = (String[])this.getProp(269496329);
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[n2]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_supObjs.addChild(objectArray[0]);
                            } else {
                                IAdminProp iAdminProp = this.m_subSchema.createAttribute();
                                iAdminProp.setProp(0x103000, stringArray[n2]);
                                iAdminProp.setProp(1638914, LDAPLang.getStrUnknownAttribute());
                                this.m_supObjs.addChild(iAdminProp);
                            }
                            ++n2;
                        }
                    }
                    this.m_supObjs.setProp(2032706, (Object)this.getPropName(n));
                    this.m_supObjs.setProp(2162725, 114688);
                    IAdminProp[] iAdminPropArray = new CommandProp[3];
                    int n3 = 0;
                    iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, 6, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDesc(), "images/create.gif");
                    iAdminPropArray[n3++] = new CommandProp(this, 7, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc3(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n3 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                    iAdminPropArray[n3++] = new CommandProp(this, 8, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc1(), "images/edit.gif", 1, 1);
                    if (this.isExisting()) {
                        int n4 = 0;
                        while (n4 < n3) {
                            ((CommandProp)iAdminPropArray[n4]).setEnabled(false);
                            ++n4;
                        }
                    }
                    this.m_supObjs.setCommandList(iAdminPropArray);
                }
                return this.m_supObjs;
            }
            case 273613313: {
                CommandProp[] commandPropArray = new CommandProp[3];
                int n5 = 0;
                commandPropArray[n5++] = new CommandProp((IAdminProp)this, -10, LDAPLang.getStrCreateLikeLabel(), LDAPLang.getStrCreateLikeDesc1(), "images/createlike.gif");
                commandPropArray[n5++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc3(), "images/delete.gif");
                if (this.isReadonly()) {
                    commandPropArray[n5 - 1].setEnabled(false);
                }
                commandPropArray[n5 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                commandPropArray[n5++] = new CommandProp(this, 9, LDAPLang.getStrDeCataloge(), LDAPLang.getStrDeCatalogeDescp(), "images/decatalog.gif", 1, 1);
                if (!this.isCataloged() || this.isReadonly()) {
                    commandPropArray[n5 - 1].setEnabled(false);
                }
                commandPropArray[n5 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDropIndex());
                return commandPropArray;
            }
            case 8400897: 
            case 8794113: {
                if (this.isCataloged()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 282001422: {
                if (this.isNew()) {
                    return super.getProp(n);
                }
                int[] nArray = (int[])super.getProp(282001422);
                int[] nArray2 = new int[nArray.length];
                int n6 = 0;
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (nArray[n7] != 8794113) {
                        if (nArray[n7] == 0x103000) {
                            nArray2[n6++] = nArray[n7];
                            nArray2[n6++] = 8794113;
                        } else {
                            nArray2[n6++] = nArray[n7];
                        }
                    }
                    ++n7;
                }
                return nArray2;
            }
        }
        return super.getProp(n);
    }

    public String getOriginalString() {
        return this.m_originalString;
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (!Root.isClientCommandLine()) {
            this.setListProp(this.m_supObjs, 269496329);
        }
        if (Root.debugSaveAttribute) {
            System.out.println("Attribute.saveChanges");
            System.out.println("original string=" + this.m_originalString);
            System.out.println("     new string=" + this.toString());
            System.out.println("    has changes=" + this.m_serverModified);
        }
        if (!this.m_serverModified) {
            return;
        }
        if (!this.validate()) {
            return;
        }
        try {
            this.m_subSchema.saveAttributeType(this);
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
        this.m_originalString = this.toString();
        this.m_serverModified = false;
    }

    public boolean validate() throws SaveChangeException {
        String string;
        block17: {
            String string2;
            SubSchema subSchema = this.m_subSchema;
            boolean bl = false;
            string = "";
            try {
                bl = this.getBoolean(8466452);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            try {
                super.validate();
            }
            catch (SaveChangeException saveChangeException) {
                string = String.valueOf(string) + saveChangeException.toString();
            }
            int[] nArray = new int[]{1060871, 1060870, 1060872};
            int n = 0;
            while (n < nArray.length) {
                block16: {
                    try {
                        string2 = (String)this.getProp(nArray[n]);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                        break block16;
                    }
                    if (string2 != null && !string2.trim().equals("") && subSchema.findMatchingRule(0x103000, string2) == null && subSchema.findMatchingRule(0x103013, string2) == null) {
                        string = String.valueOf(string) + LDAPLang.getStrIllMatchingRule() + " " + string2;
                        break;
                    }
                }
                ++n;
            }
            try {
                string2 = (String)this.getProp(1060869);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
                break block17;
            }
            if (string2 != null && !string2.trim().equals("")) {
                int n2 = 0;
                while (n2 < SchemaObject.ATTRIBUTEUSAGES.length) {
                    if (string2.equalsIgnoreCase(SchemaObject.ATTRIBUTEUSAGES[n2])) break;
                    ++n2;
                }
                if (n2 == SchemaObject.ATTRIBUTEUSAGES.length) {
                    string = String.valueOf(string) + LDAPLang.getStrIllUsage();
                    n2 = 0;
                    while (n2 < SchemaObject.ATTRIBUTEUSAGES.length) {
                        string = String.valueOf(string) + SchemaObject.ATTRIBUTEUSAGES[n2];
                        if (n2 != SchemaObject.ATTRIBUTEUSAGES.length - 1) {
                            string = String.valueOf(string) + ", ";
                        }
                        ++n2;
                    }
                    string = String.valueOf(string) + " Got Value=" + string2;
                }
            }
        }
        if (!string.trim().equals("")) {
            throw new SaveChangeException(String.valueOf(string) + "\n");
        }
        return true;
    }

    public boolean isSingleValue() {
        try {
            Boolean bl = (Boolean)this.getProp(8400913);
            if (bl == null) {
                bl = (Boolean)this.getProp(8794129);
            }
            return bl;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return true;
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            IAdminProp[] iAdminPropArray;
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == -9) {
                this.m_subSchema.deleteAttribute(this);
                this.m_bValid = false;
                this.makeInvalid();
            } else {
                if (n == -10) {
                    NewAttribute newAttribute = new NewAttribute(this.m_subSchema.m_attributesHolder, this.m_subSchema);
                    this.copyTo(newAttribute);
                    newAttribute.setProp(2031768, (Object)(String.valueOf(LDAPLang.getStrEditorTitle17()) + ": " + LDAPLang.getStrCreateLikeLabel() + " " + this.getProp(0x103001)));
                    return newAttribute;
                }
                if (n == 9) {
                    iAdminPropArray = (IAdminProp[])this.getProp(0x103000);
                    this.m_subSchema.CatalogeAttr((String)iAdminPropArray, false);
                    this.setCataloged(false);
                    this.makeInvalid();
                }
            }
            if (n == 6) {
                if (this.m_supSelector == null) {
                    this.m_supSelector = new TableSelector(this, this.m_subSchema.getAttributeTypes(), 272642072, LDAPLang.getStrAttrSelector(), null, null);
                    this.m_supSelector.setProp(1048745, (Object)"super_attributes");
                    this.m_supSelector.setProp(1049370, (Object)RootList.getHelpBaseFileName());
                }
                return this.m_supSelector;
            }
            if (n == 7) {
                this.m_supObjs.removeChildren(iAdminProp);
                this.setModified(true);
            } else if (n == 8) {
                iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                return iAdminPropArray[0];
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return null;
    }

    public void copyTo(IAdminProp iAdminProp) throws PropertyException {
        super.copyTo(iAdminProp);
        int[] nArray = new int[]{1060871, 1060870, 1060872};
        int n = 0;
        while (n < nArray.length) {
            String string = (String)iAdminProp.getProp(nArray[n]);
            if (string != null && !string.equals("") && this.m_subSchema.findMatchingRule(0x103000, string) == null && this.m_subSchema.findMatchingRule(0x103013, string) == null) {
                iAdminProp.setProp(nArray[n], null);
            }
            ++n;
        }
    }

    public Vector getSiblings() {
        return this.m_subSchema.getAttributeTypes();
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (AdminProp.getPropNumber(n) >= 12288 && n != 0x103001) {
            this.m_serverModified = true;
        }
        switch (n) {
            case 0x103013: {
                this.dnValuedState = 0;
                break;
            }
            case 0x103001: {
                this.m_subSchema.setAttrDisplayName((String)this.getProp(0x103000), (String)object);
                return;
            }
            case 272642072: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null) {
                    return;
                }
                int n2 = this.m_supObjs.countChildren();
                int n3 = 0;
                while (n3 < iAdminPropArray.length) {
                    this.m_supObjs.addChildUnique(iAdminPropArray[n3]);
                    ++n3;
                }
                if (n2 != this.m_supObjs.countChildren()) {
                    this.m_supObjs.update();
                    this.setModified(true);
                }
                return;
            }
            case 2163220: {
                if (!this.isExisting()) {
                    return;
                }
            }
            case 2163740: {
                if (this.m_supObjs != null) {
                    this.m_supObjs.removeAllChildren();
                    String[] stringArray = (String[])this.getProp(269496329);
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findObjectClasses(0x103000, stringArray[n4]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_supObjs.addChild(objectArray[0]);
                            }
                            ++n4;
                        }
                    }
                    if (n == 2163740) {
                        this.m_supObjs.update();
                    }
                }
                this.setModified(false);
                return;
            }
        }
        super.setProp(n, object);
    }

    public boolean isDNValued() {
        switch (this.dnValuedState) {
            case 0: {
                String string = this.m_subSchema.getDNSyntaxId();
                if (string == null) {
                    return false;
                }
                try {
                    String[] stringArray;
                    String string2 = (String)this.getProp(0x103003);
                    int n = this.dnValuedState = string2 != null && string2.equals(string) ? 1 : 2;
                    if (this.dnValuedState == 2 && (stringArray = (String[])this.getProp(269496329)) != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[0]);
                            if (objectArray != null && objectArray.length > 0 && ((Attribute)objectArray[0]).isDNValued()) {
                                this.dnValuedState = 1;
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return this.dnValuedState == 1;
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                    return this.dnValuedState == 1;
                }
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setCataloged(boolean bl) {
        this.m_isCataloged = bl;
        this.sendAdminPropertyChangeEvents(8794113, null);
        this.sendAdminPropertyChangeEvents(8400897, null);
    }

    public boolean isCataloged() {
        return this.m_isCataloged;
    }

    public boolean hasJpegSyntax() {
        try {
            String string = super.getSyntax();
            if (string != null) {
                Syntax syntax = this.m_subSchema.findSyntax(0x103013, string);
                if (syntax == null) {
                    syntax = this.m_subSchema.findSyntax(0x103000, string);
                }
                if (syntax != null) {
                    String string2 = syntax.getName();
                    return string2 != null && (string2.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("jpg"));
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isNew() {
        return false;
    }

    public void cleanup() {
        super.cleanup();
        this.m_supObjs = null;
        this.m_supSelector = null;
    }
}

