/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class AuditLevelFlags
extends AdminProp {
    static final int PR_SUPER_USER_LOGIN = 0x803000;
    static final int PR_SCHEMA_ELEMENT_CHANGE = 8400897;
    static final int PR_SCHEMA_ELEMENT_DELETE = 8400898;
    static final int PR_BIND = 0x803003;
    static final int PR_ACCESS_VIOLATION = 8400900;
    static final int PR_DSE_MODIFICATION = 8400901;
    static final int PR_REPLICATION_LOGON = 8400902;
    static final int PR_ACL_MODIFICATION = 8400903;
    static final int PR_USER_PASSWORD_MOD = 0x803008;
    static final int PR_ADD = 8400905;
    static final int PR_DELETE = 8400906;
    static final int PR_MODIFY = 8400907;
    static final int PR_MODIFY_DN = 8400908;
    static final int PR_ALL = 8400909;
    static final int[] m_enableList = new int[]{0x803000, 8400897, 8400898, 0x803003, 8400900, 8400901, 8400902, 8400903, 0x803008, 8400905, 8400906, 8400907, 8400908};
    public Boolean m_super_user_login;
    public Boolean m_schema_element_change;
    public Boolean m_schema_element_delete;
    public Boolean m_bind;
    public Boolean m_access_violation;
    public Boolean m_dse_modification;
    public Boolean m_replication_logon;
    public Boolean m_acl_modification;
    public Boolean m_user_password_mod;
    public Boolean m_add;
    public Boolean m_delete;
    public Boolean m_modify;
    public Boolean m_modify_dn;
    public Boolean m_all;
    Entry m_entry;
    int m_propId;
    boolean m_isReadonly;
    int m_flags;

    public AuditLevelFlags(Entry entry, int n, int n2, boolean bl) {
        this.m_entry = entry;
        this.m_propId = n;
        this.m_isReadonly = bl;
        this.m_flags = n2;
        this.setupFlags(this.m_flags);
    }

    public void setupFlags(int n) {
        this.m_super_user_login = Boolean.FALSE;
        this.m_schema_element_change = Boolean.FALSE;
        this.m_schema_element_delete = Boolean.FALSE;
        this.m_bind = Boolean.FALSE;
        this.m_access_violation = Boolean.FALSE;
        this.m_dse_modification = Boolean.FALSE;
        this.m_replication_logon = Boolean.FALSE;
        this.m_acl_modification = Boolean.FALSE;
        this.m_user_password_mod = Boolean.FALSE;
        this.m_add = Boolean.FALSE;
        this.m_delete = Boolean.FALSE;
        this.m_modify = Boolean.FALSE;
        this.m_modify_dn = Boolean.FALSE;
        this.m_all = Boolean.FALSE;
        if ((n & 1) != 0) {
            this.m_super_user_login = Boolean.TRUE;
        }
        if ((n & 2) != 0) {
            this.m_schema_element_change = Boolean.TRUE;
        }
        if ((n & 4) != 0) {
            this.m_schema_element_delete = Boolean.TRUE;
        }
        if ((n & 8) != 0) {
            this.m_bind = Boolean.TRUE;
        }
        if ((n & 0x10) != 0) {
            this.m_access_violation = Boolean.TRUE;
        }
        if ((n & 0x20) != 0) {
            this.m_dse_modification = Boolean.TRUE;
        }
        if ((n & 0x40) != 0) {
            this.m_replication_logon = Boolean.TRUE;
        }
        if ((n & 0x80) != 0) {
            this.m_acl_modification = Boolean.TRUE;
        }
        if ((n & 0x100) != 0) {
            this.m_user_password_mod = Boolean.TRUE;
        }
        if ((n & 0x200) != 0) {
            this.m_add = Boolean.TRUE;
        }
        if ((n & 0x400) != 0) {
            this.m_delete = Boolean.TRUE;
        }
        if ((n & 0x800) != 0) {
            this.m_modify = Boolean.TRUE;
        }
        if ((n & 0x1000) != 0) {
            this.m_modify_dn = Boolean.TRUE;
        }
        if ((n & 0x1FFF) == 8191) {
            this.m_all = Boolean.TRUE;
        }
        this.setEnabledProperties();
    }

    public void updateBackup() {
        this.m_flags = this.getAuditLevelFlags();
    }

    public void editorCancel(boolean bl) {
        this.setupFlags(this.m_flags);
        if (bl) {
            try {
                this.sendAdminPropertyChangeEvents((int[])this.getProp(282001422), null);
            }
            catch (Exception exception) {}
            try {
                this.update();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void initProps() throws PropertyException {
        super.initProps();
        this.setProp(2687386, 2048);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x803000, LDAPLang.getStrSuperUserLogin(), LDAPLang.getStrEmptyString());
        this.registerProp(8400897, LDAPLang.getStrSchemaElementChange(), LDAPLang.getStrEmptyString());
        this.registerProp(8400898, LDAPLang.getStrSchemaElementDelete(), LDAPLang.getStrEmptyString());
        this.registerProp(0x803003, LDAPLang.getStrBind(), LDAPLang.getStrEmptyString());
        this.registerProp(8400900, LDAPLang.getStrAccessViolation(), LDAPLang.getStrEmptyString());
        this.registerProp(8400901, LDAPLang.getStrDseModification(), LDAPLang.getStrEmptyString());
        this.registerProp(8400902, LDAPLang.getStrReplicationLogon(), LDAPLang.getStrEmptyString());
        this.registerProp(8400903, LDAPLang.getStrAclModification(), LDAPLang.getStrEmptyString());
        this.registerProp(0x803008, LDAPLang.getStrUserPasswordMod(), LDAPLang.getStrEmptyString());
        this.registerProp(8400905, LDAPLang.getStrAdd(), LDAPLang.getStrEmptyString());
        this.registerProp(8400906, LDAPLang.getStrDelete(), LDAPLang.getStrEmptyString());
        this.registerProp(8400907, LDAPLang.getStrModify(), LDAPLang.getStrEmptyString());
        this.registerProp(8400908, LDAPLang.getStrModifyDN(), LDAPLang.getStrEmptyString());
        this.registerProp(8400909, LDAPLang.getStrAll(), LDAPLang.getStrEmptyString());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "audit_mask_levels";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/msorgs.gif";
            }
            case 2686979: {
                if (!this.m_isReadonly) break;
                return new Integer(1);
            }
            case 2163836: {
                return new Integer(100);
            }
            case 0x110001: {
                return LDAPLang.getStrAuditMaskLevels();
            }
            case 0x803000: {
                return this.m_super_user_login;
            }
            case 8400897: {
                return this.m_schema_element_change;
            }
            case 8400898: {
                return this.m_schema_element_delete;
            }
            case 0x803003: {
                return this.m_bind;
            }
            case 8400900: {
                return this.m_access_violation;
            }
            case 8400901: {
                return this.m_dse_modification;
            }
            case 8400902: {
                return this.m_replication_logon;
            }
            case 8400903: {
                return this.m_acl_modification;
            }
            case 0x803008: {
                return this.m_user_password_mod;
            }
            case 8400905: {
                return this.m_add;
            }
            case 8400906: {
                return this.m_delete;
            }
            case 8400907: {
                return this.m_modify;
            }
            case 8400908: {
                return this.m_modify_dn;
            }
            case 8400909: {
                return this.m_all;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x803000: {
                this.m_super_user_login = (Boolean)object;
                break;
            }
            case 8400897: {
                this.m_schema_element_change = (Boolean)object;
                break;
            }
            case 8400898: {
                this.m_schema_element_delete = (Boolean)object;
                break;
            }
            case 0x803003: {
                this.m_bind = (Boolean)object;
                break;
            }
            case 8400900: {
                this.m_access_violation = (Boolean)object;
                break;
            }
            case 8400901: {
                this.m_dse_modification = (Boolean)object;
                break;
            }
            case 8400902: {
                this.m_replication_logon = (Boolean)object;
                break;
            }
            case 8400903: {
                this.m_acl_modification = (Boolean)object;
                break;
            }
            case 0x803008: {
                this.m_user_password_mod = (Boolean)object;
                break;
            }
            case 8400905: {
                this.m_add = (Boolean)object;
                break;
            }
            case 8400906: {
                this.m_delete = (Boolean)object;
                break;
            }
            case 8400907: {
                this.m_modify = (Boolean)object;
                break;
            }
            case 8400908: {
                this.m_modify_dn = (Boolean)object;
                break;
            }
            case 8400909: {
                this.m_all = (Boolean)object;
                break;
            }
            default: {
                super.setProp(n, object);
            }
        }
        int n2 = AdminProp.getPropNumber(n);
        if (n2 >= 12288 && n2 <= 12301) {
            this.update();
            if (n == 8400909) {
                this.setEnabledProperties();
            }
        }
    }

    public void setEnabledProperties() {
        try {
            int n = 281609325;
            if (this.m_all.booleanValue()) {
                super.setProp(n, (Object)m_enableList);
            } else {
                super.setProp(n, null);
            }
            this.sendAdminPropertyChangeEvents(n, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getAuditLevelFlags() {
        int n = 0;
        if (this.m_super_user_login.booleanValue()) {
            n |= 1;
        }
        if (this.m_schema_element_change.booleanValue()) {
            n |= 2;
        }
        if (this.m_schema_element_delete.booleanValue()) {
            n |= 4;
        }
        if (this.m_bind.booleanValue()) {
            n |= 8;
        }
        if (this.m_access_violation.booleanValue()) {
            n |= 0x10;
        }
        if (this.m_dse_modification.booleanValue()) {
            n |= 0x20;
        }
        if (this.m_replication_logon.booleanValue()) {
            n |= 0x40;
        }
        if (this.m_acl_modification.booleanValue()) {
            n |= 0x80;
        }
        if (this.m_user_password_mod.booleanValue()) {
            n |= 0x100;
        }
        if (this.m_add.booleanValue()) {
            n |= 0x200;
        }
        if (this.m_delete.booleanValue()) {
            n |= 0x400;
        }
        if (this.m_modify.booleanValue()) {
            n |= 0x800;
        }
        if (this.m_modify_dn.booleanValue()) {
            n |= 0x1000;
        }
        if (this.m_all.booleanValue()) {
            n = 8191;
        }
        return n;
    }

    public void update() throws PropertyException {
        int[] nArray = new int[]{this.m_propId};
        Object[] objectArray = new Object[]{Integer.toString(this.getAuditLevelFlags())};
        this.m_entry.setProps(nArray, objectArray);
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            this.update();
            this.updateBackup();
            this.m_entry.saveChanges(n);
        }
        catch (Exception exception) {
            this.setupFlags(this.m_flags);
            throw new SaveChangeException(exception);
        }
        this.m_flags = this.getAuditLevelFlags();
    }

    public String toString() {
        return Integer.toString(this.m_flags);
    }

    public void cleanup() {
        this.m_entry = null;
    }
}

