/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.text.DateFormat;
import java.util.GregorianCalendar;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;

public class AuditLog
extends AdminProp {
    Root m_parent;
    String m_basedn;
    String m_displayName;
    public static final String[] m_auditAttributes = new String[]{"orclsequence", "orcleventtime", "orclopresult", "orcleventtype", "orclauditmessage", "orcluserdn"};
    public static final Class[] m_auditAttrTypes = new Class[]{AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : (AdminProp.class$java$lang$String = AuditLog.class$("java.lang.String")), AdminProp.class$java$util$Date != null ? AdminProp.class$java$util$Date : (AdminProp.class$java$util$Date = AuditLog.class$("java.util.Date")), AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : (AdminProp.class$java$lang$String = AuditLog.class$("java.lang.String")), AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : (AdminProp.class$java$lang$String = AuditLog.class$("java.lang.String")), AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : (AdminProp.class$java$lang$String = AuditLog.class$("java.lang.String")), AdminProp.class$java$lang$String != null ? AdminProp.class$java$lang$String : (AdminProp.class$java$lang$String = AuditLog.class$("java.lang.String"))};

    public AuditLog() {
    }

    public AuditLog(Root root, String string, String string2, Object[] objectArray) {
        this.init(root);
        this.m_parent = root;
        this.m_basedn = string;
        this.m_displayName = string2;
        this.parseAttributes(objectArray);
    }

    public static String[] getAuditAttributes() {
        return m_auditAttributes;
    }

    public static Object[] getAuditAttrTypes() {
        return m_auditAttrTypes;
    }

    public static Object[] getAuditAttrOpList() {
        return new String[][]{Directory.SEARCH_TYPE_LOV, Directory.SEARCH_TYPE_LOV_DATE, Directory.SEARCH_TYPE_LOV, Directory.SEARCH_TYPE_LOV, Directory.SEARCH_TYPE_LOV, Directory.SEARCH_TYPE_LOV};
    }

    void init(Root root) {
        String[] stringArray = new String[]{LDAPLang.getStrSequence(), LDAPLang.getStrEventTime(), LDAPLang.getStrOpResult(), LDAPLang.getStrEventType(), LDAPLang.getStrAuditMessage(), LDAPLang.getStrUserDn()};
        int n = 0;
        while (n < m_auditAttributes.length) {
            int n2 = root.getAttrPropId(m_auditAttributes[n]);
            n2 = AuditLog.convertPropId(m_auditAttributes[n], n2);
            this.registerProp(n2, stringArray[n], "");
            ++n;
        }
    }

    public static int convertPropId(String string, int n) {
        int n2 = 0;
        while (n2 < m_auditAttributes.length) {
            if (string.equalsIgnoreCase(m_auditAttributes[n2])) {
                n &= 0xEFFFFFFF;
                if (!string.equals("orclauditmessage")) break;
                n = AdminProp.getPropNumber(n) | 0xB00000;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void parseAttributes(Object[] objectArray) {
        boolean bl = Root.debugAuditLog;
        if (bl) {
            this.setDebug(true);
        }
        int n = 0;
        while (n < objectArray.length) {
            block26: {
                Object object;
                Object object2 = this.m_parent.m_serverAccess.getType(objectArray[n]);
                if (Character.isDigit(((String)object2).charAt(0))) {
                    Attribute attribute;
                    if (bl) {
                        this.debugMessageLn("looking attribute by oid");
                    }
                    if ((attribute = this.m_parent.findAttributeType(0x103013, object2)) != null) {
                        if (bl) {
                            this.debugMessageLn("got attribute");
                        }
                        try {
                            object = attribute.getName();
                            if (object != null) {
                                if (bl) {
                                    this.debugMessageLn("translated type=" + (String)object2 + "to name=" + (String)object);
                                }
                                object2 = object;
                            }
                        }
                        catch (PropertyException propertyException) {
                            this.unexpectedException(propertyException);
                        }
                    }
                }
                if (bl) {
                    this.debugMessageLn("type='" + (String)object2 + "'");
                }
                object = this.m_parent.getAttrPropId(object2);
                int n2 = (Integer)object;
                n2 = AuditLog.convertPropId((String)object2, n2);
                if (bl) {
                    this.debugMessageLn("iPropId=" + n2);
                }
                String[] stringArray = this.m_parent.m_serverAccess.getValues(objectArray[n]);
                if (bl) {
                    this.debugMessageLn("vals.length=" + stringArray.length);
                }
                if (!((String)object2).equalsIgnoreCase("objectclass")) {
                    if (bl) {
                        this.debugMessageLn("property id is not for array value");
                    }
                    try {
                        if (stringArray.length == 1) {
                            if (bl) {
                                this.debugMessageLn("val='" + stringArray[0] + "'");
                            }
                            String string = stringArray[0];
                            if (((String)object2).equalsIgnoreCase("orcleventtime") && stringArray[0] != null) {
                                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
                                try {
                                    GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(stringArray[0].substring(0, 4)), Integer.parseInt(stringArray[0].substring(4, 6)) - 1, Integer.parseInt(stringArray[0].substring(6, 8)), Integer.parseInt(stringArray[0].substring(8, 10)), Integer.parseInt(stringArray[0].substring(10, 12)), Integer.parseInt(stringArray[0].substring(12, 14)));
                                    string = dateFormat.format(gregorianCalendar.getTime());
                                }
                                catch (Exception exception) {
                                    string = null;
                                }
                            }
                            this.setProp(n2, (Object)string);
                            break block26;
                        }
                        if (stringArray.length != 0) {
                            if (bl) {
                                this.debugMessageLn("value is multivalued! inconsistent w/ propId");
                            }
                            if (bl) {
                                this.debugMessageLn("val='" + stringArray[0] + "'");
                            }
                            this.setProp(n2, (Object)stringArray[stringArray.length - 1]);
                        }
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                }
            }
            ++n;
        }
        if (bl) {
            this.debugMessageLn("Done");
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "view_audit_log_properties";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 2686979: {
                return new Integer(1);
            }
            case 3080204: {
                return new Integer(8196);
            }
            case 2031768: {
                return LDAPLang.getStrAuditLogEntry();
            }
            case 0x110001: {
                return this.m_displayName;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

