/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import oracle.ldap.admin.AuditLog;
import oracle.ldap.admin.AuditLogSample;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminDirectory;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.Util;

public class AuditLogs
extends Directory {
    Vector m_indexedAttrIds;
    Object m_criteria;

    public AuditLogs(Root root) {
        super(root);
        this.m_basedn = "cn=auditlog";
        this.m_children = null;
    }

    public void registerMessages() {
        super.registerMessages();
        this.unregisterProp(0x103100);
        this.unregisterProp(1061122);
    }

    public void initProps() throws PropertyException {
        super.initProps();
        this.setProp(1061129, (Object)"(objectclass=*)");
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 276759696: {
                return this.getIndexAttrTypes();
            }
            case 276759697: {
                return this.getIndexAttrOpList();
            }
            case 1048745: {
                return "viewing_audit_logs";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1639559: {
                return LDAPLang.getStrViewProps();
            }
            case 0x110001: {
                return LDAPLang.getStrDisplayName22();
            }
            case 1638408: {
                return "images/auditlog.gif";
            }
            case 3080204: {
                String[] stringArray = this.getAttributeNames();
                if (stringArray == null || stringArray.length == 0) {
                    this.setProp(7929867, (Object)LDAPLang.getStrNoAuditlogMgmt());
                    return new Integer(1);
                }
                if (Root.isClientCommandLine()) {
                    return new Integer(3153924);
                }
                return new Integer(260);
            }
            case 273612805: {
                n = 273219601;
                break;
            }
            case 272695330: 
            case 273220108: 
            case 273613313: {
                return null;
            }
            case 2686995: 
            case 0x10110021: 
            case 281083936: 
            case 282001424: {
                if (this.getSampleChild() == null) {
                    this.setSampleChild(new AuditLogSample((Root)this.getParent()));
                }
                return this.getTableProp(n, this.m_children, this.m_childrenArr, this.m_sampleChild);
            }
            case 275841152: {
                GridBagConstraints gridBagConstraints;
                GridBagConstraints[] gridBagConstraintsArray = null;
                int n2 = 0;
                gridBagConstraintsArray = new GridBagConstraints[6 + 6 * this.m_termCount];
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = null;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets.left = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets.top = 10;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                return gridBagConstraintsArray;
            }
        }
        return super.getProp(n);
    }

    private Object[] getIndexAttrTypes() {
        String[] stringArray = AuditLog.getAuditAttributes();
        Object[] objectArray = AuditLog.getAuditAttrTypes();
        String[] stringArray2 = this.getAttributeNames();
        Vector<Object> vector = new Vector<Object>();
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray2[n].equalsIgnoreCase(stringArray[n2])) {
                    vector.addElement(objectArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        return AdminProp.vectorToObjectArray(vector);
    }

    private Object[] getIndexAttrOpList() {
        String[] stringArray = AuditLog.getAuditAttributes();
        Object[] objectArray = AuditLog.getAuditAttrOpList();
        String[] stringArray2 = this.getAttributeNames();
        Vector<Object> vector = new Vector<Object>();
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray2[n].equalsIgnoreCase(stringArray[n2])) {
                    vector.addElement(objectArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        return AdminProp.vectorToObjectArray(vector);
    }

    public String[] getAttributeNames() {
        this.setSubSchema(this.m_parent.getSubSchema());
        Object[] objectArray = AuditLog.getAuditAttributes();
        Vector vector = AdminProp.objectArrayToVector(objectArray);
        Vector vector2 = null;
        try {
            vector2 = AdminProp.objectArrayToVector(this.getAttributeNames(null, false, true));
        }
        catch (PropertyException propertyException) {
            return null;
        }
        if (vector == null || vector2 == null) {
            return null;
        }
        Util.intersect(vector, vector2);
        this.m_indexedAttributes = vector;
        this.m_indexedAttrIds = new Vector();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_indexedAttrIds.addElement(this.getAttrPropId(this.m_indexedAttributes.elementAt(n2)));
            ++n2;
        }
        if (vector.size() != 0) {
            String[] stringArray = AdminProp.vectorToStringArray(vector);
            this.m_defaultAttr = this.m_parent.getAttrDisplayName(stringArray[0]);
            return stringArray;
        }
        return null;
    }

    public Integer getAttrPropId(Object object) {
        Integer n = this.m_parent.getAttrPropId(object);
        return new Integer(AuditLog.convertPropId((String)object, n));
    }

    public void addChild(Object object) {
        if (this.m_nonIndexPropUseCount == 0) {
            super.addChild(object);
            return;
        }
        if (this.match(this.m_criteria, (IAdminProp)object)) {
            super.addChild(object);
            return;
        }
    }

    public boolean match(int n, Object object, String string, int n2) {
        String string2 = object == null ? "" : object.toString();
        switch (n2) {
            case 0x100000: {
                if (string2 == null) {
                    string2 = "";
                }
                switch (n) {
                    case 4: {
                        return string.equalsIgnoreCase(string2);
                    }
                    case 2: {
                        return string2.toLowerCase().startsWith(string.toLowerCase());
                    }
                    case 3: {
                        return string2.toLowerCase().endsWith(string.toLowerCase());
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return string2.toLowerCase().compareTo(string.toLowerCase()) >= 0;
                    }
                    case 6: {
                        return string2.toLowerCase().compareTo(string.toLowerCase()) <= 0;
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
            case 0x200000: {
                Integer n3 = object instanceof String ? new Integer((String)object) : (Integer)object;
                if (n3 == null) {
                    return n != 7;
                }
                Integer n4 = new Integer(0);
                try {
                    n4 = Integer.valueOf(string);
                }
                catch (Exception exception) {}
                switch (n) {
                    case 4: {
                        return n3.equals(n4);
                    }
                    case 2: {
                        return string2.startsWith(string);
                    }
                    case 3: {
                        return string2.endsWith(string);
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return n3 >= n4;
                    }
                    case 6: {
                        return n3 <= n4;
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
            case 0x300000: {
                Date date = (Date)object;
                if (date == null) {
                    return n != 7;
                }
                Date date2 = null;
                try {
                    date2 = DateFormat.getDateTimeInstance().parse(string);
                }
                catch (Exception exception) {
                    return true;
                }
                switch (n) {
                    case 4: {
                        return date.equals(date2);
                    }
                    case 2: {
                        return string2.startsWith(string);
                    }
                    case 3: {
                        return string2.endsWith(string);
                    }
                    case 7: {
                        return object != null;
                    }
                    case 1: {
                        return string2.toLowerCase().indexOf(string.toLowerCase()) >= 0;
                    }
                    case 5: {
                        return date.after(date2) || date.equals(date2);
                    }
                    case 6: {
                        return date.before(date2) || date.equals(date2);
                    }
                    case 8: {
                        return true;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public boolean match(Object object, IAdminProp iAdminProp) {
        if (AdminDirectory.criteriaGetOperator(object) instanceof Integer) {
            Integer n;
            Object object2 = AdminDirectory.criteriaGetOperand(object, 0);
            if (!(object2 instanceof Integer)) {
                if (!(object2 instanceof String)) {
                    return true;
                }
                n = this.m_parent.getAttrPropId((String)object2);
            } else {
                n = (Integer)AdminDirectory.criteriaGetOperand(object, 0);
            }
            if (this.m_indexedAttrIds.contains(n)) {
                return true;
            }
            Integer n2 = (Integer)AdminDirectory.criteriaGetOperator(object);
            String string = (String)AdminDirectory.criteriaGetOperand(object, 1);
            Object object3 = null;
            try {
                object3 = iAdminProp.getProp(n);
            }
            catch (Exception exception) {
                return true;
            }
            return this.match(n2, object3, string, AdminProp.getPropType(n));
        }
        if (AdminDirectory.criteriaGetOperator(object) instanceof String) {
            int n = AdminDirectory.criteriaGetArity(object);
            String string = (String)AdminDirectory.criteriaGetOperator(object);
            String string2 = string.substring(0, 1);
            if (n == 1 && (string2.equals("&") || string2.equals("|"))) {
                return this.match(AdminDirectory.criteriaGetOperand(object, 0), iAdminProp);
            }
            if (string2.equals("&")) {
                int n3 = 0;
                while (n3 < n) {
                    if (!this.match(AdminDirectory.criteriaGetOperand(object, n3), iAdminProp)) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
            if (string2.equals("|")) {
                int n4 = 0;
                while (n4 < n) {
                    if (this.match(AdminDirectory.criteriaGetOperand(object, n4), iAdminProp)) {
                        return true;
                    }
                    ++n4;
                }
                return false;
            }
            return !this.match(AdminDirectory.criteriaGetOperand(object, 0), iAdminProp);
        }
        return true;
    }

    public Object transformCriteria(Object object, Root root) throws PropertyException {
        this.m_nonIndexPropUseCount = 0;
        this.m_criteria = null;
        Object object2 = this.transformCriteria(object, root, false, true);
        if (this.m_nonIndexPropUseCount != 0) {
            this.m_criteria = this.transformCriteria(object, root, true, false);
        }
        return object2;
    }

    public void cleanup() {
        super.cleanup();
        if (this.m_indexedAttrIds != null) {
            this.m_indexedAttrIds.removeAllElements();
        }
        this.m_indexedAttrIds = null;
        this.m_criteria = null;
    }
}

