/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Options;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminPropGridView;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ConfigEntryMgmt
extends AdminProp {
    static final int PR_SIZELIMIT = 0x203000;
    static final int PR_TIMELIMIT = 2109441;
    Server m_server;
    Options m_options;

    public ConfigEntryMgmt() {
    }

    public ConfigEntryMgmt(Options options, Server server) {
        this.m_server = server;
        this.m_options = options;
    }

    public void initProps() throws PropertyException {
        this.setProp(3080204, 16);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "setentrymngmnt";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                return LDAPLang.getStrMenuConfigEntryMgmt();
            }
            case 0x110001: {
                return LDAPLang.getStrMenuConfigEntryMgmt();
            }
            case 0x203000: {
                return this.m_server.getSizeLimit();
            }
            case 2109441: {
                return this.m_server.getTimeLimit();
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x203000: {
                this.m_server.setSizeLimit((Integer)object);
                return;
            }
            case 2109441: {
                this.m_server.setTimeLimit((Integer)object);
                return;
            }
        }
        super.setProp(n, object);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x203000, LDAPLang.getStrSizeLimitLabel(), "");
        this.registerProp(2109441, LDAPLang.getStrTimeLimitLabel(), "");
        this.registerPropUnits(2109441, IAdminPropGridView.PU_SECONDS);
        this.registerPropRange(2109441, 25, 3600);
    }

    public void saveChanges(int n) throws SaveChangeException {
        this.m_server.getServerList().getCfgFile().saveData();
    }
}

