/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.DirTree;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewProcConnector;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.ProcConnector;
import oracle.ldap.admin.ProcMetaConfSet;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SampleProcConnector;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Connectors
extends AdminList
implements ICommandParent {
    static final String DN_CONN_PROFILE = "cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory";
    static final String CONN_RDN_PREFIX = "orclmetaconnname=";
    ProcMetaConfSet m_confSet;
    IAdminProp[] _cmdList;
    IAdminProp[] m_selection;
    ProcConfSets m_holder;

    public Connectors(Root root, ProcMetaConfSet procMetaConfSet, ProcConfSets procConfSets) {
        super((IAdminProp)root, new Vector());
        this.m_confSet = procMetaConfSet;
        this.m_holder = procConfSets;
        this.setSampleChild(new SampleProcConnector(root));
        try {
            this.loadConnectors();
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        this.buildCmdList();
    }

    public void buildCmdList() {
        try {
            this._cmdList = new CommandProp[5];
            int n = 0;
            this._cmdList[n++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrCreateLabel(), LDAPLang.getStrCreateDesc(), "images/create.gif");
            this._cmdList[n++] = new CommandProp(this, -10, LDAPLang.getStrCreateLikeLabel(), LDAPLang.getStrCreateLikeDescp7(), "images/createlike.gif", 1, 1);
            this._cmdList[n++] = new CommandProp(this, -51, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDescp1(), "images/edit.gif", 1, 1);
            this._cmdList[n++] = new CommandProp(this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDescp5(), "images/delete.gif", 1, 0);
            this._cmdList[n - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
            this._cmdList[n++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), String.valueOf(LDAPLang.getStrRefreshDescp6()) + "...", "images/refresh.gif");
            this._cmdList[n - 1].setProp(2687509, new Integer(4));
            this.setCommandList(this._cmdList);
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1638408: {
                return "images/msprpms.gif";
            }
            case 3080204: {
                return new Integer(66);
            }
            case 2162725: {
                return new Integer(51264);
            }
            case 2031768: {
                return LDAPLang.getStrConnectors();
            }
            case 4260001: {
                return this.m_parent;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 273220105: {
                this.m_selection = (IAdminProp[])object;
            }
        }
        super.setProp(n, object);
    }

    void loadConnectors() throws PropertyException {
        boolean bl = Root.debugConfMgmt;
        String[] stringArray = new String[]{"*"};
        int[] nArray = new int[]{7};
        String[] stringArray2 = new String[]{"objectclass"};
        int n = DirTree.m_sizeLimit;
        int n2 = DirTree.m_timeLimit;
        ((AdminProp)this.m_parent).setErrorMessage("");
        try {
            boolean bl2 = ((Root)this.m_parent).m_serverAccess.findEntry(stringArray, nArray, DN_CONN_PROFILE, false, null, (Object)this, n, n2, stringArray2);
        }
        catch (Exception exception) {
            if (bl) {
                this.debugMessageLn(exception.getMessage());
            }
            throw new PropertyException(exception);
        }
        String string = ((AdminProp)this.m_parent).getErrorMessage();
        if (!string.equals("") && bl) {
            this.debugMessageLn(string);
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            IAdminProp[] iAdminPropArray;
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == -8) {
                NewProcConnector newProcConnector = new NewProcConnector((Root)this.m_parent, "", "", null, false, this);
                return newProcConnector;
            }
            if (n == -9) {
                IAdminProp[] iAdminPropArray2 = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray2 != null) {
                    this.delete((Entry)iAdminPropArray2[0]);
                }
                return null;
            }
            if (n == -51 && (iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105)) != null) {
                return iAdminPropArray[0];
            }
            if (n == -10) {
                iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                ProcConnector procConnector = (ProcConnector)iAdminPropArray[0];
                NewProcConnector newProcConnector = new NewProcConnector((Root)this.m_parent, "", procConnector.getDisplayMsg(), procConnector.getAttributes(), true, this);
                return newProcConnector;
            }
            if (n == -5) {
                this.refresh(iAdminProp);
                return null;
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public void refresh(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        this.m_children = null;
        this.sendAdminPropertyChangeEvents(273612805, null);
        this.sendAdminPropertyChangeEvents(273219601, null);
        this.loadConnectors();
        this.update();
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
    }

    void delete(Entry entry) throws PropertyException {
        if (!((Root)this.m_parent).deleteEntry(entry)) {
            throw new PropertyException(((Root)this.m_parent).getErrorMessage());
        }
        this.removeChild(entry);
        this.makeInvalid();
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            if (this.m_selection != null && this.m_selection[0] != null) {
                this.m_confSet.addChild((AdminProp)this.m_selection[0]);
                if (this.m_confSet.save()) {
                    this.m_confSet.update();
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
    }

    public ProcConfSets getHolder() {
        return this.m_holder;
    }
}

