/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import oracle.ldap.admin.AuditLogs;
import oracle.ldap.admin.DirTree;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ManageTableColumns;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.NewEntry;
import oracle.ldap.admin.PathSelector;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminDirectory;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class Directory
extends AdminDirectory
implements ICommandParent {
    static boolean DEBUG = Root.debugDirectory;
    static final int CMD_MAN_TABLE_COL = -8192;
    static String[] m_searchTypes = null;
    Root m_parent;
    String m_searchType = m_searchTypes[2];
    IAdminProp[] m_tabObjList;
    Integer m_dnPropId;
    DirTree m_dirTree;
    DirTree m_dirChildren;
    Vector m_indexedAttributes;
    int m_nonIndexPropUseCount;
    static final int PR_BASEDN = 0x103100;
    static final int PR_BASEDN_RO = 1454336;
    static final int PR_MAX_RESULTS = 2633985;
    static final int PR_MAX_TIME = 2633987;
    static final int PR_SEARCH_TYPE = 1061122;
    static String[] SEARCH_TYPE_LOV = new String[7];
    static String[] SEARCH_TYPE_LOV_INT;
    static String[] SEARCH_TYPE_LOV_DATE;
    String m_basedn = "";
    int m_maxResults = 100;
    int m_maxTime = 25;
    SubSchema m_subSchema;
    public Vector m_deletableAttrs = new Vector();
    int[] m_tablePropList;
    String[] m_tableNameList;
    int[] m_tableWidthList;
    Names m_adminNames;

    public void registerMessages() {
        super.registerMessages();
        if (m_searchTypes == null) {
            m_searchTypes = new String[3];
            Directory.m_searchTypes[0] = LDAPLang.getStrSrctypeBase();
            Directory.m_searchTypes[1] = LDAPLang.getStrSrctypeOnelevel();
            Directory.m_searchTypes[2] = LDAPLang.getStrSrctypeSubtree();
        }
        this.registerProp(0x103100, LDAPLang.getStrBasednPlbl(), LDAPLang.getStrBasednPdsc());
        this.registerProp(1061122, LDAPLang.getStrSearchTypePlbl(), LDAPLang.getStrSearchTypePdsc());
        this.registerPropListOfValues(1061122, m_searchTypes);
        this.registerProp(2633985, LDAPLang.getStrMaxResultsPlbl(), LDAPLang.getStrMaxResultsPdsc());
        this.registerProp(2633987, LDAPLang.getStrMaxTimePlbl(), LDAPLang.getStrMaxTimePdsc());
        this.registerPropRange(2633987, 25, 3600);
        this.registerProp(0x110001, LDAPLang.getStrDisplayNamePlbl1(), LDAPLang.getStrEmptyString());
        if (SEARCH_TYPE_LOV[0] == null) {
            Directory.SEARCH_TYPE_LOV[0] = LDAPLang.getStrBeginsWith();
            Directory.SEARCH_TYPE_LOV[1] = LDAPLang.getStrEndsWith();
            Directory.SEARCH_TYPE_LOV[2] = LDAPLang.getStrContains();
            Directory.SEARCH_TYPE_LOV[3] = LDAPLang.getStrExactMatch();
            Directory.SEARCH_TYPE_LOV[4] = LDAPLang.getStrGrtOrEq();
            Directory.SEARCH_TYPE_LOV[5] = LDAPLang.getStrLssOrEq();
            Directory.SEARCH_TYPE_LOV[6] = LDAPLang.getStrPresent();
        }
        if (SEARCH_TYPE_LOV_DATE[0] == null) {
            Directory.SEARCH_TYPE_LOV_DATE[0] = LDAPLang.getStrExactMatch();
            Directory.SEARCH_TYPE_LOV_DATE[1] = LDAPLang.getStrGrtOrEq();
            Directory.SEARCH_TYPE_LOV_DATE[2] = LDAPLang.getStrLssOrEq();
            Directory.SEARCH_TYPE_LOV_DATE[3] = LDAPLang.getStrPresent();
            SEARCH_TYPE_LOV_INT = SEARCH_TYPE_LOV_DATE;
        }
        this.setPropHidden(1061129, true, false);
    }

    public Directory() {
    }

    public Directory(Root root) {
        super((IAdminProp)root, "Common Name", "Begins With");
        this.m_parent = root;
        this.m_maxTime = this.m_parent.getTimelimit();
        this.m_maxResults = this.m_parent.getSizelimit();
        this.m_defaultOp = SEARCH_TYPE_LOV[0];
        Vector vector = root.getSubSchemas();
        if (vector != null && vector.size() != 0) {
            this.setSubSchema((SubSchema)vector.elementAt(0));
        }
        try {
            this.setProp(0x110001, (Object)LDAPLang.getStrDisplayName5());
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.m_dirChildren = new DirTree(this.m_parent, null);
        this.m_dnPropId = this.m_parent.getAttrPropId("dn");
        this.registerPropListOfValues(0x103100, new PathSelector(this.m_parent));
    }

    public void setSubSchema(SubSchema subSchema) {
        this.m_subSchema = subSchema;
    }

    public SubSchema getSubSchema() {
        return this.m_subSchema;
    }

    public boolean hasSubSchema() {
        if (this.m_subSchema == null) {
            return false;
        }
        return this.m_subSchema.countChildren() != 0;
    }

    public Object getProp(int n) throws PropertyException {
        GridBagConstraints[] gridBagConstraintsArray = null;
        int n2 = 0;
        switch (n) {
            case 2162855: {
                return this.m_dnPropId;
            }
            case 1048745: {
                return "using_the_search_pane";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/entrymgmnt.gif";
            }
            case 0x110001: {
                return LDAPLang.getStrDisplayName5();
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle9();
            }
            case 2686979: {
                return new Integer(35);
            }
            case 3080204: {
                if (!this.hasSubSchema()) {
                    return new Integer(0x300001);
                }
                return new Integer(3145988);
            }
            case 2687386: {
                Integer n3 = (Integer)super.getProp(n);
                if (n3 != null) {
                    return new Integer((int)(n3 | 0x100000));
                }
                return new Integer(0x100000);
            }
            case 273612805: {
                if (this.m_dirChildren == null) {
                    return null;
                }
                return this.m_dirChildren.getProp(n);
            }
            case 273613313: {
                if (this.m_dirChildren != null) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[2];
                    int n4 = 0;
                    iAdminPropArray[n4++] = new CommandProp((IAdminProp)this.m_parent, -8, LDAPLang.getStrCreateLabel(), LDAPLang.getStrNewEntryDesc(), "images/create.gif");
                    if (!this.hasSubSchema()) {
                        iAdminPropArray[n4 - 1].setProp(8978948, new Boolean(false));
                    }
                    iAdminPropArray[n4++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), LDAPLang.getStrCmdRefresh(), "images/refresh.gif");
                    return iAdminPropArray;
                }
                return null;
            }
            case 272695330: 
            case 272696422: {
                if (this.m_tabObjList == null) {
                    this.m_tabObjList = new IAdminProp[1];
                    int[] nArray = new int[]{0x110001, 3080204, 273613313, 273220108};
                    IAdminProp[] iAdminPropArray = new IAdminProp[2];
                    n2 = 0;
                    iAdminPropArray[n2++] = new CommandProp(this, -10, LDAPLang.getStrCreateLikeLabel(), LDAPLang.getStrNewLikeDesc(), "images/createlike.gif", 1, 1);
                    iAdminPropArray[n2++] = new CommandProp(this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc4(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n2 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete1());
                    IAdminProp[] iAdminPropArray2 = new IAdminProp[]{new CommandProp((IAdminProp)this, -8192, LDAPLang.getStrManTableColName(), LDAPLang.getStrManTableColDesc(), "images/changetableprops.gif")};
                    Object[] objectArray = new Object[]{"List", new Integer(64), iAdminPropArray2, iAdminPropArray};
                    this.m_tabObjList[0] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                }
                return this.m_tabObjList;
            }
            case 275841152: {
                GridBagConstraints gridBagConstraints;
                gridBagConstraintsArray = new GridBagConstraints[10 + 6 * this.m_termCount];
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets.top = 0;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = null;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.insets.left = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets.top = 10;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                return gridBagConstraintsArray;
            }
            case 1061122: {
                return this.m_searchType;
            }
            case 2633985: {
                return new Integer(this.m_maxResults);
            }
            case 2633987: {
                return new Integer(this.m_maxTime);
            }
            case 0x103100: 
            case 1454336: {
                return this.m_basedn;
            }
            case 5177493: {
                return this.createChild();
            }
            case 2686995: {
                return new Integer(this.getTableColumnCount());
            }
            case 0x10110021: {
                return this.getTableColumnNameList();
            }
            case 282001424: {
                return this.getTableColumnPropList();
            }
            case 281083936: {
                return this.getTableColumnWidthList();
            }
            case 7929867: {
                int n5 = (Integer)this.getProp(3080204);
                if ((n5 & 1) != 1) break;
                PropertyException propertyException = new PropertyException(LDAPLang.getStrErrInsufficientAccessRights());
                propertyException.setReminder();
                throw propertyException;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1061122: {
                this.m_searchType = (String)object;
                return;
            }
            case 2633985: {
                this.m_maxResults = (Integer)object;
                return;
            }
            case 2633987: {
                this.m_maxTime = (Integer)object;
                return;
            }
            case 0x103100: 
            case 1454336: {
                this.m_basedn = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public String getStrBeginsWith() {
        return SEARCH_TYPE_LOV[0];
    }

    public String[] getOperationNames() {
        return SEARCH_TYPE_LOV;
    }

    public String getSearchTypeString(int n) {
        switch (n) {
            case 2: {
                return SEARCH_TYPE_LOV[0];
            }
            case 3: {
                return SEARCH_TYPE_LOV[1];
            }
            case 1: {
                return SEARCH_TYPE_LOV[2];
            }
            case 4: {
                return SEARCH_TYPE_LOV[3];
            }
            case 5: {
                return SEARCH_TYPE_LOV[4];
            }
            case 6: {
                return SEARCH_TYPE_LOV[5];
            }
            case 7: {
                return SEARCH_TYPE_LOV[6];
            }
        }
        return SEARCH_TYPE_LOV[7];
    }

    public int getSearchType(String string) {
        int n = 1;
        if (string.equals(SEARCH_TYPE_LOV[0])) {
            n = 2;
        } else if (string.equals(SEARCH_TYPE_LOV[1])) {
            n = 3;
        } else if (string.equals(SEARCH_TYPE_LOV[2])) {
            n = 1;
        } else if (string.equals(SEARCH_TYPE_LOV[3])) {
            n = 4;
        } else if (string.equals(SEARCH_TYPE_LOV[4])) {
            n = 5;
        } else if (string.equals(SEARCH_TYPE_LOV[5])) {
            n = 6;
        } else if (string.equals(SEARCH_TYPE_LOV[6])) {
            n = 7;
        } else if (string.equals(SEARCH_TYPE_LOV[7])) {
            n = 8;
        }
        return n;
    }

    public void printIt(Object object, String string) {
        if (object instanceof String) {
            System.out.println(String.valueOf(string) + object);
            return;
        }
        System.out.println(String.valueOf(string) + "op=" + AdminDirectory.criteriaGetOperator(object));
        int n = AdminDirectory.criteriaGetArity(object);
        System.out.println(String.valueOf(string) + "arity=" + n);
        string = String.valueOf(string) + " ";
        int n2 = 0;
        while (n2 < n) {
            this.printIt(AdminDirectory.criteriaGetOperand(object, n2), string);
            ++n2;
        }
    }

    public Object writeStringToCriteria(String string, Root root) {
        int n = (string = string.trim()).length();
        if (n < 3) {
            return null;
        }
        if (string.charAt(0) != '(') {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        switch (string.charAt(1)) {
            case '!': 
            case '&': 
            case '|': {
                int n3 = 2;
                while (n3 < n) {
                    int n4 = n3;
                    while (n4 < n) {
                        if (string.charAt(n4) == ')') {
                            return AdminDirectory.criteriaCreate(string.substring(1, 2), vector);
                        }
                        if (string.charAt(n4) == '(') break;
                        ++n4;
                    }
                    if (n4 >= n) {
                        return null;
                    }
                    n2 = 0;
                    int n5 = n4 + 1;
                    while (n5 < n) {
                        if (string.charAt(n5) == '(') {
                            ++n2;
                        }
                        if (string.charAt(n5) == ')') {
                            if (n2 == 0) break;
                            --n2;
                        }
                        ++n5;
                    }
                    if (n5 >= n) {
                        return null;
                    }
                    Object object = this.writeStringToCriteria(string.substring(n4, n5 + 1), root);
                    if (object == null) {
                        return null;
                    }
                    vector.addElement(object);
                    n3 = n5;
                    ++n3;
                }
                break;
            }
            default: {
                string = string.substring(1, string.length() - 1);
                String string2 = "";
                int n6 = string.indexOf("<=");
                if (n6 > 0) {
                    String string3 = string.substring(0, n6).trim();
                    if ((string3 = root.getAttrDisplayName(string3)) == null) {
                        return null;
                    }
                    String string4 = string.substring(n6 + 2).trim();
                    string2 = LDAPLang.getStrLssOrEq();
                    vector.addElement(string3);
                    vector.addElement(string4);
                    return AdminDirectory.criteriaCreate(string2, vector);
                }
                n6 = string.indexOf(">=");
                if (n6 > 0) {
                    String string5 = string.substring(0, n6).trim();
                    if ((string5 = root.getAttrDisplayName(string5)) == null) {
                        return null;
                    }
                    String string6 = string.substring(n6 + 2).trim();
                    string2 = LDAPLang.getStrGrtOrEq();
                    vector.addElement(string5);
                    vector.addElement(string6);
                    return AdminDirectory.criteriaCreate(string2, vector);
                }
                n6 = string.indexOf("~=");
                if (n6 > 0) {
                    String string7 = string.substring(0, n6).trim();
                    if ((string7 = root.getAttrDisplayName(string7)) == null) {
                        return null;
                    }
                    String string8 = string.substring(n6 + 2).trim();
                    string2 = LDAPLang.getStrApproxMatch();
                    vector.addElement(string7);
                    vector.addElement(string8);
                    return AdminDirectory.criteriaCreate(string2, vector);
                }
                n6 = string.indexOf("=");
                if (n6 <= 0) break;
                String string9 = string.substring(0, n6).trim();
                if ((string9 = root.getAttrDisplayName(string9)) == null) {
                    return null;
                }
                String string10 = string.substring(n6 + 1).trim();
                if (string10.equals("*")) {
                    string2 = LDAPLang.getStrBeginsWith();
                } else if (string10.equals("")) {
                    string2 = LDAPLang.getStrBeginsWith();
                } else if (string10.startsWith("*")) {
                    if (string10.endsWith("*")) {
                        string10 = string10.substring(1, string10.length() - 1);
                        string2 = LDAPLang.getStrContains();
                    } else {
                        string10 = string10.substring(1);
                        string2 = LDAPLang.getStrEndsWith();
                    }
                } else if (string10.endsWith("*")) {
                    string10 = string10.substring(0, string10.length() - 1);
                    string2 = LDAPLang.getStrBeginsWith();
                } else {
                    string2 = LDAPLang.getStrExactMatch();
                }
                vector.addElement(string9);
                vector.addElement(string10);
                return AdminDirectory.criteriaCreate(string2, vector);
            }
        }
        return null;
    }

    public void writeCriteriaToString(Object object, PrintWriter printWriter) {
        if (AdminDirectory.criteriaGetOperator(object) instanceof Integer) {
            printWriter.print("(");
            printWriter.print(AdminDirectory.criteriaGetOperand(object, 0));
            Integer n = (Integer)AdminDirectory.criteriaGetOperator(object);
            switch (n) {
                case 2: 
                case 4: {
                    printWriter.print("=");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    break;
                }
                case 3: {
                    printWriter.print("=");
                    printWriter.print("*");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    break;
                }
                case 7: {
                    printWriter.print("=");
                    printWriter.print("*");
                    break;
                }
                case 1: {
                    printWriter.print("=");
                    printWriter.print("*");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    printWriter.print("*");
                    break;
                }
                case 5: {
                    printWriter.print(">=");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    break;
                }
                case 6: {
                    printWriter.print("<=");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    break;
                }
                case 8: {
                    printWriter.print("~=");
                    printWriter.print(AdminDirectory.criteriaGetOperand(object, 1));
                    break;
                }
            }
            switch (n) {
                case 2: {
                    printWriter.print("*");
                    break;
                }
            }
            printWriter.print(")");
            return;
        }
        if (AdminDirectory.criteriaGetOperator(object) instanceof String) {
            int n = AdminDirectory.criteriaGetArity(object);
            String string = (String)AdminDirectory.criteriaGetOperator(object);
            String string2 = string.substring(0, 1);
            if (n == 1 && (string2.equals("&") || string2.equals("|"))) {
                this.writeCriteriaToString(AdminDirectory.criteriaGetOperand(object, 0), printWriter);
                return;
            }
            printWriter.print("(");
            printWriter.print(string2);
            int n2 = 0;
            while (n2 < n) {
                this.writeCriteriaToString(AdminDirectory.criteriaGetOperand(object, n2), printWriter);
                ++n2;
            }
            printWriter.print(")");
        }
    }

    public String criteriaToString(Object object) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeCriteriaToString(object, printWriter);
        return stringWriter.toString();
    }

    public boolean isKnownOperator(String string) {
        int n = 0;
        while (n < SEARCH_TYPE_LOV.length) {
            if (string.equals(SEARCH_TYPE_LOV[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object transformCriteria(Object object, Root root, boolean bl, boolean bl2) throws PropertyException {
        if (object instanceof String) return object;
        String string = (String)AdminDirectory.criteriaGetOperator(object);
        int n = AdminDirectory.criteriaGetArity(object);
        object = AdminDirectory.criteriaClone(object);
        if (n == 2 && this.isKnownOperator(string)) {
            String string2 = (String)AdminDirectory.criteriaGetOperand(object, 0);
            String string3 = root.getAttrInternalName(string2);
            if (string3 == null && string3 == null) {
                Object[] objectArray = new Object[]{string3};
                throw new PropertyException(this.getMessage(LDAPLang.getStrCannotConvert(), objectArray));
            }
            String string4 = (String)AdminDirectory.criteriaGetOperand(object, 1);
            int n2 = this.getSearchType(string);
            if (bl2 && this.m_indexedAttributes != null && this.m_indexedAttributes.size() > 0 && !this.m_indexedAttributes.contains(string3)) {
                ++this.m_nonIndexPropUseCount;
                n2 = 7;
                string3 = "objectclass";
                string4 = "*";
            }
            if (bl) {
                AdminDirectory.criteriaSetOperand(object, 0, this.getAttrPropId(string3));
            } else if (!string2.equals(string3)) {
                AdminDirectory.criteriaSetOperand(object, 0, string3);
            }
            if (string4 != null) {
                string4 = string4.trim();
            }
            if ((string4 == null || string4.equals("")) && n2 != 7) {
                String string5 = LDAPLang.getStrNoQueryGiven();
                Object[] objectArray = new Object[]{string5, string2, string};
                throw new PropertyException(this.getMessage(LDAPLang.getStrNoQueryGiven2(), objectArray));
            }
            AdminDirectory.criteriaSetOperator(object, new Integer(n2));
            if (!string4.equals("*")) return object;
            switch (n2) {
                case 2: 
                case 3: 
                case 4: {
                    AdminDirectory.criteriaSetOperator(object, new Integer(7));
                    return object;
                }
                default: {
                    return object;
                }
            }
        }
        int n3 = 0;
        while (n3 < n) {
            AdminDirectory.criteriaSetOperand(object, n3, this.transformCriteria(AdminDirectory.criteriaGetOperand(object, n3), root, bl, bl2));
            ++n3;
        }
        return object;
    }

    public Object transformCriteria(Object object, Root root) throws PropertyException {
        return this.transformCriteria(object, root, false, false);
    }

    public IAdminProp getSearchResults(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        try {
            this.doSearch();
            Object var3_5 = null;
            ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
            if (Root.isClientCommandLine()) {
                AdminList adminList = this.countChildren() > 0 ? new AdminList((IAdminProp)this, this.getChildren()) : new AdminList((IAdminProp)this, new Vector());
                adminList.setDisplayName("Search Results");
                return adminList;
            }
            throw throwable;
        }
        if (Root.isClientCommandLine()) {
            AdminList adminList = this.countChildren() > 0 ? new AdminList((IAdminProp)this, this.getChildren()) : new AdminList((IAdminProp)this, new Vector());
            adminList.setDisplayName("Search Results");
            return adminList;
        }
        return null;
    }

    public void doSearch() throws PropertyException {
        Object object;
        String string;
        Object object2 = this.getProp(8324195);
        if (object2 == null) {
            string = (String)this.getProp(1061129);
            if (string == null) {
                throw new PropertyException(LDAPLang.getStrNoCriteria());
            }
            object2 = this.writeStringToCriteria(string, this.m_parent);
            if (object2 == null) {
                throw new PropertyException(LDAPLang.getStrNoCriteria());
            }
            object2 = this.transformCriteria(object2, this.m_parent);
            if (DEBUG) {
                System.out.println("PR_SEARCH_STRING IN  = " + string);
                System.out.println("PR_SEARCH_STRING OUT = " + this.criteriaToString(object2));
                System.out.print("PR_SEARCH_STRING OUT = ");
                this.printIt(object2, "");
                System.out.println();
            }
        } else {
            object2 = this.transformCriteria(object2, this.m_parent);
            string = this.criteriaToString(object2);
            if (DEBUG) {
                System.out.println("ldapSearchString = " + string);
                this.writeStringToCriteria(string, this.m_parent);
            }
        }
        int n = 3;
        if (this.m_searchType.equals(m_searchTypes[0])) {
            n = 1;
        } else if (this.m_searchType.equals(m_searchTypes[1])) {
            n = 2;
        }
        Runtime runtime = Runtime.getRuntime();
        int n2 = this.countChildren();
        int n3 = 0;
        while (n3 < n2) {
            object = (String[])this.nthChild(n3);
            if (object instanceof DirTree) {
                ((DirTree)object).cleanup();
            }
            ++n3;
        }
        this.setChildren((Vector)null);
        runtime.gc();
        object = this instanceof AuditLogs ? null : new String[]{"dn"};
        try {
            this.m_parent.setErrorMessage("");
            boolean bl = this.m_parent.m_serverAccess.findEntry(string, object2, this.m_basedn, n, (String[])object, this, this.m_maxResults, this.m_maxTime);
            if (bl) {
                if (this.countChildren() == 0) {
                    String string2 = this.m_parent.getErrorMessage();
                    PropertyException propertyException = new PropertyException(string2.equals("") ? LDAPLang.getStrNullResults() : string2);
                    propertyException.setNotice();
                    throw propertyException;
                }
                this.update();
                if (this.countChildren() == 1) {
                    this.setStatusMessage("1 entry found.");
                } else {
                    this.setStatusMessage(String.valueOf(this.countChildren()) + " entries found.");
                }
                String string3 = this.m_parent.getErrorMessage();
                if (!string3.equals("")) {
                    PropertyException propertyException = new PropertyException(string3);
                    propertyException.setNotice();
                    throw propertyException;
                }
            } else {
                if (this.countChildren() == 0) {
                    String string4 = this.m_parent.getErrorMessage();
                    PropertyException propertyException = new PropertyException(string4.equals("") ? LDAPLang.getStrIncompleteSearch() : string4);
                    propertyException.setNotice();
                    throw propertyException;
                }
                if (this.countChildren() == 1) {
                    this.setStatusMessage(LDAPLang.getStrOneEntryFound());
                } else {
                    Object[] objectArray = new Object[]{new Integer(this.countChildren())};
                    this.setStatusMessage(this.getMessage(LDAPLang.getStrXEntriesFound(), objectArray));
                }
            }
            if (this.m_dirTree != null) {
                this.m_dirTree.refresh();
                return;
            }
        }
        catch (IOException iOException) {
            throw new PropertyException(iOException.getMessage());
        }
    }

    public void update() {
        this.sendAdminPropertyChangeEvents(273219601, null);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == -8192) {
                return new ManageTableColumns(this);
            }
            if (n == -5) {
                Integer n2 = new Integer(-8195);
                iAdminProp.setProp(2687496, n2);
                this.m_dirChildren.doCommand(iAdminProp);
                this.sendAdminPropertyChangeEvents(273612805, null);
                return null;
            }
            if (n == -51) {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                return iAdminPropArray[0];
            }
            if (n == -9) {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                String string = "";
                int n3 = 0;
                while (n3 < iAdminPropArray.length) {
                    try {
                        ((Entry)iAdminPropArray[n3]).delete();
                        this.removeChild(iAdminPropArray[n3]);
                    }
                    catch (PropertyException propertyException) {
                        string = String.valueOf(string) + propertyException.getMessage() + "\n";
                    }
                    ++n3;
                }
                this.update();
                if (string.length() != 0) {
                    throw new PropertyException(string);
                }
                return null;
            }
            if (n == -10) {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                Entry entry = (Entry)iAdminPropArray[0];
                NewEntry newEntry = this.createChild();
                entry.copyTo(newEntry);
                newEntry.setDn(entry.getDn());
                return newEntry;
            }
            return super.doCommand(iAdminProp);
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public String[] getAttributeNames() throws PropertyException {
        this.m_defaultAttr = this.m_parent.getAttrDisplayName("cn");
        return this.getAttributeNames(null, false, true);
    }

    public String[] getAttributeNames(String string, boolean bl, boolean bl2) throws PropertyException {
        if (!this.hasSubSchema()) {
            PropertyException propertyException = new PropertyException(LDAPLang.getStrErrInsufficientAccessRights());
            propertyException.setReminder();
            throw propertyException;
        }
        return this.m_subSchema.getAttributeNames(string, bl, bl2);
    }

    public Vector getDeletableAttrs() {
        return this.m_deletableAttrs;
    }

    public Vector getAddableAttrs() {
        boolean bl = this.isDebug();
        if (bl) {
            System.out.println("getAttableAttrs");
        }
        Vector vector = this.m_parent.getAllAttrNames();
        AdminProp.subtract(vector, this.getDeletableAttrs());
        return vector;
    }

    public void resetTableProps() {
        this.m_tablePropList = null;
        this.m_tableNameList = null;
        this.m_tableWidthList = null;
    }

    public void removeAttr(String string, boolean bl) {
        this.m_deletableAttrs.removeElement(string);
        this.resetTableProps();
        if (bl) {
            this.sendAdminPropertyChangeEvents(282001424, null);
        }
    }

    public void addAttr(String string) {
        this.resetTableProps();
        this.m_deletableAttrs.addElement(string);
    }

    public int[] getTableColumnPropList() {
        int n = this.m_deletableAttrs.size();
        if (this.m_tablePropList != null) {
            return this.m_tablePropList;
        }
        this.m_tablePropList = new int[n + 1];
        this.m_tablePropList[0] = this.m_dnPropId;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.m_deletableAttrs.elementAt(n2);
            Integer n3 = this.m_parent.getAttrPropId(string);
            this.m_tablePropList[n2 + 1] = n3;
            ++n2;
        }
        return this.m_tablePropList;
    }

    public String[] getTableColumnNameList() {
        int n = this.m_deletableAttrs.size();
        if (this.m_tableNameList != null) {
            return this.m_tableNameList;
        }
        this.m_tableNameList = new String[n + 1];
        this.m_tableNameList[0] = LDAPLang.getStrDisplayNamePlbl1();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = (String)this.m_deletableAttrs.elementAt(n2);
            if (this.m_adminNames == null) {
                this.m_adminNames = this.m_parent.getAdminNames();
            }
            if ((string = this.m_adminNames.getPropName(string2)) != null) {
                string2 = string;
            }
            this.m_tableNameList[n2 + 1] = string2;
            ++n2;
        }
        return this.m_tableNameList;
    }

    public int[] getTableColumnWidthList() {
        int n = this.m_deletableAttrs.size();
        if (this.m_tableWidthList != null) {
            return this.m_tableWidthList;
        }
        this.m_tableWidthList = new int[n + 1];
        this.m_tableWidthList[0] = n == 0 ? 40 : 20;
        int n2 = 0;
        while (n2 < n) {
            this.m_tableWidthList[n2 + 1] = 20;
            ++n2;
        }
        return this.m_tableWidthList;
    }

    public int getTableColumnCount() {
        return this.m_deletableAttrs.size() + 1;
    }

    public boolean getUseCriteria() {
        return true;
    }

    public NewEntry createChild() {
        return new NewEntry(this.m_parent, this, this.getSubSchema());
    }

    public void initSearch(String string) {
        Object object = this.writeStringToCriteria(string, this.m_parent);
        if (object == null) {
            System.out.println("Could create criteria from " + string);
            return;
        }
        try {
            this.setProp(8324195, object);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addNewChild(NewEntry newEntry) {
        if (this.m_dirChildren != null) {
            this.m_dirChildren.addNewChild(newEntry);
        }
        this.sendAdminPropertyChangeEvents(273612805, null);
    }

    public void removeOldChild(Entry entry) {
        if (this.m_dirChildren != null) {
            this.m_dirChildren.removeOldChild(entry);
        }
        if (this.m_dirTree != null) {
            this.m_dirTree.removeOldChild(entry);
        }
        this.sendAdminPropertyChangeEvents(273612805, null);
    }

    public void removeChild(Object object) {
        super.removeChild(object);
        if (object instanceof Entry) {
            this.removeOldChild((Entry)object);
        }
    }

    public Integer getAttrPropId(Object object) {
        return this.m_parent.getAttrPropId(object);
    }

    public void cleanup() {
        int n = this.countChildren();
        int n2 = 0;
        while (n2 < n) {
            IAdminProp iAdminProp = (IAdminProp)this.nthChild(n2);
            if (iAdminProp instanceof DirTree) {
                ((DirTree)iAdminProp).cleanup();
            }
            ++n2;
        }
        this.setChildren((Vector)null);
        this.m_parent = null;
        this.m_tabObjList = null;
        this.m_dirTree = null;
        this.m_dirChildren = null;
        this.m_indexedAttributes = null;
    }

    static {
        SEARCH_TYPE_LOV_DATE = new String[4];
    }
}

