/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import java.io.ByteArrayOutputStream;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.ACPAttrList;
import oracle.ldap.admin.ACPStructList;
import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.AccessList;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.DirTree;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.ImageSelector;
import oracle.ldap.admin.JpegAttr;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.LocalDirectory;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.NewAccessItem;
import oracle.ldap.admin.NewEntry;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminLang;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.AdminSort;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Entry
extends AdminProp
implements ICommandParent {
    String m_helpTopic = "entry_properties";
    Directory m_directory;
    LocalDirectory m_localDirectory;
    boolean m_bValid = true;
    Root m_parent;
    String m_dn;
    DirTree m_dirTreeParent;
    AccessList m_orclACI;
    AccessList m_orclEntryACI;
    ACPStructList m_structList;
    ACPAttrList m_attrList;
    ACPAttrList m_entryAttrList;
    ACPStructList m_entryStructList;
    boolean m_parseAttr = false;
    Object[] m_attributes;
    boolean m_hasACIAttrType = false;
    boolean m_hasEntryACIAttrType = false;
    int m_objClassPropId;
    int m_status;
    boolean m_loadingAttrs = false;
    boolean m_repaint = false;
    boolean m_refreshEntry = false;
    static final int CMD_DEL = -9;
    static final int CMD_CREATE1 = 2;
    static final int CMD_CREATE2 = 3;
    static final int PR_DESC = 0x103000;
    static final int PR_NAME = 1458176;
    public static final int PR_DN = 1458177;
    static final int PR_DN_WRITABLE = 0x104001;
    static final String DISPLAY_NAME_ATTR_TYPE = "cn";
    static final String OBJECT_CLASS_ATTR_TYPE = "objectClass";
    static final String ORACLE_ACI_ATTR_TYPE = "orclACI";
    static final String ORACLE_ENTRY_ACI_ATTR_TYPE = "orclEntryLevelACI";
    static final String EXTENSIBLEOBJECT = "extensibleObject";
    static final String AGREEMENT_DN_ATTR_TYPE = "orclDirReplGroupAgreement";
    static final String COFIG_SET_NUM_ATTR_TYPE = "Orclconfigsetnumber";
    boolean m_bInitializing = true;
    Directory m_lookupDir;
    ImageSelector m_lookupImage;
    Integer m_access = new Integer(3);
    Integer m_gridViewStatus;
    int[] m_plInput;
    String[] m_groupOutput;
    int[] m_plOutput;
    int[] m_sortPropList;
    Vector m_objectClasses;
    boolean m_removeOrclACI = false;
    boolean m_removeOrclEntryACI = false;
    int m_lastSetPropId;
    Vector m_unsetAttrNames;
    Vector m_setAttrNames = new Vector();
    Vector circleV = new Vector();
    String[] m_dnTypes;
    Hashtable m_addMods = new Hashtable();
    Vector m_mods = new Vector();
    Names m_adminNames;
    static String[] emptyStringArray = new String[0];
    SubSchema m_subSchema;

    public String getName() {
        return this.m_dn;
    }

    public String getDn() {
        return this.m_dn;
    }

    public Directory getDirectory() {
        return this.m_directory;
    }

    public void setDn(String string) {
        this.m_dn = string;
    }

    public void setDirTreeParent(DirTree dirTree) {
        this.m_dirTreeParent = dirTree;
    }

    public ACPStructList getACPStructList() {
        return this.m_structList;
    }

    public ACPAttrList getACPAttrList() {
        return this.m_attrList;
    }

    public void setACPStructList(ACPStructList aCPStructList) {
        this.m_structList = aCPStructList;
    }

    public void setACPAttrList(ACPAttrList aCPAttrList) {
        this.m_attrList = aCPAttrList;
    }

    public Entry() {
    }

    public Entry(Root root, Directory directory, String string, Object[] objectArray, boolean bl) {
        this.init(root, directory, string, objectArray, bl);
    }

    public Entry(Root root, Directory directory, String string, Object[] objectArray) {
        this.init(root, directory, string, objectArray, true);
    }

    public Root getRoot() {
        return this.m_parent;
    }

    public Object[] getEntryLOV(int[] nArray) {
        return this.getEntryLOV(nArray, null);
    }

    public Object[] getEntryLOV(int[] nArray, Object[] objectArray) {
        if (this.m_parent == null) {
            return null;
        }
        if ((this.m_access & 2) == 0) {
            return null;
        }
        if (objectArray == null || objectArray.length != nArray.length) {
            objectArray = new Object[nArray.length];
        }
        int n = 0;
        while (n < nArray.length) {
            String string;
            Attribute attribute;
            if (!AdminProp.isPropReadonly(nArray[n]) && (attribute = this.m_parent.findAttributeType(0x103000, string = super.getPropName(nArray[n]))) != null && attribute.isDNValued()) {
                if (this.m_lookupDir == null) {
                    this.m_lookupDir = new EntrySelector(this.m_parent);
                    try {
                        this.m_lookupDir.setProp(2163785, (Object)new Integer(1));
                        this.m_lookupDir.setProp(0x805000, (Object)new Boolean(true));
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                    }
                }
                objectArray[n] = this.m_lookupDir;
            }
            ++n;
        }
        return objectArray;
    }

    void init(Root root, Directory directory, String string, Object[] objectArray, boolean bl) {
        this.m_parent = root;
        this.m_directory = directory;
        this.m_dn = string;
        Vector vector = this.m_parent.getSubSchemas();
        if (vector != null && vector.size() != 0) {
            this.setSubSchema((SubSchema)vector.elementAt(0));
        }
        this.m_objClassPropId = root.getAttrPropId(OBJECT_CLASS_ATTR_TYPE);
        this.setPropertyDisabled(this.m_objClassPropId, true, false);
        try {
            this.m_orclACI = new AccessList(this.m_parent, this.m_dn, "orclaci", this);
            this.m_orclEntryACI = new AccessList(this.m_parent, this.m_dn, "orclentrylevelaci", this);
            try {
                this.setProp(4784134, (Object)new AdminLang(this.getClass()));
                this.registerMessages();
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
                return;
            }
            this.registerProp(0x110001, LDAPLang.getStrDisplayNamePlbl1(), LDAPLang.getStrEmptyString());
            if (string != null) {
                Integer n = root.getAttrPropId("dn");
                this.registerProp(n, "dn", "dn");
                this.registerPropLength(n, 10);
                this.registerPropWidth(n, 10);
                try {
                    this.setProp((int)n, (Object)string);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
                try {
                    this.setProp(0x110001, (Object)string);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
            }
            this.m_attributes = objectArray;
            if (bl) {
                this.parseSearchResult(objectArray);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.unexpectedException(exception);
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return this.m_helpTopic;
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/ldapentry.gif";
            }
            case 2162846: {
                return new Integer(5);
            }
            case 2031768: {
                return LDAPLang.getStrCompleteEntry();
            }
            case 2687386: {
                if (this.m_gridViewStatus != null) {
                    return new Integer((int)(this.m_gridViewStatus | 0x100000));
                }
                return new Integer(0x100000);
            }
            case 2163876: {
                return new Integer(100);
            }
            case 2686979: {
                return this.m_access;
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(4 | this.m_status | (this.m_directory == null ? 8192 : 4096));
            }
            case 0x110001: {
                return this.m_dn;
            }
            case 276758675: {
                return this.getEntryLOV((int[])this.getProp(282001422), (Object[])super.getProp(n));
            }
            case 282001422: {
                int[] nArray = (int[])super.getProp(282001422);
                if (nArray == null) {
                    return null;
                }
                this.sortPropertiesByName(nArray);
                return nArray;
            }
            case 1115239: {
                return LDAPLang.getStrCardLabel();
            }
            case 272696422: {
                boolean bl = this.canAccessSchema();
                int n2 = 0;
                int n3 = bl ? 2 : 1;
                IAdminProp[] iAdminPropArray = new IAdminProp[n3];
                int[] nArray = new int[]{0x110001, 3080204, 282001422, 273613313, 276758675, 269550621};
                int[] nArray2 = this.getSetPropertyList();
                this.sortPropertiesByName(nArray2);
                Object[] objectArray = new Object[]{LDAPLang.getStrSetProps(), new Integer(8196), nArray2, null, this.getEntryLOV(nArray2, null), null};
                iAdminPropArray[n2++] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                if (!bl) {
                    return iAdminPropArray;
                }
                int[] nArray3 = new int[]{0x110001, 3080204, 273613313};
                Object[] objectArray2 = new Object[]{LDAPLang.getStrAllProps(), new Integer(8196), null};
                iAdminPropArray[n2++] = new AdminPropView((IAdminProp)this, nArray3, objectArray2);
                return iAdminPropArray;
            }
            case 272695330: {
                boolean bl = this.canAccessSchema();
                if (!this.m_parseAttr && this.m_attributes != null) {
                    this.parseSearchResult(this.m_attributes);
                }
                int n4 = 0;
                int n5 = bl ? 4 : 3;
                IAdminProp[] iAdminPropArray = new IAdminProp[n5];
                int[] nArray = new int[]{0x110001, 3080204, 273613313};
                Object[] objectArray = new Object[]{LDAPLang.getStrProperties(), new Integer(0x400004), null};
                iAdminPropArray[n4++] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                if (this.m_localDirectory == null) {
                    this.m_localDirectory = new LocalDirectory(this.m_parent, this);
                }
                if (bl) {
                    iAdminPropArray[n4++] = this.m_localDirectory;
                }
                int[] nArray4 = new int[]{1048745, 1049370, 0x110001, 3080204, 273613313, 275776081, 272630352};
                Object[] objectArray3 = new Object[]{"subtree_access", RootList.getHelpBaseFileName(), LDAPLang.getStrOrclAci(), new Integer(32768), null, this.getAccessCntrlLayout(false), this.getAccessCntrlChildren(false)};
                iAdminPropArray[n4++] = new AdminPropView((IAdminProp)this, nArray4, objectArray3);
                int[] nArray5 = new int[]{1048745, 1049370, 0x110001, 3080204, 273613313, 275776081, 272630352};
                Object[] objectArray4 = new Object[]{"local_access", RootList.getHelpBaseFileName(), LDAPLang.getStrOrclEntryAci(), new Integer(32768), null, this.getAccessCntrlLayout(false), this.getEntryAccessCntrlChildren(false)};
                iAdminPropArray[n4++] = new AdminPropView((IAdminProp)this, nArray5, objectArray4);
                return iAdminPropArray;
            }
            case 273613313: {
                if ((this.m_access & 2) == 0) break;
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int n6 = 0;
                iAdminPropArray[n6++] = new CommandProp((IAdminProp)this, -10, LDAPLang.getStrCreateLikeLabel1(), LDAPLang.getStrCreateLikeDescp3(), "images/createlike.gif");
                if (!this.hasSubSchema()) {
                    iAdminPropArray[n6 - 1].setProp(8978948, new Boolean(false));
                }
                iAdminPropArray[n6++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDelDescp(), "images/delete.gif");
                iAdminPropArray[n6 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    boolean canAccessSchema() throws PropertyException {
        int n;
        if (this.m_localDirectory == null) {
            this.m_localDirectory = new LocalDirectory(this.m_parent, this);
        }
        return ((n = ((Integer)this.m_localDirectory.getProp(3080204)).intValue()) & 1) != 1;
    }

    public void consolidateGroups(String[] stringArray, int[] nArray) throws PropertyException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                int n2 = n + 1;
                while (n2 < stringArray.length) {
                    String string2 = stringArray[n2];
                    if (!(string2 == null && n == 0 || string2 == null || string.equals(string2))) {
                        n = n2 - 1;
                        break;
                    }
                    ++n2;
                }
                int n3 = n2 + 1;
                while (n3 < stringArray.length) {
                    boolean bl = false;
                    String string3 = stringArray[n3];
                    if (string3 == null && n == 0) {
                        bl = true;
                    } else if (string3 != null && string.equals(string3)) {
                        bl = true;
                    }
                    if (bl) {
                        int n4 = nArray[n3];
                        int n5 = n3;
                        while (n5 > n2) {
                            stringArray[n5] = stringArray[n5 - 1];
                            nArray[n5] = nArray[n5 - 1];
                            --n5;
                        }
                        stringArray[n2] = string3;
                        nArray[n2] = n4;
                        n = n2++;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public String[] getGroupNameList(int[] nArray) throws PropertyException {
        int n;
        if (nArray == null) {
            nArray = (int[])super.getProp(282001422);
        }
        if (nArray == null) {
            return null;
        }
        if (this.m_parent == null || this.m_objectClasses == null) {
            return null;
        }
        if (this.m_plInput != null && nArray.length == this.m_plInput.length) {
            n = 0;
            while (n < nArray.length) {
                if (nArray[n] != this.m_plInput[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = this.m_plOutput[n];
                    ++n;
                }
                return this.m_groupOutput;
            }
        }
        if (this.m_plInput == null || nArray.length != this.m_plInput.length) {
            this.m_plInput = new int[nArray.length];
        }
        n = 0;
        while (n < nArray.length) {
            this.m_plInput[n] = nArray[n];
            ++n;
        }
        String[] stringArray = null;
        try {
            stringArray = this.getGroupNameListUncached(nArray);
        }
        catch (PropertyException propertyException) {
            this.m_plInput[0] = 0;
            throw propertyException;
        }
        catch (Exception exception) {
            this.m_plInput[0] = 0;
            throw new PropertyException(exception);
        }
        if (this.m_plOutput == null || nArray.length != this.m_plOutput.length) {
            this.m_plOutput = new int[nArray.length];
        }
        n = 0;
        while (n < nArray.length) {
            this.m_plOutput[n] = nArray[n];
            ++n;
        }
        if (this.m_groupOutput == null || stringArray.length != this.m_groupOutput.length) {
            this.m_groupOutput = new String[stringArray.length];
        }
        n = 0;
        while (n < stringArray.length) {
            this.m_groupOutput[n] = stringArray[n];
            ++n;
        }
        return stringArray;
    }

    public String[] getGroupNameListUncached(int[] nArray) throws PropertyException {
        Object object;
        this.sortPropertiesByName(nArray);
        Vector vector = (Vector)this.getObjectClasses().clone();
        try {
            AdminSort.qsort(vector, 0x103000, false);
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        int n = vector.size();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n2 = 0;
        while (n2 < n) {
            object = (ObjectClass)vector.elementAt(n2);
            String string = ((SchemaObject)object).getName();
            int n3 = 0;
            while (n3 < 2) {
                String[] stringArray = (String[])((ObjectClass)object).getProp(n3 == 0 ? 269496330 : 269496331);
                if (stringArray != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        hashtable.put(this.m_parent.getAttrPropId(stringArray[n4]), string);
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        object = new String[nArray.length];
        int n5 = 0;
        while (n5 < nArray.length) {
            object[n5] = (String)hashtable.get(new Integer(nArray[n5]));
            if (object[n5] == null) {
                object[n5] = LDAPLang.getStrGeneral();
            }
            ++n5;
        }
        this.consolidateGroups((String[])object, nArray);
        return object;
    }

    public void registerProp(int n, String string, String string2) {
        super.registerProp(n, string, string2);
        this.m_sortPropList = null;
    }

    public void sortPropertiesByName(int[] nArray) {
        if (this.m_sortPropList != null && this.m_sortPropList.length == nArray.length) {
            System.arraycopy(this.m_sortPropList, 0, nArray, 0, nArray.length);
            return;
        }
        Object[] objectArray = this.getPropNames(nArray);
        Object[] objectArray2 = new Integer[nArray.length];
        try {
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = new Integer(nArray[n]);
                ++n;
            }
            AdminSort.qsort(objectArray, objectArray2, false);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                nArray[n2] = (Integer)objectArray2[n2];
                ++n2;
            }
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        this.m_sortPropList = nArray;
    }

    int[] copyIntArray(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
        return nArray2;
    }

    int[] getSetPropertyList() {
        int[] nArray = null;
        try {
            nArray = (int[])super.getProp(282001422);
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            int[] nArray2 = new int[]{0x110001};
            return nArray2;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            try {
                if (this.getProp(nArray[n2]) != null) {
                    if (n != n2) {
                        nArray[n] = nArray[n2];
                    }
                    ++n;
                }
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            ++n2;
        }
        if (n == nArray.length) {
            return nArray;
        }
        nArray = this.copyIntArray(nArray, n);
        this.sortPropertiesByName(nArray);
        return nArray;
    }

    void addObjectClass(String string) {
        ObjectClass objectClass = this.m_parent.findObjectClass(0x103000, string);
        if (objectClass == null) {
            if (Root.debugSaveEntry) {
                AdminProp.errorMessageLn("Didn't get expected object class=" + string);
            }
            return;
        }
        if (this.m_objectClasses == null) {
            this.m_objectClasses = new Vector();
        }
        if (!AdminProp.vectorContains(this.m_objectClasses, objectClass)) {
            this.m_objectClasses.addElement(objectClass);
        }
    }

    public Vector getObjectClasses() {
        return this.m_objectClasses;
    }

    void addOrclACI(String string) {
        int[] nArray = new int[]{0};
        this.m_orclACI.addAccessItem(new AccessItem(this.m_parent, string, nArray, this.m_orclACI));
    }

    void removeOrclACI() throws PropertyException {
        this.m_removeOrclACI = true;
        if (this.m_parent.saveEntry(this)) {
            if (Root.debugSaveEntry) {
                System.out.println("saveEntry() Done");
                return;
            }
        } else {
            if (Root.debugSaveEntry) {
                System.out.println("saveEntry() not Done");
            }
            String string = this.m_parent.getErrorMessage();
            throw new PropertyException(string);
        }
    }

    public AccessList getOrclACI() {
        return this.m_orclACI;
    }

    void addOrclEntryACI(String string) {
        int[] nArray = new int[]{0};
        this.m_orclEntryACI.addAccessItem(new AccessItem(this.m_parent, string, nArray, this.m_orclEntryACI));
    }

    void removeOrclEntryACI() throws PropertyException {
        this.m_removeOrclEntryACI = true;
        if (this.m_parent.saveEntry(this)) {
            if (Root.debugSaveEntry) {
                System.out.println("saveEntry() Done");
                return;
            }
        } else {
            if (Root.debugSaveEntry) {
                System.out.println("saveEntry() not Done");
            }
            String string = this.m_parent.getErrorMessage();
            throw new PropertyException(string);
        }
    }

    public AccessList getOrclEntryACI() {
        return this.m_orclEntryACI;
    }

    void addUnsetAttrName(String string) {
        string = this.adaptString(string);
        if (this.m_unsetAttrNames == null) {
            this.m_unsetAttrNames = new Vector();
        }
        if (!AdminProp.vectorContainsIgnoreCase(this.m_unsetAttrNames, string)) {
            this.m_unsetAttrNames.addElement(string.toLowerCase());
            Integer n = this.m_parent.getAttrPropId(string);
            this.registerProp(n, string, string);
        }
    }

    void removeUnsetAttrName(String string) {
        string = this.adaptString(string);
        if (this.m_unsetAttrNames == null) {
            this.m_unsetAttrNames = new Vector();
        }
        string = string.toLowerCase();
        this.m_unsetAttrNames.removeElement(string);
    }

    Vector getUnsetAttrNames() {
        return this.m_unsetAttrNames;
    }

    void emptyUnsetAttrName() {
        if (this.m_unsetAttrNames != null) {
            this.m_unsetAttrNames.removeAllElements();
        }
    }

    void saveUnsetAttrNames(Object[] objectArray, String[] stringArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (stringArray == null) {
                this.addUnsetAttrName((String)objectArray[n]);
            } else {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equalsIgnoreCase((String)objectArray[n])) break;
                    ++n2;
                }
                if (n2 == stringArray.length) {
                    this.addUnsetAttrName((String)objectArray[n]);
                }
            }
            ++n;
        }
    }

    Vector getSetAttrNamesVector() {
        return this.m_setAttrNames;
    }

    String[] getSetAttrNames() {
        if (this.m_setAttrNames.size() == 0) {
            return null;
        }
        return AdminProp.vectorToStringArray(this.m_setAttrNames);
    }

    void addSetAttrName(String string) {
        if (!this.m_setAttrNames.contains(string = string.toLowerCase())) {
            this.m_setAttrNames.addElement(string);
        }
    }

    void removeSetAttrName(String string) {
        string = string.toLowerCase();
        this.m_setAttrNames.removeElement(string);
    }

    void emptySetAttrName() {
        this.m_setAttrNames.removeAllElements();
    }

    void emptyCircleV() {
        this.circleV = new Vector();
    }

    void setupAllPropIds(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        String[] stringArray = this.getSetAttrNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = new int[]{269496331, 269496330};
            ObjectClass objectClass = (ObjectClass)vector.elementAt(n2);
            try {
                if (this.circleV != null || this.circleV.size() > 0) {
                    String string = (String)objectClass.getProp(0x103013);
                    int n3 = 0;
                    while (n3 < this.circleV.size()) {
                        ObjectClass objectClass2 = (ObjectClass)this.circleV.elementAt(n3);
                        String string2 = (String)objectClass2.getProp(0x103013);
                        if (string2.equalsIgnoreCase(string)) {
                            return;
                        }
                        ++n3;
                    }
                }
                this.circleV.addElement(objectClass);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            int n4 = 0;
            while (n4 < nArray.length) {
                try {
                    Object[] objectArray = (Object[])objectClass.getProp(nArray[n4]);
                    if (objectArray != null && objectArray.length != 0) {
                        this.saveUnsetAttrNames(objectArray, stringArray);
                    }
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
                ++n4;
            }
            this.setupAllPropIds(objectClass.getSuperClasses());
            ++n2;
        }
    }

    public Vector getDeletableAttrs() {
        boolean bl;
        boolean bl2 = bl = this.isDebug() || Root.debugSaveEntry;
        if (bl) {
            System.out.println("getDeletableAttrs");
        }
        Vector vector = (Vector)this.getSetAttrNamesVector().clone();
        if (bl) {
            this.printVector("all set attrs", vector);
        }
        this.removeAttrsGivenObjectClasses(this.getObjectClasses(), vector, false);
        if (bl) {
            this.printVector("all optional attrs", vector);
        }
        String[] stringArray = new String[]{"createtimestamp", "creatorsname", "objectclass"};
        int n = 0;
        while (n < stringArray.length) {
            vector.removeElement(stringArray[n]);
            ++n;
        }
        return vector;
    }

    boolean isExtensible() {
        if (this.getObjectClasses() == null) {
            return false;
        }
        Vector vector = (Vector)this.getObjectClasses().clone();
        if (vector == null) {
            return false;
        }
        this.addSuperClassObjects(vector);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ObjectClass objectClass = (ObjectClass)vector.elementAt(n2);
            try {
                if (objectClass != null && EXTENSIBLEOBJECT.equalsIgnoreCase(objectClass.getName())) {
                    return true;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return false;
    }

    public Vector getAddableAttrs() {
        Vector vector;
        boolean bl = this.isDebug();
        if (bl) {
            System.out.println("getAttableAttrs");
        }
        if (this.isExtensible()) {
            vector = this.m_parent.getAllAttrNames();
        } else {
            vector = this.getUnsetAttrNames();
            if (vector == null) {
                vector = new Vector();
            }
        }
        if (bl) {
            this.printVector("all attrs", vector);
        }
        this.removeAttrsGivenObjectClasses(this.getObjectClasses(), vector, true);
        if (bl) {
            this.printVector("addable attrs", vector);
        }
        Vector vector2 = this.getSetAttrNamesVector();
        if (bl) {
            this.printVector("set attrs", vector2);
        }
        AdminProp.subtract(vector, vector2);
        if (bl) {
            this.printVector("final addable attrs", vector);
        }
        return vector;
    }

    void printVector(String string, Vector vector) {
        System.out.println(string);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.println("\t" + n2 + ": " + vector.elementAt(n2));
            ++n2;
        }
        System.out.println("Done");
    }

    public void removeAttrNames(String[] stringArray, Vector vector) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            vector.removeElement(stringArray[n].toLowerCase());
            ++n;
        }
    }

    public void removeAttrsGivenObjectClasses(Vector vector, Vector vector2, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            block7: {
                ObjectClass objectClass;
                block6: {
                    objectClass = (ObjectClass)vector.elementAt(n2);
                    try {
                        String[] stringArray = (String[])objectClass.getProp(269496330);
                        if (stringArray != null && stringArray.length != 0) {
                            this.removeAttrNames(stringArray, vector2);
                        }
                        if (!bl || (stringArray = (String[])objectClass.getProp(269496331)) == null || stringArray.length == 0) break block6;
                        this.removeAttrNames(stringArray, vector2);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                        break block7;
                    }
                }
                if (vector2.size() == 0) {
                    return;
                }
                this.removeAttrsGivenObjectClasses(objectClass.getSuperClasses(), vector2, bl);
            }
            ++n2;
        }
    }

    String adaptString(String string) {
        int n = string.indexOf(0);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public void parseSearchResult(Object[] objectArray) {
        this.m_parseAttr = true;
        boolean bl = Root.debugAccessItemEntry;
        if (bl) {
            this.setDebug(true);
        }
        if (bl) {
            this.debugMessageLn("Search for Entry completed");
        }
        int n = 0;
        while (n < objectArray.length) {
            block62: {
                String string = this.m_parent.m_serverAccess.getType(objectArray[n]);
                if (Character.isDigit(string.charAt(0))) {
                    Attribute attribute;
                    if (bl) {
                        this.debugMessageLn("looking attribute by oid");
                    }
                    if ((attribute = this.m_parent.findAttributeType(0x103013, string)) != null) {
                        if (bl) {
                            this.debugMessageLn("got attribute");
                        }
                        try {
                            String string2 = attribute.getName();
                            if (string2 != null) {
                                if (bl) {
                                    this.debugMessageLn("translated type=" + string + "to name=" + string2);
                                }
                                string = string2;
                            }
                        }
                        catch (PropertyException propertyException) {
                            this.unexpectedException(propertyException);
                        }
                    }
                }
                if (bl) {
                    this.debugMessageLn("type='" + string + "'");
                }
                boolean bl2 = string.equalsIgnoreCase(OBJECT_CLASS_ATTR_TYPE);
                boolean bl3 = string.equalsIgnoreCase(ORACLE_ACI_ATTR_TYPE);
                boolean bl4 = string.equalsIgnoreCase(ORACLE_ENTRY_ACI_ATTR_TYPE);
                Integer n2 = this.m_parent.getAttrPropId(string);
                Attribute attribute = this.m_parent.getAttributeByPropId(n2);
                int n3 = n2;
                if (this.isTypeAsRDN(string)) {
                    n3 |= 0x60000;
                }
                if (bl) {
                    this.debugMessageLn(" type=" + string + "  iPropId=" + n3);
                }
                String[] stringArray = this.m_parent.m_serverAccess.getValues(objectArray[n]);
                this.addSetAttrName(string);
                if (bl) {
                    this.debugMessageLn("vals.length=" + stringArray.length);
                }
                if (bl3) {
                    this.m_hasACIAttrType = true;
                }
                if (bl4) {
                    this.m_hasEntryACIAttrType = true;
                }
                if (Root.debugSaveEntry && bl3) {
                    try {
                        System.out.println("\nOld access Info is:");
                        if (stringArray != null) {
                            int n4 = 0;
                            while (n4 < stringArray.length) {
                                System.out.println("[" + n4 + "] =" + stringArray[n4]);
                                ++n4;
                            }
                        }
                        System.out.println("Done.\n");
                    }
                    catch (Exception exception) {}
                }
                if (!AdminProp.isPropArray(n3)) {
                    if (bl) {
                        this.debugMessageLn("property id is not for array value");
                    }
                    try {
                        if (!bl3 && !bl4) {
                            if (stringArray.length == 1) {
                                if (bl) {
                                    this.debugMessageLn("val='" + this.adaptString(stringArray[0]) + "'");
                                }
                                this.registerProp(n3, this.adaptString(string), string);
                                if (attribute != null && attribute.hasJpegSyntax()) {
                                    ByteArrayOutputStream[] byteArrayOutputStreamArray = !Root.SSLEnabled ? this.m_parent.m_serverAccess.getNoUTF8Values(objectArray[n]) : new ByteArrayOutputStream[]{null};
                                    this.setProp(n3, (Object)new JpegAttr(byteArrayOutputStreamArray[0]));
                                } else {
                                    if ((string.equalsIgnoreCase("modifytimestamp") || string.equalsIgnoreCase("createtimestamp")) && stringArray[0] != null) {
                                        String string3 = AdminProp.parseDate(stringArray[0]);
                                        this.setProp(n3, (Object)string3);
                                        break block62;
                                    }
                                    this.setProp(n3, (Object)this.adaptString(stringArray[0]));
                                }
                            } else if (stringArray.length != 0) {
                                if (bl) {
                                    this.debugMessageLn("value is multivalued! inconsistent w/ propId");
                                }
                                if (bl) {
                                    this.debugMessageLn("val='" + this.adaptString(stringArray[0]) + "'");
                                }
                                this.registerProp(n3, this.adaptString(string), string);
                                this.setProp(n3, (Object)this.adaptString(stringArray[stringArray.length - 1]));
                            }
                        }
                        if (string.equalsIgnoreCase(DISPLAY_NAME_ATTR_TYPE)) {
                            this.setProp(0x110001, (Object)this.adaptString(stringArray[0]));
                        } else if (bl2) {
                            this.addObjectClass(this.adaptString(stringArray[0]));
                        } else if (bl3) {
                            this.addOrclACI(this.adaptString(stringArray[0]));
                        } else if (bl4) {
                            this.addOrclEntryACI(this.adaptString(stringArray[0]));
                        }
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                } else if (attribute != null && attribute.hasJpegSyntax()) {
                    ByteArrayOutputStream[] byteArrayOutputStreamArray = !Root.SSLEnabled ? this.m_parent.m_serverAccess.getNoUTF8Values(objectArray[n]) : new ByteArrayOutputStream[]{null};
                    try {
                        this.registerProp(n3, string, string);
                        this.setProp(n3, (Object)new JpegAttr(byteArrayOutputStreamArray));
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                } else {
                    if (bl) {
                        this.debugMessageLn("property id is for array value");
                    }
                    try {
                        String[] stringArray2 = new String[stringArray.length];
                        int n5 = 0;
                        while (n5 < stringArray.length) {
                            if (bl) {
                                this.debugMessageLn("\tval[" + n5 + "]='" + this.adaptString(stringArray[n5]) + "'");
                            }
                            stringArray2[n5] = this.adaptString(stringArray[n5]);
                            if (bl2) {
                                this.addObjectClass(stringArray2[n5]);
                            } else if (bl3) {
                                this.addOrclACI(stringArray2[n5]);
                            } else if (bl4) {
                                this.addOrclEntryACI(stringArray2[n5]);
                            }
                            ++n5;
                        }
                        this.registerProp(n3, string, string);
                        this.setProp(n3, (Object)stringArray2);
                        if (string.equalsIgnoreCase(DISPLAY_NAME_ATTR_TYPE)) {
                            this.setProp(0x110001, (Object)stringArray2[0]);
                        } else if (bl2) {
                            this.addObjectClass(this.adaptString(stringArray[0]));
                        }
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                }
            }
            ++n;
        }
        this.setupAllPropIds(this.m_objectClasses);
        this.m_bInitializing = false;
        if (bl) {
            this.debugMessageLn("Done");
        }
    }

    private void setDnTypes() {
        String string = this.m_dn;
        int n = this.m_dn.indexOf(",");
        if (n > 0) {
            string = this.m_dn.substring(0, n);
        }
        String string2 = string;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (true) {
            string2 = string.substring(n2);
            int n3 = string2.indexOf("=");
            if (string2 == null || n3 <= 0) break;
            String string3 = string2.substring(0, n3);
            vector.addElement(string3);
            n2 = string2.indexOf("+");
            if (n2 <= 0) break;
            ++n2;
        }
        if (vector.size() > 0) {
            this.m_dnTypes = AdminProp.vectorToStringArray(vector);
        }
    }

    private boolean isTypeAsRDN(String string) {
        if (this.m_dnTypes == null) {
            this.setDnTypes();
        }
        if (this.m_dnTypes == null || this.m_dnTypes.length <= 0) {
            return false;
        }
        if (string.equalsIgnoreCase(OBJECT_CLASS_ATTR_TYPE)) {
            return false;
        }
        int n = 0;
        while (n < this.m_dnTypes.length) {
            if (string.equalsIgnoreCase(this.m_dnTypes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isAddModification(Integer n) {
        return this.m_addMods.get(n) != null;
    }

    public boolean propertyIsModified(int n) {
        return this.m_mods.contains(new Integer(n));
    }

    public Object[] getMods() {
        if (this.m_removeOrclACI) {
            if (Root.debugSaveEntry) {
                System.out.println("remove OrclACI orclACI");
            }
            Object[] objectArray = this.m_parent.m_serverAccess.createModificationArray(1);
            objectArray[0] = this.m_parent.m_serverAccess.createModification(4, ORACLE_ACI_ATTR_TYPE);
            return objectArray;
        }
        if (this.m_removeOrclEntryACI) {
            if (Root.debugSaveEntry) {
                System.out.println("remove OrclEntryACI orclEntryLevelACI");
            }
            Object[] objectArray = this.m_parent.m_serverAccess.createModificationArray(1);
            objectArray[0] = this.m_parent.m_serverAccess.createModification(4, ORACLE_ENTRY_ACI_ATTR_TYPE);
            return objectArray;
        }
        int n = this.m_mods.size();
        if (Root.debugSaveEntry) {
            System.out.println("\nEntry.getMods(): Entered\nm_mods.size()=" + n);
        }
        Object[] objectArray = this.m_parent.m_serverAccess.createModificationArray(n);
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Integer n3 = (Integer)this.m_mods.elementAt(n2);
            int n4 = n3;
            boolean bl = this.isAddModification(n3);
            String string = super.getPropName(n4);
            if (string == null) {
                string = this.m_parent.getPropIdAttr(new Integer(n4));
                if (this.m_parent != null) {
                    try {
                        object = this.m_parent.findAttributeType(0x103013, string);
                        if (object != null) {
                            string = (String)((Attribute)object).getProp(1519616);
                        }
                    }
                    catch (Exception exception) {}
                }
                if (Root.debugSaveEntry) {
                    System.out.println("deleting attribute =" + n4);
                }
                objectArray[n2] = this.m_parent.m_serverAccess.createModification(4, string);
            } else {
                if (Root.debugSaveEntry) {
                    System.out.println("attr=" + string);
                }
                try {
                    if (AdminProp.isPropArray(n4)) {
                        object = (String[])this.getProp(n4);
                        if (object == null) {
                            objectArray[n2] = this.m_parent.m_serverAccess.createModification(4, string);
                            if (Root.debugSaveEntry) {
                                System.out.println("didn't get value for propid=" + n4);
                                System.out.println("deleting attribute=" + string);
                            }
                        } else {
                            if (Root.debugSaveEntry) {
                                System.out.println(bl ? "adding" : "replacing");
                                int n5 = 0;
                                while (n5 < ((Object)object).length) {
                                    System.out.println("values[" + n5 + "]=" + (String)object[n5]);
                                    ++n5;
                                }
                            }
                            objectArray[n2] = this.m_parent.m_serverAccess.createModification(bl ? 1 : 2, string, (String[])object);
                        }
                    } else {
                        object = this.getProp(n4);
                        if (object == null) {
                            objectArray[n2] = this.m_parent.m_serverAccess.createModification(4, string);
                            if (Root.debugSaveEntry) {
                                System.out.println("didn't get value for propid=" + n4);
                                System.out.println("deleting attribute=" + string);
                            }
                        } else {
                            Attribute attribute;
                            if (Root.debugSaveEntry && !string.equalsIgnoreCase("orclsupassword")) {
                                System.out.println(String.valueOf(bl ? "adding" : "replacing") + " value=" + object);
                            }
                            if ((attribute = this.m_parent.getAttributeByPropId(new Integer(n4))) != null && attribute.hasJpegSyntax() && object instanceof JpegAttr) {
                                if (Root.debugSaveEntry) {
                                    System.out.println(String.valueOf(bl ? "adding" : "replacing") + " value is image byte data");
                                }
                                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)((AdminProp)object).getProp(1114269);
                                objectArray[n2] = this.m_parent.m_serverAccess.createModification(bl ? 1 : 2, string, byteArrayOutputStream);
                            } else {
                                objectArray[n2] = object instanceof Calendar ? this.m_parent.m_serverAccess.createModification(bl ? 1 : 2, string, AdminProp.convertCalendar2String((Calendar)object)) : this.m_parent.m_serverAccess.createModification(bl ? 1 : 2, string, (String)object);
                            }
                        }
                    }
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    if (Root.debugSaveEntry) {
                        System.out.println("Entry.getMods(): Done\n");
                    }
                    return null;
                }
            }
            ++n2;
        }
        if (Root.debugSaveEntry) {
            System.out.println("Entry.getMods(): Done\n");
        }
        return objectArray;
    }

    public void saveChanges(int n) throws SaveChangeException {
        block9: {
            try {
                this.updateEntryAccessInfo();
                this.updateSubtreeAccessInfo();
                if (Root.debugSaveEntry) {
                    System.out.println("Calling Entry.saveChanges() mod_size=" + this.m_mods.size());
                }
                if (this.m_mods.size() == 0) break block9;
                if (Root.debugSaveEntry) {
                    System.out.println("Object " + this.m_dn + " needs saving.");
                }
                if (this.m_parent.saveEntry(this)) {
                    this.m_mods = new Vector();
                    this.m_addMods = new Hashtable();
                    this.update();
                    if (this.m_structList != null) {
                        this.m_structList.updateBackup();
                    }
                    if (this.m_attrList != null) {
                        this.m_attrList.updateBackup();
                    }
                    if (this.m_entryStructList != null) {
                        this.m_entryStructList.updateBackup();
                    }
                    if (this.m_entryAttrList != null) {
                        this.m_entryAttrList.updateBackup();
                        return;
                    }
                    break block9;
                }
                throw new SaveChangeException(this.m_parent.getErrorMessage());
            }
            catch (Exception exception) {
                throw new SaveChangeException(exception);
            }
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (n == 2686979) {
            this.m_access = (Integer)object;
            return;
        }
        if (n == 2687386) {
            this.m_gridViewStatus = new Integer((int)((Integer)object | 0x100000));
            return;
        }
        if (n == 2163740 || n == 2163220) {
            if (this.m_structList != null) {
                this.m_structList.editorCancel(n == 2163740);
            }
            if (this.m_attrList != null) {
                this.m_attrList.editorCancel(n == 2163740);
            }
            if (this.m_entryAttrList != null) {
                this.m_entryAttrList.editorCancel(n == 2163740);
            }
            if (this.m_entryStructList != null) {
                this.m_entryStructList.editorCancel(n == 2163740);
            }
            return;
        }
        if (n == 1048745) {
            this.m_helpTopic = (String)object;
            return;
        }
        if (this.m_mods != null && !this.m_bInitializing) {
            String string;
            Integer n2 = new Integer(n);
            if (!this.m_mods.contains(n2) && this.m_parent.validAttributePropId(n2)) {
                if (this.m_addMods.get(n2) == null && this.getProp(n) == null) {
                    this.m_addMods.put(n2, Boolean.TRUE);
                }
                if (Root.debugSaveEntry && (string = super.getPropName(n)) != null) {
                    if (string.endsWith("ConfirmPassword")) {
                        System.out.print("########### ");
                    }
                    System.out.println("adding to mod list " + n2 + " attrName =" + string);
                }
                this.m_mods.addElement(n2);
            }
            if (Root.debugSaveEntry) {
                System.out.println("setting attr " + n2 + " attrName =" + super.getPropName(n));
            }
            if (this.m_parent.getPropIdAttr(n2) != null && (string = super.getPropName(n)) != null) {
                if (object == null) {
                    if (Root.debugSaveEntry) {
                        System.out.println("removing from set attr " + string);
                    }
                    this.removeSetAttrName(string);
                    this.addUnsetAttrName(string);
                } else {
                    if (Root.debugSaveEntry) {
                        System.out.println("adding to set attr " + string);
                    }
                    this.addSetAttrName(string);
                    this.removeUnsetAttrName(string);
                }
                if (Root.debugSaveEntry) {
                    System.out.println("   set attrs = " + this.getSetAttrNamesVector());
                }
            }
        }
        super.setProp(n, object);
        if (!this.m_bInitializing && n == this.m_objClassPropId) {
            if (Root.debugSaveEntry) {
                System.out.println("\nchanging object classes");
            }
            this.changeObjectClasses(object);
        }
    }

    public void changeObjectClasses(Object object) throws PropertyException {
        Object object2;
        Object object3;
        boolean bl = this.isExtensible();
        Vector vector = this.getAllAttributes(this.m_objectClasses);
        this.m_objectClasses = new Vector();
        if (object instanceof String[]) {
            object3 = (String[])object;
            int n = 0;
            while (n < ((String[])object3).length) {
                this.addObjectClass((String)object3[n]);
                ++n;
            }
        } else if (object instanceof String) {
            this.addObjectClass((String)object);
        }
        object3 = this.getAllAttributes(this.m_objectClasses);
        Vector vector2 = (Vector)((Vector)object3).clone();
        int n = ((Vector)object3).size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)((Vector)object3).elementAt(n2);
            if (vector.contains(string)) {
                vector.removeElement(string);
                ((Vector)object3).removeElementAt(n2);
                --n2;
                --n;
            }
            if (vector.size() == 0) break;
            ++n2;
        }
        n = vector.size();
        if (Root.debugSaveEntry) {
            System.out.println("removing attrs = " + vector);
        }
        int n3 = 0;
        while (n3 < n) {
            String string = (String)vector.elementAt(n3);
            this.removeAttr(string, false, true, false);
            ++n3;
        }
        n = ((Vector)object3).size();
        if (Root.debugSaveEntry) {
            System.out.println("adding attrs = " + object3);
        }
        int n4 = 0;
        while (n4 < n) {
            object2 = (String)((Vector)object3).elementAt(n4);
            this.addUnsetAttrName((String)object2);
            ++n4;
        }
        if (bl && !this.isExtensible() && (object2 = (Object)((int[])super.getProp(282001422))) != null) {
            int n5 = this.m_parent.getAttrPropId("dn");
            int n6 = 0;
            while (n6 < ((Object)object2).length) {
                String string;
                if (object2[n6] != 0x110001 && object2[n6] != n5 && !vector2.contains(string = super.getPropName((int)object2[n6]))) {
                    if (Root.debugSaveEntry) {
                        System.out.println("unregisting extensible attr=" + string);
                    }
                    this.m_parent.getAttrPropId(string).intValue();
                    this.removeAttr(string, false, true, false);
                }
                ++n6;
            }
        }
        if (Root.debugSaveEntry) {
            System.out.println("sending change event\n");
        }
        this.update();
    }

    public boolean isKnownAttribute(String string) {
        Vector vector = this.getObjectClasses();
        if (vector == null || vector.size() == 0) {
            return false;
        }
        Vector vector2 = (Vector)this.getObjectClasses().clone();
        this.addSuperClassObjects(vector2);
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            ObjectClass objectClass = (ObjectClass)vector2.elementAt(n2);
            try {
                int n3 = 0;
                while (n3 < 2) {
                    String[] stringArray = (String[])objectClass.getProp(n3 == 0 ? 269496330 : 269496331);
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            if (stringArray[n4].equalsIgnoreCase(string)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
            ++n2;
        }
        return false;
    }

    public Vector getAllAttributes(Vector vector) throws PropertyException {
        Vector<String> vector2 = new Vector<String>();
        if (vector == null || vector.size() == 0) {
            return vector2;
        }
        Vector vector3 = (Vector)this.getObjectClasses().clone();
        this.addSuperClassObjects(vector3);
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            ObjectClass objectClass = (ObjectClass)vector3.elementAt(n2);
            int n3 = 0;
            while (n3 < 2) {
                String[] stringArray = (String[])objectClass.getProp(n3 == 0 ? 269496330 : 269496331);
                if (stringArray != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        String string = stringArray[n4].toLowerCase();
                        if (!vector2.contains(string)) {
                            vector2.addElement(string);
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return vector2;
    }

    public String getPropNameNormal(int n) {
        return super.getPropName(n);
    }

    public String getPropName(int n) {
        if (this.m_parent == null) {
            String string = super.getPropName(n);
            return string;
        }
        if (this.m_adminNames == null) {
            this.m_adminNames = this.m_parent.getAdminNames();
        }
        String string = super.getPropName(n);
        if (this.m_adminNames != null) {
            String string2 = this.alwaysUseDisplayName() ? this.m_adminNames.getPropNameReal(string) : this.m_adminNames.getPropName(string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
        return string;
    }

    public boolean alwaysUseDisplayName() {
        return false;
    }

    public void delete() throws PropertyException {
        if (!this.m_parent.deleteEntry(this)) {
            throw new PropertyException(this.m_parent.getErrorMessage());
        }
        if (this.m_directory != null) {
            this.m_directory.removeChild(this);
        }
        if (this.m_dirTreeParent != null) {
            this.m_dirTreeParent.removeChild(this);
        }
        this.m_bValid = false;
        this.makeInvalid();
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case -9: {
                    this.delete();
                    break;
                }
                case 2: {
                    return new NewAccessItem(this.m_orclACI, this.m_parent);
                }
                case 3: {
                    return new NewAccessItem(this.m_orclEntryACI, this.m_parent);
                }
                case -10: {
                    if (this.m_parent == null) {
                        return null;
                    }
                    if (this.m_directory == null) {
                        this.m_directory = this.m_parent.getDirectory();
                    }
                    if (this.m_directory == null) {
                        return null;
                    }
                    NewEntry newEntry = new NewEntry(this.m_parent, this.m_directory, this.m_directory.getSubSchema());
                    this.copyTo(newEntry);
                    newEntry.setDn(this.getDn());
                    return newEntry;
                }
                default: {
                    return null;
                }
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public void removeAttr(String string, boolean bl, boolean bl2, boolean bl3) {
        if (Root.debugSaveEntry) {
            System.out.println("removeAttr attr= " + string);
        }
        this.removeSetAttrName(string);
        Integer n = this.m_parent.getAttrPropId(string);
        int n2 = n;
        if (Root.debugSaveEntry) {
            System.out.println("removeAttr propId= " + n2);
        }
        if (bl2) {
            this.unregisterProp(n2);
        } else if (this.isKnownAttribute(string)) {
            try {
                this.setProp(n2, null);
            }
            catch (Exception exception) {}
        } else {
            this.unregisterProp(n2);
        }
        if (Root.debugSaveEntry) {
            try {
                System.out.println("removeAttr old value?= " + this.getProp(n2));
                System.out.println("removeAttr still set?= " + this.m_Properties.containsKey(n2));
            }
            catch (Exception exception) {}
        }
        if (bl3 && !this.m_mods.contains(n) && this.m_parent.validAttributePropId(n)) {
            String string2;
            if (Root.debugSaveEntry && (string2 = super.getPropName(n2)) != null) {
                if (string2.endsWith("ConfirmPassword")) {
                    System.out.print("########### ");
                }
                System.out.println("adding to mod list " + n + " attrName =" + string2);
            }
            this.m_mods.addElement(n);
        }
        if (bl) {
            this.update();
        }
    }

    public void addAttr(String string, boolean bl) {
        try {
            Integer n = this.m_parent.getAttrPropId(string);
            int n2 = n;
            if (this.getProp(n2) != null) {
                return;
            }
            this.addSetAttrName(string);
            this.registerProp(n2, string, string);
            if (AdminProp.isPropArray(n2)) {
                this.setProp(n2, (Object)emptyStringArray);
            } else {
                this.setProp(n2, (Object)"");
            }
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        if (bl) {
            this.update();
        }
    }

    public void addAttrs(Vector vector, boolean bl) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            this.addAttr(string, false);
            ++n2;
        }
        if (bl) {
            this.update();
        }
    }

    public void addSuperClasses(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            block8: {
                String string = (String)vector.elementAt(n);
                ObjectClass objectClass = this.m_subSchema.findObjectClass(0x110001, string);
                if (objectClass != null) {
                    String[] stringArray;
                    try {
                        stringArray = (String[])objectClass.getProp(269496329);
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                        break block8;
                    }
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            int n3 = vector.size();
                            int n4 = 0;
                            while (n4 < n3) {
                                if (stringArray[n2].equalsIgnoreCase((String)vector.elementAt(n4))) break;
                                ++n4;
                            }
                            if (n4 == n3) {
                                vector.addElement(stringArray[n2]);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void addSuperClassObjects(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            block13: {
                ObjectClass objectClass = null;
                Object e = vector.elementAt(n);
                if (e instanceof String) {
                    objectClass = this.m_parent.findObjectClass(0x110001, (String)e);
                    if (objectClass != null) {
                        vector.insertElementAt(objectClass, n);
                        vector.removeElementAt(n + 1);
                    }
                } else {
                    objectClass = (ObjectClass)e;
                }
                if (objectClass != null) {
                    String[] stringArray;
                    try {
                        stringArray = (String[])objectClass.getProp(269496329);
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                        break block13;
                    }
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            ObjectClass objectClass2 = null;
                            if (this.m_subSchema != null) {
                                objectClass2 = this.m_subSchema.findObjectClass(0x110001, stringArray[n2]);
                            } else if (this.m_parent != null) {
                                objectClass2 = this.m_parent.findObjectClass(0x110001, stringArray[n2]);
                            }
                            if (objectClass2 != null && !AdminProp.vectorContains(vector, objectClass2)) {
                                vector.addElement(stringArray[n2]);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void update() {
        this.sendAdminPropertyChangeEvents(272695330, null);
    }

    public void update(boolean bl) {
        this.update();
        if (bl && (this.m_status & 2) == 0) {
            this.m_status |= 2;
            this.sendAdminPropertyChangeEvents(3080204, null);
        }
    }

    public void update(Object[] objectArray) {
        this.m_loadingAttrs = false;
        this.m_attributes = objectArray;
        if (this.m_repaint) {
            this.parseSearchResult(objectArray);
            this.update();
        }
    }

    public void setSubSchema(SubSchema subSchema) {
        this.m_subSchema = subSchema;
    }

    public SubSchema getSubSchema() {
        return this.m_subSchema;
    }

    public boolean hasSubSchema() {
        return this.m_subSchema != null && this.m_subSchema.countChildren() != 0;
    }

    void verifyDN(String string) throws PropertyException {
        ((AdminProp)this.m_parent).setErrorMessage("");
        try {
            boolean bl = this.m_parent.m_serverAccess.findObjectSync(string, null, this);
        }
        catch (Exception exception) {
            if (Root.debugSaveEntry) {
                System.out.println(exception.getMessage());
            }
            throw new PropertyException(exception.getMessage());
        }
        String string2 = ((AdminProp)this.m_parent).getErrorMessage();
        if (!string2.equals("")) {
            if (Root.debugSaveEntry) {
                System.out.println(string2);
            }
            throw new PropertyException(string2);
        }
    }

    GridBagConstraints[] getAccessCntrlLayout(boolean bl) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints[] gridBagConstraintsArray = new GridBagConstraints[bl ? 3 : 2];
        int n = 0;
        if (bl) {
            gridBagConstraintsArray[n++] = gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
        }
        gridBagConstraintsArray[n++] = gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        if (bl) {
            gridBagConstraints.insets.top = 20;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraintsArray[n++] = gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraintsArray;
    }

    public int[] getVisibleProps() {
        int[] nArray = new int[]{1458177};
        return nArray;
    }

    public Object[] getVisiblePropListOfValues() {
        return null;
    }

    IAdminProp[] getAccessCntrlChildren(boolean bl) {
        Object[] objectArray;
        int[] nArray;
        IAdminProp[] iAdminPropArray = new IAdminProp[bl ? 3 : 2];
        int n = 0;
        if (bl) {
            nArray = new int[]{3080204, 282001422, 0x110001, 276758675};
            objectArray = new Object[nArray.length];
            objectArray[0] = new Integer(8196);
            objectArray[1] = this.getVisibleProps();
            objectArray[2] = "Header Information";
            objectArray[3] = this.getVisiblePropListOfValues();
            iAdminPropArray[n++] = new AdminPropView((IAdminProp)this, nArray, objectArray);
        }
        nArray = new int[]{1048745, 0x110001, 3080204, 273613313, 2032706};
        objectArray = new Object[]{"structural_access", LDAPLang.getStrStructAccessItem(), new Integer(68), null, LDAPLang.getStrStructAccessItem()};
        if (this.m_structList == null) {
            this.m_structList = new ACPStructList(this.m_orclACI, this);
        }
        iAdminPropArray[n++] = new AdminPropView((IAdminProp)this.m_structList, nArray, objectArray);
        int[] nArray2 = new int[]{1048745, 0x110001, 3080204, 273613313, 2032706};
        Object[] objectArray2 = new Object[]{"content_access", LDAPLang.getStrContentAccessItem(), new Integer(68), null, LDAPLang.getStrContentAccessItem()};
        if (this.m_attrList == null) {
            this.m_attrList = new ACPAttrList(this.m_orclACI, this);
        }
        iAdminPropArray[n++] = new AdminPropView((IAdminProp)this.m_attrList, nArray2, objectArray2);
        return iAdminPropArray;
    }

    IAdminProp[] getEntryAccessCntrlChildren(boolean bl) {
        Object[] objectArray;
        int[] nArray;
        IAdminProp[] iAdminPropArray = new IAdminProp[bl ? 3 : 2];
        int n = 0;
        if (bl) {
            nArray = new int[]{3080204, 282001422, 0x110001, 276758675};
            objectArray = new Object[nArray.length];
            objectArray[0] = new Integer(8196);
            objectArray[1] = this.getVisibleProps();
            objectArray[2] = "Header Information";
            objectArray[3] = this.getVisiblePropListOfValues();
            iAdminPropArray[n++] = new AdminPropView((IAdminProp)this, nArray, objectArray);
        }
        nArray = new int[]{0x110001, 3080204, 273613313, 2032706};
        objectArray = new Object[]{LDAPLang.getStrStructAccessItem(), new Integer(64), null, LDAPLang.getStrStructAccessItem()};
        if (this.m_entryStructList == null) {
            this.m_entryStructList = new ACPStructList(this.m_orclEntryACI, this);
        }
        iAdminPropArray[n++] = new AdminPropView((IAdminProp)this.m_entryStructList, nArray, objectArray);
        int[] nArray2 = new int[]{0x110001, 3080204, 273613313, 2032706};
        Object[] objectArray2 = new Object[]{LDAPLang.getStrContentAccessItem(), new Integer(64), null, LDAPLang.getStrContentAccessItem()};
        if (this.m_entryAttrList == null) {
            this.m_entryAttrList = new ACPAttrList(this.m_orclEntryACI, this);
        }
        iAdminPropArray[n++] = new AdminPropView((IAdminProp)this.m_entryAttrList, nArray2, objectArray2);
        return iAdminPropArray;
    }

    public void updateEntryAccessInfo() throws PropertyException {
        if (this.m_entryAttrList != null && this.m_entryAttrList.isDirty() || this.m_entryStructList != null && this.m_entryStructList.isDirty()) {
            this.m_hasEntryACIAttrType = this.updateAccessInfo(this.m_entryStructList.toStrings(), this.m_entryAttrList.toStrings(), ORACLE_ENTRY_ACI_ATTR_TYPE, this.m_hasEntryACIAttrType);
            this.m_entryAttrList.setDirty(false);
            this.m_entryStructList.setDirty(false);
        }
    }

    public void updateSubtreeAccessInfo() throws PropertyException {
        if (this.m_attrList != null && this.m_attrList.isDirty() || this.m_structList != null && this.m_structList.isDirty()) {
            this.m_hasACIAttrType = this.updateAccessInfo(this.m_structList.toStrings(), this.m_attrList.toStrings(), ORACLE_ACI_ATTR_TYPE, this.m_hasACIAttrType);
            this.m_attrList.setDirty(false);
            this.m_structList.setDirty(false);
        }
    }

    public boolean updateAccessInfo(String[] stringArray, String[] stringArray2, String string, boolean bl) throws PropertyException {
        int n = this.m_parent.getAttrPropId(string);
        if (stringArray == null || stringArray.length == 0) {
            if (stringArray2 == null || stringArray2.length == 0) {
                if (bl) {
                    if (Root.debugSaveEntry) {
                        this.debugMessageLn("remove access info");
                    }
                    this.setProp(n, null);
                    this.unregisterProp(n);
                    bl = false;
                }
            } else {
                if (!bl) {
                    if (Root.debugSaveEntry) {
                        this.debugMessageLn("add access info");
                    }
                    this.registerProp(n, string, string);
                    bl = true;
                }
                this.setProp(n, (Object)stringArray2);
            }
        } else if (stringArray2 == null || stringArray2.length == 0) {
            if (!bl) {
                if (Root.debugSaveEntry) {
                    this.debugMessageLn("add access info");
                }
                this.registerProp(n, string, string);
                bl = true;
            }
            this.setProp(n, (Object)stringArray);
        } else {
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            if (!bl) {
                if (Root.debugSaveEntry) {
                    this.debugMessageLn("add access info");
                }
                this.registerProp(n, string, string);
                bl = true;
            }
            this.setProp(n, (Object)stringArray3);
        }
        return bl;
    }

    public boolean isDirty() {
        return this.m_status == 2;
    }

    public void setDirty(boolean bl) {
        if (bl && (this.m_status & 2) == 0) {
            this.m_status |= 2;
            this.sendAdminPropertyChangeEvents(3080204, null);
            return;
        }
        if (!bl && (this.m_status & 2) != 0) {
            this.m_status &= 0xFFFFFFFD;
            this.sendAdminPropertyChangeEvents(3080204, null);
        }
    }

    public boolean isEntryRefreshed() {
        return this.m_refreshEntry;
    }

    public boolean loadAttrs(boolean bl) throws PropertyException {
        try {
            this.m_refreshEntry = true;
            this.m_loadingAttrs = true;
            this.m_repaint = bl;
            int n = 0;
            this.m_parent.m_serverAccess.findObjectSync(this.m_dn, null, this);
            while (this.m_loadingAttrs && n++ < 30) {
                if (Root.debugDirTree) {
                    System.out.println(".9");
                }
                Thread.sleep(500L);
            }
            if (n == 30) {
                if (Root.debugDirTree) {
                    System.out.println("DirTree.getProp(PR_TAB_OBJ_LIST): (TIMEOUT) Returned");
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return true;
    }

    public void cleanup() {
        this.m_directory = null;
        this.m_localDirectory = null;
        this.m_parent = null;
        this.m_dirTreeParent = null;
        this.m_orclACI.cleanup();
        this.m_orclACI = null;
        this.m_orclEntryACI.cleanup();
        this.m_orclEntryACI = null;
        this.m_attrList = null;
        this.m_entryAttrList = null;
        this.m_entryStructList = null;
        this.m_attributes = null;
        this.m_lookupDir = null;
        this.m_objectClasses = null;
        this.m_unsetAttrNames = null;
        this.m_setAttrNames = null;
        this.m_addMods = null;
        this.m_mods = null;
        this.m_adminNames = null;
        this.m_subSchema = null;
        if (this.m_orclACI != null) {
            this.m_orclACI.cleanup();
        }
        this.m_orclACI = null;
        if (this.m_orclEntryACI != null) {
            this.m_orclEntryACI.cleanup();
        }
        this.m_orclEntryACI = null;
    }
}

