/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AccessCtrlPoint;
import oracle.ldap.admin.AccessCtrlPoints;
import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewAccessCtrlPoint
extends AccessCtrlPoint {
    boolean m_newObject = true;
    boolean debug;

    public NewAccessCtrlPoint(Root root, AccessCtrlPoints accessCtrlPoints) {
        super(root, null, null, null, false, accessCtrlPoints);
        this.m_bInitializing = false;
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x104001, LDAPLang.getStrDnPlbl1(), LDAPLang.getStrDnPdsc());
    }

    public Object getProp(int n) throws PropertyException {
        if (!this.m_newObject) {
            return super.getProp(n);
        }
        switch (n) {
            case 1048745: {
                return "new_access_control_point";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                if (this.m_dn != null) {
                    return String.valueOf(LDAPLang.getStrEditorTitle15()) + ": " + LDAPLang.getStrCreateLikeLabel() + " " + this.m_dn;
                }
                return LDAPLang.getStrEditorTitle15();
            }
            case 0x104001: {
                return this.m_dn;
            }
            case 0x110001: {
                return null;
            }
            case 273613313: {
                if (this.m_newObject) {
                    return null;
                }
            }
            case 2687386: {
                Integer n2 = (Integer)super.getProp(n);
                if (n2 != null) {
                    return new Integer((int)(n2 | 0x100000 | 0x800));
                }
                return new Integer(0x100800);
            }
        }
        return super.getProp(n);
    }

    public String getPropName(int n) {
        String string = super.getPropName(n);
        if (string == null && n == 0x104001) {
            return "Path To Entry ";
        }
        return string;
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (!this.m_newObject) {
            super.setProp(n, object);
            return;
        }
        switch (n) {
            case 0x104001: {
                String string = (String)object;
                if (string != null && string.length() > 0) {
                    if (this.doesExist(string)) {
                        throw new PropertyException(LDAPLang.getStrDuplicateAcp());
                    }
                    this.verifyDN(string);
                    this.setDn(string);
                    int n2 = this.m_dn.indexOf(",");
                    String string2 = n2 <= 0 ? this.m_dn : this.m_dn.substring(0, n2);
                    this.setProp(1458176, (Object)string2);
                }
                return;
            }
            case 2163220: 
            case 2163740: {
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        super.saveChanges(n);
        if ((this.m_structList != null && this.m_structList.countChildren() > 0 || this.m_attrList != null && this.m_attrList.countChildren() > 0) && this.m_newObject) {
            this.m_newObject = false;
            this.m_container.addChildUnique(this);
            this.m_container.update();
        }
    }

    boolean doesExist(String string) throws PropertyException {
        string = string.trim();
        int n = this.m_container.countChildren();
        int n2 = 0;
        while (n2 < n) {
            AccessCtrlPoint accessCtrlPoint = (AccessCtrlPoint)this.m_container.nthChild(n2);
            String string2 = accessCtrlPoint.getDn();
            if ((string2 = string2.trim()).equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int[] getVisibleProps() {
        if (!this.m_newObject) {
            return super.getVisibleProps();
        }
        int[] nArray = new int[]{0x104001};
        return nArray;
    }

    public Object[] getVisiblePropListOfValues() {
        if (!this.m_newObject) {
            return super.getVisiblePropListOfValues();
        }
        Object[] objectArray = new Object[]{new EntrySelector(this.m_parent)};
        return objectArray;
    }
}

