/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.Attributes;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewAttribute
extends Attribute {
    Attributes m_container;
    boolean m_newObject = true;
    String m_title;

    public NewAttribute(Attributes attributes, SubSchema subSchema) {
        this.m_container = attributes;
        this.m_subSchema = subSchema;
        this.setCataloged(false);
        try {
            this.setProp(1060869, (Object)SchemaObject.ATTRIBUTEUSAGES[0]);
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void registerMessages() {
        super.registerMessages();
        this.unregisterProp(8794113);
        this.setPropTabPages(8794113, null);
        this.registerPropOnTabPage(8400897, LDAPLang.getStrIsCatalogedPlbl(), LDAPLang.getStrIsCatalogedPdsc(), LDAPLang.getStrAdvanced());
    }

    public Object getProp(int n) throws PropertyException {
        if (!this.m_newObject) {
            return super.getProp(n);
        }
        switch (n) {
            case 3081366: {
                return new Integer(12);
            }
            case 1048745: {
                return "adding_new_attribute_types";
            }
            case 1638408: {
                return "images/ldapattr.gif";
            }
            case 2031768: {
                if (this.m_title == null) {
                    this.m_title = LDAPLang.getStrEditorTitle17();
                }
                return this.m_title;
            }
            case 273613313: {
                return null;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 2031768: {
                this.m_title = (String)object;
                return;
            }
            case 8400897: {
                boolean bl = (Boolean)object;
                this.setCataloged(bl);
            }
        }
        super.setProp(n, object);
    }

    public boolean validate() throws SaveChangeException {
        if (!super.validate()) {
            return false;
        }
        String string = null;
        try {
            boolean bl = (Boolean)this.getProp(8400897);
            if (!bl) {
                return true;
            }
            string = (String)this.getProp(1060871);
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        if (string == null || string.trim().equals("")) {
            throw new SaveChangeException(String.valueOf(LDAPLang.getStrCannotIndex()) + "\n");
        }
        return true;
    }

    public void saveChanges(int n) throws SaveChangeException {
        Object object;
        if (!this.m_newObject) {
            super.saveChanges(n);
            return;
        }
        if (!Root.isClientCommandLine()) {
            this.setListProp(this.m_supObjs, 269496329);
        }
        try {
            if (!this.validate()) {
                return;
            }
        }
        catch (SaveChangeException saveChangeException) {
            throw new SaveChangeException(saveChangeException);
        }
        try {
            this.m_subSchema.saveNewAttribute(this);
            object = (String)this.getProp(0x103000);
            boolean bl = (Boolean)this.getProp(8400897);
            if (bl) {
                this.m_subSchema.CatalogeAttr((String)object, true);
            }
            this.unregisterProp(8400897);
            this.setPropTabPages(8400897, null);
            this.registerPropOnTabPage(8794113, LDAPLang.getStrIsCatalogedPlbl(), LDAPLang.getStrIsCatalogedPdsc(), LDAPLang.getStrAdvanced());
            this.sendAdminPropertyChangeEvents(282001422, null);
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
        object = this.m_subSchema.getParent();
        String string = ((Root)object).getErrorMessage();
        if (!string.trim().equals("")) {
            throw new SaveChangeException(string);
        }
        this.m_newObject = false;
        this.setOriginalString(this.toString());
        this.setExisting(true);
        this.m_supObjs = null;
    }

    public boolean isNew() {
        return this.m_newObject;
    }
}

