/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.INewEntry;
import oracle.ldap.admin.ImageSelector;
import oracle.ldap.admin.JpegAttr;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.PathSelector;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminLang;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.AdminSort;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.TableSelector;

public class NewEntry
extends AdminProp
implements INewEntry,
ICommandParent {
    public static boolean DEBUG;
    Directory m_directory;
    SubSchema m_subSchema;
    Root m_parent;
    Directory m_lookupDir;
    ImageSelector m_lookupImage;
    Vector m_mayList;
    Vector m_mustList;
    static final int PR_BASEDN = 0x103000;
    static final int PR_OBJCLASS_OBJ = 4206593;
    static int[] PR_OBJECT_CLASS;
    static int PR_JPEGPHOTO;
    static final int PR_MAY_PROPERTY_LIST = 281030658;
    static final int PR_MUST_PROPERTY_LIST = 281030659;
    static final int PR_MAY_PROPERTY_LIST_OF_VALUES = 275787780;
    static final int PR_MUST_PROPERTY_LIST_OF_VALUES = 275787781;
    static final int PR_INIT_DESCRIPTION = 1060870;
    static final int PR_SELECT_OBJCLS = 272642055;
    static final int CMD_ADD_OBJCLS = 6;
    static final int CMD_DELETE_OBJCLS = 7;
    static final int CMD_EDIT_OBJCLS = 8;
    Names m_adminNames;
    AdminList m_objectClasses;
    String[] m_objectClassNames;
    TableSelector m_objectClassSelector;
    String m_dn;

    public String getDn() {
        return this.m_dn;
    }

    public void setDn(String string) {
        this.m_dn = string;
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public NewEntry(Root root, Directory directory, SubSchema subSchema) {
        this.m_parent = root;
        this.m_directory = directory;
        this.m_subSchema = subSchema;
        if (this.m_adminNames == null) {
            this.m_adminNames = this.m_parent.getAdminNames();
        }
        try {
            try {
                this.setProp(4784134, (Object)new AdminLang(this.getClass()));
                this.registerMessages();
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
                return;
            }
            this.registerMessages();
            this.registerProp(0x103000, LDAPLang.getStrDisplayNamePlbl1(), LDAPLang.getStrBasednPdsc1());
            if (!Root.isClientCommandLine()) {
                this.registerProp(4206593, LDAPLang.getStrObjclassObjPlbl(), LDAPLang.getStrObjclassObjPdsc());
                this.setPropertyLabelHidden(4206593, true, false);
            }
            NewEntry.PR_OBJECT_CLASS[0] = this.m_parent.getAttrPropId("objectClass");
            PR_JPEGPHOTO = this.m_parent.getAttrPropId("jpegphoto");
            this.registerProp(PR_OBJECT_CLASS[0], LDAPLang.getStrObjectClassPlbl(), LDAPLang.getStrObjectClassPdsc());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.unexpectedException(exception);
            return;
        }
    }

    int[] getMustPropList() {
        return this.convertAttrsToPropIds(this.m_mustList);
    }

    int[] getMayPropList() {
        return this.convertAttrsToPropIds(this.m_mayList);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3081366: {
                return new Integer(12);
            }
            case 2688122: {
                return new Integer(500);
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1048745: {
                return "new_entry";
            }
            case 1638408: {
                return "images/ldapentry.gif";
            }
            case 0x103000: {
                return this.m_dn;
            }
            case 281609329: {
                int[] nArray = new int[]{PR_OBJECT_CLASS[0]};
                return nArray;
            }
            case 1060870: {
                if (this.m_objectClassNames == null || this.m_objectClassNames.length == 0) {
                    return LDAPLang.getStrPickObjclass();
                }
                return null;
            }
            case 275787780: {
                return this.getEntryLOV((int[])this.getProp(281030658), null);
            }
            case 275787781: {
                return this.getEntryLOV((int[])this.getProp(281030659), null);
            }
            case 281030658: {
                int[] nArray = this.getMayPropList();
                if (nArray != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        ++n2;
                    }
                }
                this.sortPropertiesByName(nArray);
                return nArray;
            }
            case 281030659: {
                int[] nArray = this.getMustPropList();
                if (nArray != null) {
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        if (nArray[n3] == PR_OBJECT_CLASS[0]) {
                            int[] nArray2 = new int[nArray.length - 1];
                            n3 = 0;
                            int n4 = 0;
                            while (n4 < nArray.length) {
                                if (nArray[n4] != PR_OBJECT_CLASS[0]) {
                                    nArray2[n3++] = nArray[n4];
                                }
                                ++n4;
                            }
                            nArray = nArray2;
                            break;
                        }
                        ++n3;
                    }
                }
                this.sortPropertiesByName(nArray);
                return nArray;
            }
            case 2031768: {
                if (this.m_dn != null) {
                    return String.valueOf(LDAPLang.getStrEditorTitle18()) + ": " + LDAPLang.getStrCreateLikeLabel() + " " + this.m_dn;
                }
                return LDAPLang.getStrEditorTitle18();
            }
            case 3080204: {
                return new Integer(32772);
            }
            case 272630352: 
            case 272630384: {
                Object object;
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int[] nArray = new int[]{3080204, 282001422, 276758675, 2687386, 0x110001};
                Object[] objectArray = new Object[nArray.length];
                objectArray[0] = new Integer(8196);
                int[] nArray3 = new int[]{0x103000, !Root.isClientCommandLine() ? 4206593 : PR_OBJECT_CLASS[0]};
                objectArray[1] = nArray3;
                if (Root.isClientCommandLine()) {
                    object = new Object[]{null, this.getObjectClassNames()};
                    objectArray[2] = object;
                } else {
                    objectArray[2] = null;
                    object = new Object[]{new PathSelector(this.m_parent), null};
                    objectArray[2] = object;
                }
                objectArray[3] = new Integer(5244979);
                objectArray[4] = "Header Information";
                object = new AdminPropView((IAdminProp)this, nArray, objectArray);
                iAdminPropArray[0] = object;
                ((AdminPropView)object).setSkipSaveChange(true);
                int[] nArray4 = new int[]{3080204, 2162846, 0x110001};
                Object[] objectArray2 = new Object[nArray4.length];
                objectArray2[0] = new Integer(4100);
                objectArray2[1] = new Integer(5);
                objectArray2[2] = "Property Information";
                AdminPropView adminPropView = new AdminPropView((IAdminProp)this, nArray4, objectArray2);
                iAdminPropArray[1] = adminPropView;
                return iAdminPropArray;
            }
            case 2687386: {
                return new Integer(0x100800);
            }
            case 275841152: {
                GridBagConstraints gridBagConstraints;
                GridBagConstraints[] gridBagConstraintsArray = null;
                int n5 = 1;
                int n6 = 0;
                gridBagConstraintsArray = new GridBagConstraints[4 + 6 * n5];
                gridBagConstraintsArray[n6++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets.top = 0;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n6++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets.top = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n6++] = null;
                gridBagConstraintsArray[n6++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets.left = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraintsArray[n6++] = null;
                gridBagConstraintsArray[n6++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets.left = 5;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                return gridBagConstraintsArray;
            }
            case 272695330: {
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int[] nArray = new int[]{0x110001, 3080204, 275841152};
                Object[] objectArray = new Object[nArray.length];
                objectArray[0] = LDAPLang.getStrMustProps();
                objectArray[1] = new Integer(8196);
                objectArray[2] = null;
                int[] nArray5 = new int[]{282001422, 276758675, 1638914};
                int[] nArray6 = new int[]{281030659, 275787781, 1060870};
                AdminPropView adminPropView = new AdminPropView((IAdminProp)this, nArray, objectArray, nArray5, nArray6);
                iAdminPropArray[0] = adminPropView;
                adminPropView.setSkipSaveChange(true);
                int[] nArray7 = new int[]{0x110001, 3080204, 275841152};
                Object[] objectArray3 = new Object[nArray7.length];
                objectArray3[0] = LDAPLang.getStrMayProps();
                objectArray3[1] = new Integer(8196);
                objectArray3[2] = null;
                int[] nArray8 = new int[]{282001422, 276758675, 1638914};
                int[] nArray9 = new int[]{281030658, 275787780, 1060870};
                AdminPropView adminPropView2 = new AdminPropView((IAdminProp)this, nArray7, objectArray3, nArray8, nArray9);
                iAdminPropArray[1] = adminPropView2;
                adminPropView2.setSkipSaveChange(true);
                return iAdminPropArray;
            }
            case 4206593: {
                if (this.m_objectClasses == null) {
                    this.m_objectClasses = new AdminList((IAdminProp)this, new Vector());
                    this.m_objectClasses.setSampleChild(ObjectClass.getSampleOC());
                    this.m_objectClasses.setDisplayNameProp(0x103000);
                    String[] stringArray = this.m_objectClassNames;
                    if (stringArray != null) {
                        int n7 = 0;
                        while (n7 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findObjectClasses(0x103000, stringArray[n7]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_objectClasses.addChild(objectArray[0]);
                            }
                            ++n7;
                        }
                    }
                    this.m_objectClasses.setProp(2032706, (Object)this.getPropName(n));
                    this.m_objectClasses.setProp(2162725, 114688);
                    IAdminProp[] iAdminPropArray = new CommandProp[3];
                    int n8 = 0;
                    iAdminPropArray[n8++] = new CommandProp((IAdminProp)this, 6, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDesc1(), "images/create.gif");
                    iAdminPropArray[n8++] = new CommandProp(this, 7, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc5(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n8 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                    iAdminPropArray[n8++] = new CommandProp(this, 8, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc3(), "images/edit.gif", 1, 1);
                    this.m_objectClasses.setCommandList(iAdminPropArray);
                }
                return this.m_objectClasses;
            }
            case 273613313: {
                return null;
            }
            case 2163876: {
                return new Integer(100);
            }
        }
        int n9 = 0;
        while (n9 < PR_OBJECT_CLASS.length) {
            if (PR_OBJECT_CLASS[n9] == n) {
                return this.m_objectClassNames;
            }
            ++n9;
        }
        return super.getProp(n);
    }

    String[] getObjectClassNames() {
        Vector vector = this.m_subSchema.getObjectClasses();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            block6: {
                ObjectClass objectClass = (ObjectClass)vector.elementAt(n2);
                String string = null;
                try {
                    string = (String)objectClass.getProp(0x110001);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    break block6;
                }
                if (string != null) {
                    vector2.addElement(string);
                }
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return new String[0];
        }
        return AdminProp.vectorToStringArray(vector2);
    }

    void addToVector(String[] stringArray, Vector vector) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.isDebug()) {
                    this.debugMessageLn("addToVector: " + n + " " + stringArray[n]);
                }
                if (stringArray[n] != null && !vector.contains(stringArray[n])) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
            return;
        }
        if (this.isDebug()) {
            this.debugMessageLn("addToVector: strs is null");
        }
    }

    void collectAttrInfo(Vector vector, Vector vector2, Vector vector3) {
        int n = vector.size();
        if (this.isDebug()) {
            this.debugMessageLn("collectAttrInfo #class=" + n);
        }
        int n2 = 0;
        while (n2 < n) {
            block18: {
                ObjectClass objectClass;
                String string = (String)vector.elementAt(n2);
                if (this.isDebug()) {
                    this.debugMessageLn("class='" + string + "'");
                }
                if ((objectClass = this.m_subSchema.findObjectClass(0x110001, string)) == null) {
                    if (this.isDebug()) {
                        this.debugMessageLn("Couldn't find object class");
                    }
                    this.setErrorMessage("Unexpected case: couldn't find object class " + string);
                } else {
                    if (this.isDebug()) {
                        this.debugMessageLn("found ObjectClass");
                    }
                    String[] stringArray = null;
                    String[] stringArray2 = null;
                    try {
                        stringArray = (String[])objectClass.getProp(269496331);
                        stringArray2 = (String[])objectClass.getProp(269496330);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                        break block18;
                    }
                    if (stringArray != null) {
                        if (this.isDebug()) {
                            this.debugMessageLn("mayNameList not null");
                        }
                    } else if (this.isDebug()) {
                        this.debugMessageLn("mayNameList is null");
                    }
                    if (stringArray2 != null) {
                        if (this.isDebug()) {
                            this.debugMessageLn("mustNameList not null");
                        }
                    } else if (this.isDebug()) {
                        this.debugMessageLn("mustNameList is null");
                    }
                    if (this.isDebug()) {
                        objectClass.printDebug(System.out, true, true, true);
                    }
                    this.addToVector(stringArray, vector2);
                    this.addToVector(stringArray2, vector3);
                }
            }
            ++n2;
        }
    }

    void subtract(Vector vector, Vector[] vectorArray) {
        int n = 0;
        while (n < vectorArray.length) {
            Vector vector2 = vectorArray[n];
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = vector2.elementAt(n3);
                if (vector.contains(e)) {
                    vector.removeElement(e);
                }
                ++n3;
            }
            ++n;
        }
    }

    void append(Vector vector, Vector vector2) {
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector2.elementAt(n2);
            if (!vector.contains(e)) {
                vector.addElement(e);
            }
            ++n2;
        }
    }

    Vector merge(Vector vector, Vector vector2) {
        Vector vector3 = new Vector(vector.size() + vector2.size());
        this.append(vector3, vector);
        this.append(vector3, vector2);
        return vector3;
    }

    public void update(String[] stringArray) throws PropertyException {
        int n;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        if (this.m_objectClassNames != null) {
            if (this.isDebug()) {
                this.debugMessageLn("create delete list");
            }
            n = 0;
            while (n < this.m_objectClassNames.length) {
                if (this.isDebug()) {
                    this.debugMessageLn("\tadd to del " + this.m_objectClassNames[n]);
                }
                vector3.addElement(this.m_objectClassNames[n]);
                ++n;
            }
            if (this.isDebug()) {
                this.debugMessageLn("Done");
            }
        }
        if (stringArray != null && stringArray.length != 0) {
            if (this.isDebug()) {
                this.debugMessageLn("compare old with new");
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.m_objectClassNames != null) {
                    n = 0;
                    while (n < this.m_objectClassNames.length) {
                        if (this.m_objectClassNames[n].equalsIgnoreCase(stringArray[n2])) {
                            if (this.isDebug()) {
                                this.debugMessageLn("add to old " + stringArray[n2]);
                            }
                            vector2.addElement(stringArray[n2]);
                            vector3.removeElement(stringArray[n2]);
                            break;
                        }
                        ++n;
                    }
                    if (n == this.m_objectClassNames.length) {
                        if (this.isDebug()) {
                            this.debugMessageLn("add to new " + stringArray[n2]);
                        }
                        vector.addElement(stringArray[n2]);
                    }
                } else {
                    if (this.isDebug()) {
                        this.debugMessageLn("add to new " + stringArray[n2]);
                    }
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
        }
        if (vector.size() == 0 && vector3.size() == 0) {
            if (this.isDebug()) {
                this.debugMessageLn("No change detected");
            }
            return;
        }
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        Vector vector7 = new Vector();
        Vector vector8 = new Vector();
        Vector vector9 = new Vector();
        this.addSuperClasses(vector3);
        this.addSuperClasses(vector);
        this.addSuperClasses(vector2);
        this.collectAttrInfo(vector3, vector8, vector9);
        this.printVector("delList", vector3);
        this.collectAttrInfo(vector, vector4, vector5);
        this.printVector("newList", vector);
        this.collectAttrInfo(vector2, vector6, vector7);
        this.printVector("oldList", vector2);
        Vector[] vectorArray = new Vector[]{vector6, vector7};
        this.subtract(vector5, vectorArray);
        this.printVector("newMustList", vector5);
        this.subtract(vector4, vectorArray);
        this.printVector("newMayList", vector4);
        Vector[] vectorArray2 = new Vector[]{vector6, vector7, vector4, vector5};
        this.subtract(vector9, vectorArray2);
        this.printVector("delMustList", vector9);
        this.subtract(vector8, vectorArray2);
        this.printVector("delMayList", vector8);
        Vector vector10 = this.merge(vector9, vector8);
        this.printVector("delAttrList", vector10);
        if (vector10.size() != 0) {
            this.deleteProps(this.convertAttrsToPropIds(vector10));
        }
        this.registerProps(vector4);
        this.registerProps(vector5);
        this.m_mayList = this.merge(vector6, vector4);
        if (this.isDebug()) {
            this.printVector("m_mayList", this.m_mayList);
        }
        this.m_mustList = this.merge(vector7, vector5);
        if (this.isDebug()) {
            this.printVector("m_mustList", this.m_mustList);
        }
        this.m_objectClassNames = stringArray;
        this.sendAdminPropertyChangeEvents(PR_OBJECT_CLASS[0], (Object)this.m_objectClassNames);
        this.sendAdminPropertyChangeEvents(282001422, null);
    }

    public void addSuperClasses(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            block8: {
                String string = (String)vector.elementAt(n);
                ObjectClass objectClass = this.m_subSchema.findObjectClass(0x110001, string);
                if (objectClass != null) {
                    String[] stringArray;
                    try {
                        stringArray = (String[])objectClass.getProp(269496329);
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                        break block8;
                    }
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            int n3 = vector.size();
                            int n4 = 0;
                            while (n4 < n3) {
                                if (stringArray[n2].equalsIgnoreCase((String)vector.elementAt(n4))) break;
                                ++n4;
                            }
                            if (n4 == n3) {
                                vector.addElement(stringArray[n2]);
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n;
        }
    }

    void printVector(String string, Vector vector) {
        this.debugMessageLn(string);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.debugMessageLn("\t" + n2 + ": " + vector.elementAt(n2));
            ++n2;
        }
        this.debugMessageLn("Done");
    }

    int[] convertAttrsToPropIds(Vector vector) {
        if (vector == null) {
            return new int[0];
        }
        int n = vector.size();
        if (n != 0) {
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                nArray[n2] = this.m_subSchema.getAttrPropId(string);
                ++n2;
            }
            return nArray;
        }
        return new int[0];
    }

    void registerProps(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            int n3 = this.m_subSchema.getAttrPropId(string);
            this.registerProp(n3, string, string);
            ++n2;
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x103000: {
                this.m_dn = (String)object;
                break;
            }
            case 272642055: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null) {
                    return;
                }
                this.m_objectClasses.countChildren();
                int n2 = 0;
                while (n2 < iAdminPropArray.length) {
                    this.m_objectClasses.addChildUnique(iAdminPropArray[n2]);
                    ++n2;
                }
                this.m_objectClasses.update();
                this.setListProp(this.m_objectClasses, PR_OBJECT_CLASS[0]);
                return;
            }
        }
        int n3 = 0;
        while (n3 < PR_OBJECT_CLASS.length) {
            if (PR_OBJECT_CLASS[n3] == n) {
                this.update((String[])object);
                return;
            }
            ++n3;
        }
        super.setProp(n, object);
    }

    public Object[] getAttributes() {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        Object[] objectArray2;
        if (Root.debugSaveEntry) {
            this.setDebug(true);
            this.debugMessageLn("\nNewEntry.getAttributes(): Entered");
        }
        int[] nArray = this.getMustPropList();
        int[] nArray2 = this.getMayPropList();
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        int n4 = 0;
        int n5 = 0;
        try {
            if (nArray2 != null && nArray2.length != 0) {
                objectArray4 = this.getProps(nArray2);
            }
            if (nArray != null && nArray.length != 0) {
                objectArray3 = this.getProps(nArray);
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            this.debugMessageLn("NewEntry.getAttributes(): Returned");
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n6 = 0;
        while (n6 < 2) {
            objectArray2 = n6 == 0 ? objectArray4 : objectArray3;
            int[] nArray3 = objectArray = n6 == 0 ? nArray2 : nArray;
            if (objectArray2 != null && objectArray2.length != 0) {
                int n7 = 0;
                while (n7 < objectArray2.length) {
                    if (objectArray2[n7] != null) {
                        n3 = 0;
                        n2 = 0;
                        while (n2 < vector.size()) {
                            n = (Integer)vector.elementAt(n2);
                            if (n == objectArray[n7]) {
                                n3 = 1;
                                break;
                            }
                            ++n2;
                        }
                        if (n3 == 0) {
                            ++n4;
                            vector.addElement(new Integer(objectArray[n7]));
                        }
                    }
                    ++n7;
                }
            }
            ++n6;
        }
        if (n4 == 0) {
            return null;
        }
        objectArray2 = this.m_parent.m_serverAccess.createAttributeArray(n4);
        vector = new Vector();
        n6 = 0;
        while (n6 < 2) {
            objectArray = n6 == 0 ? objectArray4 : objectArray3;
            int[] nArray4 = n6 == 0 ? nArray2 : nArray;
            n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] != null) {
                    n2 = nArray4[n3];
                    n = 0;
                    int n8 = 0;
                    while (n8 < vector.size()) {
                        int n9 = (Integer)vector.elementAt(n8);
                        if (n9 == n2) {
                            n = 1;
                            break;
                        }
                        ++n8;
                    }
                    if (n == 0) {
                        Object object;
                        Object object2;
                        vector.addElement(new Integer(n2));
                        String string = super.getPropName(n2);
                        if (string == null) {
                            System.out.println("didn't get attr for propid=" + n2);
                            this.debugMessageLn("NewEntry.getAttributes(): Returned\n");
                            return null;
                        }
                        if (this.isDebug()) {
                            this.debugMessageLn("attr='" + string + "' m=" + n5);
                        }
                        boolean bl = false;
                        int n10 = 0;
                        while (n10 < PR_OBJECT_CLASS.length) {
                            if (PR_OBJECT_CLASS[n10] == n2) {
                                object2 = AdminProp.objectArrayToVector(this.m_objectClassNames);
                                this.addSuperClasses((Vector)object2);
                                object = AdminProp.vectorToStringArray((Vector)object2);
                                objectArray2[n5++] = this.m_parent.m_serverAccess.createAttribute(string, (String[])object);
                                if (this.isDebug()) {
                                    int n11 = 0;
                                    while (n11 < ((Object)object).length) {
                                        this.debugMessageLn("val[" + n11 + "]='" + (String)object[n11] + "'");
                                        ++n11;
                                    }
                                }
                                bl = true;
                                break;
                            }
                            ++n10;
                        }
                        if (!bl) {
                            if (AdminProp.isPropArray(n2)) {
                                object2 = (String[])objectArray[n3];
                                if (this.isDebug()) {
                                    int n12 = 0;
                                    while (n12 < ((int)object2).length) {
                                        this.debugMessageLn("val[" + n12 + "]='" + (String)object2[n12] + "'");
                                        ++n12;
                                    }
                                }
                                objectArray2[n5++] = this.m_parent.m_serverAccess.createAttribute(string, (String[])object2);
                            } else {
                                object2 = objectArray[n3];
                                object = this.m_parent.getAttributeByPropId(new Integer(n2));
                                if (object != null && ((Attribute)object).hasJpegSyntax() && object2 instanceof JpegAttr) {
                                    if (this.isDebug()) {
                                        this.debugMessageLn("adding value is image byte data");
                                    }
                                    try {
                                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)((AdminProp)object2).getProp(1114269);
                                        objectArray2[n5++] = this.m_parent.m_serverAccess.createAttribute(string, byteArrayOutputStream);
                                    }
                                    catch (PropertyException propertyException) {
                                        this.unexpectedException(propertyException);
                                    }
                                } else {
                                    if (this.isDebug()) {
                                        this.debugMessageLn(" val='" + object2 + "'");
                                    }
                                    objectArray2[n5++] = this.m_parent.m_serverAccess.createAttribute(string, (String)object2);
                                }
                            }
                        }
                    }
                }
                ++n3;
            }
            ++n6;
        }
        if (Root.debugSaveEntry) {
            this.debugMessageLn("NewEntry.getAttributes(): Returned\n");
            this.setDebug(false);
        }
        return objectArray2;
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (!Root.isClientCommandLine()) {
            this.setListProp(this.m_objectClasses, PR_OBJECT_CLASS[0]);
        }
        this.validate();
        if (!this.m_parent.addEntry(this)) {
            throw new SaveChangeException(this.m_parent.getErrorMessage());
        }
        if (this.m_parent.getDirectory() != null) {
            this.m_parent.getDirectory().addNewChild(this);
        }
    }

    public boolean validate() throws SaveChangeException {
        if (this.m_objectClassNames == null || this.m_objectClassNames.length == 0) {
            throw new SaveChangeException(LDAPLang.getStrNoObjectClass());
        }
        this.validateDn();
        int[] nArray = this.getMustPropList();
        if (nArray != null && nArray.length != 0) {
            Object[] objectArray = null;
            try {
                objectArray = this.getProps(nArray);
            }
            catch (PropertyException propertyException) {
                throw new SaveChangeException(propertyException.getMessage());
            }
            if (objectArray == null || objectArray.length == 0) {
                throw new SaveChangeException(LDAPLang.getStrCouldnotGetManProps());
            }
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    throw new SaveChangeException(LDAPLang.getStrMustSetAllManProps());
                }
                ++n;
            }
        } else {
            int[] nArray2 = this.getMayPropList();
            if (nArray2 != null && nArray2.length != 0) {
                Object[] objectArray = null;
                try {
                    objectArray = this.getProps(nArray2);
                }
                catch (PropertyException propertyException) {
                    throw new SaveChangeException(propertyException.getMessage());
                }
                if (objectArray == null || objectArray.length == 0) {
                    throw new SaveChangeException(LDAPLang.getStrCouldnotGetOptProps());
                }
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) break;
                    ++n;
                }
                if (n == objectArray.length) {
                    throw new SaveChangeException(LDAPLang.getStrMustSetSomeProps());
                }
            } else {
                throw new SaveChangeException(LDAPLang.getStrMustSetAllManProps());
            }
        }
        return true;
    }

    public void validateDn() throws SaveChangeException {
        if (DEBUG) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.debugMessageLn("NewEntry.validateDn: entered dn=" + this.m_dn);
        }
        new StringBuffer();
        if (this.m_dn != null) {
            this.m_dn = this.m_dn.trim();
        }
        if (this.m_dn == null || this.m_dn.length() == 0) {
            throw new SaveChangeException(LDAPLang.getStrNoBaseDn());
        }
    }

    public String getPropName(int n) {
        String string = super.getPropName(n);
        String string2 = this.m_adminNames.getPropName(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public String getName() {
        return this.m_dn;
    }

    public void sortPropertiesByName(int[] nArray) {
        Object[] objectArray = this.getPropNames(nArray);
        Object[] objectArray2 = new Integer[nArray.length];
        try {
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = new Integer(nArray[n]);
                ++n;
            }
            AdminSort.qsort(objectArray, objectArray2, false);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                nArray[n2] = (Integer)objectArray2[n2];
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case 6: {
                    if (this.m_objectClassSelector == null) {
                        if (this.m_subSchema == null || this.m_subSchema.countChildren() == 0) {
                            PropertyException propertyException = new PropertyException(LDAPLang.getStrErrInsufficientAccessRights());
                            propertyException.setReminder();
                            throw propertyException;
                        }
                        this.m_objectClassSelector = new TableSelector(this, this.m_subSchema.getObjectClasses(), 272642055, LDAPLang.getStrObjclassSelector(), null, null);
                    }
                    return this.m_objectClassSelector;
                }
                case 7: {
                    this.m_objectClasses.removeChildren(iAdminProp);
                    this.setListProp(this.m_objectClasses, PR_OBJECT_CLASS[0]);
                    break;
                }
                case 8: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    return iAdminPropArray[0];
                }
                default: {
                    return null;
                }
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public void setListProp(AdminList adminList, int n) throws SaveChangeException {
        try {
            int n2 = adminList.countChildren();
            if (n2 != 0) {
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = (String)((IAdminProp)adminList.nthChild(n3)).getProp(0x103000);
                    ++n3;
                }
                this.setProp(n, (Object)stringArray);
                return;
            }
            this.setProp(n, (Object)new String[0]);
            return;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
    }

    public Object[] getEntryLOV(int[] nArray, Object[] objectArray) {
        if (this.m_parent == null || nArray == null || nArray.length == 0) {
            return null;
        }
        if (objectArray == null || objectArray.length != nArray.length) {
            objectArray = new Object[nArray.length];
        }
        int n = 0;
        while (n < nArray.length) {
            if (!AdminProp.isPropReadonly(nArray[n])) {
                String string = super.getPropName(nArray[n]);
                Attribute attribute = this.m_parent.findAttributeType(0x103000, string);
                if (attribute != null && attribute.isDNValued()) {
                    if (this.m_lookupDir == null) {
                        this.m_lookupDir = new EntrySelector(this.m_parent);
                        try {
                            this.m_lookupDir.setProp(2163785, (Object)new Integer(1));
                        }
                        catch (Exception exception) {
                            this.unexpectedException(exception);
                        }
                    }
                    objectArray[n] = this.m_lookupDir;
                } else if (attribute != null && attribute.hasJpegSyntax()) {
                    if (this.m_lookupImage == null) {
                        this.m_lookupImage = new ImageSelector();
                        try {
                            this.m_lookupImage.setProp(2163785, (Object)new Integer(1));
                        }
                        catch (Exception exception) {
                            this.unexpectedException(exception);
                        }
                    }
                    objectArray[n] = this.m_lookupImage;
                }
            }
            ++n;
        }
        return objectArray;
    }

    static {
        PR_OBJECT_CLASS = new int[1];
    }
}

