/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.ACPOptions;
import oracle.ldap.admin.ConfigEntryMgmt;
import oracle.ldap.admin.ConfigFile;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.ServerList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Options
extends AdminProp {
    public ACPOptions m_acpoptions;
    public ConfigEntryMgmt m_cfgmgmt;
    Root m_parent;
    Server m_server;
    ServerList m_serverList;
    ConfigFile m_file;
    String server;
    int port = 389;

    public Options(Root root, ServerList serverList) {
        this.m_parent = root;
        this.m_serverList = serverList;
        this.m_file = serverList.getCfgFile();
        this.server = this.m_parent.getHost();
        this.port = this.m_parent.getPort();
        this.m_server = this.m_serverList.getCurrentServer(this.server, this.port);
    }

    public Root getRoot() {
        return this.m_parent;
    }

    public void initProps() throws PropertyException {
        this.setProp(3080204, 16);
    }

    public void saveChanges(int n) throws SaveChangeException {
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                return LDAPLang.getStrUserPrefTitle();
            }
            case 0x110001: {
                return null;
            }
            case 2032706: {
                return null;
            }
            case 3080204: {
                return new Integer(4096);
            }
            case 2162846: {
                return new Integer(9);
            }
            case 272695330: {
                if (this.m_acpoptions == null) {
                    this.m_acpoptions = new ACPOptions(this.m_server, this);
                }
                if (this.m_cfgmgmt == null) {
                    this.m_cfgmgmt = new ConfigEntryMgmt(this, this.m_server);
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_cfgmgmt, this.m_acpoptions};
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    public ConfigFile getCfgFile() {
        return this.m_file;
    }
}

