/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.AgreementDNs;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.ProcDebugFlags;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.IAdminPropGridView;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ProcBase
extends Entry {
    static String STR_PASSWORDS;
    static String STR_GENERAL;
    static String STR_DEBUG_FLAGS;
    static String STR_SSL_SETTINGS;
    static String STR_AGREEMENTS;
    static String STR_AGREEMENT;
    static final String STR_PASSWORDS_HTOPIC = "configset_general";
    static final String STR_GENERAL_HTOPIC = "configset_general";
    static final String STR_REPL_GENERAL_HTOPIC = "replication_configset_general";
    static final String STR_DEBUG_FLAGS_HTOPIC = "debug_flags";
    static final String STR_REPL_DEBUG_FLAGS_HTOPIC = "replication_debug_flags";
    static final String STR_SSL_SETTINGS_HTOPIC = "ssl_settings";
    static final String STR_AGREEMENTS_HTOPIC = "replication_agreement";
    static final String STR_AGREEMENT_HTOPIC = "replication_agreement";
    static String STR_PASSWORDS_HFILE;
    static String STR_GENERAL_HFILE;
    static String STR_DEBUG_FLAGS_HFILE;
    static String STR_SSL_SETTINGS_HFILE;
    static String STR_AGREEMENTS_HFILE;
    static String STR_AGREEMENT_HFILE;
    String m_displayName;
    int m_baseNum;
    String[] m_objectClassNames;
    Object[] m_attrs;
    AgreementDNs m_agreementDNs;
    int m_csNum;
    AdminList m_holder;
    boolean m_bValid;
    boolean debug;
    ProcDebugFlags m_debugFlags;
    int m_debugFlagsId;
    int m_sslEnableId;
    int[] m_sslEnableList;
    int m_sslWalletConfirmPasswdId;
    int m_debugFlagsPropId;
    Object m_sslEnableValue;
    Vector m_addedAttributes = new Vector();
    Vector m_confirmPasswords = new Vector();

    public ProcBase() {
    }

    public ProcBase(Root root, String string, String string2, Object[] objectArray) {
        super(root, null, string, objectArray, false);
        this.m_attrs = objectArray;
        try {
            this.m_baseNum = this.parseBaseNum(string2);
        }
        catch (Exception exception) {
            this.m_baseNum = 0;
        }
        this.m_bValid = true;
        this.debug = Root.debugConfMgmt;
        if (this.debug) {
            this.setDebug(true);
        }
        this.m_bInitializing = true;
        try {
            this.parseAttributes();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_bInitializing = false;
            throw throwable;
        }
        Object var6_5 = null;
        this.m_bInitializing = false;
    }

    public void registerMessages() {
        super.registerMessages();
        if (STR_PASSWORDS == null) {
            STR_PASSWORDS = LDAPLang.getStrPasswords();
            STR_GENERAL = LDAPLang.getStrGeneral();
            STR_SSL_SETTINGS = LDAPLang.getStrSslSettings();
            STR_DEBUG_FLAGS = LDAPLang.getStrDebugFlags();
            STR_AGREEMENTS = LDAPLang.getStrGroupLabel();
            STR_AGREEMENT = LDAPLang.getStrAgreement();
        }
    }

    public String[] getSampleObjectClasses() {
        return this.m_objectClassNames;
    }

    public void setHolder(AdminList adminList) {
        this.m_holder = adminList;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "browsing_configuration_sets";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return this.m_displayName;
            }
            case 1638408: {
                return "images/msprpms.gif";
            }
            case 273613313: {
                IAdminProp[] iAdminPropArray = new IAdminProp[1];
                int n2 = 0;
                iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -9, "Delete", "Delete", "images/delete.gif");
                iAdminPropArray[n2 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete1());
                return iAdminPropArray;
            }
            case 0x10110440: {
                String[] stringArray = new String[]{STR_GENERAL, STR_DEBUG_FLAGS, STR_SSL_SETTINGS, STR_AGREEMENTS, STR_AGREEMENT};
                return stringArray;
            }
            case 269550752: {
                String[] stringArray = new String[]{"configset_general", STR_DEBUG_FLAGS_HTOPIC, STR_SSL_SETTINGS_HTOPIC, "replication_agreement", "replication_agreement"};
                return stringArray;
            }
            case 269550753: {
                String[] stringArray = new String[]{STR_GENERAL_HFILE, STR_DEBUG_FLAGS_HFILE, STR_SSL_SETTINGS_HFILE, STR_AGREEMENTS_HFILE, STR_AGREEMENT_HFILE};
                return stringArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (n == 2163220 || n == 2163740) {
            if (this.m_debugFlags != null) {
                this.m_debugFlags.editorCancel(true);
            }
            if (this.m_sslEnableId != 0) {
                super.setProp(this.m_sslEnableId, this.m_sslEnableValue);
                if (n == 2163740) {
                    this.sendAdminPropertyChangeEvents(this.m_sslEnableId, null);
                }
            }
        }
        if (this.m_sslEnableId == n) {
            if (object instanceof Boolean) {
                object = (Boolean)object != false ? "1" : "0";
            } else if (object instanceof String) {
                String string = ((String)object).toLowerCase();
                if (string.startsWith("t") || string.startsWith("y")) {
                    object = "1";
                } else if (string.startsWith("f") || string.startsWith("n")) {
                    object = "0";
                }
            }
        }
        super.setProp(n, object);
        if (n == this.m_sslEnableId) {
            this.updateEnabledProperties();
        }
    }

    public void updateEnabledProperties() throws PropertyException {
        if (this.m_sslEnableList == null) {
            return;
        }
        Object object = this.getProp(this.m_sslEnableId);
        if (object == null || object.equals("0")) {
            int n = 0;
            while (n < this.m_sslEnableList.length) {
                this.setPropertyDisabled(this.m_sslEnableList[n], true, n + 1 == this.m_sslEnableList.length);
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.m_sslEnableList.length) {
            this.setPropertyDisabled(this.m_sslEnableList[n], false, n + 1 == this.m_sslEnableList.length);
            ++n;
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case -9: {
                    this.delete();
                    ((ProcConfSets)this.m_holder).update();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public void delete() throws PropertyException {
        super.delete();
        if (this.m_holder != null) {
            this.m_holder.removeChild(this);
            this.m_holder.update();
        }
    }

    public Object[] getMods() {
        int n = this.m_addedAttributes.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_mods.removeElement(this.m_addedAttributes.elementAt(n2));
            ++n2;
        }
        return super.getMods();
    }

    public void registerTabPages(String string, int n) throws PropertyException {
        if (string.equalsIgnoreCase("orclReplBindDn")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            return;
        }
        if (string.equalsIgnoreCase("orclditroot")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orcldebuglevel")) {
            this.setPropTabPages(n, STR_DEBUG_FLAGS);
            this.setPropertyDisabled(n, true, false);
            return;
        }
        if (string.equalsIgnoreCase("orclmaxcc")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orcldbtype")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclReplBindPassword")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            string = "orclReplBindConfirmPassword";
            Integer n2 = this.m_parent.getAttrPropId("orclReplBindConfirmPassword");
            this.m_confirmPasswords.addElement(new Integer(n));
            this.m_confirmPasswords.addElement(n2);
            this.m_addedAttributes.addElement(n2);
            int n3 = n2;
            this.registerPropOnTabPage(n3, string, string, STR_PASSWORDS);
            this.setProp(n3, this.getProp(n));
            return;
        }
        if (string.equalsIgnoreCase("orclReplicationProtocol")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclSizeLimit")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclPrName")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            return;
        }
        if (string.equalsIgnoreCase("orclPrPassword")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            string = "orclPrConfirmPassword";
            Integer n4 = this.m_parent.getAttrPropId("orclPrConfirmPassword");
            this.m_confirmPasswords.addElement(new Integer(n));
            this.m_confirmPasswords.addElement(n4);
            this.m_addedAttributes.addElement(n4);
            int n5 = n4;
            this.registerPropOnTabPage(n5, string, string, STR_PASSWORDS);
            this.setProp(n5, this.getProp(n));
            return;
        }
        if (string.equalsIgnoreCase("orclGuName")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            return;
        }
        if (string.equalsIgnoreCase("orclGuPassword")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            string = "orclGuConfirmPassword";
            Integer n6 = this.m_parent.getAttrPropId("orclGuConfirmPassword");
            this.m_confirmPasswords.addElement(new Integer(n));
            this.m_confirmPasswords.addElement(n6);
            this.m_addedAttributes.addElement(n6);
            int n7 = n6;
            this.registerPropOnTabPage(n7, string, string, STR_PASSWORDS);
            this.setProp(n7, this.getProp(n));
            return;
        }
        if (string.equalsIgnoreCase("orclSuName")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            return;
        }
        if (string.equalsIgnoreCase("orclSuPassword")) {
            this.setPropTabPages(n, STR_PASSWORDS);
            string = "orclSuConfirmPassword";
            Integer n8 = this.m_parent.getAttrPropId("orclSuConfirmPassword");
            this.m_confirmPasswords.addElement(new Integer(n));
            this.m_confirmPasswords.addElement(n8);
            this.m_addedAttributes.addElement(n8);
            int n9 = n8;
            this.registerPropOnTabPage(n9, string, string, STR_PASSWORDS);
            this.setProp(n9, this.getProp(n));
            return;
        }
        if (string.equalsIgnoreCase("orclSuffix")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclSupplierReference")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclUpdateSchedule")) {
            this.setPropTabPages(n, STR_GENERAL);
            this.registerPropUnits(n, IAdminPropGridView.PU_MINUTES);
            return;
        }
        if (string.equalsIgnoreCase("orclconfigsetnumber")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclhostname")) {
            this.setPropTabPages(n, STR_GENERAL);
            return;
        }
        if (string.equalsIgnoreCase("orclsslAuthentication")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclsslEnable")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclsslPort")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclsslVersion")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclsslWalletPasswd")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclsslWalletURL")) {
            this.setPropTabPages(n, STR_SSL_SETTINGS);
            return;
        }
        if (string.equalsIgnoreCase("orclPurgeSchedule")) {
            this.registerPropUnits(n, IAdminPropGridView.PU_MINUTES);
            return;
        }
        if (string.equalsIgnoreCase("orclmetaconnconfigrefreshflag")) {
            this.setPropTabPages(n, STR_GENERAL);
        }
    }

    public int parseAttributes(String string, String[] stringArray, int n, int[] nArray, int n2) {
        if (this.debug) {
            this.debugMessageLn("vals.length=" + stringArray.length);
        }
        if (string.toLowerCase().startsWith("orclssl") && !string.equalsIgnoreCase("orclsslenable")) {
            nArray[n2++] = n;
        }
        if (!AdminProp.isPropArray(n)) {
            if (this.debug) {
                this.debugMessageLn("property id is not for array value");
            }
            try {
                if (string.equalsIgnoreCase("Orclconfigsetnumber")) {
                    this.m_csNum = new Integer(stringArray[0]);
                }
                if (string.equalsIgnoreCase("orcldebuglevel")) {
                    int n3 = AdminProp.getPropNumber(n) | 0x400000;
                    this.registerPropOnTabPage(n3, STR_DEBUG_FLAGS, STR_DEBUG_FLAGS, STR_DEBUG_FLAGS);
                    this.m_debugFlagsPropId = n3;
                    int n4 = 0;
                    try {
                        n4 = new Integer(stringArray[0]);
                    }
                    catch (Exception exception) {}
                    this.m_debugFlagsId = n;
                    this.m_debugFlags = new ProcDebugFlags(this, n, n4, this.isReadonly());
                    this.setProp(n3, (Object)this.m_debugFlags);
                    if (this.m_agreementDNs != null) {
                        this.m_debugFlags.setReplOwner(true);
                    }
                    this.setPropertyLabelHidden(n3, true, false);
                }
                if (string.equalsIgnoreCase("orclsslenable")) {
                    this.m_sslEnableId = n;
                    this.registerPropRange(n, 0, 1);
                    this.setPropertyUpdatedSync(n, true, false);
                    this.setPropertyGroupTitle(n, true, false);
                } else if (string.equalsIgnoreCase("orclsslauthentication")) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("1", LDAPLang.getStrNoSslAuth());
                    hashtable.put("32", LDAPLang.getStrNoSslServer());
                    hashtable.put("64", LDAPLang.getStrNoSslClientServer());
                    this.registerPropListOfValues(n, hashtable);
                    String string2 = "";
                    if (stringArray.length == 1) {
                        string2 = stringArray[0].trim();
                    }
                    if (!(string2.equals("1") || string2.equals("32") || string2.equals("64"))) {
                        String[] stringArray2 = new String[]{"1"};
                        stringArray = stringArray2;
                    }
                }
                if (stringArray.length == 1) {
                    if (this.debug) {
                        this.debugMessageLn("val='" + this.adaptString(stringArray[0]) + "'");
                    }
                    this.registerProp(n, this.adaptString(string), string);
                    this.setProp(n, (Object)this.adaptString(stringArray[0]));
                } else if (stringArray.length != 0) {
                    if (this.debug) {
                        this.debugMessageLn("value is multivalued! inconsistent w/ propId");
                    }
                    if (this.debug) {
                        this.debugMessageLn("val='" + this.adaptString(stringArray[0]) + "'");
                    }
                    this.registerProp(n, this.adaptString(string), string);
                    this.setProp(n, (Object)this.adaptString(stringArray[stringArray.length - 1]));
                }
                this.registerTabPages(string, n);
                if (string.equalsIgnoreCase("orclsslenable")) {
                    this.m_sslEnableValue = this.getProp(this.m_sslEnableId);
                }
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
        } else {
            if (this.debug) {
                this.debugMessageLn("property id is for array value");
            }
            try {
                String[] stringArray3 = new String[stringArray.length];
                int n5 = 0;
                while (n5 < stringArray.length) {
                    if (this.debug) {
                        this.debugMessageLn("\tval[" + n5 + "]='" + this.adaptString(stringArray[n5]) + "'");
                    }
                    stringArray3[n5] = this.adaptString(stringArray[n5]);
                    ++n5;
                }
                if (string.equalsIgnoreCase("cn")) {
                    return n2;
                }
                if (string.equalsIgnoreCase("objectClass")) {
                    this.m_objectClassNames = stringArray3;
                    return n2;
                }
                if (string.equalsIgnoreCase("orclDirReplGroupAgreement")) {
                    this.addAgreementDNs(stringArray3);
                    return n2;
                }
                this.registerProp(n, string, string);
                this.setProp(n, (Object)stringArray3);
                this.registerTabPages(string, n);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
        }
        return n2;
    }

    public Object[] getAttributes() {
        return this.m_attrs;
    }

    public void parseAttributes() {
        int n;
        int[] nArray;
        block29: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            Vector<String[]> vector = new Vector<String[]>();
            Object[] objectArray = this.m_attrs;
            nArray = new int[40];
            n = 0;
            if (this.debug) {
                this.debugMessageLn("parseAttributes() start...");
            }
            if (objectArray != null) {
                n2 = 0;
                while (n2 < objectArray.length) {
                    object4 = this.m_parent.m_serverAccess.getType(objectArray[n2]);
                    if (Character.isDigit(((String)object4).charAt(0))) {
                        if (this.debug) {
                            this.debugMessageLn("looking attribute by oid");
                        }
                        if ((object3 = this.m_parent.findAttributeType(0x103013, object4)) != null) {
                            if (this.debug) {
                                this.debugMessageLn("got attribute");
                            }
                            try {
                                object2 = ((SchemaObject)object3).getName();
                                if (object2 != null) {
                                    if (this.debug) {
                                        this.debugMessageLn("translated type=" + (String)object4 + "to name=" + (String)object2);
                                    }
                                    object4 = object2;
                                }
                            }
                            catch (PropertyException propertyException) {
                                this.unexpectedException(propertyException);
                            }
                        }
                    }
                    if (this.debug) {
                        this.debugMessageLn("type='" + (String)object4 + "'");
                    }
                    object2 = this.m_parent.getAttrPropId(object4);
                    int n3 = (Integer)object2;
                    if (this.debug) {
                        this.debugMessageLn("iPropId=" + n3);
                    }
                    vector.addElement((String[])object2);
                    String[] stringArray = this.m_parent.m_serverAccess.getValues(objectArray[n2]);
                    n = this.parseAttributes((String)object4, stringArray, n3, nArray, n);
                    if ((((String)object4).equalsIgnoreCase("modifytimestamp") || ((String)object4).equalsIgnoreCase("createtimestamp")) && stringArray.length == 1 && stringArray[0] != null) {
                        object = AdminProp.parseDate(stringArray[0]);
                        try {
                            this.setProp(n3, object);
                        }
                        catch (PropertyException propertyException) {
                            this.unexpectedException(propertyException);
                        }
                    }
                    ++n2;
                }
            }
            try {
                if (this.m_objectClassNames == null) break block29;
                n2 = 0;
                while (n2 < this.m_objectClassNames.length) {
                    object3 = this.m_objectClassNames[n2];
                    if (((String)object3).equalsIgnoreCase("orclreplsubconfig") || ((String)object3).equalsIgnoreCase("orclldapsubconfig")) {
                        object4 = this.getRoot().findObjectClass(0x103000, object3);
                        if (object4 != null && (object2 = (String[])((ObjectClass)object4).getProp(269496331)) != null) {
                            String[] stringArray = new String[]{""};
                            int n4 = 0;
                            while (n4 < ((String[])object2).length) {
                                object = this.m_parent.getAttrPropId(object2[n4]);
                                if (!vector.contains(object)) {
                                    int n5 = (Integer)object;
                                    n = this.parseAttributes((String)object2[n4], stringArray, n5, nArray, n);
                                }
                                ++n4;
                            }
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
        }
        if (n != 0 && this.m_sslWalletConfirmPasswdId != 0) {
            nArray[n++] = this.m_sslWalletConfirmPasswdId;
        }
        this.m_sslEnableList = new int[n];
        int n6 = 0;
        while (n6 < n) {
            this.m_sslEnableList[n6] = nArray[n6];
            ++n6;
        }
        try {
            if (this.m_sslEnableId != 0) {
                this.updateEnabledProperties();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debug) {
            this.debugMessageLn("Done");
        }
    }

    public int getBaseNum() {
        return this.m_baseNum;
    }

    public void setBaseNum(int n) {
        this.m_baseNum = n;
    }

    int parseBaseNum(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = n = string.length();
        while (n2 > 0) {
            char c = string.charAt(n2 - 1);
            if (c < '0' || c > '9') break;
            --n2;
        }
        return new Integer(string.substring(n2, n));
    }

    void addAgreementDNs(String[] stringArray) {
        if (this.m_agreementDNs == null) {
            this.m_agreementDNs = new AgreementDNs(this.m_parent, stringArray, null);
            if (this.m_debugFlags != null) {
                this.m_debugFlags.setReplOwner(true);
            }
        }
    }

    public int getConfSetNum() {
        return this.m_csNum;
    }

    public String getBaseDN() {
        return this.getDn();
    }

    public void sortPropertiesByName(int[] nArray) {
    }

    public void saveChanges(int n) throws SaveChangeException {
        int n2 = this.m_confirmPasswords.size();
        StringBuffer stringBuffer = new StringBuffer("Passwords are not confirmed:\n");
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            Integer n4 = (Integer)this.m_confirmPasswords.elementAt(n3);
            Integer n5 = (Integer)this.m_confirmPasswords.elementAt(n3 + 1);
            if (n4 != null && n5 != null) {
                try {
                    String string = (String)this.getProp(n4);
                    String string2 = (String)this.getProp(n5);
                    if (string == null != (string2 == null) || string != null && !string.equals(string2)) {
                        stringBuffer.append(this.getPropName(n4));
                        stringBuffer.append("\n");
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    throw new SaveChangeException(exception);
                }
            }
            n3 += 2;
        }
        if (bl) {
            throw new SaveChangeException(stringBuffer.toString());
        }
        super.saveChanges(n);
        if (this.m_debugFlags != null) {
            this.m_debugFlags.updateBackup();
        }
        try {
            if (this.m_sslEnableId != 0) {
                this.m_sslEnableValue = this.getProp(this.m_sslEnableId);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isReadonly() {
        return false;
    }

    public boolean alwaysUseDisplayName() {
        return true;
    }

    static {
        STR_PASSWORDS_HFILE = RootList.getHelpBaseFileName();
        STR_GENERAL_HFILE = RootList.getHelpBaseFileName();
        STR_DEBUG_FLAGS_HFILE = RootList.getHelpBaseFileName();
        STR_SSL_SETTINGS_HFILE = RootList.getHelpBaseFileName();
        STR_AGREEMENTS_HFILE = RootList.getHelpBaseFileName();
        STR_AGREEMENT_HFILE = RootList.getHelpBaseFileName();
    }
}

