/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.ACPAttrList;
import oracle.ldap.admin.ACPStructList;
import oracle.ldap.admin.AttrAccessItem;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ProcBase;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminPropGridView;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ProcConnector
extends ProcBase {
    static final int PR_CONN_NAME = 1454336;
    static String STR_LOCAL_DIRECTORY;
    static String STR_AGENT;
    static String STR_MAPPING;
    static String STR_RUNTIME;
    static final String STR_LOCAL_DIRECTORY_HTOPIC = "meta_local_directory";
    static final String STR_AGENT_HTOPIC = "meta_agent";
    static final String STR_MAPPING_HTOPIC = "meta_mapping";
    static final String STR_RUNTIME_HTOPIC = "meta_runtime";
    static final String STR_LOCAL_DIRECTORY_HFILE;
    static final String STR_AGENT_HFILE;
    static final String STR_MAPPING_HFILE;
    static final String STR_RUNTIME_HFILE;
    static final String UNREGISTER_DN = "dn";
    static final String SYNC_NAME_CTX = "orclmetaconnldapnamctx";
    static final String CKPT_TIME = "orclmetaconnlastckpttime";
    static Hashtable m_opModeLov;
    static Hashtable m_runnableLov;
    static Hashtable m_isextagentLov;
    static Hashtable m_extagentstatusLov;
    String m_connRDN;
    String m_displayMsg;
    boolean m_isBrandNew = false;
    ProcConfSets m_procConfSets;
    int m_ckptTimePropId;
    String[][] expectedAttrs = new String[][]{{"userpassword", "", "welcome"}, {"orclmetaconnrunnable", "M", "y"}, {"orclmetaconnbinddn", "M", ""}, {"orclmetaconnbindpasswd", "M", "welcome"}, {"orclmetaconnrunhost", "", ""}, {"orclmetaconnoprnmode", "", "IMPORT"}, {"orclmetaconnIpollintvl", "", "3600"}, {"orclmetaconnEpollintvl", "", "3600"}, {"orclmetaconnretrycount", "", "0"}, {"orclmetaconnerrorlogs", "", ""}, {"orclmetaconnlocaldatasrc", "", ""}, {"orclmetaconnlocalacctname", "", ""}, {"orclmetaconnlocalacctpass", "", ""}, {"orclmetaconnlocalappnamctx", "", ""}, {"orclmetaconncmdname", "", ""}, {"orclmetaconnimpcmdargfmt", "", ""}, {"orclmetaconnexpcmdargfmt", "", ""}, {"orclmetaconncfgfile", "", ""}, {"orclmetaconnagentoutfile", "", "/tmp/Oracle%s_%d.out"}, {"orclmetaconnagentinfile", "", "/tmp/Oracle%s_%d.in"}, {"orclmetaconnmapfile", "", ""}, {"orclmetaconnldapnamctx", "M", ""}, {"orcllastappliedchangenumber", "", "0"}, {"orclmetaconnlastckpttime", "M", "20000101000000"}, {"orclmetaconnname", "M", ""}, {"orclmetaconnIsExtAgent", "M", "n"}, {"orclmetaconnExtAgentStatus", "", "1"}};
    Entry m_syncNameContextEntry;

    public ProcConnector() {
    }

    public ProcConnector(Root root, String string, String string2, Object[] objectArray) {
        super(root, string, string2, objectArray);
        this.m_displayMsg = string2;
        this.init();
    }

    public ProcConnector(Root root, String string, String string2, Object[] objectArray, ProcConfSets procConfSets) {
        super(root, string, string2, objectArray);
        this.m_procConfSets = procConfSets;
        this.m_displayMsg = string2;
        this.init();
    }

    void init() {
        Object object;
        if (this.m_dn != null && this.m_dn.length() > 0) {
            object = null;
            object = this.m_dn.substring(0, this.m_dn.indexOf(","));
            this.m_connRDN = ((String)object).indexOf("+") > 0 ? ((String)object).substring(((String)object).indexOf("=") + 1, ((String)object).indexOf("+")) : ((String)object).substring(((String)object).indexOf("=") + 1);
            this.m_displayName = this.m_connRDN = this.m_connRDN.trim();
        }
        try {
            int n;
            this.registerProp(1454336, "orclmetaconnname", "");
            object = this.m_parent.getAttrPropId(UNREGISTER_DN);
            int n2 = (Integer)object;
            this.unregisterProp(n2);
            int n3 = 0;
            String[] stringArray = null;
            int[] nArray = (int[])this.getProp(282001422);
            if (nArray != null) {
                stringArray = new String[nArray.length];
                n3 = stringArray.length;
                n = 0;
                while (n < nArray.length) {
                    stringArray[n] = super.getPropNameNormal(nArray[n]);
                    ++n;
                }
            }
            n = 0;
            while (n < this.expectedAttrs.length) {
                boolean bl = false;
                int n4 = 0;
                while (n4 < n3) {
                    if (this.expectedAttrs[n][0].equalsIgnoreCase(stringArray[n4])) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    Integer n5 = this.m_parent.getAttrPropId(this.expectedAttrs[n][0]);
                    int n6 = n5;
                    this.registerProp(n6, this.expectedAttrs[n][0], this.expectedAttrs[n][0]);
                    this.registerTabPages(this.expectedAttrs[n][0], n6);
                    if (this.expectedAttrs[n][2].length() > 0) {
                        Object object2;
                        this.addSetAttrName(this.expectedAttrs[n][0]);
                        this.m_mods.addElement(n5);
                        this.m_addMods.put(n5, Boolean.TRUE);
                        if (!AdminProp.isPropArray(n6)) {
                            if (this.expectedAttrs[n][0].equalsIgnoreCase(CKPT_TIME)) {
                                object2 = AdminProp.parseCalendar(this.expectedAttrs[n][2]);
                                this.setProp(n6, object2);
                            } else {
                                this.setProp(n6, (Object)this.expectedAttrs[n][2]);
                            }
                        } else {
                            object2 = new String[]{this.expectedAttrs[n][2]};
                            this.setProp(n6, object2);
                        }
                    }
                }
                ++n;
            }
            return;
        }
        catch (PropertyException propertyException) {
            return;
        }
    }

    public String getDisplayMsg() {
        return this.m_displayMsg;
    }

    public void registerMessages() {
        super.registerMessages();
        if (STR_LOCAL_DIRECTORY == null) {
            STR_LOCAL_DIRECTORY = LDAPLang.getStrLocalDirectory();
            STR_AGENT = LDAPLang.getStrAgent();
            STR_MAPPING = LDAPLang.getStrMapping();
            STR_RUNTIME = LDAPLang.getStrRunTime();
        }
    }

    public void registerTabPages(String string, int n) throws PropertyException {
        if (string.equalsIgnoreCase("orclmetaconnname")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("userpassword")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
            this.setPropHidden(n, true);
        }
        if (string.equalsIgnoreCase("orclmetaconnrunnable")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
            if (m_runnableLov == null) {
                m_runnableLov = new Hashtable();
                m_runnableLov.put("y", LDAPLang.getStrTrue());
                m_runnableLov.put("n", LDAPLang.getStrFalse());
            }
            this.registerPropListOfValues(n, m_runnableLov);
        }
        if (string.equalsIgnoreCase("orclmetaconnbinddn")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("orclmetaconnbindpasswd")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("orclmetaconnrunhost")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("orclmetaconnoprnmode")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
            if (m_opModeLov == null) {
                m_opModeLov = new Hashtable();
                m_opModeLov.put("IMPORT", LDAPLang.getStrImport());
                m_opModeLov.put("EXPORT", LDAPLang.getStrExport());
            }
            this.registerPropListOfValues(n, m_opModeLov);
        }
        if (string.equalsIgnoreCase("orclmetaconnIpollintvl")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
            this.registerPropUnits(n, IAdminPropGridView.PU_SECONDS);
        }
        if (string.equalsIgnoreCase("orclmetaconnEpollintvl")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
            this.registerPropUnits(n, IAdminPropGridView.PU_SECONDS);
        }
        if (string.equalsIgnoreCase("orclmetaconnretrycount")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("orclmetaconnerrorlogs")) {
            this.setPropTabPages(n, ProcBase.STR_GENERAL);
        }
        if (string.equalsIgnoreCase("orclmetaconnlocaldatasrc")) {
            this.setPropTabPages(n, STR_LOCAL_DIRECTORY);
        }
        if (string.equalsIgnoreCase("orclmetaconnlocalacctname")) {
            this.setPropTabPages(n, STR_LOCAL_DIRECTORY);
        }
        if (string.equalsIgnoreCase("orclmetaconnlocalacctpass")) {
            this.setPropTabPages(n, STR_LOCAL_DIRECTORY);
        }
        if (string.equalsIgnoreCase("orclmetaconnlocalappnamctx")) {
            this.setPropTabPages(n, STR_LOCAL_DIRECTORY);
        }
        if (string.equalsIgnoreCase("orclmetaconncmdname")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconnimpcmdargfmt")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconnexpcmdargfmt")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconncfgfile")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconnagentoutfile")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconnagentinfile")) {
            this.setPropTabPages(n, STR_AGENT);
        }
        if (string.equalsIgnoreCase("orclmetaconnisextagent")) {
            this.setPropTabPages(n, STR_AGENT);
            if (m_isextagentLov == null) {
                m_isextagentLov = new Hashtable();
                m_isextagentLov.put("y", LDAPLang.getStrTrue());
                m_isextagentLov.put("n", LDAPLang.getStrFalse());
            }
            this.registerPropListOfValues(n, m_isextagentLov);
        }
        if (string.equalsIgnoreCase("orclmetaconnextagentstatus")) {
            this.setPropTabPages(n, STR_AGENT);
            if (m_extagentstatusLov == null) {
                m_extagentstatusLov = new Hashtable();
                m_extagentstatusLov.put("1", LDAPLang.getStrToBeExecuted());
                m_extagentstatusLov.put("2", LDAPLang.getStrExecutedOK());
                m_extagentstatusLov.put("3", LDAPLang.getStrExecutedError());
            }
            this.registerPropListOfValues(n, m_extagentstatusLov);
        }
        if (string.equalsIgnoreCase("orclmetaconnmapfile")) {
            this.setPropTabPages(n, STR_MAPPING);
        }
        if (string.equalsIgnoreCase(SYNC_NAME_CTX)) {
            EntrySelector entrySelector = new EntrySelector(this.m_parent);
            this.registerPropListOfValues(n, entrySelector);
            this.setPropTabPages(n, STR_MAPPING);
        }
        if (string.equalsIgnoreCase("orcllastappliedchangenumber")) {
            this.setPropTabPages(n, STR_RUNTIME);
        }
        if (string.equalsIgnoreCase(CKPT_TIME)) {
            this.setPropTabPages(n, STR_RUNTIME);
        }
    }

    public void parseAttributes() {
        super.parseAttributes();
        if (this.m_attrs != null) {
            int n = 0;
            while (n < this.m_attrs.length) {
                Object object;
                String string = this.m_parent.m_serverAccess.getType(this.m_attrs[n]);
                Integer n2 = this.m_parent.getAttrPropId(string);
                int n3 = n2;
                String[] stringArray = this.m_parent.m_serverAccess.getValues(this.m_attrs[n]);
                String string2 = null;
                if ((string.equalsIgnoreCase("modifytimestamp") || string.equalsIgnoreCase("createtimestamp")) && stringArray.length == 1 && stringArray[0] != null) {
                    object = AdminProp.parseDate(stringArray[0]);
                    try {
                        this.setProp(n3, object);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                }
                if (stringArray != null) {
                    if (string.equalsIgnoreCase("orclmetaconnoprnmode")) {
                        if (stringArray[0].equalsIgnoreCase("import") || stringArray[0].equalsIgnoreCase("export") || stringArray[0].equalsIgnoreCase("both")) {
                            string2 = stringArray[0].trim().toUpperCase();
                        }
                    } else if (string.equalsIgnoreCase("orclmetaconnrunnable") && (stringArray[0].equalsIgnoreCase("y") || stringArray[0].equalsIgnoreCase("n"))) {
                        string2 = stringArray[0].trim().toLowerCase();
                    }
                    try {
                        if (string2 != null) {
                            this.setProp(n3, string2);
                        }
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                    if (string.equalsIgnoreCase(CKPT_TIME)) {
                        this.m_ckptTimePropId = n3;
                        object = AdminProp.parseCalendar(stringArray[0].trim().toLowerCase());
                        try {
                            this.setProp(n3, object);
                        }
                        catch (PropertyException propertyException) {
                            this.unexpectedException(propertyException);
                        }
                    }
                } else if (string.equalsIgnoreCase(CKPT_TIME)) {
                    this.m_ckptTimePropId = n3;
                    object = AdminProp.parseCalendar("20000101000000");
                    try {
                        this.setProp(n3, object);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                }
                ++n;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1454336: {
                return this.m_connRDN;
            }
            case 2031768: {
                return LDAPLang.getStrConnector();
            }
            case 0x10110440: {
                String[] stringArray = (String[])super.getProp(n);
                String[] stringArray2 = new String[stringArray.length + 4];
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray2[n2] = stringArray[n2];
                    ++n2;
                }
                stringArray2[n2++] = STR_LOCAL_DIRECTORY;
                stringArray2[n2++] = STR_AGENT;
                stringArray2[n2++] = STR_MAPPING;
                stringArray2[n2++] = STR_RUNTIME;
                return stringArray2;
            }
            case 269550752: {
                String[] stringArray = (String[])super.getProp(n);
                String[] stringArray3 = new String[stringArray.length + 4];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray3[n3] = stringArray[n3];
                    ++n3;
                }
                stringArray3[n3++] = STR_LOCAL_DIRECTORY_HTOPIC;
                stringArray3[n3++] = STR_AGENT_HTOPIC;
                stringArray3[n3++] = STR_MAPPING_HTOPIC;
                stringArray3[n3++] = STR_RUNTIME_HTOPIC;
                return stringArray3;
            }
            case 269550753: {
                String[] stringArray = (String[])super.getProp(n);
                String[] stringArray4 = new String[stringArray.length + 4];
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringArray4[n4] = stringArray[n4];
                    ++n4;
                }
                stringArray4[n4++] = STR_LOCAL_DIRECTORY_HFILE;
                stringArray4[n4++] = STR_AGENT_HFILE;
                stringArray4[n4++] = STR_MAPPING_HFILE;
                stringArray4[n4++] = STR_RUNTIME_HFILE;
                return stringArray4;
            }
            case 273613313: {
                return null;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    boolean validate() throws PropertyException {
        int n = 0;
        while (n < this.expectedAttrs.length) {
            Integer n2;
            int n3;
            Object object;
            String string = this.expectedAttrs[n][0];
            boolean bl = this.expectedAttrs[n][1].equalsIgnoreCase("M");
            if (bl && (object = this.getProp(n3 = (n2 = this.m_parent.getAttrPropId(string)).intValue())) instanceof String && (object == null || ((String)object).length() == 0)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void updatePassword() throws PropertyException {
        Integer n = this.m_parent.getAttrPropId("orclmetaconnbindpasswd");
        int n2 = n;
        Object object = this.getProp(n2);
        if (!this.propertyIsModified(n2)) {
            return;
        }
        Integer n3 = this.m_parent.getAttrPropId("userpassword");
        int n4 = n3;
        if (object instanceof String) {
            this.setProp(n4, object);
        }
    }

    void addSyncNameCtx(Entry entry) {
        this.m_syncNameContextEntry = entry;
    }

    void updateSyncNameContext() throws PropertyException {
        try {
            int n;
            Integer n2 = this.m_parent.getAttrPropId(SYNC_NAME_CTX);
            int n3 = n2;
            if (!this.propertyIsModified(n3)) {
                return;
            }
            String string = (String)this.getProp(n3);
            this.m_parent.m_serverAccess.findObjectSync(string, null, this);
            int n4 = 0;
            while (this.m_syncNameContextEntry == null && n4++ < 5) {
                Thread.sleep(30L);
            }
            if (n4 >= 5) {
                throw new PropertyException(String.valueOf(LDAPLang.getStrNoSyncNameCtxEntry()) + ": " + string);
            }
            StructAccessItem structAccessItem = new StructAccessItem();
            structAccessItem.setUser("dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\"");
            structAccessItem.setAccessRights("(add,delete,browse)");
            AttrAccessItem attrAccessItem = new AttrAccessItem();
            structAccessItem.setUser("dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\"");
            structAccessItem.setAccessRights("(read,search,write,selfwrite,compare)");
            ACPStructList aCPStructList = this.m_syncNameContextEntry.getACPStructList();
            ACPAttrList aCPAttrList = this.m_syncNameContextEntry.getACPAttrList();
            boolean bl = true;
            boolean bl2 = false;
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (aCPStructList != null) {
                int n5 = 0;
                while (n5 < aCPStructList.countChildren()) {
                    if (((StructAccessItem)aCPStructList.nthChild(n5)).equals(structAccessItem)) {
                        bl = false;
                        break;
                    }
                    ++n5;
                }
            }
            if (bl) {
                if (aCPStructList != null) {
                    String[] stringArray3 = aCPStructList.toStrings();
                    stringArray = new String[stringArray3.length + 1];
                    n = 0;
                    while (n < stringArray3.length) {
                        stringArray[n] = stringArray3[n];
                        ++n;
                    }
                    stringArray[stringArray3.length] = "by dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\" (add,delete,browse)";
                } else {
                    stringArray = new String[]{"access to entry by dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\" (add,delete,browse)"};
                }
                bl2 = true;
            }
            bl = true;
            if (aCPAttrList != null) {
                int n6 = 0;
                while (n6 < aCPAttrList.countChildren()) {
                    if (((AttrAccessItem)aCPAttrList.nthChild(n6)).equals(attrAccessItem)) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
            }
            if (bl) {
                if (aCPAttrList != null) {
                    String[] stringArray4 = aCPAttrList.toStrings();
                    stringArray2 = new String[stringArray4.length + 1];
                    n = 0;
                    while (n < stringArray4.length) {
                        stringArray2[n] = stringArray4[n];
                        ++n;
                    }
                    stringArray2[stringArray4.length + 1] = "by dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\" (read,search,write,selfwrite,compare)";
                } else {
                    stringArray2 = new String[]{"access to attr=(*) by dn=\".*,cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory\" (read,search,write,selfwrite,compare)"};
                }
                bl2 = true;
            }
            if (bl2) {
                this.m_syncNameContextEntry.updateAccessInfo(stringArray, stringArray2, "orclACI", aCPStructList != null || aCPAttrList != null);
                Integer n7 = this.m_parent.getAttrPropId("orclACI");
                if (aCPStructList == null && aCPAttrList == null) {
                    this.m_addMods.put(n7, Boolean.TRUE);
                }
                if (!this.m_parent.saveEntry(this.m_syncNameContextEntry)) {
                    throw new PropertyException(this.m_parent.getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    boolean isExtAgentStatusUpdatedOnly() {
        Integer n;
        return this.m_mods.size() == 1 && this.m_mods.contains(n = this.m_parent.getAttrPropId("orclmetaconnextagentstatus"));
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            if (!this.validate()) {
                throw new SaveChangeException(LDAPLang.getStrMustSetAllManProps());
            }
            this.updatePassword();
            this.updateSyncNameContext();
            boolean bl = this.isExtAgentStatusUpdatedOnly();
            if (!this.m_parent.saveEntry(this)) {
                throw new SaveChangeException(this.m_parent.getErrorMessage());
            }
            if (this.m_mods.size() != 0) {
                this.m_mods = new Vector();
                this.m_addMods = new Hashtable();
                if (this.m_procConfSets != null && !bl) {
                    this.m_procConfSets.updateHolders(this.m_dn);
                    return;
                }
            }
        }
        catch (PropertyException propertyException) {
            throw new SaveChangeException(propertyException);
        }
    }

    static {
        STR_LOCAL_DIRECTORY_HFILE = RootList.getHelpBaseFileName();
        STR_AGENT_HFILE = RootList.getHelpBaseFileName();
        STR_MAPPING_HFILE = RootList.getHelpBaseFileName();
        STR_RUNTIME_HFILE = RootList.getHelpBaseFileName();
    }
}

