/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ProcDebugFlags
extends AdminProp {
    static final int PR_TRACE_FUNC_CALLS = 0x803000;
    static final int PR_PACKET_HANDLING = 8400897;
    static final int PR_HEAVY_TRACE_DEBUGGING = 8400898;
    static final int PR_CONNECTION_MANAGEMENT = 0x803003;
    static final int PR_PRINT_PACKETS = 8400900;
    static final int PR_SEARCH_FILTER = 8400901;
    static final int PR_CONFIG_FILE = 8400902;
    static final int PR_ACCESS_CONTROL = 8400903;
    static final int PR_STAT_LOG_CONNECT = 0x803008;
    static final int PR_STAT_LOG_ENTRY = 8400905;
    static final int PR_PRINT_COMM = 8400906;
    static final int PR_PRINT_ENTRY_PARSE = 8400907;
    static final int PR_SCHEMA = 8400908;
    static final int PR_PROCESS = 8400909;
    static final int PR_REPLICATION = 8400910;
    static final int PR_ALL = 8400911;
    static final int[] m_enableList = new int[]{0x803000, 8400897, 8400898, 0x803003, 8400900, 8400901, 8400902, 8400903, 0x803008, 8400905, 8400906, 8400907, 8400908, 8400909, 8400910};
    static final int[] m_replHideList = new int[]{8400897, 8400898, 0x803003, 8400900, 8400901, 8400902, 8400903, 0x803008, 8400905, 8400906, 8400907, 8400908, 8400909, 8400910};
    public Boolean m_trace_func_calls = Boolean.FALSE;
    public Boolean m_packet_handling = Boolean.FALSE;
    public Boolean m_heavy_trace_debugging = Boolean.FALSE;
    public Boolean m_connection_management = Boolean.FALSE;
    public Boolean m_print_packets = Boolean.FALSE;
    public Boolean m_search_filter = Boolean.FALSE;
    public Boolean m_config_file = Boolean.FALSE;
    public Boolean m_access_control = Boolean.FALSE;
    public Boolean m_stat_log_connect = Boolean.FALSE;
    public Boolean m_stat_log_entry = Boolean.FALSE;
    public Boolean m_print_comm = Boolean.FALSE;
    public Boolean m_print_entry_parse = Boolean.FALSE;
    public Boolean m_schema = Boolean.FALSE;
    public Boolean m_process = Boolean.FALSE;
    public Boolean m_replication = Boolean.FALSE;
    public Boolean m_all = Boolean.FALSE;
    Entry m_entry;
    int m_propId;
    boolean m_isReadonly;
    int m_backupFlags;
    public boolean m_replOwner = false;

    public ProcDebugFlags(Entry entry, int n, int n2, boolean bl) {
        this.m_entry = entry;
        this.m_propId = n;
        this.m_isReadonly = bl;
        this.m_backupFlags = n2;
        this.setupFlags(this.m_backupFlags);
    }

    public void setupFlags(int n) {
        this.m_trace_func_calls = Boolean.FALSE;
        this.m_packet_handling = Boolean.FALSE;
        this.m_heavy_trace_debugging = Boolean.FALSE;
        this.m_connection_management = Boolean.FALSE;
        this.m_print_packets = Boolean.FALSE;
        this.m_search_filter = Boolean.FALSE;
        this.m_config_file = Boolean.FALSE;
        this.m_access_control = Boolean.FALSE;
        this.m_stat_log_connect = Boolean.FALSE;
        this.m_stat_log_entry = Boolean.FALSE;
        this.m_print_comm = Boolean.FALSE;
        this.m_print_entry_parse = Boolean.FALSE;
        this.m_schema = Boolean.FALSE;
        this.m_process = Boolean.FALSE;
        this.m_replication = Boolean.FALSE;
        this.m_all = Boolean.FALSE;
        if ((n & 1) != 0) {
            this.m_trace_func_calls = Boolean.TRUE;
        }
        if ((n & 2) != 0) {
            this.m_packet_handling = Boolean.TRUE;
        }
        if ((n & 4) != 0) {
            this.m_heavy_trace_debugging = Boolean.TRUE;
        }
        if ((n & 8) != 0) {
            this.m_connection_management = Boolean.TRUE;
        }
        if ((n & 0x10) != 0) {
            this.m_print_packets = Boolean.TRUE;
        }
        if ((n & 0x20) != 0) {
            this.m_search_filter = Boolean.TRUE;
        }
        if ((n & 0x40) != 0) {
            this.m_config_file = Boolean.TRUE;
        }
        if ((n & 0x80) != 0) {
            this.m_access_control = Boolean.TRUE;
        }
        if ((n & 0x100) != 0) {
            this.m_stat_log_connect = Boolean.TRUE;
        }
        if ((n & 0x200) != 0) {
            this.m_stat_log_entry = Boolean.TRUE;
        }
        if ((n & 0x400) != 0) {
            this.m_print_comm = Boolean.TRUE;
        }
        if ((n & 0x800) != 0) {
            this.m_print_entry_parse = Boolean.TRUE;
        }
        if ((n & 0x1000) != 0) {
            this.m_schema = Boolean.TRUE;
        }
        if ((n & 0x2000) != 0) {
            this.m_process = Boolean.TRUE;
        }
        if ((n & 0x8000) != 0) {
            this.m_replication = Boolean.TRUE;
        }
        if (n == 65535) {
            this.m_all = Boolean.TRUE;
        }
        this.setEnabledProperties();
    }

    public void updateBackup() {
        this.m_backupFlags = this.getDebugFlags();
    }

    public void editorCancel(boolean bl) {
        this.setupFlags(this.m_backupFlags);
        if (bl) {
            try {
                this.sendAdminPropertyChangeEvents((int[])this.getProp(282001422), null);
            }
            catch (Exception exception) {}
            try {
                this.update();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void initProps() throws PropertyException {
        super.initProps();
        this.setProp(2687386, 2048);
    }

    public Object getProp(int n) throws PropertyException {
        if (n == 2686979 && this.m_isReadonly) {
            return new Integer(1);
        }
        if (n == 281609329 && this.isReplOwner()) {
            return m_replHideList;
        }
        return super.getProp(n);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerPropField(0x803000, LDAPLang.getStrTraceFuncCallsPlbl(), LDAPLang.getStrTraceFuncCallsPdsc(), "m_trace_func_calls");
        this.registerPropField(8400897, LDAPLang.getStrPacketHandlingPlbl(), LDAPLang.getStrPacketHandlingPdsc(), "m_packet_handling");
        this.registerPropField(8400898, LDAPLang.getStrHeavyTraceDebuggingPlbl(), LDAPLang.getStrHeavyTraceDebuggingPdsc(), "m_heavy_trace_debugging");
        this.registerPropField(0x803003, LDAPLang.getStrConnectionManagementPlbl(), LDAPLang.getStrConnectionManagementPdsc(), "m_connection_management");
        this.registerPropField(8400900, LDAPLang.getStrPrintPacketsPlbl(), LDAPLang.getStrPrintPacketsPdsc(), "m_print_packets");
        this.registerPropField(8400901, LDAPLang.getStrSearchFilterPlbl(), LDAPLang.getStrSearchFilterPdsc(), "m_search_filter");
        this.registerPropField(8400902, LDAPLang.getStrConfigFilePlbl(), LDAPLang.getStrConfigFilePdsc(), "m_config_file");
        this.registerPropField(8400903, LDAPLang.getStrAccessControlPlbl(), LDAPLang.getStrAccessControlPdsc(), "m_access_control");
        this.registerPropField(0x803008, LDAPLang.getStrStatLogConnectPlbl(), LDAPLang.getStrStatLogConnectPdsc(), "m_stat_log_connect");
        this.registerPropField(8400905, LDAPLang.getStrStatLogEntryPlbl(), LDAPLang.getStrStatLogEntryPdsc(), "m_stat_log_entry");
        this.registerPropField(8400906, LDAPLang.getStrPrintCommPlbl(), LDAPLang.getStrPrintCommPdsc(), "m_print_comm");
        this.registerPropField(8400907, LDAPLang.getStrPrintEntryParsePlbl(), LDAPLang.getStrPrintEntryParsePdsc(), "m_print_entry_parse");
        this.registerPropField(8400908, LDAPLang.getStrSchemaPlbl(), LDAPLang.getStrSchemaPdsc(), "m_schema");
        this.registerPropField(8400909, LDAPLang.getStrProcessThreadStatus(), LDAPLang.getStrProcessThreadStatus(), "m_process");
        this.registerPropField(8400910, LDAPLang.getStrReplicationThreadStatus(), LDAPLang.getStrReplicationThreadStatus(), "m_replication");
        this.registerPropField(8400911, LDAPLang.getStrAllPlbl(), LDAPLang.getStrAllPdsc(), "m_all");
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
        int n2 = AdminProp.getPropNumber(n);
        if (n2 >= 12288 && n2 <= 12303) {
            this.update();
            if (n == 8400911) {
                this.setEnabledProperties();
            }
        }
    }

    public void setEnabledProperties() {
        try {
            int n = 281609325;
            if (this.m_all.booleanValue()) {
                super.setProp(n, (Object)m_enableList);
            } else {
                super.setProp(n, null);
            }
            this.sendAdminPropertyChangeEvents(n, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getDebugFlags() {
        int n = 0;
        if (this.m_trace_func_calls.booleanValue()) {
            n |= 1;
        }
        if (this.m_packet_handling.booleanValue()) {
            n |= 2;
        }
        if (this.m_heavy_trace_debugging.booleanValue()) {
            n |= 4;
        }
        if (this.m_connection_management.booleanValue()) {
            n |= 8;
        }
        if (this.m_print_packets.booleanValue()) {
            n |= 0x10;
        }
        if (this.m_search_filter.booleanValue()) {
            n |= 0x20;
        }
        if (this.m_config_file.booleanValue()) {
            n |= 0x40;
        }
        if (this.m_access_control.booleanValue()) {
            n |= 0x80;
        }
        if (this.m_stat_log_connect.booleanValue()) {
            n |= 0x100;
        }
        if (this.m_stat_log_entry.booleanValue()) {
            n |= 0x200;
        }
        if (this.m_print_comm.booleanValue()) {
            n |= 0x400;
        }
        if (this.m_print_entry_parse.booleanValue()) {
            n |= 0x800;
        }
        if (this.m_schema.booleanValue()) {
            n |= 0x1000;
        }
        if (this.m_process.booleanValue()) {
            n |= 0x2000;
        }
        if (this.m_replication.booleanValue()) {
            n |= 0x8000;
        }
        if (this.m_all.booleanValue()) {
            n = 65535;
        }
        return n;
    }

    public void setReplOwner(boolean bl) {
        this.m_replOwner = bl;
    }

    public boolean isReplOwner() {
        return this.m_replOwner;
    }

    public void update() throws PropertyException {
        int[] nArray = new int[]{this.m_propId};
        Object[] objectArray = new Object[]{Integer.toString(this.getDebugFlags())};
        this.m_entry.setProps(nArray, objectArray);
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            this.update();
            this.updateBackup();
            return;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
    }

    public String toString() {
        return Integer.toString(this.m_backupFlags);
    }

    public void cleanup() {
        this.m_entry = null;
    }
}

