/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.Connectors;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewProcMetaConfSet;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.ProcConnector;
import oracle.ldap.admin.ProcConnectorSample;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class ProcMetaConfSet
extends ProcConfSet {
    static final int CMD_ADD = 16;
    static final int CMD_REMOVE = 17;
    static final int CMD_REFRESH_TABLE = 18;
    static final String META_CONF_DNS = "orclmetaconnconfigdns";
    static final String META_CONF_REF = "orclmetaconnconfigrefreshflag";
    static String STR_CONNECTORS;
    AdminList m_connectors;
    Connectors m_conn_holder;

    public ProcMetaConfSet() {
    }

    public ProcMetaConfSet(Root root) {
        super(root);
    }

    public ProcMetaConfSet(Root root, Proc proc) {
        super(root);
        this.m_holder = proc.getHolder();
    }

    public ProcMetaConfSet(Root root, String string, String string2, Object[] objectArray) {
        super(root, string, string2, objectArray);
    }

    public ProcMetaConfSet(Root root, String string, String string2, Object[] objectArray, Proc proc) {
        super(root, string, string2, objectArray);
        this.m_holder = proc.getHolder();
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public void init() {
        super.init();
        this.m_connectors = new AdminList((IAdminProp)this, new Vector());
        this.m_connectors.setSampleChild(new ProcConnectorSample(this.m_parent));
        STR_CONNECTORS = LDAPLang.getStrConnectors();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3080204: {
                return new Integer(4100);
            }
            case 272695330: {
                if (this.m_connectors == null || this.m_connectors.countChildren() == 0) {
                    this.loadConnectors();
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int[] nArray = new int[]{3080204, 0x110001, 273613313};
                Object[] objectArray = new Object[nArray.length];
                objectArray[0] = new Integer(8196);
                objectArray[1] = LDAPLang.getStrGeneral();
                objectArray[2] = null;
                iAdminPropArray[0] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                nArray = new int[]{3080204, 0x110001, 273220108, 1638408};
                objectArray = new Object[nArray.length];
                objectArray[0] = new Integer(68);
                objectArray[1] = LDAPLang.getStrConnectors();
                objectArray[2] = this.getTableCommands();
                objectArray[3] = "images/msprpms.gif";
                iAdminPropArray[1] = new AdminPropView((IAdminProp)this.m_connectors, nArray, objectArray);
                return iAdminPropArray;
            }
            case 3081366: {
                return new Integer(12);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    IAdminProp[] getTableCommands() throws PropertyException {
        IAdminProp[] iAdminPropArray = new IAdminProp[4];
        int n = 0;
        iAdminPropArray[n++] = new CommandProp((IAdminProp)this, 16, LDAPLang.getStrAddConnector(), LDAPLang.getStrAddConnector(), "images/create.gif");
        iAdminPropArray[n++] = new CommandProp(this, 17, LDAPLang.getStrRemoveConnector(), LDAPLang.getStrRemoveConnector(), "images/delete.gif", 1, 1);
        iAdminPropArray[n - 1].setProp(1639168, LDAPLang.getStrConfirmDelete1());
        iAdminPropArray[n++] = new CommandProp((IAdminProp)this, 18, LDAPLang.getStrRefreshConnector(), LDAPLang.getStrRefreshConnector(), "images/refresh.gif");
        iAdminPropArray[n++] = new CommandProp(this, -51, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditLabel(), "images/edit.gif", 1, 1);
        return iAdminPropArray;
    }

    String[] getConnDNs() {
        String[] stringArray = null;
        try {
            Integer n = this.m_parent.getAttrPropId(META_CONF_DNS);
            int n2 = n;
            stringArray = (String[])this.getProp(n2);
        }
        catch (Exception exception) {}
        return stringArray;
    }

    void loadConnectors() throws PropertyException {
        Object object;
        ((AdminProp)this.m_parent).setErrorMessage("");
        int n = 0;
        try {
            object = this.getConnDNs();
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                this.m_parent.findObject(object[n2], null, this);
                while (n++ < 6 && this.m_connectors.countChildren() == 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                this.debugMessageLn(exception.getMessage());
            }
            throw new PropertyException(exception);
        }
        object = ((AdminProp)this.m_parent).getErrorMessage();
        if (!((String)object).equals("") && this.debug) {
            this.debugMessageLn((String)object);
        }
    }

    public void addChild(AdminProp adminProp) {
        this.m_connectors.addChild(adminProp);
    }

    public void update() {
        this.m_connectors.update();
        Integer n = this.m_parent.getAttrPropId(META_CONF_REF);
        int n2 = n;
        String string = null;
        try {
            string = (String)this.getProp(n2);
        }
        catch (PropertyException propertyException) {}
        this.sendAdminPropertyChangeEvents(n2, string);
    }

    public void updateRefreshFlag() throws PropertyException {
        Integer n = this.m_parent.getAttrPropId(META_CONF_REF);
        int n2 = n;
        try {
            this.setProp(n2, (Object)"1");
        }
        catch (PropertyException propertyException) {}
        if (this.m_parent.saveEntry(this)) {
            this.sendAdminPropertyChangeEvents(n2, "1");
        }
    }

    public boolean save() throws PropertyException {
        Integer n = this.m_parent.getAttrPropId(META_CONF_REF);
        int n2 = n;
        this.setProp(n2, (Object)"1");
        String[] stringArray = new String[this.m_connectors.countChildren()];
        int n3 = 0;
        while (n3 < this.m_connectors.countChildren()) {
            ProcConnector procConnector = (ProcConnector)this.m_connectors.nthChild(n3);
            stringArray[n3] = procConnector.getDn();
            ++n3;
        }
        n = this.m_parent.getAttrPropId(META_CONF_DNS);
        n2 = n;
        if (super.getPropName(n2) == null) {
            this.registerProp(n2, META_CONF_DNS, META_CONF_DNS);
            this.addSetAttrName(META_CONF_DNS);
        }
        this.setProp(n2, (Object)stringArray);
        return this.m_parent.saveEntry(this);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -51: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                return iAdminPropArray[0];
            }
            case 16: {
                if (this.m_conn_holder == null) {
                    this.m_conn_holder = new Connectors(this.m_parent, this, (ProcConfSets)this.m_holder);
                }
                return this.m_conn_holder;
            }
            case 17: {
                this.m_connectors.removeChildren(iAdminProp);
                this.save();
                this.update();
                return null;
            }
            case -8: {
                String string = ((ProcConfSets)this.m_holder).computeNewSetId();
                NewProcMetaConfSet newProcMetaConfSet = new NewProcMetaConfSet(this.m_parent, "", string, null, false, this.m_holder);
                return newProcMetaConfSet;
            }
            case -10: {
                String string = ((ProcConfSets)this.m_holder).computeNewSetId();
                NewProcMetaConfSet newProcMetaConfSet = new NewProcMetaConfSet(this.m_parent, "", string, this.getAttributes(), true, this.m_holder);
                return newProcMetaConfSet;
            }
            case -9: {
                if (!this.m_parent.deleteEntry(this)) {
                    throw new PropertyException(this.m_parent.getErrorMessage());
                }
                this.m_holder.removeChild(this);
                this.m_holder.update();
                return null;
            }
            case -5: {
                super.doCommand(iAdminProp);
            }
            case 18: {
                if (this.m_connectors == null) {
                    this.m_connectors = new AdminList((IAdminProp)this, new Vector());
                } else {
                    this.m_connectors.removeAllChildren();
                }
                this.loadConnectors();
                this.m_connectors.update();
                return null;
            }
            default: {
                return super.doCommand(iAdminProp);
            }
        }
    }

    public ProcConfSets getHolder() {
        return (ProcConfSets)this.m_holder;
    }

    public AdminList getConnectorList() {
        return this.m_connectors;
    }
}

