/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcInstSample;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;

public class Procs
extends AdminList {
    static final String LDAP_CONF_DN = "cn=osdldapd, cn=subconfigsubentry";
    static final String REPL_CONF_DN = "cn=osdrepld, cn=subconfigsubentry";
    static final String META_CONF_DN = "cn=metadird, cn=configsets, cn=oracle internet directory";
    String m_displayMsg;
    Object[] m_attrs;
    Vector m_procs;

    public Procs(Root root) {
        super(root);
        this.setDisplayName(LDAPLang.getStrDisplayName14());
        this.setIconName("images/svrmgmnt.gif");
        this.m_procs = new Vector();
        this.m_procs.addElement(new Proc(root, LDAP_CONF_DN, LDAPLang.getStrLdapServer(), root.m_serverAccess.createAttributeArray(0)));
        this.m_procs.addElement(new Proc(root, REPL_CONF_DN, LDAPLang.getStrReplServer(), root.m_serverAccess.createAttributeArray(0)));
        if (Root.MetaDirEnabled) {
            this.m_procs.addElement(new Proc(root, META_CONF_DN, LDAPLang.getStrMetaServer(), root.m_serverAccess.createAttributeArray(0)));
        }
        this.m_children = null;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "configuring_servers";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3080204: {
                if (Root.isClientCommandLine()) {
                    return new Integer(0x300004);
                }
                return new Integer(0x300044);
            }
            case 273612805: {
                return AdminProp.vectorToObjectArray(this.m_procs);
            }
            case 273219601: {
                if (this.m_children == null) {
                    this.loadServerChildren();
                }
                return AdminProp.vectorToObjectArray(this.m_children);
            }
            case 2032706: {
                return LDAPLang.getStrActiveProcesses();
            }
            case 1639559: {
                return LDAPLang.getStrViewProps();
            }
            case 2686995: 
            case 0x10110021: 
            case 281083936: 
            case 282001424: {
                if (this.getSampleChild() != null) break;
                this.setSampleChild(new ProcInstSample((Root)this.getParent()));
                break;
            }
        }
        return super.getProp(n);
    }

    public void addChild(Object object) {
        if (object instanceof Proc) {
            if (this.m_procs == null) {
                this.m_procs = new Vector();
            }
            this.m_procs.addElement(object);
            return;
        }
        super.addChild(object);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    public void loadServerChildren() throws PropertyException {
        if (this.m_procs != null) {
            int n = this.m_procs.size();
            int n2 = 0;
            while (n2 < n) {
                Proc proc = (Proc)this.m_procs.elementAt(n2);
                AdminList adminList = proc.getProcInsts();
                Vector vector = adminList.getChildren();
                if (vector != null) {
                    int n3 = vector.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        Object e = vector.elementAt(n4);
                        if (this.m_children == null) {
                            this.m_children = new Vector();
                        }
                        this.m_children.addElement(e);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public void cleanup() {
        this.m_displayMsg = null;
        this.m_attrs = null;
        int n = 0;
        while (n < this.m_procs.size()) {
            ((Proc)this.m_procs.elementAt(n)).cleanup();
            ++n;
        }
        this.m_procs = null;
        this.m_children = null;
    }
}

