/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import oracle.ldap.admin.InitialScreen;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.ServerList;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.AdminURL;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.help.AdminHelp;
import oracle.ldap.admin.ldapDebugFlags;

public class RootList
extends AdminList
implements ICommandParent,
AdminPropertyChangeListener {
    public static final int PR_CHILDREN_CONFIG_LIST = 0x10103000;
    public static final int CMD_CREATE_OBJCLASS = 1;
    public static final int CMD_CREATE_ATTR = 2;
    public static final int CMD_CREATE_ACP = 3;
    public static final int CMD_CREATE_ENTRY = 4;
    public static final int CMD_MAN_TABLE_COL = -8192;
    public static final int CMD_MAN_ATTR = -8193;
    public static final int CMD_REFRESH_ENTRY = -8194;
    public static final int CMD_REFRESH_SUBENTRIES = -8195;
    public static final int CMD_DECATALOGE = -8196;
    public static final int CMD_ACPS_SEARCH = -8197;
    public static final int CMD_OPTIONS = -8198;
    static final int[] m_childConfigList = new int[]{0x10103000};
    CommandProp[] m_globalCmdItems;
    CommandProp[] m_menuList;
    CommandProp m_toggleConnect;
    ServerList m_serverList;
    IAdminProp[] m_cmdList;
    static String[][] helpLangs = new String[][]{{"de", "de_DE"}, {"de_AT", "de_DE"}, {"de_LI", "de_DE"}, {"de_LIECHTENSTEIN", "de_DE"}, {"de_LU", "de_DE"}, {"de_LUXEMBOURG", "de_DE"}, {"de_DE", "de_DE"}, {"de_CH", "de_DE"}, {"fr", "fr_FR"}, {"fr_BE", "fr_FR"}, {"fr_CA", "fr_FR"}, {"fr_LU", "fr_FR"}, {"fr_LUXEMBOURG", "fr_FR"}, {"fr_FR", "fr_FR"}, {"fr_CH", "fr_FR"}, {"ja", "ja"}, {"ja_JP", "ja"}, {"zh_CN", "zh_CN"}, {"pt_BR", "pt_BR"}};

    public int getHostPort(String string, int n) {
        return this.m_serverList.getHostPort(string, n);
    }

    public Server getDefaultServer() {
        return this.m_serverList.getDefaultServer();
    }

    public void addChild(Object object) {
        super.addChild(object);
        ((IAdminProp)object).addAdminPropertyChangeListener(this);
    }

    public void removeChild(Object object) {
        super.removeChild(object);
        ((IAdminProp)object).removeAdminPropertyChangeListener(this);
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            if (adminPropertyChangeEvent.getPropId() == 0x110001) {
                this.sendAdminPropertyChangeEvents(282002580, null);
                return;
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public RootList() {
        super(null, new Vector());
        this.addChild(new Root(this));
        this.registerProp(0x10103000, LDAPLang.getStrChildrenConfigListPlbl(), LDAPLang.getStrChildrenConfigListPdsc());
        this.setupHelp();
        this.m_serverList = new ServerList();
        try {
            this.m_cmdList = new IAdminProp[3];
            int n = 0;
            this.m_cmdList[n++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrCmdNew1(), LDAPLang.getStrCmdDecpNew1(), "images/create.gif");
            this.m_cmdList[n++] = new CommandProp(this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrCmdDecpDelete1(), "images/delete.gif", 1, 0);
            this.m_cmdList[n - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
            int n2 = n++;
            this.m_toggleConnect = new CommandProp(this, -4, LDAPLang.getStrConnect(), LDAPLang.getStrCmdDecpConnect(), "images/connect.gif", 1, 1);
            this.m_cmdList[n2] = this.m_toggleConnect;
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public ServerList getServerList() {
        return this.m_serverList;
    }

    public void setupHelp() {
        URL uRL = null;
        try {
            String string = "helpDrive";
            String string2 = "C:";
            string2 = System.getProperty(string);
            if (string2 == null || string2.length() == 0) {
                return;
            }
            string2 = "file:/" + string2 + "/oracle/io/admin/help/ldap/";
            uRL = new URL(string2);
        }
        catch (Exception exception) {}
        AdminHelp.addBook(uRL, "ods", LDAPLang.getStrHelpTitle());
    }

    public static String getHelpBaseFileName() {
        return "ods";
    }

    public static String getHelpDir() {
        String string = Locale.getDefault().toString();
        String string2 = null;
        int n = 0;
        while (n < helpLangs.length) {
            if (string.equalsIgnoreCase(helpLangs[n][0])) {
                string2 = new String("ldap_" + helpLangs[n][1]);
            }
            ++n;
        }
        if (string2 == null) {
            string2 = new String("ldap");
        } else if (string2.equalsIgnoreCase("ldap_ja")) {
            string2 = System.getProperty("os.name", "DEFAULT").startsWith("Windows") ? new String("ldap_ja_SJIS") : new String("ldap_ja_EUC");
        }
        return string2;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 5178518: {
                return new ldapDebugFlags();
            }
            case 1639543: {
                return "images/logo.gif";
            }
            case 1639544: {
                return "images/ldaplo.gif";
            }
            case 1638408: {
                return "images/ldapsrvrs.gif";
            }
            case 1049119: {
                return RootList.getHelpDir();
            }
            case 2032710: {
                return LDAPLang.getStrAboutProductTitle();
            }
            case 1049371: 
            case 2032709: {
                return LDAPLang.getStrHelpTitle();
            }
            case 1049370: {
                return "ods";
            }
            case 1048745: {
                return "view_drectory_servers";
            }
            case 0x110001: {
                return LDAPLang.getStrDisplayName15();
            }
            case 2032789: {
                return AdminURL.makeComponent(this.getClass().getName());
            }
            case 282002580: {
                return m_childConfigList;
            }
            case 0x10103000: {
                Vector vector = this.getChildren();
                int n2 = vector.size();
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n3);
                    String string = (String)iAdminProp.getProp(1585157);
                    if (string == null) {
                        string = "@null@";
                    } else if ((string = string.trim()).length() == 0) {
                        string = "@empty@";
                    }
                    String string2 = (String)iAdminProp.getProp(1585154);
                    if (string2 == null) {
                        string2 = "@null@";
                    } else if ((string2 = string2.trim()).length() == 0) {
                        string2 = "@empty@";
                    }
                    Integer n4 = (Integer)iAdminProp.getProp(3026947);
                    String string3 = n4 == null ? "@null@" : n4.toString();
                    stringArray[n3] = String.valueOf(string) + " " + string2 + " " + string3;
                    System.out.println("child config = " + stringArray[n3]);
                    ++n3;
                }
                return stringArray;
            }
            case 1048731: {
                return String.valueOf(LDAPLang.getStrVersionLocal()) + " 2.1.1";
            }
            case 3080204: {
                return new Integer(0x100044);
            }
            case 2162725: {
                return new Integer(16448);
            }
            case 273220108: {
                return this.m_cmdList;
            }
            case 282001424: {
                int[] nArray = new int[]{1585157, 1585154, 3026947};
                return nArray;
            }
            case 272696468: {
                if (this.m_globalCmdItems == null) {
                    this.m_globalCmdItems = new CommandProp[5];
                    CommandProp[] commandPropArray = this.m_globalCmdItems;
                    int n5 = 0;
                    commandPropArray[n5++] = new CommandProp((IAdminProp)this, -8194, LDAPLang.getStrCmdRefreshEntry(), LDAPLang.getStrRefreshEntryDescp2(), "images/updateentry.gif", 'f');
                    commandPropArray[n5++] = new CommandProp((IAdminProp)this, -8195, LDAPLang.getStrCmdRefreshSubentries(), LDAPLang.getStrRefreshSubentriesDescp1(), "images/updateentry.gif", 'r');
                    commandPropArray[n5++] = new CommandProp((IAdminProp)this, -8196, LDAPLang.getStrDeCataloge(), LDAPLang.getStrDeCatalogeDescp(), "images/decatalog.gif", 'D');
                    commandPropArray[n5++] = new CommandProp((IAdminProp)this, -8197, LDAPLang.getStrSearch(), LDAPLang.getStrSearchACPs(), "images/msdir.gif", 'S');
                    commandPropArray[n5++] = new CommandProp((IAdminProp)this, -8198, LDAPLang.getStrUserPrefTitle(), LDAPLang.getStrUserPrefTitle(), "images/options.gif", 'U');
                }
                return this.m_globalCmdItems;
            }
            case 1114271: {
                return LDAPLang.getStrOperation();
            }
            case 2032137: {
                return "O";
            }
            case 272695456: {
                if (this.m_menuList == null) {
                    this.m_menuList = new CommandProp[4];
                    CommandProp[] commandPropArray = this.m_menuList;
                    int n6 = 0;
                    commandPropArray[n6++] = new CommandProp((IAdminProp)this, 1, LDAPLang.getStrMenuCreateObjclass(), LDAPLang.getStrMenuDecpCreateObjclass(), 'b');
                    commandPropArray[n6++] = new CommandProp((IAdminProp)this, 2, LDAPLang.getStrMenuCreateAttr(), LDAPLang.getStrMenuDecpCreateAttr(), 'A');
                    commandPropArray[n6++] = new CommandProp((IAdminProp)this, 3, LDAPLang.getStrMenuCreateAcp(), LDAPLang.getStrMenuDecpCreateAcp(), 'P');
                    commandPropArray[n6++] = new CommandProp((IAdminProp)this, 4, LDAPLang.getStrMenuCreateEntry(), LDAPLang.getStrMenuDecpCreateEntry(), 'E');
                }
                return this.m_menuList;
            }
            case 273220679: {
                Root root;
                if (this.m_serverList.countChildren() == 0 && !(root = (Root)this.nthChild(0)).isConnected()) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{new InitialScreen(), this.m_serverList, root};
                    return iAdminPropArray;
                }
                return null;
            }
            case 4785223: {
                Root root;
                if (this.countChildren() == 1 && !(root = (Root)this.nthChild(0)).isConnected()) {
                    return root;
                }
                return null;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 273220105: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null || iAdminPropArray.length != 1 || this.m_toggleConnect == null) break;
                if (((Root)iAdminPropArray[0]).isConnected()) {
                    this.m_toggleConnect.setProp(0x110001, (Object)LDAPLang.getStrDisconnect());
                    this.m_toggleConnect.setProp(1638914, (Object)LDAPLang.getStrDisconnectDesc());
                    this.m_toggleConnect.setProp(1638408, (Object)"images/disconnect.gif");
                    break;
                }
                this.m_toggleConnect.setProp(0x110001, (Object)LDAPLang.getStrConnect());
                this.m_toggleConnect.setProp(1638914, (Object)LDAPLang.getStrConnectDesc());
                this.m_toggleConnect.setProp(1638408, (Object)"images/connect.gif");
                break;
            }
            case 0x10190099: {
                String[] stringArray = (String[])object;
                if (stringArray != null) {
                    int n2 = this.countChildren();
                    int n3 = 0;
                    Root root = (Root)this.nthChild(0);
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray[n4].equalsIgnoreCase("-help")) {
                            this.doHelp();
                        } else if (stringArray[n4].equalsIgnoreCase("-LDAPRoot:Start")) {
                            ++n4;
                            while (n4 + 1 < stringArray.length) {
                                if (stringArray[n4].equalsIgnoreCase("-LDAPRoot:End")) break;
                                if (stringArray[n4].equalsIgnoreCase("-user")) {
                                    root.m_user = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-password")) {
                                    root.m_password = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-host") || stringArray[n4].equalsIgnoreCase("-server")) {
                                    root.m_host = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-port")) {
                                    root.m_port = Integer.parseInt(stringArray[++n4]);
                                } else if (stringArray[n4].equalsIgnoreCase("-sslLevel")) {
                                    root.m_sslLevel = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-sslLocation")) {
                                    root.m_sslLocation = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-sslPassword")) {
                                    root.m_sslPassword = stringArray[++n4];
                                } else if (stringArray[n4].equalsIgnoreCase("-logon")) {
                                    try {
                                        root.saveChanges(0);
                                    }
                                    catch (Exception exception) {
                                        this.unexpectedException(exception);
                                    }
                                } else if (stringArray[n4].equalsIgnoreCase("-new")) {
                                    if (++n3 < n2) {
                                        root = (Root)this.nthChild(n3);
                                    } else {
                                        root = new Root(this);
                                        this.addChild(root);
                                    }
                                } else if (stringArray[n4].equalsIgnoreCase("-noSyntaxLOV")) {
                                    SchemaObject.NO_SYNTAX_LOV = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-useDisplayNames")) {
                                    Names.USE_DISPLAY_NAME = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-ssl")) {
                                    Root.SSLEnabled = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-meta")) {
                                    Root.MetaDirEnabled = true;
                                } else if (stringArray[n4].equals("-debug")) {
                                    Root.DEBUG = true;
                                    Root.debugDirTree = true;
                                    Root.debugServerAccess = true;
                                    Root.debugLoadSchema = true;
                                    Root.debugSaveEntry = true;
                                    Root.debugDeleteEntry = true;
                                    Root.debugConfMgmt = true;
                                    Root.debugAccessItemEntry = true;
                                    Root.debugSaveAttribute = true;
                                    Root.debugSaveObjectClass = true;
                                    Root.debugSearchEntry = true;
                                    Root.debugSaveACI = true;
                                    Root.debugAuditLog = true;
                                    Root.debugDirectory = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugDirTree")) {
                                    Root.debugDirTree = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugServerAccess")) {
                                    Root.debugServerAccess = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugSaveEntry")) {
                                    Root.debugSaveEntry = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugLoadSchema")) {
                                    Root.debugLoadSchema = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugDeleteEntry")) {
                                    Root.debugDeleteEntry = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugSearchEntry")) {
                                    Root.debugSearchEntry = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugSaveACP")) {
                                    Root.debugSaveACI = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugSaveObjectClass")) {
                                    Root.debugSaveObjectClass = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugSaveAttribute")) {
                                    Root.debugSaveAttribute = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugAccessItemEntry")) {
                                    Root.debugAccessItemEntry = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugConfMgmt")) {
                                    Root.debugConfMgmt = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugAuditLog")) {
                                    Root.debugAuditLog = true;
                                } else if (stringArray[n4].equalsIgnoreCase("-debugDirectory")) {
                                    Root.debugDirectory = true;
                                }
                                ++n4;
                            }
                        }
                        ++n4;
                    }
                }
                return;
            }
            case 8454180: {
                int n5 = this.countChildren();
                int n6 = 0;
                while (n6 < n5) {
                    Root root = (Root)this.nthChild(n6);
                    root.setProp(n, object);
                    ++n6;
                }
                return;
            }
            case 0x10103000: {
                Vector vector = this.getChildren();
                String[] stringArray = (String[])object;
                int n7 = 0;
                while (n7 < stringArray.length) {
                    System.out.println("Child config = " + stringArray[n7]);
                    int n8 = stringArray[n7].indexOf(" ");
                    if (n8 >= 0) {
                        int n9 = stringArray[n7].indexOf(" ", n8 + 1);
                        if (n9++ >= 0) {
                            if (n7 >= vector.size()) {
                                this.addChild(new Root(this));
                            }
                            IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n7);
                            String string = stringArray[n7].substring(0, n8);
                            String string2 = stringArray[n7].substring(n8 + 1, n9 - 1);
                            String string3 = stringArray[n7].substring(n9);
                            if (string.equals("@null@")) {
                                string = null;
                            } else if (string.equals("@empty@")) {
                                string = "";
                            }
                            if (string2.equals("@null@")) {
                                string2 = null;
                            } else if (string2.equals("@empty@")) {
                                string2 = "";
                            }
                            if (string3.equals("@null@")) {
                                string3 = "389";
                            }
                            iAdminProp.setProp(1585157, string);
                            iAdminProp.setProp(1650690, string2);
                            iAdminProp.setProp(3026947, new Integer(string3));
                        }
                    }
                    ++n7;
                }
                this.update();
                return;
            }
        }
        super.setProp(n, object);
    }

    public int getConnectedCount() {
        int n = 0;
        int n2 = this.countChildren();
        int n3 = 0;
        while (n3 < n2) {
            Root root = (Root)this.nthChild(n3);
            if (root.isConnected()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public void enableMenuList() {
        try {
            if (this.getConnectedCount() != 1) {
                int n = 0;
                while (n < this.m_menuList.length) {
                    this.m_menuList[n].setProp(8978948, (Object)Boolean.FALSE);
                    ++n;
                }
                return;
            }
            int n = 0;
            while (n < this.m_menuList.length) {
                this.m_menuList[n].setProp(8978948, (Object)Boolean.TRUE);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case 1: {
                    int n2 = this.countChildren();
                    int n3 = 0;
                    while (n3 < n2) {
                        Root root = (Root)this.nthChild(n3);
                        if (root.isConnected()) {
                            return root.createObjectClass();
                        }
                        ++n3;
                    }
                    return null;
                }
                case 2: {
                    int n4 = this.countChildren();
                    int n5 = 0;
                    while (n5 < n4) {
                        Root root = (Root)this.nthChild(n5);
                        if (root.isConnected()) {
                            return root.createAttribute();
                        }
                        ++n5;
                    }
                    return null;
                }
                case 3: {
                    int n6 = this.countChildren();
                    int n7 = 0;
                    while (n7 < n6) {
                        Root root = (Root)this.nthChild(n7);
                        if (root.isConnected()) {
                            return root.createACP();
                        }
                        ++n7;
                    }
                    return null;
                }
                case 4: {
                    int n8 = this.countChildren();
                    int n9 = 0;
                    while (n9 < n8) {
                        Root root = (Root)this.nthChild(n9);
                        if (root.isConnected()) {
                            return root.createEntry();
                        }
                        ++n9;
                    }
                    return null;
                }
                case -4: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) return null;
                    Root root = (Root)iAdminPropArray[0];
                    if (!root.isConnected()) return root;
                    root.setProp(8454180, (Object)Boolean.TRUE);
                    return null;
                }
                case -9: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null) return null;
                    int n10 = 1;
                    while (n10 < iAdminPropArray.length) {
                        this.removeChild(iAdminPropArray[n10]);
                        iAdminPropArray[n10].setProp(8454180, Boolean.TRUE);
                        ++n10;
                    }
                    if (this.countChildren() == 1) {
                        this.addChild(new Root(this));
                    }
                    this.removeChild(iAdminPropArray[0]);
                    iAdminPropArray[0].setProp(8454180, Boolean.TRUE);
                    return null;
                }
                case -8: {
                    return new Root(this);
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new PropertyException(exception.getMessage());
        }
    }

    public void save(Root root) {
        this.addChildUnique(root);
        this.update();
        this.enableMenuList();
    }

    public void doHelp() {
        System.out.println("\nHelp for LDAP Administration Server:");
        System.out.println(" -LDAPRoot:Start - denotes start of ldap admin server command line options.");
        System.out.println(" -LDAPRoot:End - denotes end of ldap admin server command line options.");
        System.out.println(" -user <username> - specify entry dn for ldap authentication.");
        System.out.println(" -password <string> - specify password of entry for ldap authentication.");
        System.out.println(" -host <hostname> - specify ldap server host name");
        System.out.println(" -port <port#> - specify port number that ldap server is listening on.");
        System.out.println(" -logon - initiate logon to ldap server");
        System.out.println(" -new - create another ldap server object.");
        System.out.println(" -noSyntaxLOV - disable the use of List of values for the Syntax field of schema objects to allow the user to type in any value desired.");
        System.out.println(" -meta - enabling meta directory admin functions.");
        System.out.println(" -ssl - using net8 packages with SSL support.");
        System.out.println(" -sslLevel - SSL authentication level which can be : Anonymous, Simple SSLNoAuth, SSLOneWay, SSLTwoWay");
        System.out.println(" -sslLocation - the location where stores wallet certificate.");
        System.out.println(" -sslPassword - the password associated with the wallet.");
        System.out.println(" -useDisplayName - enable use of more user friendly attribute names.");
        System.out.println("\nDEBUG FLAGS:");
        System.out.println(" -debugSaveEntry - enable debug message for directory entry save.");
        System.out.println(" -debugLoadSchema - enable debug messages for schema data loading.");
        System.out.println(" -debugDeleteEntry - enable debug messages for directory entry deletion.");
        System.out.println(" -debugSearchEntry - enable debug messages for directory entry search.");
        System.out.println(" -debugSaveACP - enable debug messages for access control item save.");
        System.out.println(" -debugSaveObjectClass - enable debug messages for object class save.");
        System.out.println(" -debugSaveAttribute - enable debug messages for attribute save.");
        System.out.println(" -debugAccessItemEntry - enable debug messages for entry access item.");
        System.out.println(" -debugConfMgmt - enable debug messages for configuration management.");
        System.out.println(" -debugServerAccess - enable debug messages for server network access.");
        System.out.println(" -debugAuditLog - enable debug messages for audit log.");
        System.out.println(" -debug - enable all debug flags.");
    }

    public static void main(String[] stringArray) {
        RootList rootList = new RootList();
        rootList.printDebugTraverse(System.out, true, true, true);
    }
}

