/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SelectAccessPermission;
import oracle.ldap.admin.SelectAccessPermissions;
import oracle.ldap.admin.SelectAccessToWhat;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class SelectAccessByWhom
extends SelectAccessToWhat {
    String m_orgByWhom;
    String m_byWhomWithoutBindMode = "";
    SelectAccessPermissions m_permissions;

    public SelectAccessByWhom() {
        boolean bl = Root.debugAccessItemEntry;
        if (bl) {
            this.setDebug(true);
        }
    }

    public SelectAccessByWhom(AccessItem accessItem, String string, SelectAccessPermissions selectAccessPermissions) {
        this.m_aci = accessItem;
        this.m_type = LDAPLang.getStrEveryone();
        this.m_accessToWhat = false;
        this.m_orgByWhom = string;
        this.m_permissions = selectAccessPermissions;
        this.init();
    }

    public void init() {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
        String[] stringArray = new String[]{"Anonymous"};
        this.registerProp(1650696, LDAPLang.getStrBindmodesPlbl(), LDAPLang.getStrBindModePdsc());
        this.registerPropListOfValues(1650696, stringArray);
        this.m_bindMode = "";
        String[] stringArray2 = new String[]{LDAPLang.getStrEveryone(), LDAPLang.getStrSelf(), LDAPLang.getStrAnentry(), LDAPLang.getStrDnattr(), LDAPLang.getStrGroup()};
        this.registerProp(1585152, LDAPLang.getStrTypePlbl(), LDAPLang.getStrEmptyString());
        this.registerPropListOfValues(1585152, stringArray2);
        this.parse(this.m_orgByWhom);
    }

    public void parseBindMode(String string) {
        this.m_byWhomWithoutBindMode = string;
        int n = (string = string.toLowerCase().replace('\t', ' ')).indexOf(" bindmode=");
        if (n < 0 && string.startsWith("bindmode=")) {
            n = 0;
        }
        if (n < 0) {
            return;
        }
        if (n != 0) {
            string = string.substring(n + 1);
        }
        this.m_byWhomWithoutBindMode = this.m_byWhomWithoutBindMode.substring(0, n);
        String string2 = "bindmode=";
        if (string.startsWith("bindmode=")) {
            string = string.substring(string2.length()).trim();
            if (this.debug) {
                this.debugMessageLn("byWhom='" + string + "'");
            }
            if (string.startsWith("\"")) {
                string = string.substring(1).trim();
            }
            string2 = "simple";
            if (string.startsWith("simple")) {
                this.m_bindMode = "Simple";
                string = string.substring(string2.length()).trim();
                if (this.debug) {
                    this.debugMessageLn("m_bindMode=" + this.m_bindMode + "  byWhom=" + string);
                }
            } else {
                string2 = "sslnoauth";
                if (string.startsWith("sslnoauth")) {
                    this.m_bindMode = "SSLNoAuth";
                    string = string.substring(string2.length()).trim();
                    if (this.debug) {
                        this.debugMessageLn("m_bindMode=" + this.m_bindMode + "  byWhom=" + string);
                    }
                } else {
                    string2 = "ssloneway";
                    if (string.startsWith("ssloneway")) {
                        this.m_bindMode = "SSLOneWay";
                        string = string.substring(string2.length()).trim();
                        if (this.debug) {
                            this.debugMessageLn("m_bindMode=" + this.m_bindMode + "  byWhom=" + string);
                        }
                    } else {
                        string2 = "ssltwoway";
                        if (string.startsWith("ssltwoway")) {
                            this.m_bindMode = "SSLTwoWay";
                            string = string.substring(string2.length()).trim();
                            if (this.debug) {
                                this.debugMessageLn("m_bindMode=" + this.m_bindMode + "  byWhom=" + string);
                            }
                        } else {
                            this.m_bindMode = "Anonymous";
                            string2 = "anonymous";
                            if (string.startsWith("anonymous")) {
                                string = string.substring(string2.length()).trim();
                            }
                            if (this.debug) {
                                this.debugMessageLn("m_bindMode=" + this.m_bindMode + "  byWhom=" + string);
                            }
                        }
                    }
                }
            }
            if (string.startsWith("\"")) {
                string = string.substring(1).trim();
            }
        }
    }

    public void parse(String string) {
        block39: {
            try {
                if (string == null || string.equals("")) {
                    return;
                }
                if (this.debug) {
                    this.debugMessageLn("byWhom='" + string + "'");
                }
                string = string.trim();
                this.parseBindMode(string);
                String string2 = string.toLowerCase();
                int n = string2.length();
                int[] nArray = new int[]{0};
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                while (nArray[0] < n) {
                    AccessItem.skipSpace(string2, nArray);
                    String string3 = string2.substring(nArray[0]);
                    if (this.debug) {
                        this.debugMessageLn("whom = " + string3);
                    }
                    String string4 = "dnattr";
                    if (string3.startsWith("dnattr")) {
                        this.m_type = LDAPLang.getStrDnattr();
                        bl2 = true;
                        if (this.debug) {
                            this.debugMessageLn("got dnattr");
                        }
                    } else {
                        string4 = "dn";
                        if (string3.startsWith("dn")) {
                            this.m_type = LDAPLang.getStrAnentry();
                            bl = true;
                            if (this.debug) {
                                this.debugMessageLn("got dn");
                            }
                        } else {
                            string4 = "self";
                            if (string3.startsWith("self")) {
                                this.m_type = LDAPLang.getStrSelf();
                                if (this.debug) {
                                    this.debugMessageLn("got self");
                                }
                            } else {
                                string4 = "group";
                                if (string3.startsWith("group")) {
                                    this.m_type = LDAPLang.getStrGroup();
                                    bl3 = true;
                                    if (this.debug) {
                                        this.debugMessageLn("got group");
                                    }
                                } else {
                                    string4 = "*";
                                    if (string3.startsWith("*")) {
                                        this.m_type = LDAPLang.getStrEveryone();
                                        if (this.debug) {
                                            this.debugMessageLn("got *");
                                        }
                                    } else {
                                        string4 = "=";
                                        if (string3.startsWith("=")) {
                                            if (this.debug) {
                                                this.debugMessageLn("got =");
                                            }
                                        } else {
                                            string4 = "\"";
                                            if (string3.startsWith("\"")) {
                                                if (bl) {
                                                    this.m_dn = this.parseDN(string2, nArray, string4, false);
                                                    bl = false;
                                                } else if (bl3) {
                                                    this.m_group = this.parseDN(string2, nArray, string4, false);
                                                    bl3 = false;
                                                } else if (this.debug) {
                                                    this.debugMessageLn("syntax errors.....");
                                                }
                                                if (this.debug) {
                                                    this.debugMessageLn("got \"");
                                                }
                                            } else {
                                                string4 = "(";
                                                if (!string3.startsWith("(")) {
                                                    String string5 = string2.substring(nArray[0]).trim();
                                                    if (bl) {
                                                        this.m_dn = string5;
                                                        return;
                                                    }
                                                    if (bl3) {
                                                        this.m_group = string5;
                                                        return;
                                                    }
                                                    if (bl2) {
                                                        this.m_dnattr = string5;
                                                        return;
                                                    }
                                                    if (this.debug) {
                                                        this.debugMessageLn("syntax error....");
                                                        return;
                                                    }
                                                    break block39;
                                                }
                                                if (bl2) {
                                                    this.m_dnattr = this.parseDN(string2, nArray, string4, true);
                                                    bl2 = false;
                                                }
                                                if (this.debug) {
                                                    this.debugMessageLn("got (");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    nArray[0] = nArray[0] + string4.length();
                }
                return;
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
        }
    }

    String parseDN(String string, int[] nArray, String string2, boolean bl) {
        int n = nArray[0] + string2.length();
        if (bl) {
            int n2 = string.indexOf(")", n);
            if (n2 > 0) {
                return string.substring(n, n2).trim();
            }
        } else {
            int n3 = string.indexOf("\"", n);
            if (n3 > 0) {
                return string.substring(n, n3).trim();
            }
        }
        return string.substring(n).trim();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "adding_and_modifying_user_permissions";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638690: {
                return LDAPLang.getStrGridViewGroupTitle();
            }
        }
        return super.getProp(n);
    }

    public String getByWhoWithoutBindMode() {
        return this.m_byWhomWithoutBindMode;
    }

    public void reset() {
        try {
            this.m_dnattr = " ";
            this.m_dn = " ";
            this.m_group = " ";
            this.m_bindMode = LDAPLang.getStrBindNone();
            this.setProp(1650696, (Object)LDAPLang.getStrBindNone());
            this.setProp(1585158, (Object)"");
            this.setProp(1585153, (Object)"");
            this.setProp(1585159, (Object)"");
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public String toString() {
        if (this.debug) {
            this.debugMessageLn("SelectAccessByWhom::toString() starts...");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrAnentry())) {
            stringBuffer.append("dn=\"" + this.m_dn + "\"");
        } else if (this.m_type.equalsIgnoreCase(LDAPLang.getStrGroup())) {
            stringBuffer.append("group=\"" + this.m_group + "\"");
        } else if (this.m_type.equalsIgnoreCase(LDAPLang.getStrSelf())) {
            stringBuffer.append("self");
        } else if (this.m_type.equalsIgnoreCase(LDAPLang.getStrDnattr())) {
            stringBuffer.append("dnattr=(" + this.m_dnattr + ")");
        } else if (this.m_type.equalsIgnoreCase(LDAPLang.getStrEveryone())) {
            stringBuffer.append("*");
        }
        if (this.debug) {
            this.debugMessageLn("whomStr = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            if (this.debug) {
                this.debugMessageLn("SelectAccessByWhom saveChanges() :");
                this.debugMessageLn("m_bindMode = " + this.m_bindMode);
                this.debugMessageLn("m_type     = " + this.m_type);
                this.debugMessageLn("m_dn       = " + this.m_dn);
                this.debugMessageLn("m_dnattr   = " + this.m_dnattr);
                this.debugMessageLn("m_group    = " + this.m_group);
                int n2 = this.m_permissions.countChildren();
                int n3 = 0;
                while (n3 < n2) {
                    SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.m_permissions.nthChild(n3);
                    this.debugMessage(String.valueOf(selectAccessPermission.getProp(1519616)) + "  :  ");
                    this.debugMessage(" Can = " + selectAccessPermission.getProp(8400897));
                    this.debugMessageLn(" Cannot = " + selectAccessPermission.getProp(8400898));
                    ++n3;
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrAnentry()) && this.m_dn.length() == 0) {
            throw new SaveChangeException(LDAPLang.getStrDnIsNull());
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrDnattr()) && this.m_dnattr.length() == 0) {
            throw new SaveChangeException(LDAPLang.getStrDnattrIsNull());
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrGroup()) && this.m_group.length() == 0) {
            throw new SaveChangeException(LDAPLang.getStrGroupIsNull());
        }
        this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
    }
}

