/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import java.util.Vector;
import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.ByWhomPermission;
import oracle.ldap.admin.ByWhomPermissions;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class SelectAccessToWhat
extends AdminProp {
    static final int PR_TYPE = 1585152;
    static final int PR_DN = 1585153;
    static final int PR_FILTER = 1585154;
    static final int PR_ATTRS = 270020611;
    static final int PR_DNATTR = 1585158;
    static final int PR_GROUP = 1585159;
    static final int PR_BIND_MODE = 1650696;
    static final int PR_ATTR_OP = 1585161;
    static final int PR_ENTRY = 9318404;
    Boolean m_entry = Boolean.TRUE;
    String m_filter = "";
    String m_dn = ".*";
    String[] m_attrs;
    String m_type;
    String m_dnattr = "*";
    String m_group = "*";
    String m_bindMode;
    String m_orgToWhat;
    String m_attrOp = "EQ";
    AccessItem m_aci;
    ByWhomPermissions m_byWhom;
    boolean m_initDnAttrLov = false;
    boolean m_initDnLov = false;
    boolean m_accessToWhat = true;
    boolean debug;

    public boolean isStructureAccess() {
        return this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry());
    }

    public void init(AccessItem accessItem, String string, boolean bl) {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
        if (!bl) {
            this.init(accessItem, string);
            return;
        }
        this.m_aci = accessItem;
        this.m_type = LDAPLang.getStrCompleteEntry();
        this.m_orgToWhat = string;
        this.parse(this.m_orgToWhat);
    }

    public void init(AccessItem accessItem, String string) {
        this.m_aci = accessItem;
        this.m_type = LDAPLang.getStrCompleteEntry();
        this.m_orgToWhat = string;
        String[] stringArray = new String[]{LDAPLang.getStrCompleteEntry(), LDAPLang.getStrPartialEntry()};
        this.registerProp(1585152, LDAPLang.getStrTypePlbl1(), LDAPLang.getStrEmptyString());
        this.registerPropListOfValues(1585152, stringArray);
        String[] stringArray2 = new String[]{LDAPLang.getStrEq(), LDAPLang.getStrNeq()};
        this.registerProp(1585161, LDAPLang.getStrAttrOpPlbl1(), LDAPLang.getStrSpaceString());
        this.registerPropListOfValues(1585161, stringArray2);
        this.registerPropListOfValues(270020611, AdminProp.vectorToObjectArray(this.m_aci.getParent().getAllAttrNames()));
        this.parse(this.m_orgToWhat);
    }

    /*
     * Unable to fully structure code
     */
    public void parse(String var1_1) {
        try {
            if (this.debug) {
                this.debugMessageLn("orgToWhat='" + var1_1 + "'");
            }
            if (var1_1 == null) {
                return;
            }
            var1_1 = var1_1.trim();
            var3_2 = var1_1.length();
            var4_3 = new int[]{0};
            var6_4 = false;
            var7_5 = false;
            while (var4_3[0] < var3_2) {
                block19: {
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    block17: {
                                        AccessItem.skipSpace(var1_1, var4_3);
                                        var5_8 = var1_1.substring(var4_3[0]);
                                        var5_8 = var5_8.toLowerCase();
                                        if (this.debug) {
                                            this.debugMessageLn("toWhat = " + var5_8);
                                        }
                                        var2_6 = "entry";
                                        if (var5_8.startsWith("entry")) break block17;
                                        var2_6 = "entries";
                                        if (!var5_8.startsWith("entries")) break block18;
                                    }
                                    this.m_type = LDAPLang.getStrCompleteEntry();
                                    this.m_dn = var2_6;
                                    if (this.debug) {
                                        this.debugMessageLn("got entry");
                                    }
                                    break block19;
                                }
                                var2_6 = "attrs";
                                if (var5_8.startsWith("attrs")) break block20;
                                var2_6 = "attr";
                                if (!var5_8.startsWith("attr")) break block21;
                            }
                            this.m_type = LDAPLang.getStrPartialEntry();
                            var6_4 = true;
                            if (this.debug) {
                                this.debugMessageLn("got attr");
                            }
                            break block19;
                        }
                        var2_6 = "filter";
                        if (!var5_8.startsWith("filter")) break block22;
                        var7_5 = true;
                        if (this.debug) {
                            this.debugMessageLn("got filter");
                        }
                        break block19;
                    }
                    var2_6 = "=";
                    if (var5_8.startsWith("=")) ** GOTO lbl-1000
                    var2_6 = "!=";
                    if (var5_8.startsWith("!=")) lbl-1000:
                    // 2 sources

                    {
                        if (var6_4) {
                            this.parseAttrs(var1_1, var4_3, var2_6);
                            var2_6 = "=";
                            this.m_attrOp = var5_8.startsWith("=") != false ? LDAPLang.getStrEq() : LDAPLang.getStrNeq();
                            var6_4 = false;
                        } else if (var7_5) {
                            var4_3[0] = var4_3[0] + 1;
                            this.m_filter = this.parseFilter(var1_1, var4_3, var2_6);
                            this.m_filter = this.m_filter.trim();
                            if (!this.m_filter.startsWith("(")) {
                                this.m_filter = "(" + this.m_filter;
                            }
                            if (!this.m_filter.endsWith(")")) {
                                this.m_filter = String.valueOf(this.m_filter) + ")";
                            }
                            var7_5 = false;
                        }
                        if (this.debug) {
                            this.debugMessageLn("got =  or  !=");
                        }
                    } else {
                        var2_6 = " ";
                    }
                }
                var4_3[0] = var4_3[0] + var2_6.length();
            }
            return;
        }
        catch (Exception var2_7) {
            this.unexpectedException(var2_7);
            return;
        }
    }

    String parseFilter(String string, int[] nArray, String string2) {
        int n = string.length();
        int n2 = 0;
        int n3 = nArray[0];
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '(') {
                ++n2;
            } else if (c == ')') {
                if (n2 != 0) {
                    --n2;
                }
                if (n2 == 0) {
                    String string3 = string.substring(nArray[0], n3 + 1);
                    nArray[0] = n3 + 1;
                    if (this.debug) {
                        this.debugMessageLn("parseFilter s=" + string3);
                    }
                    return string3;
                }
            } else if (c == '\\' && n3 + 1 < n) {
                ++n3;
            }
            ++n3;
        }
        if (this.debug) {
            this.debugMessageLn("parseFilter s=null");
        }
        return null;
    }

    void parseAttrs(String string, int[] nArray, String string2) {
        this.m_attrs = AdminProp.vectorToStringArray(this.parseBases(string, nArray, string2));
        if (this.debug) {
            this.debugMessage("parseAttrs:  ");
            int n = 0;
            while (n < this.m_attrs.length) {
                this.debugMessageLn("           m_attrs[" + n + "] = " + this.m_attrs[n]);
                ++n;
            }
        }
    }

    Vector parseBases(String string, int[] nArray, String string2) {
        int n;
        int n2;
        int n3 = nArray[0];
        if (this.debug) {
            this.debugMessageLn("attrs start at i=" + n3);
        }
        Vector<String> vector = new Vector<String>();
        int n4 = n3 + string2.length();
        while ((n2 = string.charAt(n4)) == 32 || n2 == 9) {
            ++n4;
        }
        n2 = n4;
        int n5 = 0;
        if (string.charAt(n2) == '(') {
            n5 = string.indexOf(")", n2);
            nArray[0] = n5 + 1;
            ++n2;
        } else {
            nArray[0] = n5 = string.indexOf(" ", n2);
        }
        if (n5 < 0) {
            nArray[0] = n5 = string.length();
        }
        if (this.debug) {
            this.debugMessageLn("attrs end at endAttrIdx=" + n5);
        }
        String string3 = string.substring(n2, n5);
        if (this.debug) {
            this.debugMessageLn("attrs=" + string3);
        }
        n3 = 0;
        do {
            String string4;
            if ((n = string3.indexOf(",", n3)) < 0) {
                string4 = string3.substring(n3).trim();
                vector.addElement(string4);
                if (!this.debug) break;
                this.debugMessageLn("last attr=" + string4);
                break;
            }
            string4 = string3.substring(n3, n).trim();
            vector.addElement(string4);
            if (!this.debug) continue;
            this.debugMessageLn("attr=" + string4);
        } while ((n3 = n + 1) < string3.length());
        if (this.debug) {
            this.debugMessageLn("done with attrs");
        }
        return vector;
    }

    public SelectAccessToWhat() {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
    }

    public SelectAccessToWhat(AccessItem accessItem, String string, ByWhomPermissions byWhomPermissions) {
        this.init(accessItem, string);
        this.m_byWhom = byWhomPermissions;
    }

    public SelectAccessToWhat(AccessItem accessItem, String string, ByWhomPermissions byWhomPermissions, boolean bl) {
        this.init(accessItem, string, bl);
        this.m_byWhom = byWhomPermissions;
    }

    public Root getRoot() {
        if (this.m_aci != null) {
            return this.m_aci.getParent();
        }
        return null;
    }

    public Root getParent() {
        if (this.m_aci != null) {
            return this.m_aci.getParent();
        }
        return null;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(1585153, LDAPLang.getStrDnPlbl1(), LDAPLang.getStrDnPdsc());
        this.registerProp(1585154, LDAPLang.getStrFilterPlbl(), LDAPLang.getStrFilterPdsc());
        this.registerProp(270020611, LDAPLang.getStrAttrsPlbl(), LDAPLang.getStrAttrsPdsc());
        this.registerProp(9318404, LDAPLang.getStrEntryPlbl(), LDAPLang.getStrEntryPdsc());
        this.registerProp(1585158, LDAPLang.getStrDnattrPlbl(), LDAPLang.getStrDnattrPdsc());
        this.registerProp(1585159, LDAPLang.getStrGroupPlbl(), LDAPLang.getStrDnPdsc());
        this.registerProp(1585161, LDAPLang.getStrAttrOpPlbl1(), LDAPLang.getStrAttrOpPdsc());
    }

    public String getFilter() {
        return this.m_filter;
    }

    public String[] getAttributes() {
        if (this.m_attrs == null) {
            String[] stringArray = new String[]{"*"};
            return stringArray;
        }
        return this.m_attrs;
    }

    public String getAttribute() {
        if (this.m_attrs == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.m_attrs.length) {
            stringBuffer.append(this.m_attrs[n]);
            if (n + 1 < this.m_attrs.length) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getAttrOp() {
        if (this.m_attrOp == null || this.m_attrOp.equalsIgnoreCase(LDAPLang.getStrEq())) {
            return "=";
        }
        return "!=";
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "adding_and_modifying_user_permissions";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638690: {
                return LDAPLang.getStrGridViewGroupTitle1();
            }
            case 0x110001: {
                if (this.m_accessToWhat) {
                    return "Access Item Header Information";
                }
                return "User/Group Header Information";
            }
            case 2031768: {
                return "Select";
            }
            case 3080204: {
                return new Integer(8198);
            }
            case 2687386: {
                return new Integer(2048);
            }
            case 1585152: {
                return this.m_type;
            }
            case 1585153: {
                return this.m_dn;
            }
            case 1585154: {
                return this.m_filter;
            }
            case 270020611: {
                return this.m_attrs;
            }
            case 9318404: {
                return this.m_entry;
            }
            case 1585158: {
                return this.m_dnattr;
            }
            case 1585159: {
                return this.m_group;
            }
            case 1650696: {
                return this.m_bindMode;
            }
            case 1585161: {
                return this.m_attrOp;
            }
            case 276758675: {
                int[] nArray = (int[])this.getProp(282001422);
                Object[] objectArray = (Object[])super.getProp(n);
                if (objectArray == null) {
                    return null;
                }
                Root root = this.getParent();
                if (root != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        switch (nArray[n2]) {
                            case 1585153: 
                            case 1585159: {
                                EntrySelector entrySelector = new EntrySelector(root);
                                objectArray[n2] = entrySelector;
                                break;
                            }
                            case 1585158: 
                            case 270020611: {
                                objectArray[n2] = AdminProp.vectorToObjectArray(root.getAllAttrNames());
                                break;
                            }
                        }
                        ++n2;
                    }
                }
                return objectArray;
            }
            case 282001422: {
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry())) {
                    int[] nArray = new int[]{1585152, 1585154};
                    return nArray;
                }
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry())) {
                    int[] nArray = new int[]{1585152, 1585154, 270020611, 1585161};
                    return nArray;
                }
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrAnentry())) {
                    int[] nArray = new int[]{1650696, 1585152, 1585153};
                    return nArray;
                }
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrDnattr())) {
                    int[] nArray = new int[]{1650696, 1585152, 1585158};
                    return nArray;
                }
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrGroup())) {
                    int[] nArray = new int[]{1650696, 1585152, 1585159};
                    return nArray;
                }
                int[] nArray = new int[]{1650696, 1585152};
                return nArray;
            }
            case 275841152: {
                GridBagConstraints[] gridBagConstraintsArray = null;
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry())) {
                    GridBagConstraints gridBagConstraints;
                    gridBagConstraintsArray = new GridBagConstraints[8];
                    int n3 = 0;
                    gridBagConstraintsArray[n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = -1;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.left = 5;
                    gridBagConstraints.insets.right = 5;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.right = 25;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = -1;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.left = 5;
                    gridBagConstraints.insets.right = 5;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.right = 25;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.left = 5;
                    gridBagConstraints.insets.right = 75;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 3;
                    gridBagConstraints.gridy = n3 / 2;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.right = 25;
                    gridBagConstraintsArray[++n3] = null;
                    gridBagConstraintsArray[++n3] = gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.gridy = n3 / 2 - 1;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = -1;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets.right = 5;
                }
                return gridBagConstraintsArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1585152: {
                this.m_type = (String)object;
                this.sendAdminPropertyChangeEvents(282001422, null);
                if (this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry()) || this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry())) {
                    this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
                }
                return;
            }
            case 1650696: {
                this.m_bindMode = ((String)object).trim();
                return;
            }
            case 1585153: 
            case 1585159: {
                String string = (String)object;
                if (string != null && string.length() >= 0) {
                    if ((string = string.trim()).startsWith(".*")) {
                        String string2 = string.substring(2);
                        if (!(string2 = string2.trim()).startsWith(",")) {
                            throw new PropertyException(LDAPLang.getStrInvalidDn());
                        }
                        string2 = string2.substring(1);
                        string2 = string2.trim();
                        if (this.debug) {
                            this.debugMessageLn("before verify:subDN = '" + string2 + "'");
                        }
                        ((Entry)this.m_aci.m_accessList.getEntry()).verifyDN(string2);
                    } else {
                        ((Entry)this.m_aci.m_accessList.getEntry()).verifyDN(string);
                    }
                    if (n == 1585153) {
                        this.m_dn = string.trim();
                        return;
                    }
                    this.m_group = string.trim();
                }
                return;
            }
            case 1585154: {
                this.m_filter = ((String)object).trim();
                this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
                return;
            }
            case 270020611: {
                this.m_attrs = (String[])object;
                this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
                return;
            }
            case 1585161: {
                this.m_attrOp = ((String)object).trim();
                this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
                return;
            }
            case 9318404: {
                this.m_entry = (Boolean)object;
                return;
            }
            case 1585158: {
                this.m_dnattr = ((String)object).trim();
                return;
            }
            case 7405739: {
                String string = (String)object;
                if (string != null && !string.trim().equals("")) {
                    switch (Character.toLowerCase(string.charAt(0))) {
                        case 'e': {
                            this.m_type = LDAPLang.getStrCompleteEntry();
                            break;
                        }
                        case 'a': 
                        case 'f': {
                            this.m_type = LDAPLang.getStrPartialEntry();
                            break;
                        }
                        default: {
                            this.m_type = LDAPLang.getStrCompleteEntry();
                            break;
                        }
                    }
                }
                super.setProp(n, object);
                return;
            }
        }
        super.setProp(n, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry())) {
            if (this.m_filter.length() > 0) {
                stringBuffer.append("filter=(" + this.m_filter + ") entry");
            } else {
                stringBuffer.append("entry");
            }
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry())) {
            if (this.m_filter.length() > 0) {
                stringBuffer.append("filter=(" + this.m_filter + ") ");
            }
            if (this.m_attrs != null && this.m_attrs.length > 0) {
                if (this.m_attrOp.equalsIgnoreCase(LDAPLang.getStrEq())) {
                    stringBuffer.append("attr=(");
                } else {
                    stringBuffer.append("attr!=(");
                }
                int n = this.m_attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(this.m_attrs[n2]);
                    if (n2 != n - 1) {
                        stringBuffer.append(",");
                    }
                    ++n2;
                }
                stringBuffer.append(")");
            }
        }
        if (this.debug) {
            this.debugMessageLn("SelectAccessToWhat::toString():   val=" + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public boolean isChanged() {
        return true;
    }

    public boolean isEntry() {
        return this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry());
    }

    public boolean isAttr() {
        return this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry());
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.debug) {
            int n2;
            int n3;
            this.debugMessageLn("SelectAccessToWhat saveChanges() :");
            this.debugMessageLn("m_type     = " + this.m_type);
            this.debugMessageLn("m_attrOp   = " + this.m_attrOp);
            this.debugMessageLn("m_filter   = " + this.m_filter);
            if (this.m_attrs != null) {
                n3 = this.m_attrs.length;
                n2 = 0;
                while (n2 < n3) {
                    this.debugMessage("m_attrs[" + n2 + "] = " + this.m_attrs[n2]);
                    ++n2;
                }
            }
            n3 = this.m_byWhom.countChildren();
            n2 = 0;
            while (n2 < n3) {
                try {
                    ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_byWhom.nthChild(n2);
                    this.debugMessageLn(" by whom   = " + byWhomPermission.getProp(1585152));
                    this.debugMessageLn(" bind mode = " + byWhomPermission.getProp(1650690));
                    this.debugMessageLn(" permission= " + byWhomPermission.getProp(1585153));
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
                ++n2;
            }
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry()) && (this.m_attrs == null || this.m_attrs.length == 0)) {
            throw new SaveChangeException(LDAPLang.getStrIncompletePartialEntry());
        }
        if (this.m_byWhom.countChildren() <= 0) {
            throw new SaveChangeException(LDAPLang.getStrUserPermissionIsEmpty());
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrCompleteEntry()) && this.m_byWhom.hasAttrPermissions()) {
            throw new SaveChangeException(LDAPLang.getStrInvalidPermission());
        }
        if (this.m_type.equalsIgnoreCase(LDAPLang.getStrPartialEntry()) && this.m_byWhom.hasEntryPermissions()) {
            throw new SaveChangeException(LDAPLang.getStrInvalidPermission());
        }
        if (this.isChanged() || this.m_byWhom.isChanged()) {
            try {
                this.m_aci.update();
                return;
            }
            catch (PropertyException propertyException) {
                throw new SaveChangeException(LDAPLang.getStrCannotUpdateAi());
            }
        }
    }

    public void reset() {
        try {
            this.m_filter = " ";
            this.m_attrs = null;
            this.m_dn = " ";
            this.setProp(1585154, (Object)"");
            this.setProp(270020611, null);
            this.setProp(1585153, (Object)"");
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }
}

