/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.net.Socket;
import java.util.Vector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.ServerList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Server
extends AdminProp
implements Runnable {
    static final int PR_SERVER = 0x103000;
    static final int PR_PORT = 2109441;
    static final int PR_AVAILABLE = 8794114;
    ServerList m_serverList;
    public String m_server = "";
    public Integer m_port = new Integer(389);
    public boolean m_available;
    public Integer m_timelimit = new Integer(25);
    public Integer m_sizelimit = new Integer(200);
    public Integer m_acpoption = new Integer(0);
    public boolean m_defServer = false;
    public Vector m_acpsearch;
    Thread m_checkThread;

    public Server() {
    }

    public Server(ServerList serverList) {
        this.m_serverList = serverList;
    }

    public Server(ServerList serverList, Server server) {
        this.m_serverList = serverList;
        this.m_server = server.getHost();
        this.m_port = server.getPort();
    }

    public Server(ServerList serverList, String string, Integer n) {
        this.m_serverList = serverList;
        this.m_server = string;
        this.m_port = n;
    }

    public Server(ServerList serverList, String string, Integer n, Integer n2, Integer n3, Integer n4) {
        this.m_serverList = serverList;
        this.m_server = string;
        this.m_port = n;
        this.m_timelimit = n3;
        this.m_sizelimit = n2;
        this.m_acpoption = n4;
    }

    public Server(ServerList serverList, String string, Integer n, Integer n2, Integer n3, Integer n4, Vector vector) {
        this.m_serverList = serverList;
        this.m_server = string;
        this.m_port = n;
        this.m_timelimit = n3;
        this.m_sizelimit = n2;
        this.m_acpoption = n4;
        this.m_acpsearch = vector;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerPropField(0x103000, LDAPLang.getStrHostPlbl(), LDAPLang.getStrHostPdsc(), "m_server");
        this.registerPropField(2109441, LDAPLang.getStrPortPlbl(), LDAPLang.getStrPortPdsc(), "m_port");
        this.registerPropWidth(0x103000, 15);
        this.registerPropWidth(2109441, 15);
        this.registerPropRange(2109441, 0, 65534);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle13();
            }
            case 1048745: {
                return "directory_server_connection";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 8978950: {
                return Boolean.TRUE;
            }
            case 8794114: {
                if (this.m_available) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        return super.getProp(n);
    }

    public synchronized void startCheck() {
        if (this.m_checkThread == null) {
            this.m_checkThread = new Thread(this);
            this.m_checkThread.start();
        }
    }

    public synchronized void stopCheck() {
        this.m_checkThread = null;
    }

    public void checkAvailable() {
        this.startCheck();
    }

    public void run() {
        try {
            Socket socket = new Socket(this.m_server, (int)this.m_port);
            socket.close();
            if (!this.m_available) {
                this.m_available = true;
                this.sendAdminPropertyChangeEvents(8794114, Boolean.TRUE);
            }
            this.stopCheck();
            return;
        }
        catch (Exception exception) {
            if (this.m_available) {
                this.m_available = false;
                this.sendAdminPropertyChangeEvents(8794114, Boolean.FALSE);
            }
            this.stopCheck();
            return;
        }
    }

    public String getHost() {
        return this.m_server;
    }

    public void setHost(String string) {
        this.m_server = string;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public void setPort(Integer n) {
        this.m_port = n;
    }

    public Integer getTimeLimit() {
        return this.m_timelimit;
    }

    public void setTimeLimit(Integer n) {
        this.m_timelimit = n;
    }

    public Integer getSizeLimit() {
        return this.m_sizelimit;
    }

    public void setSizeLimit(Integer n) {
        this.m_sizelimit = n;
    }

    public Integer getAcpOption() {
        return this.m_acpoption;
    }

    public void setAcpOption(Integer n) {
        this.m_acpoption = n;
    }

    public void unsetDefaultServer() {
        this.m_defServer = false;
    }

    public void setDefaultServer() {
        this.m_defServer = true;
    }

    public boolean isDefaultServer() {
        return this.m_defServer;
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_server.trim().equals("")) {
            throw new SaveChangeException(LDAPLang.getStrInvalidServer());
        }
        this.m_serverList.addChildUnique(this);
        this.m_serverList.update();
    }

    public String toString() {
        return String.valueOf(this.m_server) + "@" + this.m_port;
    }

    public String toLine() {
        return String.valueOf(this.m_server) + "@" + this.m_port + "@" + this.m_sizelimit + "@" + this.m_timelimit + "@" + this.m_acpoption + "@" + this.m_defServer + "\n";
    }

    public ServerList getServerList() {
        return this.m_serverList;
    }

    public void addAcpsSearch(String string) {
        if (this.m_acpsearch == null) {
            this.m_acpsearch = new Vector();
        }
        this.m_acpsearch.addElement(string);
    }

    public int getSearchCount() {
        if (this.m_acpsearch != null) {
            return this.m_acpsearch.size();
        }
        return 0;
    }

    public String getSearchStringAt(int n) {
        if (this.m_acpsearch != null) {
            return (String)this.m_acpsearch.elementAt(n);
        }
        return null;
    }
}

