/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.io.IOException;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.ServerAccessCreator;
import oracle.ldap.admin.common.AdminProp;
import oracle.sumatra.net.ldap.ILDAPRequest;
import oracle.sumatra.net.ldap.LDAPAddResponse;
import oracle.sumatra.net.ldap.LDAPBindRequest;
import oracle.sumatra.net.ldap.LDAPBindResponse;
import oracle.sumatra.net.ldap.LDAPDelResponse;
import oracle.sumatra.net.ldap.LDAPEvent;
import oracle.sumatra.net.ldap.LDAPListener;
import oracle.sumatra.net.ldap.LDAPModifyResponse;
import oracle.sumatra.net.ldap.LDAPSearchResponse;
import oracle.sumatra.net.ldap.LDAPSession;

abstract class ServerAccessListener
extends ServerAccessCreator
implements LDAPListener {
    LDAPSession m_client;
    String m_user = "";
    String m_password = "";
    String m_host = "";
    int m_port;
    int m_requestCount;
    int m_ignoreBoundCallback;

    public ServerAccessListener() {
    }

    public ServerAccessListener(String string, String string2, String string3, int n) {
        if (Root.debugServerAccess) {
            System.out.println("ServerAccessListener constructor");
        }
        this.initInstance(string, string2, string3, n, false, "", "", "", null);
    }

    public void initInstance(String string, String string2, String string3, int n, boolean bl, String string4, String string5, String string6, Root root) {
        this.m_user = string;
        this.m_password = string2;
        this.m_host = string3;
        this.m_port = n;
        this.initClient();
    }

    public void initClient() {
        this.m_client = this.m_port != 389 ? new LDAPSession(this.m_host, this.m_port) : new LDAPSession(this.m_host);
        this.m_client.addLDAPListener((LDAPListener)this);
    }

    public void connected(LDAPEvent lDAPEvent) {
        try {
            LDAPBindRequest lDAPBindRequest = new LDAPBindRequest(2, this.m_user, 0, this.m_password);
            this.debugMessageLn("Connected to " + this.m_host);
            this.setStatusMessage(LDAPLang.getStrBinding());
            this.setConnected(true);
            this.m_client.send((ILDAPRequest)lDAPBindRequest, null);
            return;
        }
        catch (IOException iOException) {
            this.debugMessageLn("Unable to bind to " + this.m_host + " " + iOException);
            return;
        }
    }

    public void bound(LDAPEvent lDAPEvent) {
        LDAPBindResponse lDAPBindResponse = lDAPEvent.getBindResponse();
        if (lDAPBindResponse != null && lDAPBindResponse.getResultCode() != 0) {
            this.setStatusMessage("Failed to bind to server: " + this.m_host);
            this.setErrorMessage(this.getErrorMessage("Bind", lDAPBindResponse.getResultCode(), lDAPBindResponse.getErrorMessage()));
            AdminProp.errorMessageLn(this.getErrorMessage("Bind", lDAPBindResponse.getResultCode(), lDAPBindResponse.getErrorMessage()));
            this.m_bConnectionOk = false;
            this.m_bBindFailed = true;
            return;
        }
        this.setBound(true);
        if (this.isDebug()) {
            this.debugMessageLn("Succeeded in binding to " + this.m_host);
        }
        this.m_bConnectionOk = true;
        this.doBoundCallback();
    }

    public void doBoundCallback() {
    }

    public void connectFailed(LDAPEvent lDAPEvent) {
        this.setStatusMessage(LDAPLang.getStrConnectFailed());
        this.debugMessageLn("Unable to connect to " + this.m_host + " " + lDAPEvent.getError());
        this.setErrorMessage("Unable to connect to " + this.m_host + " " + lDAPEvent.getError());
        this.m_bConnectionOk = false;
        this.m_bBindFailed = true;
    }

    public void searched(LDAPEvent lDAPEvent) {
        LDAPSearchResponse lDAPSearchResponse;
        if (this.isDebug()) {
            this.debugMessageLn("Search completed: requestCount=" + this.m_requestCount);
        }
        if ((lDAPSearchResponse = lDAPEvent.getSearchResponse()) != null && lDAPSearchResponse.getResultCode() != 0) {
            String string = this.getErrorMessage(LDAPLang.getStrSearch(), lDAPSearchResponse.getResultCode(), lDAPSearchResponse.getErrorMessage());
            new Exception("Searched found an error=" + string).printStackTrace();
            this.debugMessageLn(string);
            this.setErrorMessage(string);
            if (this.m_requestCount != 0) {
                this.m_bConnectionOk = false;
            }
            if (this.m_bConnecting) {
                this.m_bConnecting = false;
                this.m_bConnectionOk = false;
            }
        }
        if (this.m_requestCount != 0) {
            --this.m_requestCount;
            if (this.m_requestCount == 0) {
                this.m_bDataReady = true;
            }
        }
        this.m_searchStarted = false;
    }

    public synchronized void searchFoundEntry(LDAPEvent lDAPEvent) {
    }

    public void added(LDAPEvent lDAPEvent) {
        LDAPAddResponse lDAPAddResponse;
        Object object = lDAPEvent.getUserParm();
        if (this.isDebug()) {
            this.debugMessageLn("modified completed" + object.toString());
        }
        if ((lDAPAddResponse = lDAPEvent.getAddResponse()) != null && lDAPAddResponse.getResultCode() != 0) {
            String string = this.getErrorMessage("Add", lDAPAddResponse.getResultCode(), lDAPAddResponse.getErrorMessage());
            this.debugMessageLn(string);
            this.setErrorMessage(string);
        } else {
            this.m_bAddOk = true;
        }
        this.m_bAddDone = true;
    }

    public void deleted(LDAPEvent lDAPEvent) {
        LDAPDelResponse lDAPDelResponse;
        Object object = lDAPEvent.getUserParm();
        if (Root.debugDeleteEntry) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.debugMessageLn("delete request completed = " + object.toString());
        }
        if ((lDAPDelResponse = lDAPEvent.getDelResponse()) != null && lDAPDelResponse.getResultCode() != 0) {
            String string = this.getErrorMessage("Delete", lDAPDelResponse.getResultCode(), lDAPDelResponse.getErrorMessage());
            string = String.valueOf(string) + "\n dn=" + object.toString();
            this.debugMessageLn(string);
            this.setErrorMessage(string);
            if (Root.debugDeleteEntry) {
                this.debugMessageLn("delete error= " + string);
                this.setDebug(false);
            }
        } else {
            if (this.isDebug()) {
                this.debugMessageLn("delete ok");
            }
            this.m_bDeleteOk = true;
        }
        if (Root.debugDeleteEntry) {
            this.setDebug(false);
        }
        this.m_bDeleteDone = true;
    }

    public void modified(LDAPEvent lDAPEvent) {
        LDAPModifyResponse lDAPModifyResponse;
        Object object = lDAPEvent.getUserParm();
        if (this.isDebug()) {
            this.debugMessageLn("modified completed" + object.toString());
        }
        if ((lDAPModifyResponse = lDAPEvent.getModifyResponse()) != null && lDAPModifyResponse.getResultCode() != 0) {
            String string = this.getErrorMessage("Modify", lDAPModifyResponse.getResultCode(), lDAPModifyResponse.getErrorMessage());
            this.debugMessageLn(string);
            this.setErrorMessage(string);
        } else {
            this.m_bModifyOk = true;
        }
        this.m_bModifyDone = true;
    }

    public void modifiedRdn(LDAPEvent lDAPEvent) {
    }

    public void compared(LDAPEvent lDAPEvent) {
    }

    protected void finalize() {
        if (this.m_client != null) {
            this.m_client.removeLDAPListener((LDAPListener)this);
            this.m_client = null;
        }
    }

    public void setErrorMessage(String string) {
        super.setErrorMessage(string);
    }

    public String getErrorMessage(String string, int n, String string2) {
        if (string2 == null || string2.equals("")) {
            switch (n) {
                case 0: {
                    string2 = LDAPLang.getStrErrSuccess();
                    break;
                }
                case 1: {
                    string2 = LDAPLang.getStrErrOperationError();
                    break;
                }
                case 2: {
                    string2 = LDAPLang.getStrErrProtocolError();
                    break;
                }
                case 3: {
                    string2 = LDAPLang.getStrErrTimeLimitExceeded();
                    break;
                }
                case 4: {
                    string2 = LDAPLang.getStrErrSizeLimitExceeded();
                    break;
                }
                case 5: {
                    string2 = LDAPLang.getStrErrCompareFalse();
                    break;
                }
                case 6: {
                    string2 = LDAPLang.getStrErrCompareTrue();
                    break;
                }
                case 7: {
                    string2 = LDAPLang.getStrErrAuthMethodNotSupported();
                    break;
                }
                case 8: {
                    string2 = LDAPLang.getStrErrStrongAuthRequired();
                    break;
                }
                case 9: {
                    string2 = LDAPLang.getStrErrPartialResults();
                    break;
                }
                case 10: {
                    string2 = LDAPLang.getStrErrReferral();
                    break;
                }
                case 11: {
                    string2 = LDAPLang.getStrErrAdminlimitExceeded();
                    break;
                }
                case 12: {
                    string2 = LDAPLang.getStrErrUnavailableCriticalExtension();
                    break;
                }
                case 16: {
                    string2 = LDAPLang.getStrErrNoSuchAttribute();
                    break;
                }
                case 17: {
                    string2 = LDAPLang.getStrErrUndefinedAttributeType();
                    break;
                }
                case 18: {
                    string2 = LDAPLang.getStrErrInappropriateMatching();
                    break;
                }
                case 19: {
                    string2 = LDAPLang.getStrErrConstraintViolation();
                    break;
                }
                case 20: {
                    string2 = LDAPLang.getStrErrAttributeOrValueExists();
                    break;
                }
                case 21: {
                    string2 = LDAPLang.getStrErrInvalidAttributeSyntax();
                    break;
                }
                case 32: {
                    string2 = LDAPLang.getStrErrNoSuchObject();
                    break;
                }
                case 33: {
                    string2 = LDAPLang.getStrErrAliasProblem();
                    break;
                }
                case 34: {
                    string2 = LDAPLang.getStrErrInvalidDnSyntax();
                    break;
                }
                case 35: {
                    string2 = LDAPLang.getStrErrIsLeaf();
                    break;
                }
                case 36: {
                    string2 = LDAPLang.getStrErrAliasDereferencingProblem();
                    break;
                }
                case 48: {
                    string2 = LDAPLang.getStrErrInappropriateAuthentication();
                    break;
                }
                case 49: {
                    string2 = LDAPLang.getStrErrInvalidCredentials();
                    break;
                }
                case 50: {
                    string2 = LDAPLang.getStrErrInsufficientAccessRights();
                    break;
                }
                case 51: {
                    string2 = LDAPLang.getStrErrBusy();
                    break;
                }
                case 52: {
                    string2 = LDAPLang.getStrErrUnavailable();
                    break;
                }
                case 53: {
                    string2 = LDAPLang.getStrErrUnwillingToPerform();
                    break;
                }
                case 54: {
                    string2 = LDAPLang.getStrErrcwLoopDetect();
                    break;
                }
                case 64: {
                    string2 = LDAPLang.getStrErrNamingViolation();
                    break;
                }
                case 65: {
                    string2 = LDAPLang.getStrErrObjectClassViolation();
                    break;
                }
                case 66: {
                    string2 = LDAPLang.getStrErrNotAllowedOnNonleaf();
                    break;
                }
                case 67: {
                    string2 = LDAPLang.getStrErrNotAllowedOnRDN();
                    break;
                }
                case 68: {
                    string2 = LDAPLang.getStrErrEntryAlreadyExists();
                    break;
                }
                case 69: {
                    string2 = LDAPLang.getStrErrObjectClassModsProhibited();
                    break;
                }
                case 70: {
                    string2 = LDAPLang.getStrErrResultsTooLarge();
                    break;
                }
                case 80: {
                    string2 = LDAPLang.getStrErrOther();
                    break;
                }
                case 81: {
                    string2 = LDAPLang.getStrErrCannotContactLdapServer();
                    break;
                }
                case 82: {
                    string2 = LDAPLang.getStrErrLocalError();
                    break;
                }
                case 83: {
                    string2 = LDAPLang.getStrEncodingError();
                    break;
                }
                case 84: {
                    string2 = LDAPLang.getStrErrDecodingError();
                    break;
                }
                case 85: {
                    string2 = LDAPLang.getStrErrTimeOut();
                    break;
                }
                case 86: {
                    string2 = LDAPLang.getStrErrUnknownAuthError();
                    break;
                }
                case 87: {
                    string2 = LDAPLang.getStrErrBadSearchFilter();
                    break;
                }
                case 88: {
                    string2 = LDAPLang.getStrErrUserCancelledOperation();
                    break;
                }
                case 89: {
                    string2 = LDAPLang.getStrErrBadParameter();
                    break;
                }
                case 90: {
                    string2 = LDAPLang.getStrErrOutOfMemory();
                    break;
                }
                default: {
                    string2 = LDAPLang.getStrUnknown();
                    break;
                }
            }
        }
        if (n == 80) {
            try {
                this.shutdown();
                this.initClient();
                ++this.m_ignoreBoundCallback;
                this.connect();
                string2 = String.valueOf(string2) + "\n\nNOTE:\nThe connection to the server was successfully reestablished!\nPlease try your operation again.";
            }
            catch (Exception exception) {
                string2 = String.valueOf(string2) + "\n\nAttempt reestablished connection failed.\nPlease logout and logon again.\nReconnect error due to:\n" + exception;
            }
        }
        if (n == 4) {
            return String.valueOf(string) + " " + LDAPLang.getStrIncomplete() + ".\n" + LDAPLang.getStrResultCode() + "=" + n + "\n\n" + LDAPLang.getStrDetails() + ":\n" + string2;
        }
        return String.valueOf(string) + " " + LDAPLang.getStrFailed() + ".\n" + LDAPLang.getStrHost() + "='" + this.m_host + "'\n" + LDAPLang.getStrErrorCode() + "=" + n + "\n\n" + LDAPLang.getStrDetails() + ":\n" + string2;
    }

    public abstract boolean connect();

    public abstract void shutdown();
}

