/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.io.IOException;
import java.util.Vector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.ServerAccessListener;
import oracle.ldap.admin.common.AdminDirectory;
import oracle.sumatra.net.ldap.ILDAPFilter;
import oracle.sumatra.net.ldap.ILDAPRequest;
import oracle.sumatra.net.ldap.LDAPAddRequest;
import oracle.sumatra.net.ldap.LDAPAttribute;
import oracle.sumatra.net.ldap.LDAPAttributeValueAssertion;
import oracle.sumatra.net.ldap.LDAPDelRequest;
import oracle.sumatra.net.ldap.LDAPFilterAnd;
import oracle.sumatra.net.ldap.LDAPFilterApproxMatch;
import oracle.sumatra.net.ldap.LDAPFilterEqualityMatch;
import oracle.sumatra.net.ldap.LDAPFilterGreaterOrEqual;
import oracle.sumatra.net.ldap.LDAPFilterLessOrEqual;
import oracle.sumatra.net.ldap.LDAPFilterNot;
import oracle.sumatra.net.ldap.LDAPFilterOr;
import oracle.sumatra.net.ldap.LDAPFilterPresent;
import oracle.sumatra.net.ldap.LDAPFilterSubStrings;
import oracle.sumatra.net.ldap.LDAPListener;
import oracle.sumatra.net.ldap.LDAPModification;
import oracle.sumatra.net.ldap.LDAPModifyRequest;
import oracle.sumatra.net.ldap.LDAPSearchRequest;
import oracle.sumatra.net.ldap.LDAPUnbindRequest;

class ServerAccessWrappers
extends ServerAccessListener {
    static int MAX_ATTR_CUTOFF = 400;

    public ServerAccessWrappers() {
    }

    public ServerAccessWrappers(String string, String string2, String string3, int n) {
        super(string, string2, string3, n);
        if (Root.debugServerAccess) {
            System.out.println("ServerAccessWrapper constructor");
        }
    }

    public void shutdown() {
        if (this.m_client == null) {
            return;
        }
        LDAPUnbindRequest lDAPUnbindRequest = new LDAPUnbindRequest();
        try {
            this.m_client.send((ILDAPRequest)lDAPUnbindRequest, null);
        }
        catch (IOException iOException) {
            this.unexpectedException(iOException);
        }
        try {
            this.m_client.disconnect();
        }
        catch (IOException iOException) {
            this.unexpectedException(iOException);
        }
        this.m_client.removeLDAPListener((LDAPListener)this);
        this.m_client = null;
    }

    public boolean connect() {
        if (Root.debugServerAccess) {
            System.out.println("ServerAccessSumatra::connect(),  m_requestCount= " + this.m_requestCount);
        }
        this.m_client.connect();
        try {
            int n = 0;
            if (this.isDebug()) {
                this.debugMessageLn("Waiting for logon to complete");
            }
            String string = "Waiting for logon";
            this.setStatusMessage(string);
            this.m_bBindFailed = false;
            this.m_bConnectionOk = true;
            this.m_bDataReady = false;
            this.m_bConnecting = true;
            while (!this.m_bDataReady && n++ < 300 && this.m_bConnecting && !this.m_bBindFailed) {
                if (this.isDebug()) {
                    this.debugMessage(".0");
                }
                string = String.valueOf(string) + ".";
                this.setStatusMessage(string);
                Thread.sleep(500L);
            }
            this.m_bConnecting = false;
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
            if (this.isDebug()) {
                if (n >= 60) {
                    this.debugMessageLn("timeout at 60 and count got to = " + n);
                }
                this.debugMessageLn("Done waiting for logon to complete.");
                if (n == 40) {
                    this.debugMessageLn("waiting for logon incomplete.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        return this.m_bConnectionOk;
    }

    public void disconnect() throws Exception {
        this.m_client.disconnect();
    }

    public void unbind() throws Exception {
        LDAPUnbindRequest lDAPUnbindRequest = new LDAPUnbindRequest();
        this.m_client.send((ILDAPRequest)lDAPUnbindRequest, null);
    }

    public int saveEntry(String string, Object[] objectArray) {
        this.m_bModifyOk = false;
        if (!this.isBound()) {
            return 4;
        }
        LDAPModification[] lDAPModificationArray = (LDAPModification[])objectArray;
        if (Root.debugSaveEntry) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.debugMessageLn("Saving entry=" + string);
        }
        if (lDAPModificationArray != null && lDAPModificationArray.length != 0) {
            try {
                this.m_client.send((ILDAPRequest)new LDAPModifyRequest(string, lDAPModificationArray), (Object)"ModifyRequest");
            }
            catch (IOException iOException) {
                this.unexpectedException(iOException);
                return 4;
            }
            if (this.isDebug()) {
                this.debugMessageLn("Waiting for save to complete");
            }
            this.m_bModifyDone = false;
            try {
                int n = 0;
                this.isDebug();
                this.debugMessageLn("Modify Entry");
                String string2 = "Waiting for save ";
                this.setStatusMessage(string2);
                while (!this.m_bModifyDone && n++ < 50 && this.m_bConnectionOk) {
                    if (this.isDebug()) {
                        this.debugMessage(".6");
                    }
                    string2 = String.valueOf(string2) + ".";
                    this.setStatusMessage(string2);
                    Thread.sleep(500L);
                }
                if (this.isDebug()) {
                    this.debugMessageLn("");
                }
            }
            catch (InterruptedException interruptedException) {
                this.unexpectedException(interruptedException);
            }
        } else {
            this.setErrorMessage("Didn't get any attributes to modify!");
        }
        if (this.m_bModifyOk) {
            return 2;
        }
        return 1;
    }

    public int addEntry(String string, Object[] objectArray) {
        block36: {
            try {
                if (!this.isBound()) {
                    return 4;
                }
                this.m_bAddOk = false;
                if (Root.debugSaveEntry) {
                    this.setDebug(true);
                }
                if (this.isDebug()) {
                    this.debugMessageLn("\nServerAccess.addEntry(): Entered");
                }
                LDAPAttribute[] lDAPAttributeArray = (LDAPAttribute[])objectArray;
                if (this.isDebug()) {
                    this.debugMessageLn("Adding entry with DN=" + string);
                }
                if (lDAPAttributeArray != null && lDAPAttributeArray.length != 0) {
                    if (this.isDebug()) {
                        this.debugMessageLn("Submitting request new attr count=" + lDAPAttributeArray.length);
                    }
                    Object[] objectArray2 = null;
                    if (lDAPAttributeArray.length > MAX_ATTR_CUTOFF) {
                        if (Root.debugServerAccess) {
                            System.out.println("attrs should be truncated length=" + lDAPAttributeArray.length);
                        }
                        LDAPAttribute[] lDAPAttributeArray2 = new LDAPAttribute[MAX_ATTR_CUTOFF];
                        int n = 0;
                        while (n < MAX_ATTR_CUTOFF) {
                            lDAPAttributeArray2[n] = lDAPAttributeArray[n];
                            ++n;
                        }
                        objectArray2 = new LDAPModification[lDAPAttributeArray.length - MAX_ATTR_CUTOFF];
                        if (Root.debugServerAccess) {
                            System.out.println("reminder=" + objectArray2.length);
                        }
                        int n2 = 0;
                        while (n2 < objectArray2.length) {
                            objectArray2[n2] = new LDAPModification(0, lDAPAttributeArray[n2 + MAX_ATTR_CUTOFF]);
                            ++n2;
                        }
                        lDAPAttributeArray = lDAPAttributeArray2;
                    }
                    try {
                        this.m_client.send((ILDAPRequest)new LDAPAddRequest(string, lDAPAttributeArray), (Object)"AddRequest");
                    }
                    catch (IOException iOException) {
                        this.unexpectedException(iOException);
                        return 4;
                    }
                    if (this.isDebug()) {
                        this.debugMessageLn("Waiting for add request to complete");
                    }
                    this.m_bAddDone = false;
                    try {
                        int n = 0;
                        this.isDebug();
                        if (this.isDebug()) {
                            this.debugMessageLn("Add Entry");
                        }
                        String string2 = "Waiting for add ";
                        this.setStatusMessage(string2);
                        while (!this.m_bAddDone && n++ < 50 && this.m_bConnectionOk) {
                            if (this.isDebug()) {
                                this.debugMessage(".7");
                            }
                            string2 = String.valueOf(string2) + ".";
                            this.setStatusMessage(string2);
                            Thread.sleep(500L);
                        }
                        if (this.isDebug()) {
                            this.debugMessageLn("");
                        }
                        if (n == 50) {
                            if (this.isDebug()) {
                                this.debugMessageLn("ServerAccess.addEntry(): (TIMEDOUT) Returned\n");
                            }
                            return 3;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.unexpectedException(interruptedException);
                    }
                    if (objectArray2 != null) {
                        if (Root.debugServerAccess) {
                            System.out.println("doing save ...");
                        }
                        switch (this.saveEntry(string, objectArray2)) {
                            case 3: {
                                if (Root.debugServerAccess) {
                                    System.out.println("timed out.");
                                }
                                return 3;
                            }
                            case 1: {
                                if (Root.debugServerAccess) {
                                    System.out.println("error out.");
                                }
                                return 1;
                            }
                        }
                        if (Root.debugServerAccess) {
                            System.out.println("successful. done save ...");
                        }
                    }
                    break block36;
                }
                this.setErrorMessage("Didn't get any attributes");
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
        }
        if (this.isDebug()) {
            this.debugMessageLn("ServerAccess.addEntry(): Returned\n");
        }
        if (Root.debugSaveEntry) {
            this.setDebug(false);
        }
        if (this.m_bAddOk) {
            return 2;
        }
        return 1;
    }

    public int deleteEntry(String string) {
        if (!this.isBound()) {
            return 4;
        }
        this.m_bDeleteOk = false;
        if (Root.debugDeleteEntry) {
            this.setDebug(true);
        }
        if (this.isDebug()) {
            this.debugMessageLn("Delete entry dn=" + string);
        }
        try {
            this.m_client.send((ILDAPRequest)new LDAPDelRequest(string), (Object)string);
        }
        catch (IOException iOException) {
            this.unexpectedException(iOException);
            return 4;
        }
        if (this.isDebug()) {
            System.out.println("waiting for delete to complete");
        }
        this.setErrorMessage("");
        this.m_bDeleteDone = false;
        try {
            int n = 0;
            this.debugMessageLn("Delete Entry");
            String string2 = "Waiting for delete ";
            this.setStatusMessage(string2);
            while (!this.m_bDeleteDone && n++ < 50 && this.m_bConnectionOk) {
                if (this.isDebug()) {
                    this.debugMessage(".8");
                }
                string2 = String.valueOf(string2) + ".";
                this.setStatusMessage(string2);
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        if (this.m_bDeleteOk) {
            return 2;
        }
        return 1;
    }

    public boolean findEntry(String[] stringArray, int[] nArray, String string, boolean bl, String[] stringArray2, Object object, int n, int n2, String[] stringArray3) throws IOException {
        int n3 = 2;
        if (bl) {
            n3 = 3;
        }
        return this.findEntry(stringArray, nArray, string, n3, stringArray2, object, n, n2, stringArray3);
    }

    public boolean findEntry(String[] stringArray, int[] nArray, String string, int n, String[] stringArray2, Object object, int n2, int n3, String[] stringArray3) throws IOException {
        int n4;
        int n5;
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (this.isDebug()) {
            this.debugMessageLn("search for entry rooted at baseDN=" + string);
        }
        Vector<LDAPFilterPresent> vector = new Vector<LDAPFilterPresent>(stringArray.length);
        int n6 = 0;
        while (n6 < stringArray.length) {
            LDAPFilterPresent lDAPFilterPresent;
            switch (nArray[n6]) {
                case 5: {
                    lDAPFilterPresent = new LDAPFilterGreaterOrEqual(new LDAPAttributeValueAssertion(stringArray3[n6], stringArray[n6]));
                    break;
                }
                case 6: {
                    lDAPFilterPresent = new LDAPFilterLessOrEqual(new LDAPAttributeValueAssertion(stringArray3[n6], stringArray[n6]));
                    break;
                }
                case 7: {
                    lDAPFilterPresent = new LDAPFilterPresent(stringArray3[n6]);
                    break;
                }
                case 8: {
                    lDAPFilterPresent = new LDAPFilterApproxMatch(new LDAPAttributeValueAssertion(stringArray3[n6], stringArray[n6]));
                    break;
                }
                case 4: {
                    lDAPFilterPresent = new LDAPFilterEqualityMatch(new LDAPAttributeValueAssertion(stringArray3[n6], stringArray[n6]));
                    break;
                }
                default: {
                    switch (nArray[n6]) {
                        case 2: {
                            n5 = 0;
                            break;
                        }
                        case 3: {
                            n5 = 2;
                            break;
                        }
                        default: {
                            n5 = 1;
                        }
                    }
                    lDAPFilterPresent = new LDAPFilterSubStrings(stringArray3[n6], n5, stringArray[n6]);
                }
            }
            vector.addElement(lDAPFilterPresent);
            ++n6;
        }
        switch (n) {
            case 1: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            default: {
                n4 = 2;
            }
        }
        if (this.isDebug()) {
            this.debugMessageLn("searchType=" + n4);
        }
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string, n4, 1, n2, n3, false, (ILDAPFilter)(vector.size() == 1 ? (ILDAPFilter)vector.elementAt(0) : new LDAPFilterAnd(vector)), stringArray2);
        this.setStatusMessage(LDAPLang.getStrSearching());
        this.m_searchStarted = true;
        this.m_client.send((ILDAPRequest)lDAPSearchRequest, object);
        try {
            n5 = 0;
            String string2 = LDAPLang.getStrSearching();
            this.setStatusMessage(string2);
            int n7 = 50;
            if (n3 != 0) {
                n7 = n3;
            }
            while (this.m_searchStarted && n5++ < n7 * 2 && this.m_bConnectionOk) {
                if (this.isDebug()) {
                    this.debugMessage(".1");
                }
                string2 = String.valueOf(string2) + ".";
                this.setStatusMessage(string2);
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
        return !this.m_searchStarted;
    }

    public ILDAPFilter buildFilter(Object object) {
        ILDAPFilter iLDAPFilter = null;
        if (!(object instanceof String)) {
            Object object2 = AdminDirectory.criteriaGetOperator(object);
            int n = AdminDirectory.criteriaGetArity(object);
            if (object2 instanceof Integer) {
                String string = (String)AdminDirectory.criteriaGetOperand(object, 0);
                String string2 = (String)AdminDirectory.criteriaGetOperand(object, 1);
                switch ((Integer)object2) {
                    case 5: {
                        iLDAPFilter = new LDAPFilterGreaterOrEqual(new LDAPAttributeValueAssertion(string, string2));
                        break;
                    }
                    case 6: {
                        iLDAPFilter = new LDAPFilterLessOrEqual(new LDAPAttributeValueAssertion(string, string2));
                        break;
                    }
                    case 7: {
                        iLDAPFilter = new LDAPFilterPresent(string);
                        break;
                    }
                    case 8: {
                        iLDAPFilter = new LDAPFilterApproxMatch(new LDAPAttributeValueAssertion(string, string2));
                        break;
                    }
                    case 4: {
                        iLDAPFilter = new LDAPFilterEqualityMatch(new LDAPAttributeValueAssertion(string, string2));
                        break;
                    }
                    default: {
                        int n2 = 0;
                        switch ((Integer)object2) {
                            case 2: {
                                n2 = 0;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                                break;
                            }
                            default: {
                                n2 = 1;
                            }
                        }
                        iLDAPFilter = new LDAPFilterSubStrings(string, n2, string2);
                    }
                }
                return iLDAPFilter;
            }
            String string = object2.toString();
            if (string.startsWith("!")) {
                iLDAPFilter = this.buildFilter(AdminDirectory.criteriaGetOperand(object, 0));
                if (iLDAPFilter == null) {
                    return null;
                }
                return new LDAPFilterNot(iLDAPFilter);
            }
            if (string.startsWith("|")) {
                if (n == 1) {
                    return this.buildFilter(AdminDirectory.criteriaGetOperand(object, 0));
                }
                Vector<ILDAPFilter> vector = new Vector<ILDAPFilter>();
                int n3 = 0;
                while (n3 < n) {
                    iLDAPFilter = this.buildFilter(AdminDirectory.criteriaGetOperand(object, n3));
                    if (iLDAPFilter == null) {
                        return null;
                    }
                    vector.addElement(iLDAPFilter);
                    ++n3;
                }
                return new LDAPFilterOr(vector);
            }
            if (string.startsWith("&")) {
                if (n == 1) {
                    return this.buildFilter(AdminDirectory.criteriaGetOperand(object, 0));
                }
                Vector<ILDAPFilter> vector = new Vector<ILDAPFilter>();
                int n4 = 0;
                while (n4 < n) {
                    iLDAPFilter = this.buildFilter(AdminDirectory.criteriaGetOperand(object, n4));
                    if (iLDAPFilter == null) {
                        return null;
                    }
                    vector.addElement(iLDAPFilter);
                    ++n4;
                }
                return new LDAPFilterAnd(vector);
            }
        }
        return iLDAPFilter;
    }

    public boolean findEntry(String string, Object object, String string2, int n, String[] stringArray, Object object2, int n2, int n3) throws IOException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (this.isDebug()) {
            this.debugMessageLn("search for entry rooted at baseDN=" + string2);
        }
        ILDAPFilter iLDAPFilter = this.buildFilter(object);
        if (this.isDebug()) {
            this.debugMessageLn("filter=" + iLDAPFilter);
        }
        if (iLDAPFilter == null) {
            this.setErrorMessage("Search aborted. Couldn't create low level filter from input: " + string);
            return false;
        }
        switch (n) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        if (this.isDebug()) {
            this.debugMessageLn("searchType=" + n);
        }
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string2, n, 1, n2, n3, false, iLDAPFilter, stringArray);
        this.setStatusMessage(LDAPLang.getStrSearching());
        this.m_searchStarted = true;
        this.m_client.send((ILDAPRequest)lDAPSearchRequest, object2);
        if (this.isDebug()) {
            this.debugMessageLn("sent request=" + lDAPSearchRequest);
            this.debugMessageLn("searchStarted=" + this.m_searchStarted);
            this.debugMessageLn("connectionOK=" + this.m_bConnectionOk);
        }
        try {
            int n4 = 0;
            String string3 = LDAPLang.getStrSearching();
            this.setStatusMessage(string3);
            int n5 = 50;
            if (n3 != 0) {
                n5 = n3;
            }
            while (this.m_searchStarted && n4++ < n5 * 2 && this.m_bConnectionOk) {
                if (this.isDebug()) {
                    this.debugMessage(".2");
                }
                string3 = String.valueOf(string3) + ".";
                this.setStatusMessage(string3);
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
        return !this.m_searchStarted;
    }

    public int findObject(String string, String[] stringArray, Object object) throws IOException {
        if (string == null) {
            string = "";
        }
        if (this.isDebug()) {
            this.debugMessageLn("findObject at dn='" + string + "'");
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        LDAPFilterPresent lDAPFilterPresent = new LDAPFilterPresent("objectclass");
        LDAPSearchRequest lDAPSearchRequest = new LDAPSearchRequest(string, 0, 1, 0, 0, false, (ILDAPFilter)lDAPFilterPresent, stringArray);
        this.m_client.send((ILDAPRequest)lDAPSearchRequest, object);
        try {
            int n = 0;
            if (this.isDebug()) {
                this.debugMessageLn("searchStarted=" + this.m_searchStarted);
                this.debugMessageLn("bConnectionOk=" + this.m_bConnectionOk);
            }
            String string2 = LDAPLang.getStrSearching();
            this.setStatusMessage(string2);
            while (this.m_searchStarted && n++ < 50 && this.m_bConnectionOk) {
                if (this.isDebug()) {
                    this.debugMessage(".3");
                }
                string2 = String.valueOf(string2) + ".";
                this.setStatusMessage(string2);
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
        return 2;
    }

    public boolean findObjectSync(String string, String[] stringArray, Object object) throws IOException {
        if (this.isDebug()) {
            this.debugMessageLn("findObjectSync at dn='" + string + "'");
        }
        this.setStatusMessage(LDAPLang.getStrSearching());
        this.m_searchStarted = false;
        this.findObject(string, stringArray, object);
        this.m_searchStarted = true;
        try {
            int n = 0;
            String string2 = LDAPLang.getStrSearching();
            if (this.isDebug()) {
                this.debugMessageLn("findObjectSync.searchStarted=" + this.m_searchStarted);
                this.debugMessageLn("findObjectSync.bConnectionOk=" + this.m_bConnectionOk);
            }
            this.setStatusMessage(string2);
            while (this.m_searchStarted && n++ < 50 && this.m_bConnectionOk) {
                if (this.isDebug()) {
                    this.debugMessage(".4");
                }
                string2 = String.valueOf(string2) + ".";
                this.setStatusMessage(string2);
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
            if (n >= 50 && this.isDebug()) {
                System.out.println("findObjectSync: timed out. count=" + n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
        return !this.m_searchStarted;
    }

    public int addAttributeValue(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string3};
        return this.modifyAttributeValue(string, string2, stringArray, 1);
    }

    public int replaceAttributeValue(String string, String string2, String[] stringArray) throws Exception {
        return this.modifyAttributeValue(string, string2, stringArray, 2);
    }

    public int deleteAttributeValue(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string3};
        return this.modifyAttributeValue(string, string2, stringArray, 4);
    }

    public int modifyAttributeValue(String string, String string2, String[] stringArray, int n) throws Exception {
        this.setErrorMessage("");
        if (this.isDebug()) {
            this.debugMessageLn("Modify Entry at =" + string + "\n    Attribute =" + string2);
            if (this.isDebug()) {
                switch (n) {
                    case 2: {
                        this.debugMessageLn("Operation = REPLACE");
                        break;
                    }
                    case 4: {
                        this.debugMessageLn("Operation = DELETE");
                        break;
                    }
                    default: {
                        this.debugMessageLn("Operation = ADD");
                    }
                }
            }
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.debugMessageLn("    value=" + stringArray[n2]);
                    ++n2;
                }
            }
        }
        if (stringArray == null) {
            this.debugMessageLn("Couldn't change attribute value: " + string2);
            return 4;
        }
        switch (n) {
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{new LDAPModification(n, new LDAPAttribute(string2, stringArray))};
        this.m_client.send((ILDAPRequest)new LDAPModifyRequest(string, lDAPModificationArray), (Object)"ModifyAttributeRequest");
        this.setErrorMessage("");
        this.m_bModifyOk = false;
        this.m_bModifyDone = false;
        try {
            int n3 = 0;
            boolean bl = this.isDebug();
            if (bl) {
                this.debugMessageLn("Modify ACL");
            }
            while (!this.m_bModifyDone && n3++ < 60 && this.m_bConnectionOk) {
                if (bl) {
                    this.debugMessage(".5");
                }
                Thread.sleep(500L);
            }
            if (this.isDebug()) {
                this.debugMessageLn("");
            }
            if (n3 == 60) {
                return 3;
            }
        }
        catch (InterruptedException interruptedException) {
            this.unexpectedException(interruptedException);
        }
        if (this.m_bModifyOk) {
            return 2;
        }
        return 1;
    }
}

