/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.io.IOException;
import java.util.Vector;
import oracle.ldap.admin.LDAPAttributeNet8;
import oracle.ldap.admin.LDAPEventNet8;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.LDAPModificationNet8;
import oracle.ldap.admin.LDAPSearchEntryNet8;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.ServerAccessCreatorNet8;
import oracle.net.ldap.NNFLUpdateParam;
import oracle.net.ldap.NNFLWrapper;

class ServerAccessWrappersNet8
extends ServerAccessCreatorNet8 {
    private static final String AUTH_NONE = "Anonymous";
    private static final String AUTH_SIMPLE = "Simple";
    private static final String AUTH_SSL_NOAUTH = "1";
    private static final String AUTH_SSL_ONEWAY = "32";
    private static final String AUTH_SSL_TWOWAY = "64";
    static String[] opAttrs = new String[]{"createtimestamp", "creatorsname", "modifytimestamp", "modifiersname"};

    public ServerAccessWrappersNet8() {
    }

    public ServerAccessWrappersNet8(String string, String string2, String string3, int n, boolean bl, String string4, String string5, String string6, Root root) {
        this.initInstance(string, string2, string3, n, bl, string4, string5, string6, root);
    }

    public void initInstance(String string, String string2, String string3, int n, boolean bl, String string4, String string5, String string6, Root root) {
        this.m_user = string;
        this.m_password = string2;
        this.m_host = string3;
        this.m_port = n;
        this.m_sslEnabled = bl;
        this.m_sslLocation = string5;
        this.m_sslPassword = string6;
        this.m_root = root;
        this.debug = Root.DEBUG;
        if (this.debug) {
            System.out.println("initInstance:: sslLevel=" + string4);
        }
        if (this.m_user == null && this.m_password == null && !this.m_sslEnabled) {
            if (this.debug) {
                System.out.println("NNFL_AUTH_NONE");
            }
            this.m_sslLevel = 0;
        } else if (!this.m_sslEnabled) {
            if (this.debug) {
                System.out.println("NNFL_AUTH_SIMPLE");
            }
            this.m_sslLevel = 1;
        } else if (string4.equalsIgnoreCase(AUTH_SSL_NOAUTH)) {
            if (this.debug) {
                System.out.println("NNFL_AUTH_SSL_NOAUTH");
            }
            this.m_sslLevel = 5;
        } else if (string4.equalsIgnoreCase(AUTH_SSL_ONEWAY)) {
            if (this.debug) {
                System.out.println("NNFL_AUTH_SSL_ONEWAY");
            }
            this.m_sslLevel = 6;
        } else if (string4.equalsIgnoreCase(AUTH_SSL_TWOWAY)) {
            if (this.debug) {
                System.out.println("NNFL_AUTH_SSL_TWOWAY");
            }
            this.m_sslLevel = 7;
        } else {
            if (this.debug) {
                System.out.println("NNFL_AUTH_NONE");
            }
            this.m_sslLevel = 0;
        }
        this.m_session = new NNFLWrapper();
        if (this.debug) {
            this.setDebug(true);
        }
        if (this.debug) {
            System.out.println("ServerAccessWrapper constructor:");
        }
        if (this.debug) {
            System.out.println("   user=" + this.m_user + " password=" + "xxxxxxx" + " host=" + this.m_host + " port=" + this.m_port + " sslLevel=" + this.m_sslLevel + " sslLocation=" + this.m_sslLocation + " sslPassword=" + "xxxxxx");
        }
    }

    public void shutdown() {
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::shutdown() Entered");
        }
        if (this.m_isConnected) {
            this.m_session.closeConn();
        }
    }

    public boolean connect() {
        String[] stringArray;
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::connect() Entered");
        }
        if (this.debug) {
            this.debugMessageLn("calling setAuthInfo()");
        }
        boolean bl = this.m_isConnected = this.m_session.setAuthInfo(this.m_sslLevel, stringArray = new String[]{this.m_sslLocation, this.m_sslPassword}) == 0;
        if (this.debug) {
            this.debugMessageLn("finishing setAuthInfo():  m_isConnected=" + this.m_isConnected);
        }
        if (this.debug) {
            this.debugMessageLn("calling openBindConn()");
        }
        boolean bl2 = this.m_isConnected = this.m_session.openBindConn(this.m_host, this.m_port, this.m_user, this.m_password, this.m_sslLevel, this.m_connAttr) == 0;
        if (this.debug) {
            this.debugMessageLn("finishing openBindConn(): m_isConnected=" + this.m_isConnected);
        }
        if (this.m_isConnected) {
            this.setBound(true);
            this.m_root.doBoundCallback();
        } else {
            this.setErrorMessage(LDAPLang.getStrBindFailed());
        }
        return this.m_isConnected;
    }

    public int saveEntry(String string, Object[] objectArray) {
        Object object;
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            this.setErrorMessage(string2);
            return 1;
        }
        int n = 0;
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::saveEntry() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return 4;
        }
        LDAPModificationNet8[] lDAPModificationNet8Array = (LDAPModificationNet8[])objectArray;
        if (this.debug) {
            this.debugMessageLn("Saving entry=" + string);
        }
        if (this.debug) {
            this.debugMessageLn("mods.length= " + lDAPModificationNet8Array.length);
        }
        int n2 = 0;
        while (n == 0 && n2 < lDAPModificationNet8Array.length) {
            object = lDAPModificationNet8Array[n2].getAttr();
            NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[1];
            if (this.debug) {
                this.debugMessageLn("attr.getType()= " + ((LDAPAttributeNet8)object).getType());
            }
            if (!this.isOperationalAttr(((LDAPAttributeNet8)object).getType())) {
                String[] stringArray;
                if (!((LDAPAttributeNet8)object).getType().equalsIgnoreCase("orclsupassword") && this.debug && ((LDAPAttributeNet8)object).getValues() != null) {
                    String[] stringArray2 = ((LDAPAttributeNet8)object).getValues();
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        this.debugMessageLn("val[" + n3 + "] = " + stringArray2[n3]);
                        ++n3;
                    }
                }
                int n4 = lDAPModificationNet8Array[n2].getOperation();
                if (this.debug) {
                    this.debugMessageLn("operation= " + n4);
                }
                if ((stringArray = ((LDAPAttributeNet8)object).getValues()) == null || stringArray.length == 0) {
                    String[] stringArray3 = new String[]{""};
                    nNFLUpdateParamArray[0] = new NNFLUpdateParam(((LDAPAttributeNet8)object).getType(), stringArray3);
                } else {
                    nNFLUpdateParamArray[0] = new NNFLUpdateParam(((LDAPAttributeNet8)object).getType(), stringArray);
                }
                n = this.m_session.updateEntry(string, "", nNFLUpdateParamArray, n4);
            }
            ++n2;
        }
        if (n != 0) {
            if (this.debug) {
                this.debugMessageLn("updateEntry() fail !");
            }
            object = this.getErrorMessage(LDAPLang.getStrModify(), n, "");
            this.setErrorMessage((String)object);
        }
        if (n == 0) {
            return 2;
        }
        return 1;
    }

    public int addEntry(String string, Object[] objectArray) {
        Object object;
        Object object2;
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            this.setErrorMessage(string2);
            return 1;
        }
        int n = 0;
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::addEntry() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return 4;
        }
        if (this.debug) {
            this.debugMessageLn("Adding entry with DN=" + string);
        }
        LDAPAttributeNet8[] lDAPAttributeNet8Array = (LDAPAttributeNet8[])objectArray;
        if (this.debug) {
            this.debugMessageLn("Saving entry=" + string);
        }
        if (this.debug) {
            this.debugMessageLn("attrs.length= " + lDAPAttributeNet8Array.length);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < lDAPAttributeNet8Array.length) {
            String string3;
            object2 = lDAPAttributeNet8Array[n3];
            String[] stringArray = ((LDAPAttributeNet8)object2).getValues();
            if (stringArray != null && stringArray.length != 0 && !this.isOperationalAttr(string3 = ((LDAPAttributeNet8)object2).getType())) {
                ++n2;
            }
            ++n3;
        }
        object2 = new NNFLUpdateParam[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < lDAPAttributeNet8Array.length) {
            String string4;
            object = lDAPAttributeNet8Array[n4];
            String[] stringArray = ((LDAPAttributeNet8)object).getValues();
            if (this.debug) {
                this.debugMessageLn("attr.getType()= " + ((LDAPAttributeNet8)object).getType());
            }
            if (this.debug && stringArray != null) {
                int n6 = 0;
                while (n6 < stringArray.length) {
                    this.debugMessageLn("val[" + n6 + "] = " + stringArray[n6]);
                    ++n6;
                }
            }
            if (stringArray != null && stringArray.length != 0 && !this.isOperationalAttr(string4 = ((LDAPAttributeNet8)object).getType())) {
                object2[n5++] = new NNFLUpdateParam(((LDAPAttributeNet8)object).getType(), stringArray);
            }
            ++n4;
        }
        n = this.m_session.updateEntry(string, "", (NNFLUpdateParam[])object2, 0);
        if (n != 0) {
            if (this.debug) {
                this.debugMessageLn("updateEntry() fail !");
            }
            object = this.getErrorMessage(LDAPLang.getStrAdd(), n, "");
            this.setErrorMessage((String)object);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::addEntry(): Returned\n");
        }
        if (n == 0) {
            return 2;
        }
        return 1;
    }

    public int deleteEntry(String string) {
        int n;
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            this.setErrorMessage(string2);
            return 1;
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::deleteEntry() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return 4;
        }
        if (this.debug) {
            this.debugMessageLn("Deleting entry with DN=" + string);
        }
        if ((n = this.m_session.deleteNamedEntry(string)) != 0) {
            if (this.debug) {
                this.debugMessageLn("deleteNamedEntry() fail !");
            }
            String string3 = this.getErrorMessage(LDAPLang.getStrDelete(), n, "");
            this.setErrorMessage(string3);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::deleteEntry(): Returned\n");
        }
        if (n == 0) {
            return 2;
        }
        return 1;
    }

    private String[] modifyAttrFilters(String[] stringArray) {
        if (!this.m_root.isServerGreaterThan("2.0.6")) {
            return stringArray;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{"*"};
        }
        String[] stringArray2 = new String[stringArray.length + 4];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        stringArray2[n++] = opAttrs[0];
        stringArray2[n++] = opAttrs[1];
        stringArray2[n++] = opAttrs[2];
        stringArray2[n++] = opAttrs[3];
        return stringArray2;
    }

    private boolean isOperationalAttr(String string) {
        int n = 0;
        while (n < opAttrs.length) {
            if (string.equalsIgnoreCase(opAttrs[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean findEntry(String[] stringArray, int[] nArray, String string, boolean bl, String[] stringArray2, Object object, int n, int n2, String[] stringArray3) throws IOException {
        int n3 = 2;
        if (bl) {
            n3 = 3;
        }
        return this.findEntry(stringArray, nArray, string, n3, stringArray2, object, n, n2, stringArray3);
    }

    public boolean findEntry(String[] stringArray, int[] nArray, String string, int n, String[] stringArray2, Object object, int n2, int n3, String[] stringArray3) throws IOException {
        int n4;
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            throw new IOException(string2);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findEntry() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return false;
        }
        if (this.debug) {
            int n5;
            this.debugMessage("queryVals =");
            int n6 = 0;
            while (n6 < stringArray.length) {
                this.debugMessage(" " + stringArray[n6]);
                ++n6;
            }
            this.debugMessageLn("");
            this.debugMessage("queryOps =");
            n4 = 0;
            while (n4 < nArray.length) {
                this.debugMessage(" " + nArray[n4]);
                ++n4;
            }
            this.debugMessageLn("");
            this.debugMessageLn("baseDN = " + string);
            this.debugMessageLn("depth = " + n);
            if (stringArray2 == null || stringArray2.length == 0) {
                this.debugMessageLn("attributeFilter = null");
            } else {
                this.debugMessage("attributeFilter =");
                n5 = 0;
                while (n5 < stringArray2.length) {
                    this.debugMessage(" " + stringArray2[n5]);
                    ++n5;
                }
                this.debugMessageLn("");
            }
            this.debugMessageLn("maxResults = " + n2);
            this.debugMessageLn("maxTime = " + n3);
            this.debugMessage("queryFlds =");
            n5 = 0;
            while (n5 < stringArray3.length) {
                this.debugMessage(" " + stringArray3[n5]);
                ++n5;
            }
            this.debugMessageLn("");
        }
        String string3 = null;
        if (stringArray == null || stringArray.length == 0) {
            string3 = null;
        } else {
            n4 = 0;
            while (n4 < stringArray.length) {
                switch (nArray[n4]) {
                    case 5: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + ">=" + stringArray[n4]);
                        break;
                    }
                    case 6: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "<=" + stringArray[n4]);
                        break;
                    }
                    case 7: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "=*");
                        break;
                    }
                    case 8: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "~=" + stringArray[n4]);
                        break;
                    }
                    case 4: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "=" + stringArray[n4]);
                        break;
                    }
                    case 2: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "=*" + stringArray[n4]);
                        break;
                    }
                    case 3: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "=" + stringArray[n4] + "*");
                        break;
                    }
                    case 1: {
                        string3 = new String(String.valueOf(stringArray3[n4]) + "=*" + stringArray[n4] + "*");
                        break;
                    }
                    default: {
                        string3 = null;
                        if (!this.debug) break;
                        this.debugMessageLn("Invalid operation:" + nArray[n4]);
                    }
                }
                ++n4;
            }
        }
        if (this.debug) {
            this.debugMessageLn("filter = " + string3);
        }
        switch (n) {
            case 1: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            default: {
                n4 = 2;
            }
        }
        if (this.isDebug()) {
            this.debugMessageLn("searchType=" + n4);
        }
        if (this.debug) {
            this.debugMessageLn("begin queryByFilter()");
        }
        this.m_session.setOptions(4, n3);
        this.m_session.setOptions(3, n2);
        if (n4 == 0 || stringArray2 == null) {
            stringArray2 = this.modifyAttrFilters(stringArray2);
        }
        int n7 = this.m_session.queryByFilter(string, n4, string3, stringArray2, false);
        if (this.debug) {
            this.debugMessageLn("end queryByFilter()");
        }
        if (n7 != 0) {
            String string4 = this.getErrorMessage(LDAPLang.getStrSearch(), n7, "");
            this.setErrorMessage(string4);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::findEntry(): Returned\n");
            }
            if (n7 != 4) {
                return false;
            }
        }
        if (this.debug) {
            this.debugMessageLn("begin getNextEntry()");
        }
        while ((n7 = this.m_session.getNextEntry()) == 0) {
            if (this.debug) {
                this.debugMessageLn("find DN : " + this.m_session.currDN);
            }
            Vector<LDAPAttributeNet8> vector = new Vector<LDAPAttributeNet8>();
            while ((n7 = this.m_session.getAttrValues()) == 0) {
                vector.addElement(new LDAPAttributeNet8(this.m_session.currAttr, this.m_session.currVals));
                if (!this.debug) continue;
                int n8 = 0;
                while (n8 < this.m_session.numVals) {
                    this.debugMessage("    " + this.m_session.currAttr + "=");
                    this.debugMessageLn(this.m_session.currVals[n8]);
                    ++n8;
                }
            }
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before vectorToObjectArray()");
            }
            Object[] objectArray = new LDAPAttributeNet8[vector.size()];
            vector.copyInto(objectArray);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before new LDAPSearchEntryNet8()");
            }
            LDAPSearchEntryNet8 lDAPSearchEntryNet8 = new LDAPSearchEntryNet8(this.m_session.currDN, (LDAPAttributeNet8[])objectArray);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before new LDAPEventNet8()");
            }
            LDAPEventNet8 lDAPEventNet8 = new LDAPEventNet8(lDAPSearchEntryNet8, object);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before m_root.searchFoundEntry()");
            }
            this.m_root.searchFoundEntry(lDAPEventNet8);
        }
        if (this.debug) {
            this.debugMessageLn("end getNextEntry()");
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findEntry(): Returned\n");
        }
        return true;
    }

    public boolean findEntry(String string, Object object, String string2, int n, String[] stringArray, Object object2, int n2, int n3) throws IOException {
        if (!this.m_root.isRunning()) {
            String string3 = LDAPLang.getStrServerDown();
            throw new IOException(string3);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findEntry(ldapSearchString) Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return false;
        }
        if (this.debug) {
            this.debugMessage("ldapSearchString =" + string);
            this.debugMessageLn("baseDN = " + string2);
            this.debugMessageLn("searchType = " + n);
            if (stringArray == null || stringArray.length == 0) {
                this.debugMessageLn("attributeFilter = null");
            } else {
                this.debugMessage("attributeFilter =");
                int n4 = 0;
                while (n4 < stringArray.length) {
                    this.debugMessage(" " + stringArray[n4]);
                    ++n4;
                }
                this.debugMessageLn("");
            }
            this.debugMessageLn("maxResults = " + n2);
            this.debugMessageLn("maxTime = " + n3);
            this.debugMessageLn("");
        }
        switch (n) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        if (this.isDebug()) {
            this.debugMessageLn("searchType=" + n);
        }
        if (this.debug) {
            this.debugMessageLn("begin queryByFilter()");
        }
        this.m_session.setOptions(4, n3);
        this.m_session.setOptions(3, n2);
        if (n == 0 || stringArray == null) {
            stringArray = this.modifyAttrFilters(stringArray);
        }
        int n5 = this.m_session.queryByFilter(string2, n, string, stringArray, false);
        if (this.debug) {
            this.debugMessageLn("end queryByFilter()");
        }
        if (n5 != 0) {
            String string4 = this.getErrorMessage(LDAPLang.getStrSearch(), n5, "");
            this.setErrorMessage(string4);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::findEntry(ldapsearchString): Returned\n");
            }
            if (n5 != 4) {
                return false;
            }
        }
        if (this.debug) {
            this.debugMessageLn("begin getNextEntry()");
        }
        while ((n5 = this.m_session.getNextEntry()) == 0) {
            if (this.debug) {
                this.debugMessageLn("find DN : " + this.m_session.currDN);
            }
            Vector<LDAPAttributeNet8> vector = new Vector<LDAPAttributeNet8>();
            while ((n5 = this.m_session.getAttrValues()) == 0) {
                vector.addElement(new LDAPAttributeNet8(this.m_session.currAttr, this.m_session.currVals));
                if (!this.debug) continue;
                int n6 = 0;
                while (n6 < this.m_session.numVals) {
                    this.debugMessage("    " + this.m_session.currAttr + "=");
                    this.debugMessageLn(this.m_session.currVals[n6]);
                    ++n6;
                }
            }
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before vectorToObjectArray()");
            }
            Object[] objectArray = new LDAPAttributeNet8[vector.size()];
            vector.copyInto(objectArray);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before new LDAPSearchEntryNet8()");
            }
            LDAPSearchEntryNet8 lDAPSearchEntryNet8 = new LDAPSearchEntryNet8(this.m_session.currDN, (LDAPAttributeNet8[])objectArray);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before new LDAPEventNet8()");
            }
            LDAPEventNet8 lDAPEventNet8 = new LDAPEventNet8(lDAPSearchEntryNet8, object2);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::before m_root.searchFoundEntry()");
            }
            this.m_root.searchFoundEntry(lDAPEventNet8);
        }
        if (this.debug) {
            this.debugMessageLn("end getNextEntry()");
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findEntry(): Returned\n");
        }
        return true;
    }

    public int findObject(String string, String[] stringArray, Object object) throws IOException {
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            throw new IOException(string2);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findObject() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return 4;
        }
        if (this.debug) {
            this.debugMessageLn("find entry with DN=" + string);
        }
        stringArray = this.modifyAttrFilters(stringArray);
        if (this.debug) {
            this.debugMessageLn("begin queryByFilter()");
        }
        int n = this.m_session.queryByFilter(string, 0, "objectclass=*", stringArray, false);
        if (this.debug) {
            this.debugMessageLn("end queryByFilter()");
        }
        if (n != 0) {
            String string3 = this.getErrorMessage(LDAPLang.getStrSearch(), n, "");
            this.setErrorMessage(string3);
            if (this.debug) {
                this.debugMessageLn("ServerAccessWrapper::findObject(): Returned\n");
            }
            return 1;
        }
        if (this.debug) {
            this.debugMessageLn("begin getNextEntry()");
        }
        while ((n = this.m_session.getNextEntry()) == 0) {
            if (this.debug) {
                this.debugMessageLn("find DN : " + this.m_session.currDN);
            }
            Vector<LDAPAttributeNet8> vector = new Vector<LDAPAttributeNet8>();
            while ((n = this.m_session.getAttrValues()) == 0) {
                vector.addElement(new LDAPAttributeNet8(this.m_session.currAttr, this.m_session.currVals));
                if (!this.debug) continue;
                int n2 = 0;
                while (n2 < this.m_session.numVals) {
                    this.debugMessage("    " + this.m_session.currAttr + "=");
                    this.debugMessageLn(this.m_session.currVals[n2]);
                    ++n2;
                }
            }
            if (this.debug) {
                this.debugMessageLn("before vectorToObjectArray()");
            }
            Object[] objectArray = new LDAPAttributeNet8[vector.size()];
            vector.copyInto(objectArray);
            if (this.debug) {
                this.debugMessageLn("before new LDAPSearchEntryNet8()");
            }
            LDAPSearchEntryNet8 lDAPSearchEntryNet8 = new LDAPSearchEntryNet8(this.m_session.currDN, (LDAPAttributeNet8[])objectArray);
            if (this.debug) {
                this.debugMessageLn("before new LDAPEventNet8()");
            }
            LDAPEventNet8 lDAPEventNet8 = new LDAPEventNet8(lDAPSearchEntryNet8, object);
            if (this.debug) {
                this.debugMessageLn("before m_root.searchFoundEntry()");
            }
            this.m_root.searchFoundEntry(lDAPEventNet8);
        }
        if (this.debug) {
            this.debugMessageLn("end getNextEntry()");
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findObject(): Returned\n");
        }
        return 2;
    }

    public boolean findObjectSync(String string, String[] stringArray, Object object) throws IOException {
        if (!this.m_root.isRunning()) {
            String string2 = LDAPLang.getStrServerDown();
            throw new IOException(string2);
        }
        int n = 0;
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findObjectSync() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return false;
        }
        if (this.debug) {
            this.debugMessageLn("find entry with DN=" + string);
        }
        if ((n = this.findObject(string, stringArray, object)) != 2) {
            this.setErrorMessage("findObjectSync() failed!");
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::findObjectSync(): Returned\n");
        }
        return n == 2;
    }

    public int addAttributeValue(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string3};
        return this.modifyAttributeValue(string, string2, stringArray, 1);
    }

    public int replaceAttributeValue(String string, String string2, String[] stringArray) throws Exception {
        return this.modifyAttributeValue(string, string2, stringArray, 3);
    }

    public int deleteAttributeValue(String string, String string2, String string3) throws Exception {
        String[] stringArray = new String[]{string3};
        return this.modifyAttributeValue(string, string2, stringArray, 2);
    }

    public int modifyAttributeValue(String string, String string2, String[] stringArray, int n) throws Exception {
        int n2;
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::modifyAttributeValue() Entered");
        }
        if (!this.m_isConnected) {
            this.setErrorMessage(LDAPLang.getStrNotConnectToServer());
            return 4;
        }
        if (this.debug) {
            this.debugMessageLn("modify attribute : DN=" + string);
        }
        NNFLUpdateParam[] nNFLUpdateParamArray = new NNFLUpdateParam[]{new NNFLUpdateParam(string2, stringArray)};
        if (this.debug) {
            this.debugMessageLn("attr= " + string2);
            this.debugMessageLn("values= ");
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.debugMessageLn("    values[" + n3 + "]=" + stringArray[n3]);
                ++n3;
            }
            this.debugMessageLn("operation= " + n);
        }
        if ((n2 = this.m_session.updateEntry(string, "", nNFLUpdateParamArray, n)) != 0) {
            if (this.debug) {
                this.debugMessageLn("updateEntry() fail !");
            }
            String string3 = this.getErrorMessage(LDAPLang.getStrModify(), n2, "");
            this.setErrorMessage(string3);
        }
        if (this.debug) {
            this.debugMessageLn("ServerAccessWrapper::modifyAttributeValue(): Returned\n");
        }
        if (n2 == 0) {
            return 2;
        }
        return 1;
    }
}

