/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Hashtable;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class StructBindMode
extends AdminProp {
    public static String DEFAULT_BIND_MODE = "";
    public static final int PR_BIND_MODE = 0x103000;
    StructAccessItem m_ai;
    static Hashtable m_bindModes;
    String m_bindMode;

    public StructBindMode(StructAccessItem structAccessItem, String string) {
        this.m_ai = structAccessItem;
        if (string == null) {
            string = "";
        }
        this.m_bindMode = string;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103000, LDAPLang.getStrBindmodesPlbl(), LDAPLang.getStrEmptyString());
        if (m_bindModes == null) {
            m_bindModes = new Hashtable();
            m_bindModes.put("", LDAPLang.getStrBindNone());
            m_bindModes.put("Simple", LDAPLang.getStrSimple());
            m_bindModes.put("SSLNoAuth", LDAPLang.getStrSslNoAuth());
            m_bindModes.put("SSLOneWay", LDAPLang.getStrSslOneWay());
            m_bindModes.put("SSLTwoWay", LDAPLang.getStrSslTwoWay());
        }
        this.registerPropListOfValues(0x103000, m_bindModes);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: {
                return LDAPLang.getStrTabName();
            }
            case 3080204: {
                return new Integer(8192);
            }
            case 0x103000: {
                return this.m_bindMode;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x103000: {
                this.m_bindMode = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        this.m_ai.setBindMode(this.m_bindMode);
    }
}

