/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.AppServer;
import oracle.ldap.admin.appserver.AuthenticationException;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminRoot;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AppServerUser
extends AdminProp
implements Serializable,
ICommandParent {
    static boolean DEBUG;
    public static int CMD_REFRESH;
    static final int AUTH_REPOSITORY = 1;
    static final int AUTH_OS = 2;
    static final int AUTH_LDAP = 10;
    static final int AUTH_MSGING = 20;
    static final int AUTH_WEBCON = 25;
    static final int AUTH_WKFLOW = 30;
    static final int AUTH_DOCMGMT = 35;
    static final int AUTH_THIRD_PARTY = 100;
    static final int ADMIN_USER_ID = 1;
    static final int LOGON_TITLE = 10;
    static final int ADMIN_USER = 11;
    static final int CANNOT_LOAD = 30;
    static final int INVALID_PASSWD = 31;
    static final int PR_USERNAME = 0x108800;
    static final int PR_USERID = 3115009;
    static final int PR_AUTHTYPE = 0x208802;
    static final int PR_AUTHCLASS = 2066435;
    static final int PR_PASSWORD = 13666308;
    static final int PR_CONFIRM_PASSWORD = 13666309;
    static final int PR_PROFILES = 269518854;
    Repository m_pstore;
    String m_name;
    String m_passwd;
    transient String m_confirmPasswd;
    int m_id;
    Vector m_profiles;
    transient IAdminProp[] m_cmdList;
    transient AdminProp m_root;
    transient int m_authType;
    transient String m_authClass;
    transient IAdminProp m_authObj;
    transient int m_authProps;
    private transient AdminList m_parent;
    transient AdminProp m_kid;

    public AppServerUser() {
        this.init();
    }

    public AppServerUser(Repository repository, AdminList adminList) {
        this.init();
        this.m_pstore = repository;
        this.m_parent = adminList;
    }

    public AppServerUser(String string, Repository repository) {
        this.init();
        this.m_pstore = repository;
        this.m_name = this.getMessage(11);
        this.m_passwd = string;
        this.m_id = 1;
    }

    public AppServerUser(String string, String string2, Repository repository) {
        this.init();
        this.m_name = string;
        this.m_passwd = string2;
        this.m_pstore = repository;
    }

    private void init() {
        this.m_pstore = null;
        this.m_parent = null;
        this.m_name = null;
        this.m_passwd = null;
        this.m_confirmPasswd = null;
        this.m_id = -1;
        this.m_profiles = new Vector();
        this.m_kid = null;
        this.m_authType = -1;
        this.m_authClass = null;
        this.m_authObj = null;
        this.m_authProps = -1;
        this.registerProp(269518854, "Profiles", "Profiles of AdminServer user");
        this.registerProp(13666308, "Password", "Password of AdminServer user");
        this.registerProp(13666309, "Confirm Password", "Type the password again to confirm changes.");
        this.registerProp(0x108800, "Username", "Name of AdminServer user");
        this.registerProp(3115009, "User Id", "Internal id of AdminServer user");
        this.registerProp(0x208802, "Authentication Method", "Method used to authenticate user");
        this.registerProp(2066435, "Authentication Class", "Name of Java class implementing authentication method");
        this.registerMessage(11, "admin");
        this.registerMessage(10, "InterOffice Profile Repository Logon");
        this.registerMessage(30, "Login failed -- Could not load Authentication mechnism.");
        this.registerMessage(31, "The user information you specified is incorrect.");
    }

    private IAdminProp loadAuthObj() throws Exception {
        if (this.m_authClass == null) {
            throw new Exception("No authentication info");
        }
        try {
            Class<?> clazz = Class.forName(this.m_authClass);
            Object var2_3 = null;
            if (clazz != null) {
                var2_3 = clazz.newInstance();
            }
            if (var2_3 instanceof IAdminProp) {
                IAdminProp iAdminProp = var2_3;
                return iAdminProp;
            }
            AdminProp.errorMessageLn(String.valueOf(this.getMessage(30)) + this.m_authClass);
            return null;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isAdminUser() {
        return this.m_name.equals(this.getMessage(11)) || this.m_id == 1;
    }

    public void clearKid() {
        this.m_kid = null;
    }

    public void authenticateUser(String string) throws AuthenticationException {
        String string2 = string;
        if (this.m_passwd == null) {
            this.m_passwd = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!this.m_passwd.equals(string2)) {
            throw new AuthenticationException(this.getMessage(31));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getPassword() {
        return this.m_passwd;
    }

    public int getAuthType() {
        return this.m_authType;
    }

    public String[] getProfiles() {
        if (this.m_profiles == null || this.m_profiles.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_profiles.size()];
        int n = 0;
        while (n < this.m_profiles.size()) {
            stringArray[n] = (String)this.m_profiles.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public boolean isUsingProfile(String string) {
        int n = 0;
        while (n < this.m_profiles.size()) {
            String string2 = (String)this.m_profiles.elementAt(n);
            if (string2 == string) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setPassword(String string) {
        this.m_passwd = string;
    }

    public void setParent(AdminList adminList) {
        this.m_parent = adminList;
    }

    public void addProfile(String string) {
        this.m_profiles.addElement(string);
    }

    public void setAuthType(int n) {
        switch (n) {
            case 1: {
                this.m_authType = 1;
                return;
            }
            case 10: {
                this.m_authType = 10;
                this.m_authClass = "oracle.ldap.admin.server.ldap.root";
                return;
            }
            case 20: {
                this.m_authType = 20;
                this.m_authClass = "oracle.ldap.admin.server.msging.Session";
                return;
            }
            case 25: {
                this.m_authType = 25;
                this.m_authClass = "oracle.ldap.admin.server.webcntr.WCRoot";
                return;
            }
            case 35: {
                this.m_authType = 35;
                this.m_authClass = "oracle.ldap.admin.server.dmadmin.DMRoot";
                return;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x108800: {
                return this.m_name;
            }
            case 13666308: {
                return this.m_passwd;
            }
            case 13666309: {
                if (this.m_confirmPasswd == null) {
                    return this.m_passwd;
                }
                return this.m_confirmPasswd;
            }
            case 269518854: {
                return this.getProfiles();
            }
            case 0x110001: {
                return this.m_name;
            }
            case 2686979: {
                return new Integer(3);
            }
            case 276758675: {
                int[] nArray = (int[])this.getProp(282001422);
                if (nArray == null || nArray.length == 0) {
                    return null;
                }
                Object[] objectArray = new Object[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    switch (nArray[n2]) {
                        case 269518854: {
                            objectArray[n2] = null;
                            if (this.m_pstore == null) break;
                            objectArray[n2] = AdminProp.vectorToObjectArray(this.m_pstore.getProfileNames());
                            break;
                        }
                        default: {
                            objectArray[n2] = null;
                            break;
                        }
                    }
                    ++n2;
                }
                return objectArray;
            }
            case 273612805: {
                String[] stringArray = new String[]{"-AppServer:Start", "-hideChildren", "-AppServer:End"};
                return this.getRootChildren(stringArray);
            }
            case 3080204: {
                return new Integer(0x102000);
            }
            case 273613313: {
                if (this.m_cmdList == null) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, CMD_REFRESH, "Refresh", "Refresh entries", 1, "images/refresh.gif")};
                    this.m_cmdList = iAdminPropArray;
                }
                return this.m_cmdList;
            }
        }
        return super.getProp(n);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == CMD_REFRESH) {
                this.m_kid = null;
                if (this.m_root != null) {
                    this.m_root.setProp(8454180, (Object)Boolean.TRUE);
                }
                this.sendAdminPropertyChangeEvents(273612805, null);
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return null;
    }

    public Object[] getRootChildren(String[] stringArray) {
        Object[] objectArray = null;
        try {
            block13: {
                UserProfile userProfile = this.m_pstore.createUserProfile(this.getProfiles());
                this.m_root = new AdminRoot();
                if (stringArray != null) {
                    this.m_root.setProp(0x10190099, (Object)stringArray);
                }
                if (userProfile == null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.m_name) + " children is AdminRoot");
                    }
                    this.m_kid = this.m_name.equalsIgnoreCase("Admin") ? this.m_root : null;
                } else {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.m_name) + " children use profiles");
                    }
                    this.m_kid = new AdminTransform(1, this.m_root, userProfile);
                }
                if (this.m_kid != null) {
                    objectArray = (Object[])this.m_kid.getProp(273612805);
                }
                if (objectArray == null) break block13;
                int n = 0;
                while (n < objectArray.length) {
                    block16: {
                        AppServer appServer;
                        block15: {
                            block14: {
                                appServer = null;
                                if (!(objectArray[n] instanceof AppServer)) break block14;
                                appServer = (AppServer)objectArray[n];
                                break block15;
                            }
                            if (!(objectArray[n] instanceof AdminTransform) || !(((AdminTransform)objectArray[n]).m_admprop instanceof AppServer)) break block16;
                            appServer = (AppServer)((AdminTransform)objectArray[n]).m_admprop;
                        }
                        if (appServer != null) {
                            appServer.setUser(this);
                            appServer.setConnected(true);
                        }
                    }
                    ++n;
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return null;
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x108800: {
                this.m_name = (String)object;
                return;
            }
            case 13666308: {
                this.m_passwd = (String)object;
                return;
            }
            case 13666309: {
                this.m_confirmPasswd = (String)object;
                return;
            }
            case 0x208802: {
                this.setAuthType((Integer)object);
                return;
            }
            case 269518854: {
                this.m_profiles = AdminProp.objectArrayToVector((Object[])object);
                return;
            }
            case 8454180: 
            case 0x10190099: {
                if (this.m_kid != null) {
                    this.m_kid.setProp(n, object);
                }
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        String string = this.m_passwd;
        String string2 = this.m_confirmPasswd;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!string.equals(string2)) {
            throw new SaveChangeException("Invalid password changes.");
        }
        if (this.m_pstore != null) {
            try {
                if (this.m_pstore.getUser(this.m_name) == null) {
                    this.m_pstore.addUser(this);
                    if (this.m_parent != null) {
                        this.m_parent.addChild(this);
                        this.m_parent.sendAdminPropertyChangeEvents(273612805, null);
                        this.m_parent.sendAdminPropertyChangeEvents(273219601, null);
                        return;
                    }
                } else {
                    this.sendAdminPropertyChangeEvents(273612805, null);
                }
                return;
            }
            catch (RepositoryException repositoryException) {
                AdminProp.sUnexpectedException(repositoryException);
                return;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }

    static {
        CMD_REFRESH = -5;
    }
}

