/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ConfigFilter
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    public static final int CHILD_FILTER = 10;
    public static final int PROPERTY_FILTER = 15;
    public static final int COMMAND_FILTER = 20;
    static final int INVALID_PROPERTY = 900;
    static final int PR_FILTER_TYPE = 2061056;
    static final int PR_FILTER_PROP_ID = 3109633;
    int m_propid;
    int m_type;
    ConfigFilterList m_parent;
    transient AdminProp m_transformerOwner;

    public int getType() {
        return this.m_type;
    }

    public int getPropID() {
        return this.m_propid;
    }

    private void init() {
        this.m_propid = 0;
        this.m_type = 0;
        this.m_transformerOwner = null;
        this.m_parent = null;
        this.registerProp(2061056, "Filter Type", "Type of filter");
        this.registerProp(3109633, "Property Id", "Internal Id of Property to be filtered");
        this.registerMessage(10, "Child Filter");
        this.registerMessage(15, "Property Filter");
        this.registerMessage(900, "A change request was made on a filter of the wrong type.");
    }

    public ConfigFilter(int n, int n2, ConfigFilterList configFilterList) {
        this.init();
        this.m_propid = n;
        this.m_type = n2;
        this.m_parent = configFilterList;
    }

    public void setTransformerOwner(AdminProp adminProp) {
        this.m_transformerOwner = adminProp;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.m_propid);
    }

    public boolean equals(ConfigFilter configFilter) {
        return this.m_propid == configFilter.getPropID();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: 
            case 3109633: {
                return "0x" + Integer.toHexString(this.m_propid);
            }
            case 2061056: {
                return this.getMessage(this.m_type);
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                return new Integer(8196);
            }
            case 2687386: {
                return new Integer(48);
            }
        }
        return super.getProp(n);
    }

    public void saveChanges(int n) throws SaveChangeException {
        this.m_parent.setModified(true);
        this.setModified(true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("+serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

