/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.ChildFilter;
import oracle.ldap.admin.appserver.CommandFilter;
import oracle.ldap.admin.appserver.ConfigChildDesc;
import oracle.ldap.admin.appserver.ConfigFilter;
import oracle.ldap.admin.appserver.NewChildFilter;
import oracle.ldap.admin.appserver.PropFilter;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ConfigFilterList
extends AdminProp
implements Serializable,
ICommandParent {
    static boolean DEBUG;
    public static final int CMD_CMD_OP_SWITCH = 0;
    public static final int CMD_CHILD_ADD = -8;
    public static final int CMD_CHILD_SHOW_SWITCH = 1;
    public static final int CMD_PROP_VISIBLE_SWITCH = 2;
    public static final int CMD_PROP_READONLY_SWITCH = 3;
    int m_type;
    Vector m_filters;
    transient ConfigFilter m_sample_child;
    transient AdminProp m_transformerOwner;

    public ConfigFilterList(int n) {
        this.init();
        this.m_type = n;
        this.initSample();
        this.m_filters = new Vector();
    }

    public ConfigFilterList(int n, AdminTransform adminTransform) {
        this(n);
        this.m_transformerOwner = adminTransform;
    }

    public AdminProp getParent() {
        return this.m_transformerOwner;
    }

    public AdminProp getRoot() {
        return ((AdminTransform)this.m_transformerOwner).getRoot();
    }

    public void init() {
        this.m_type = -1;
        this.m_filters = null;
        this.m_transformerOwner = null;
        this.m_sample_child = null;
        this.registerMessage(15, "Property Filters");
        this.registerMessage(10, "Child Filters");
        this.registerMessage(20, "Command Filters");
    }

    public void initSample() {
        if (this.m_type == 10) {
            try {
                this.m_sample_child = new ChildFilter(this, -4, "sampleChild");
                return;
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        if (this.m_type == 20) {
            try {
                this.m_sample_child = new CommandFilter(this, -4, null);
                return;
            }
            catch (PropertyException propertyException) {
                return;
            }
        }
        this.m_sample_child = new PropFilter(this, -4, 0, "sampleProp", "sampleDesc");
    }

    public String getListType() {
        return this.getMessage(this.m_type);
    }

    public void setTransformerOwner(AdminProp adminProp) {
        this.m_transformerOwner = adminProp;
        if (this.m_filters != null) {
            Enumeration enumeration = this.m_filters.elements();
            while (enumeration.hasMoreElements()) {
                ConfigFilter configFilter = (ConfigFilter)enumeration.nextElement();
                configFilter.setTransformerOwner(adminProp);
            }
        }
    }

    public int size() {
        return this.m_filters.size();
    }

    public void addChildFilter(int n, String string, int n2) throws MalformedURLException {
        this.addFilter(new ChildFilter(this, n, string, n2));
    }

    public void addPropFilter(int n, int n2, String string, String string2) {
        this.addFilter(new PropFilter(this, n, n2, string, string2));
    }

    public void addFilter(ConfigFilter configFilter) {
        if (!this.m_filters.contains(configFilter)) {
            this.m_filters.addElement(configFilter);
        }
    }

    public void delChildFilter(int n, String string, int n2) throws MalformedURLException {
        this.m_filters.removeElement(new ChildFilter(this, n, string, n2));
    }

    public void delChildFilter(ChildFilter childFilter) {
        this.m_filters.removeElement(childFilter);
    }

    public void delPropFilter(int n, int n2, String string, String string2) {
        this.m_filters.removeElement(new PropFilter(this, n, n2, string, string2));
    }

    public void delPropFilter(PropFilter propFilter) {
        this.m_filters.removeElement(propFilter);
    }

    public ConfigFilter getFilterAt(int n) {
        return (ConfigFilter)this.m_filters.elementAt(n);
    }

    public ConfigFilter getFilter(int n, boolean bl) {
        return ConfigFilterList.getFilter(n, this.m_type, this.m_filters, bl);
    }

    public ConfigFilter getFilter(int n, ConfigChildDesc configChildDesc, boolean bl) {
        return ConfigFilterList.getFilter(n, configChildDesc, this.m_filters, bl);
    }

    public Vector getAllFilters() {
        return this.m_filters;
    }

    public Vector getFilters(int[] nArray, boolean bl) {
        return ConfigFilterList.getFilters(nArray, this.m_type, this.m_filters, bl);
    }

    public Vector getChildFilters(int n, int n2, boolean bl) {
        return ConfigFilterList.getFilters(n, n2, this.m_filters, bl);
    }

    public int countFiltersByFlags(int n, boolean bl) {
        return ConfigFilterList.countFiltersByFlags(n, this.m_filters, bl);
    }

    public static ConfigFilter getFilter(int n, int n2, Vector vector, boolean bl) {
        int n3 = n;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            if (n2 == 15) {
                PropFilter propFilter = (PropFilter)vector.elementAt(n4);
                if (bl) {
                    n3 = n & ~propFilter.getPropFlags();
                }
                if (n3 == propFilter.getPropID()) {
                    return propFilter;
                }
            } else if (n2 == 20) {
                CommandFilter commandFilter = (CommandFilter)vector.elementAt(n4);
                if (n == commandFilter.getCommandID()) {
                    return commandFilter;
                }
            } else {
                ChildFilter childFilter = (ChildFilter)vector.elementAt(n4);
                if (n == childFilter.getPropID()) {
                    return childFilter;
                }
            }
            ++n4;
        }
        return null;
    }

    public static ConfigFilter getFilter(int n, ConfigChildDesc configChildDesc, Vector vector, boolean bl) {
        int n2 = n;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            ChildFilter childFilter = (ChildFilter)vector.elementAt(n3);
            if (n2 == childFilter.getPropID() && configChildDesc.equals(childFilter.getChildDescriptor())) {
                return childFilter;
            }
            ++n3;
        }
        return null;
    }

    public static Vector getFilters(int[] nArray, int n, Vector vector, boolean bl) {
        Vector<ConfigFilter> vector2 = new Vector<ConfigFilter>();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            int n4 = 0;
            while (n4 < vector.size()) {
                if (n == 15) {
                    PropFilter propFilter = (PropFilter)vector.elementAt(n4);
                    if (bl) {
                        n3 = nArray[n2] & ~propFilter.getPropFlags();
                    }
                    if (n3 == propFilter.getPropID()) {
                        vector2.addElement(propFilter);
                    }
                } else {
                    ChildFilter childFilter = (ChildFilter)vector.elementAt(n4);
                    if (n3 == childFilter.getPropID()) {
                        vector2.addElement(childFilter);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    public static Vector getFilters(int n, int n2, Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int[] nArray = new int[]{n};
        Vector vector2 = ConfigFilterList.getFilters(nArray, 10, vector, bl);
        if (vector2 == null) {
            return null;
        }
        Vector<ChildFilter> vector3 = new Vector<ChildFilter>();
        int n3 = 0;
        while (n3 < vector2.size()) {
            ChildFilter childFilter = (ChildFilter)vector2.elementAt(n3);
            if ((n2 & childFilter.getChildFilterOp()) != 0) {
                vector3.addElement(childFilter);
            }
            ++n3;
        }
        if (vector3.size() == 0) {
            return null;
        }
        return vector3;
    }

    public static int countFiltersByFlags(int n, Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            PropFilter propFilter = (PropFilter)vector.elementAt(n3);
            int n4 = propFilter.getPropFlags() & n;
            n2 = bl ? (n2 += n4 == 0 ? 1 : 0) : (n2 += n4 != 0 ? 1 : 0);
            ++n3;
        }
        return n2;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: {
                return this.getListType();
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                return new Integer(68);
            }
            case 2162725: {
                return new Integer(256);
            }
            case 273219601: {
                return AdminProp.vectorToObjectArray(this.m_filters);
            }
            case 273220108: {
                if (this.m_type == 20) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, 0, "Hide/Enable/Disable Command", "Switch between different operation modes.", 1, "images/reset.gif")};
                    iAdminPropArray[0].setProp(2687498, new Integer(1));
                    return iAdminPropArray;
                }
                if (this.m_type == 10) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, 1, "Show/Hide Child", "Show/Hide the child.", 1, "images/reset.gif")};
                    iAdminPropArray[0].setProp(2687498, new Integer(1));
                    return iAdminPropArray;
                }
                if (this.m_type == 15) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[2];
                    iAdminPropArray[0] = new CommandProp((IAdminProp)this, 2, "Set/Clear Visible", "Make the property to be visible or not.", 1, "images/reset.gif");
                    iAdminPropArray[0].setProp(2687498, new Integer(1));
                    iAdminPropArray[1] = new CommandProp((IAdminProp)this, 3, "Set/Clear Readonly", "Make the property to be readonly or not.", 1, "images/reset.gif");
                    iAdminPropArray[1].setProp(2687498, new Integer(1));
                    return iAdminPropArray;
                }
                return null;
            }
            case 273613313: {
                if (this.m_type != 10) break;
                IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, -8, "Add Child", "Add a new child to this object", 1, "images/create.gif")};
                return iAdminPropArray;
            }
        }
        return this.getTableProp(n, this.m_filters, (IAdminProp)this.m_sample_child);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case 0: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    int n2 = 0;
                    while (n2 < iAdminPropArray.length) {
                        CommandFilter commandFilter = (CommandFilter)iAdminPropArray[n2];
                        if (commandFilter.getCommandFilterOp() == 2) {
                            commandFilter.setProp(1078034, (Object)commandFilter.getMessage(4));
                        } else if (commandFilter.getCommandFilterOp() == 4) {
                            commandFilter.setProp(1078034, (Object)commandFilter.getMessage(1));
                        } else if (commandFilter.getCommandFilterOp() == 1) {
                            commandFilter.setProp(1078034, (Object)commandFilter.getMessage(2));
                        }
                        ++n2;
                    }
                    this.sendAdminPropertyChangeEvents(273219601, null);
                    return null;
                }
                case -8: {
                    if (this.m_type == 10) {
                        return new NewChildFilter(this);
                    }
                    return null;
                }
                case 1: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    int n3 = 0;
                    while (n3 < iAdminPropArray.length) {
                        ChildFilter childFilter = (ChildFilter)iAdminPropArray[n3];
                        if (childFilter.getChildFilterOp() == 1) {
                            this.delChildFilter(childFilter);
                        } else if (childFilter.getChildFilterOp() == 4) {
                            childFilter.setChildFilterOp(2);
                        }
                        ++n3;
                    }
                    this.getParent().sendAdminPropertyChangeEvents(273612805, null);
                    this.sendAdminPropertyChangeEvents(273219601, null);
                    return null;
                }
                case 2: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    int n4 = 0;
                    while (n4 < iAdminPropArray.length) {
                        PropFilter propFilter = (PropFilter)iAdminPropArray[n4];
                        if (propFilter.isVisible()) {
                            propFilter.setVisible(false);
                        } else {
                            propFilter.setVisible(true);
                        }
                        ++n4;
                    }
                    this.sendAdminPropertyChangeEvents(273219601, null);
                    return null;
                }
                case 3: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    int n5 = 0;
                    while (n5 < iAdminPropArray.length) {
                        PropFilter propFilter = (PropFilter)iAdminPropArray[n5];
                        if ((propFilter.getPropID() & 0x60000) == 0) {
                            if (propFilter.isReadOnly()) {
                                propFilter.setReadOnly(false);
                            } else {
                                propFilter.setReadOnly(true);
                            }
                        } else {
                            throw new PropertyException("This property is restricted to be readonly.");
                        }
                        ++n5;
                    }
                    this.sendAdminPropertyChangeEvents(273219601, null);
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
        this.initSample();
    }

    public static void main(String[] stringArray) {
        ConfigChildDesc configChildDesc;
        int n;
        int[] nArray;
        Vector vector;
        System.out.println("Starting ConfigFilterList Tests.");
        PropFilter[] propFilterArray = new PropFilter[5];
        Vector<PropFilter> vector2 = new Vector<PropFilter>(5);
        propFilterArray[0] = new PropFilter(null, 1, 16, "prop1", "a prop");
        propFilterArray[1] = new PropFilter(null, 2, 32, "prop2", "b prob");
        propFilterArray[2] = new PropFilter(null, 3, 16, "prop3", "c prob");
        propFilterArray[3] = new PropFilter(null, 4, 32, "prop4", "d prob");
        propFilterArray[4] = new PropFilter(null, 5, 48, "prop5", "e prob");
        int n2 = 0;
        while (n2 < 5) {
            vector2.addElement(propFilterArray[n2]);
            ++n2;
        }
        ConfigFilter configFilter = ConfigFilterList.getFilter(3, 15, vector2, false);
        if (configFilter == null || !configFilter.equals(propFilterArray[2])) {
            System.out.println("Test1::GetFilter simple failed.");
        }
        if (((vector = ConfigFilterList.getFilters(nArray = new int[]{3, 5}, 15, vector2, false)) == null || vector.size() == 0) && DEBUG) {
            System.out.println("Test2::GetFilters failed.");
        }
        if (vector.size() != 2) {
            System.out.println("Test2::GetFilters found: " + vector.size() + " out of 2 filters.");
        }
        if (!((ConfigFilter)vector.elementAt(0)).equals(propFilterArray[2])) {
            System.out.println("Test2::GetFilters mismatched filter.");
            ((ConfigFilter)vector.elementAt(0)).toString();
        }
        if (!((ConfigFilter)vector.elementAt(1)).equals(propFilterArray[4])) {
            System.out.println("Test2::GetFilters mismatched filter.");
            ((ConfigFilter)vector.elementAt(1)).toString();
        }
        if ((n = ConfigFilterList.countFiltersByFlags(16, vector2, false)) != 3) {
            System.out.println("Test3::CountFilters found:" + n + "out of 3 filters.");
        }
        ConfigFilter[] configFilterArray = new ConfigFilter[5];
        String[] stringArray2 = new String[]{"http://melange/AdminRoot", "http://melange/AdminRoot/Msging", "http://melange/AdminRoot/DocMgmt/Classes", "http://melange/AdminRoot/Msging/US.ORACLE.COM", "http://melange/AdminRoot/Submission-1@CHACHA(0x1e)"};
        try {
            configFilterArray[0] = new ChildFilter(null, 10, stringArray2[0], 1);
            configFilterArray[1] = new ChildFilter(null, 30, stringArray2[1], 1);
            configFilterArray[2] = new ChildFilter(null, 30, stringArray2[2], 2);
            configFilterArray[3] = new ChildFilter(null, 30, stringArray2[3], 4);
            configFilterArray[4] = new ChildFilter(null, 50, stringArray2[4], 2);
            configChildDesc = new ConfigChildDesc(1, stringArray2[4]);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Test4setup:: child filter test excepted.");
            malformedURLException.printStackTrace();
            return;
        }
        Vector<ConfigFilter> vector3 = new Vector<ConfigFilter>(5);
        int n3 = 0;
        while (n3 < 5) {
            vector3.addElement(configFilterArray[n3]);
            ++n3;
        }
        configFilter = ConfigFilterList.getFilter(50, configChildDesc, vector3, false);
        if (configFilter == null || !configFilter.equals(configFilterArray[4])) {
            System.out.println("Test4::GetChildFilter simple failed.");
        }
        if ((vector = ConfigFilterList.getFilters(30, 1, vector3, false)) == null || vector.size() == 0) {
            System.out.println("Test5::GetChildFilters failed.");
        }
        if (vector.size() != 1) {
            System.out.println("Test5::GetChildFilters found: " + vector.size() + "out of 1 filter.");
        }
        System.out.println("Ending ConfigFilterList Tests.");
    }
}

