/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ConfigPropValue
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    static final int PR_CPV_PROP_NAME = 1979393;
    static final int PR_CPV_PROP_DESC = 1979394;
    static final int PR_CPV_PROP_ID = 2176048;
    static final int PR_CPV_PROP_VALUE = 13316;
    private transient IAdminProp m_admprop;
    String m_propname;
    String m_propdesc;
    int m_propid;
    Object m_propval;
    int m_type;

    public ConfigPropValue(int n, Object object) {
        this.init();
        this.m_propid = n;
        this.m_propval = object;
        this.setupProps();
    }

    public ConfigPropValue(IAdminProp iAdminProp, int n, Object object) {
        this(n, object);
        this.m_admprop = iAdminProp;
        this.m_propname = iAdminProp.getPropName(n);
        this.m_propdesc = iAdminProp.getPropDescription(n);
    }

    void init() {
        this.m_admprop = null;
        this.m_propname = null;
        this.m_propdesc = null;
        this.m_propid = 0;
        this.m_propval = null;
        this.m_type = 0;
    }

    private void setupProps() {
        this.m_type = this.m_propid & 0x10F00000;
        this.registerProp(1979393, "Name", "Name of property");
        this.registerProp(1979394, "Description", "Description of property");
        this.registerProp(2176048, "ID", "Internal Id of property");
        this.registerProp(0x3404 | this.m_type, "Value", "Value of property");
    }

    public int getPropId() {
        return this.m_propid;
    }

    public Object getPropValue() {
        return this.m_propval;
    }

    public void setPropValue(Object object) {
        this.m_propval = object;
    }

    public String toString() {
        return String.valueOf(this.m_propname) + "(0x" + Integer.toHexString(this.m_propid) + ")=" + this.m_propval;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: 
            case 1979393: {
                return this.m_propname;
            }
            case 1979394: {
                return this.m_propdesc;
            }
            case 2176048: {
                return new Integer(this.m_propid);
            }
            case 2686979: {
                return new Integer(2);
            }
            case 3080204: {
                return new Integer(8196);
            }
            case 4784130: {
                return this.m_admprop;
            }
        }
        if ((n & 0xFFFF) == 13316) {
            return this.m_propval;
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (n == (0x3404 | this.m_type)) {
            this.m_propval = object;
            return;
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("+serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
        this.setupProps();
    }
}

