/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.Serializable;
import java.net.MalformedURLException;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.ChildFilter;
import oracle.ldap.admin.appserver.ConfigChildDesc;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewChildFilter
extends ChildFilter
implements Serializable {
    static boolean DEBUG;
    ConfigFilterList m_filterList;
    IAdminProp m_selection;

    void init() {
        super.init();
    }

    public NewChildFilter(ConfigFilterList configFilterList) throws MalformedURLException {
        super(configFilterList, 0, "");
        this.m_filterList = configFilterList;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3080204: {
                return new Integer(32);
            }
            case 0x110001: {
                return "Admin Root";
            }
            case 2031768: {
                return "URL Selector";
            }
            case 273612805: {
                AdminTransform adminTransform = (AdminTransform)this.m_filterList.getRoot();
                return new AdminTransform(5, adminTransform.getAdmPropObj(), null).getProp(n);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 4194830: {
                this.m_selection = (IAdminProp)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        String string;
        if (this.m_selection == null) {
            throw new SaveChangeException("Please select a node in the tree.");
        }
        try {
            string = (String)this.m_selection.getProp(2032789);
            if (DEBUG) {
                System.out.println("Selected url=" + string);
            }
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception.getMessage());
        }
        if (string == null) {
            throw new SaveChangeException("The selected node doesn't have a URL for some reason.\nPlease select another node in the tree.");
        }
        try {
            this.m_child_desc = new ConfigChildDesc(1, string);
            this.m_filterList.addChildFilter(273612805, string, 1);
        }
        catch (Exception exception) {
            throw new SaveChangeException(String.valueOf(string) + " " + exception.getMessage());
        }
        this.m_filterList.getParent().sendAdminPropertyChangeEvents(273612805, null);
        this.m_filterList.sendAdminPropertyChangeEvents(273219601, null);
    }
}

