/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.ConfigFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class PropFilter
extends ConfigFilter
implements Serializable,
Cloneable {
    static boolean DEBUG;
    static final int PR_PFILTER_PROP_NAME = 1078018;
    static final int PR_PFILTER_PROP_ISINVISIBLE = 8418051;
    static final int PR_PFILTER_PROP_ISRO_CHANGEABLE = 8418052;
    static final int PR_PFILTER_PROP_ISRO_NOTCHANGEABLE = 8811268;
    static final int PR_PFILTER_PROP_DESC = 1078021;
    int m_propflag;
    String m_propname;
    String m_propdesc;
    transient boolean m_adminConfigDirty;

    private void init() {
        this.m_propflag = 0;
        this.m_propname = null;
        this.m_propdesc = null;
        this.m_adminConfigDirty = false;
        this.m_transformerOwner = null;
        this.registerProp(8418051, "Invisible", "Should this property be invisible?");
        this.registerProp(8418052, "Read-Only", "Should this property only be readable?");
        this.registerProp(8811268, "Read-Only", "Should this property only be readable?");
        this.registerProp(1078018, "Name", "New Property name to be applied to property");
        this.registerProp(1078021, "Description", "New Property description to be applied to property");
    }

    public PropFilter(ConfigFilterList configFilterList, int n) {
        this(configFilterList, n, 0xF0000 & n, null, null);
    }

    public PropFilter(ConfigFilterList configFilterList, int n, int n2, String string, String string2) {
        super(n, 15, configFilterList);
        this.init();
        this.m_propflag = n2;
        this.m_propname = string;
        this.m_propdesc = string2;
    }

    public Object clone() {
        PropFilter propFilter = new PropFilter(this.m_parent, this.m_propid, this.m_propflag, this.m_propname, this.m_propdesc);
        return propFilter;
    }

    public int getPropFlags() {
        return this.m_propflag;
    }

    public String getPropName() {
        return this.m_propname;
    }

    public String getPropDescription() {
        return this.m_propdesc;
    }

    public boolean isVisible() {
        return (this.m_propflag & 0x10000) == 0;
    }

    public boolean isReadOnly() {
        return (this.m_propflag & 0x60000) != 0;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.m_propflag &= 0xFFFEFFFF;
            return;
        }
        this.m_propflag |= 0x10000;
    }

    public void setReadOnly(boolean bl) {
        if (bl) {
            this.m_propflag |= 0x60000;
            return;
        }
        this.m_propflag &= 0xFFF9FFFF;
    }

    public String toString() {
        String string = super.toString();
        String string2 = "0x" + Integer.toHexString(this.m_propflag);
        return "[PropFilter: id=" + string + " Flags=" + string2 + " Name/Desc=" + this.m_propname + "/" + this.m_propdesc + "]";
    }

    public boolean equals(PropFilter propFilter) {
        if (super.equals(propFilter)) {
            if (this.m_propflag != propFilter.getPropFlags()) {
                return false;
            }
            if (this.m_propname != null ? !this.m_propname.equalsIgnoreCase(propFilter.getPropName()) : propFilter.getPropName() != null) {
                return false;
            }
            return !(this.m_propdesc != null ? !this.m_propdesc.equals(propFilter.getPropDescription()) : propFilter.getPropDescription() != null);
        }
        return false;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 282001422: {
                int[] nArray = this.getPropListByType(65536, true);
                int[] nArray2 = new int[nArray.length - 1];
                boolean bl = false;
                if (DEBUG) {
                    System.out.println("PropFilter:: " + this.toString());
                }
                if ((this.m_propid & 0x60000) != 0) {
                    bl = true;
                }
                int n2 = 0;
                int n3 = 0;
                while (n2 < nArray.length) {
                    if (!(bl && nArray[n2] == 8418052 || !bl && nArray[n2] == 8811268)) {
                        nArray2[n3++] = nArray[n2];
                    }
                    ++n2;
                }
                return nArray2;
            }
            case 1078018: 
            case 0x110001: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.m_propname;
            }
            case 8418051: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return new Boolean(!this.isVisible());
            }
            case 8418052: 
            case 8811268: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return new Boolean(this.isReadOnly());
            }
            case 1078021: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.m_propdesc;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 8418051: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                if (((Boolean)object).booleanValue()) {
                    this.setVisible(false);
                    return;
                }
                this.setVisible(true);
                return;
            }
            case 8418052: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                if (((Boolean)object).booleanValue()) {
                    this.setReadOnly(true);
                    return;
                }
                this.setReadOnly(false);
                return;
            }
            case 1078018: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                this.m_propname = (String)object;
                this.m_adminConfigDirty = true;
                return;
            }
            case 1078021: {
                if (this.m_type != 15) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                this.m_propdesc = (String)object;
                this.m_adminConfigDirty = true;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (DEBUG) {
            System.out.println("Property filter changed -->" + this.toString());
        }
        if (this.m_transformerOwner != null) {
            this.m_transformerOwner.sendAdminPropertyChangeEvents(282001422, null);
            if (this.m_adminConfigDirty && ((AdminTransform)this.m_transformerOwner).m_admcnfg != null) {
                ((AdminTransform)this.m_transformerOwner).m_admcnfg.sendAdminPropertyChangeEvents(272695330, null);
            }
            this.m_adminConfigDirty = false;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

