/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminConfig;
import oracle.ldap.admin.appserver.AppServerUser;
import oracle.ldap.admin.appserver.AuthenticationException;
import oracle.ldap.admin.appserver.ChildFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.appserver.Profile;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminURL;

public class Repository
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    static final int NO_USER_SPECIFIED = 91;
    static final int NO_USER_DB = 92;
    static final int NO_PROFILE_SPECIFIED = 93;
    static final int NO_PROFILE_DB = 94;
    static final int NO_USER_FOUND = 95;
    Hashtable m_aps_user_DB;
    Hashtable m_profile_DB;

    public Repository() {
        this.init();
    }

    public Repository(boolean bl) {
        this();
        if (bl) {
            this.seedUsers();
            this.seedProfiles();
        }
    }

    public Repository(String string, String string2, String string3) {
        this.init();
    }

    private void init() {
        this.m_aps_user_DB = new Hashtable();
        this.m_profile_DB = new Hashtable();
        this.addUser(new AppServerUser("welcome", this));
        this.registerMessage(91, "Given a null user for repository lookup");
    }

    private Vector getDBkeys(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public Vector getUserNames() {
        return this.getDBkeys(this.m_aps_user_DB);
    }

    public AppServerUser getUser(String string) throws RepositoryException {
        if (string == null) {
            throw new RepositoryException(this.getMessage(91));
        }
        if (this.m_aps_user_DB == null) {
            throw new RepositoryException(this.getMessage(92));
        }
        AppServerUser appServerUser = (AppServerUser)this.m_aps_user_DB.get(string);
        return appServerUser;
    }

    public void addUser(String string, String string2) {
        AppServerUser appServerUser = new AppServerUser(string, string2, this);
        this.m_aps_user_DB.put(string, appServerUser);
    }

    public void addUser(AppServerUser appServerUser) {
        this.m_aps_user_DB.put(appServerUser.getName(), appServerUser);
    }

    public Vector getProfileNames() {
        return this.getDBkeys(this.m_profile_DB);
    }

    public Profile getProfile(String string) throws RepositoryException {
        if (string == null) {
            throw new RepositoryException(this.getMessage(93));
        }
        if (this.m_profile_DB == null) {
            throw new RepositoryException(this.getMessage(94));
        }
        Profile profile = (Profile)this.m_profile_DB.get(string);
        return profile;
    }

    public void addProfile(Profile profile) {
        this.m_profile_DB.put(profile.getName(), profile);
    }

    public Vector getUsersOfProfile(String string) {
        Vector<AppServerUser> vector = null;
        if (string == null) {
            return null;
        }
        if (this.m_aps_user_DB != null) {
            Vector vector2 = this.getUserNames();
            vector = new Vector<AppServerUser>();
            if (vector2 != null) {
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    AppServerUser appServerUser = (AppServerUser)this.m_aps_user_DB.get(string2);
                    if (appServerUser == null || !appServerUser.isUsingProfile(string)) continue;
                    vector.addElement(appServerUser);
                }
            }
        }
        return vector;
    }

    public void authenticateUser(String string, String string2) throws RepositoryException, AuthenticationException {
        AppServerUser appServerUser = (AppServerUser)this.m_aps_user_DB.get(string);
        if (appServerUser == null) {
            throw new RepositoryException(this.getMessage(95));
        }
        appServerUser.authenticateUser(string2);
    }

    public UserProfile createUserProfile(String string) {
        AdminProp adminProp;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (string == null) {
            return null;
        }
        if (this.m_profile_DB != null && (adminProp = (Profile)this.m_profile_DB.get(string)) != null) {
            hashtable = ((Profile)adminProp).getDNcache();
            hashtable2 = ((Profile)adminProp).getURLcache();
        }
        if (DEBUG) {
            AdminProp.sDebugMessageLn("Creating profile: " + string);
        }
        adminProp = new UserProfile(this, string, hashtable, hashtable2);
        return adminProp;
    }

    public UserProfile createUserProfile(String[] stringArray) {
        AdminProp adminProp;
        Vector<Hashtable> vector = null;
        Vector<Hashtable> vector2 = null;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (this.m_profile_DB != null) {
            vector = new Vector<Hashtable>();
            vector2 = new Vector<Hashtable>();
            int n = 0;
            while (n < stringArray.length) {
                adminProp = (Profile)this.m_profile_DB.get(stringArray[n]);
                if (adminProp != null) {
                    vector.addElement(((Profile)adminProp).getDNcache());
                    vector2.addElement(((Profile)adminProp).getURLcache());
                }
                ++n;
            }
            if (vector.size() == 0 && vector2.size() == 0) {
                vector = null;
                vector2 = null;
            }
        }
        adminProp = new UserProfile(this, stringArray, vector, vector2);
        return adminProp;
    }

    public void disconnect() {
    }

    private void seedUsers() {
        String[] stringArray = new String[]{"dpchu", "mcheng", "hmulling", "clcooper", "lsheung"};
        String[] stringArray2 = new String[]{"welcome", "welcome", "welcome", "welcome", "welcome"};
        int n = 0;
        while (n < stringArray.length) {
            this.addUser(stringArray[n], stringArray2[n]);
            ++n;
        }
        AppServerUser appServerUser = new AppServerUser("manager", this);
        this.m_aps_user_DB.put("admin", appServerUser);
        appServerUser = (AppServerUser)this.m_aps_user_DB.get("clcooper");
        appServerUser.addProfile("chacha-msgingQs");
        this.m_aps_user_DB.put("clcooper", appServerUser);
        appServerUser = (AppServerUser)this.m_aps_user_DB.get("mcheng");
        appServerUser.addProfile("chacha-msging");
        this.m_aps_user_DB.put("mcheng", appServerUser);
        appServerUser = (AppServerUser)this.m_aps_user_DB.get("hmulling");
        appServerUser.addProfile("ldap");
        this.m_aps_user_DB.put("hmulling", appServerUser);
    }

    private void seedProfiles() {
        Profile profile;
        AdminConfig adminConfig;
        ChildFilter childFilter;
        ChildFilter childFilter2;
        ChildFilter childFilter3;
        ChildFilter childFilter4;
        int n = 273612805;
        String string = "Admin Root";
        String string2 = "http://foo/Admin Root/";
        String string3 = "oracle.ldap.admin.server.ldap.RootList";
        String string4 = String.valueOf(string2) + AdminURL.makeComponent(string3, n);
        String string5 = "oracle.ldap.admin.server.msging.Session@admin:chacha:office_domain";
        String string6 = String.valueOf(string2) + AdminURL.makeComponent(string5, n);
        String string7 = "oracle.ldap.admin.server.webcntr.WCRootList";
        String string8 = String.valueOf(string2) + AdminURL.makeComponent(string7, n);
        String string9 = "oracle.ldap.admin.server.dmadmin.DMRootList";
        String string10 = String.valueOf(string2) + AdminURL.makeComponent(string9, n);
        ConfigFilterList configFilterList = new ConfigFilterList(10);
        try {
            childFilter4 = new ChildFilter(configFilterList, n, string4, 4);
            configFilterList.addFilter(childFilter4);
            childFilter3 = new ChildFilter(configFilterList, n, string6, 2);
            configFilterList.addFilter(childFilter3);
            childFilter2 = new ChildFilter(configFilterList, n, string8, 2);
            configFilterList.addFilter(childFilter2);
            childFilter = new ChildFilter(configFilterList, n, string10, 2);
            configFilterList.addFilter(childFilter);
            adminConfig = new AdminConfig(null, string);
            adminConfig.setChildFilters(configFilterList);
            profile = new Profile(this, "ldap");
            profile.storeConfig(string, string2, adminConfig);
            this.m_profile_DB.put("ldap", profile);
        }
        catch (MalformedURLException malformedURLException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: ldap");
            AdminProp.sUnexpectedException(malformedURLException);
        }
        catch (RepositoryException repositoryException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: ldap");
            AdminProp.sUnexpectedException(repositoryException);
        }
        ConfigFilterList configFilterList2 = new ConfigFilterList(10);
        try {
            childFilter4 = new ChildFilter(configFilterList2, n, string4, 2);
            configFilterList2.addFilter(childFilter4);
            childFilter3 = new ChildFilter(configFilterList2, n, string6, 4);
            configFilterList2.addFilter(childFilter3);
            childFilter2 = new ChildFilter(configFilterList2, n, string8, 2);
            configFilterList2.addFilter(childFilter2);
            childFilter = new ChildFilter(configFilterList2, n, string10, 2);
            configFilterList2.addFilter(childFilter);
            adminConfig = new AdminConfig(null, string);
            adminConfig.setChildFilters(configFilterList2);
            profile = new Profile(this, "Admin");
            profile.storeConfig(string, string2, adminConfig);
            adminConfig = new AdminConfig(null, string5);
            profile.storeConfig(string5, string6, adminConfig);
            this.m_profile_DB.put("Admin", profile);
        }
        catch (MalformedURLException malformedURLException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: msging");
            AdminProp.sUnexpectedException(malformedURLException);
        }
        catch (RepositoryException repositoryException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: msging");
            AdminProp.sUnexpectedException(repositoryException);
        }
        ConfigFilterList configFilterList3 = new ConfigFilterList(10);
        String string11 = "/Nodes(0x104f0005)/CHACHASCN:admin@chacha(0x104f0005)/Queues(0x104f0005)/View(0x10410045)[Queues](0x10410022)";
        String string12 = String.valueOf(string6) + string11;
        try {
            childFilter4 = new ChildFilter(configFilterList3, n, string4, 2);
            configFilterList3.addFilter(childFilter4);
            childFilter3 = new ChildFilter(configFilterList3, n, string6, 2);
            configFilterList3.addFilter(childFilter3);
            childFilter2 = new ChildFilter(configFilterList3, n, string8, 2);
            configFilterList3.addFilter(childFilter2);
            childFilter = new ChildFilter(configFilterList3, n, string10, 2);
            configFilterList3.addFilter(childFilter);
            ChildFilter childFilter5 = new ChildFilter(configFilterList3, n, string12, 1);
            configFilterList3.addFilter(childFilter5);
            adminConfig = new AdminConfig(null, string);
            adminConfig.setChildFilters(configFilterList3);
            profile = new Profile(this, "chacha-msgingQs");
            profile.storeConfig(string, string2, adminConfig);
            this.m_profile_DB.put("chacha-msgingQs", profile);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: msging");
            AdminProp.sUnexpectedException(malformedURLException);
            return;
        }
        catch (RepositoryException repositoryException) {
            AdminProp.errorMessageLn("Exception while creating seed profile: msging");
            AdminProp.sUnexpectedException(repositoryException);
            return;
        }
    }

    public void saveToDatabase(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this);
    }

    public static void main(String[] stringArray) {
        Repository repository = new Repository();
        Vector vector = repository.getUserNames();
        if (DEBUG) {
            System.out.println("Starting Repository main.");
        }
        if (vector == null) {
            System.out.println("No users found.");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (DEBUG) {
                System.out.println("user: " + string);
            }
            try {
                AppServerUser appServerUser = repository.getUser(string);
                if (appServerUser.getProfiles() == null) continue;
                UserProfile userProfile = repository.createUserProfile(appServerUser.getProfiles());
                userProfile.debugDumpProfile();
            }
            catch (RepositoryException repositoryException) {
                AdminProp.sUnexpectedException(repositoryException);
            }
        }
        if (DEBUG) {
            System.out.println("Ending Repository main.");
        }
    }
}

