/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.util.Vector;
import oracle.ldap.admin.appserver.AppServerUser;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

class UserList
extends AdminList
implements ICommandParent {
    static boolean DEBUG;
    static final int PR_STR_ADD_USER_BTNTEXT = 12544;
    static final int PR_STR_ADD_USER_DESCRIP = 12545;
    static final int PR_STR_USER_LIST = 12546;
    static final int CMD_ADD_USER = -8;
    Repository m_pstore;

    public UserList(Repository repository) {
        this.m_pstore = repository;
        this.registerMessage(12544, "New User");
        this.registerMessage(12545, "Create a new Admin Server user");
        this.registerMessage(12546, "Users");
        this.setDisplayName(this.getMessage(12546));
        IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, -8, this.getMessage(12544), this.getMessage(12545), 1, "images/configure.gif")};
        this.setCommandList(iAdminPropArray);
        this.setSampleChild(new AppServerUser());
        this.rebuildChildrenList();
    }

    public void setChildren(Vector vector) {
        if (vector == null) {
            this.rebuildChildrenList();
            return;
        }
        super.setChildren(vector);
    }

    private void rebuildChildrenList() {
        super.setChildren((Vector)null);
        if (this.m_pstore == null) {
            return;
        }
        Vector vector = this.m_pstore.getUserNames();
        if (vector != null) {
            int n = vector.size();
            if (DEBUG) {
                System.out.println(n);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                try {
                    AppServerUser appServerUser = this.m_pstore.getUser((String)vector.elementAt(n2));
                    appServerUser.setParent(this);
                    if (!appServerUser.isAdminUser()) {
                        super.addChildSorted(appServerUser);
                        if (DEBUG) {
                            System.out.print("retrieve user --->");
                        }
                        if (DEBUG) {
                            System.out.println(appServerUser.getName());
                        }
                    }
                }
                catch (RepositoryException repositoryException) {
                    AdminProp.sUnexpectedException(repositoryException);
                }
                ++n2;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 282001424: {
                int[] nArray = new int[]{0x108800, 2066435};
                return nArray;
            }
            case 2686995: {
                return new Integer(2);
            }
        }
        return super.getProp(n);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -8: {
                if (DEBUG) {
                    System.out.println("Creating a new user");
                }
                return new AppServerUser(this.m_pstore, this);
            }
        }
        return null;
    }
}

