/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Frame;
import java.util.Vector;
import oracle.ldap.admin.client.AdminExecDialog;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.IWorkCommand;
import oracle.ldap.admin.common.PropertyException;

class AdminExec
implements Runnable {
    Vector commands = new Vector();
    Thread myThread;
    Thread runningTask = null;
    static AdminExec m_workThread;
    static Frame m_frame;

    public synchronized IWorkCommand head() {
        return (IWorkCommand)this.commands.elementAt(0);
    }

    public synchronized IWorkCommand dequeue() {
        Object e = this.commands.elementAt(0);
        this.commands.removeElementAt(0);
        return (IWorkCommand)e;
    }

    public synchronized void enqueue(IWorkCommand iWorkCommand) {
        this.commands.addElement(iWorkCommand);
        iWorkCommand.setStatus(1);
        try {
            System.out.println("ADMINEXEC: command " + iWorkCommand.getName() + " enqueued !");
        }
        catch (PropertyException propertyException) {}
        this.myThread.resume();
    }

    public synchronized boolean shouldDoWork() {
        return this.commands.size() != 0;
    }

    public void run() {
        this.myThread = Thread.currentThread();
        while (true) {
            if (this.shouldDoWork()) {
                IWorkCommand iWorkCommand = this.head();
                try {
                    iWorkCommand.setStatus(2);
                    iWorkCommand.doWork();
                    this.dequeue();
                    System.out.println("ADMINEXEC: command " + iWorkCommand.getName() + " complete !");
                }
                catch (Exception exception) {
                    new ErrorAlert(AdminUtil.getFrame(m_frame), exception);
                    this.dequeue();
                }
                continue;
            }
            this.myThread.suspend();
        }
    }

    public static void execute(IWorkCommand iWorkCommand) {
        if (m_workThread == null) {
            m_workThread = new AdminExec();
            new Thread(m_workThread).start();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        m_workThread.enqueue(iWorkCommand);
    }

    public static void setFrame(Frame frame) {
        m_frame = frame;
    }

    public static Frame getFrame() {
        return m_frame;
    }

    public static void main(String[] stringArray) {
        AdminExecDialog adminExecDialog = new AdminExecDialog(new Frame(), m_workThread);
        adminExecDialog.display();
        adminExecDialog = null;
    }
}

