/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.ldap.admin.client.ErrorLock;
import oracle.ldap.admin.client.common.AdminAlert;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.PropertyException;

public class ErrorAlert
extends AdminAlert
implements Runnable,
ActionListener {
    static ErrorLock m_errorLock = new ErrorLock();
    public int results = -1;
    static int counter;
    int myCounter;
    Exception m_e;
    AdminButton m_btn;
    boolean m_running = false;
    boolean m_hasDetailBtn = true;

    public String toString() {
        return "ErrorAlert" + this.myCounter;
    }

    public static String getMessage(String string) {
        if (string == null || string.trim().length() == 0) {
            return ClientLang.getStrAnErrOccured();
        }
        return string;
    }

    public static String getMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null || string.trim().length() == 0) {
            return String.valueOf(ErrorAlert.getMessage("")) + "\n" + exception.getClass().getName();
        }
        return ErrorAlert.getMessage(string);
    }

    public void addStackTraceButton(Exception exception) {
        if (exception == null) {
            return;
        }
        this.m_e = exception;
        this.m_btn = new AdminButton(ClientLang.getStrDetails());
        this.addUserButton((Component)((Object)this.m_btn));
        this.m_btn.setLeftmost(true);
        this.m_btn.setRightmost(true);
        this.m_btn.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btn) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((Component)((Object)this.m_btn)).setEnabled(false);
            this.m_e.printStackTrace(printWriter);
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getMessage()) + "\n-----------------------------\n" + stringWriter.toString());
            int n = stringBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                switch (stringBuffer.charAt(n2)) {
                    case '\t': 
                    case '\r': {
                        stringBuffer.setCharAt(n2, ' ');
                        break;
                    }
                }
                ++n2;
            }
            this.setMessage(stringBuffer.toString());
            ((Component)((Object)this)).setSize(((Container)((Object)this)).getPreferredSize());
            this.invalidate();
            this.doLayout();
            ((Component)((Object)this)).setSize(((Container)((Object)this)).getPreferredSize());
            this.invalidate();
            ((Container)((Object)this)).validate();
            this.doLayout();
        }
    }

    public void run() {
        this.m_running = true;
        if (m_errorLock.lock(this)) {
            this.setVisible(true);
        }
    }

    public ErrorAlert(Frame frame, String string) {
        this(frame, ErrorAlert.getMessage(string), 1);
    }

    public ErrorAlert(Frame frame, String string, int n) {
        this(frame, ErrorAlert.getMessage(string), ClientLang.getStrError(), n, 4);
        this.myCounter = ++counter;
        ((Window)((Object)this)).addWindowListener(new WAdapter());
        ((Dialog)((Object)this)).setModal(true);
    }

    public ErrorAlert(Frame frame, String string, String string2, int n, int n2) {
        this(frame, string, string2, n, n2, false);
    }

    public ErrorAlert(Frame frame, String string, String string2, int n, int n2, boolean bl) {
        super(frame, ErrorAlert.getMessage(string), n, n2);
        this.m_running = bl;
        this.myCounter = ++counter;
        this.setTitle(string2);
        ((Window)((Object)this)).addWindowListener(new WAdapter());
        this.center();
        try {
            this.results = this.runAlert();
        }
        catch (NullPointerException nullPointerException) {
            if (string == null) {
                ErrorAlert errorAlert = new ErrorAlert(frame, ClientLang.getStrAnErrOccured());
                this.results = errorAlert.getResults();
            }
        }
        catch (Exception exception) {}
        this.m_running = true;
    }

    public ErrorAlert(Frame frame, Exception exception, String string, int n, int n2, boolean bl) {
        this(frame, ErrorAlert.getMessage(exception), string, n, n2);
        this.m_hasDetailBtn = bl;
        this.myCounter = ++counter;
        ((Window)((Object)this)).addWindowListener(new WAdapter());
        this.m_running = true;
    }

    public ErrorAlert(Frame frame, Exception exception, String string, int n, int n2) {
        this(frame, ErrorAlert.getMessage(exception), string, n, n2);
        if (this.m_hasDetailBtn) {
            this.addStackTraceButton(exception);
        }
        this.myCounter = ++counter;
        ((Window)((Object)this)).addWindowListener(new WAdapter());
        this.m_running = true;
    }

    public ErrorAlert(Frame frame, Exception exception) {
        super(frame, ErrorAlert.getMessage(exception), ErrorAlert.getAlertType(exception), 1);
        if (exception instanceof PropertyException) {
            boolean bl = this.m_hasDetailBtn = !((PropertyException)exception).isReminder();
        }
        if (this.m_hasDetailBtn) {
            this.addStackTraceButton(exception);
        }
        this.setTitle(exception);
        this.m_running = false;
        this.myCounter = ++counter;
        ((Window)((Object)this)).addWindowListener(new WAdapter());
        ((Dialog)((Object)this)).setModal(true);
        this.center();
        try {
            this.results = this.runAlert();
        }
        catch (Exception exception2) {}
        this.m_running = true;
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setTitle(Exception exception) {
        if (exception instanceof PropertyException) {
            PropertyException propertyException = (PropertyException)exception;
            if (propertyException.isNotice()) {
                this.setTitle(ClientLang.getStrNotice());
                return;
            }
            if (propertyException.isWarning()) {
                this.setTitle(ClientLang.getStrWarning());
                return;
            }
            this.setTitle(ClientLang.getStrError());
            return;
        }
        this.setTitle(ClientLang.getStrException());
    }

    public static int getAlertType(Exception exception) {
        if (exception instanceof PropertyException) {
            PropertyException propertyException = (PropertyException)exception;
            if (propertyException.isNotice()) {
                return 2;
            }
            if (propertyException.isWarning()) {
                return 1;
            }
        }
        return 0;
    }

    public int getResults() {
        return this.results;
    }

    public void center() {
        Rectangle rectangle = ((Component)((Object)this)).getParent().getBounds();
        Rectangle rectangle2 = ((Component)((Object)this)).getBounds();
        Dimension dimension = ((Container)((Object)this)).getPreferredSize();
        rectangle2.width = dimension.width;
        rectangle2.height = dimension.height;
        int n = rectangle.x + rectangle.width / 2 - rectangle2.width / 2;
        int n2 = rectangle.y + rectangle.height / 2 - rectangle2.height / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)((Object)this)).setBounds(n, n2, rectangle2.width, rectangle2.height);
    }

    public void setVisible(boolean bl) {
        if (!this.m_running) {
            new Thread(this).start();
            return;
        }
        if (bl) {
            this.center();
        }
        super.setVisible(bl);
        if (!bl) {
            m_errorLock.unlock(this);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        ((Component)frame).setBounds(150, 130, 200, 100);
        String string = null;
        new ErrorAlert(frame, string);
    }

    class WAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ErrorAlert.this.dispose();
        }

        WAdapter() {
            ErrorAlert.this = ErrorAlert.this;
        }
    }
}

