/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.IFrame;
import oracle.ldap.admin.client.MenuAction;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.PropToolbar;
import oracle.ldap.admin.client.common.AdminBorderPanel;
import oracle.ldap.admin.client.common.AdminFrame;
import oracle.ldap.admin.client.common.AdminMenu;
import oracle.ldap.admin.client.common.AdminMenuBar;
import oracle.ldap.admin.client.common.AdminMenuItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.IAdminPropCommandIds;

public class NavMenu
extends AdminBorderPanel
implements ActionListener,
IAdminPropCommandIds,
AdminPropertyChangeListener {
    public static boolean SHOW_DEBUG_MENU_ITEM;
    AdminFrame _frame;
    boolean _fInitialized = false;
    static boolean m_useMenuImage;
    AdminMenuBar _mb;
    MenuAction _ma;
    Hashtable _mapIdToName;
    Hashtable _mapIdToImage;
    Hashtable _mapIdToMenuItem;
    Hashtable _mapIdToEnabled;
    Hashtable _mapCmdToMenuItem;
    AdminMenu _mFile;
    AdminMenuItem _mFileConnect;
    AdminMenuItem _mFileExit;
    AdminMenu _mView;
    AdminMenuItem _mViewRefresh;
    AdminMenuItem _mViewFilter;
    AdminMenuItem _mViewAdvance;
    AdminMenu _mObject;
    AdminMenuItem _mObjectCreate;
    AdminMenu _mLog;
    AdminMenuItem _mLogRecord;
    AdminMenuItem _mLogStop;
    AdminMenuItem _mLogPause;
    AdminMenu _mHelp;
    AdminMenuItem _mHelpContents;
    AdminMenuItem _mHelpSearch;
    AdminMenuItem _mHelpUsing;
    AdminMenuItem _mHelpAbout;
    IAdminProp _lastCmdMenuOwner;
    boolean _cmdMenuInstalled;
    boolean _showmnemonic = false;
    AdminMenu _specialMenu;

    public AdminMenuBar getMenuBar() {
        return this._mb;
    }

    public NavMenu(AdminFrame adminFrame) {
        this._frame = adminFrame;
        String string = Locale.getDefault().toString();
        if (string.startsWith("en")) {
            this._showmnemonic = true;
        }
    }

    protected AdminMenuItem createMenuItem(AdminMenu adminMenu, String string, MenuAction menuAction) {
        AdminMenuItem adminMenuItem = new AdminMenuItem(string);
        adminMenuItem.addActionListener(menuAction);
        adminMenu.add(adminMenuItem);
        return adminMenuItem;
    }

    protected AdminMenuItem createMenuItem(AdminMenu adminMenu, int n, MenuAction menuAction) {
        AdminMenuItem adminMenuItem = this.createMenuItem(adminMenu, this.getName(n), menuAction);
        this.mapIdToMenuItem(n, adminMenuItem);
        ((Component)((Object)adminMenuItem)).setEnabled(this.getEnabled(n));
        if (m_useMenuImage) {
            String string = this.getImageName(n);
            Image image = null;
            if (string != null) {
                image = AdminUtil.loadImage(string, null);
            }
            if (image != null) {
                int n2;
                int n3 = image.getWidth((ImageObserver)((Object)this));
                if (n3 * 2 == (n2 = image.getHeight((ImageObserver)((Object)this)))) {
                    if (((Component)((Object)this)).getParent() == null) {
                        Frame frame = new Frame();
                        frame.add((Component)((Object)this));
                        frame.addNotify();
                        this.addNotify();
                    }
                    image = ((Component)((Object)this)).createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(0, 0, n3, n3)));
                }
                adminMenuItem.setImage(image);
            }
        }
        return adminMenuItem;
    }

    public IAdminProp getCommand(AdminMenuItem adminMenuItem) {
        if (adminMenuItem == null) {
            return null;
        }
        if (this._mapCmdToMenuItem == null) {
            this._mapCmdToMenuItem = new Hashtable();
        }
        return (IAdminProp)this._mapCmdToMenuItem.get((Object)adminMenuItem);
    }

    public void setCommand(AdminMenuItem adminMenuItem, IAdminProp iAdminProp) {
        if (this._mapCmdToMenuItem == null) {
            this._mapCmdToMenuItem = new Hashtable();
        }
        if (iAdminProp == null) {
            this._mapCmdToMenuItem.remove(this._mapCmdToMenuItem.get((Object)adminMenuItem));
            this._mapCmdToMenuItem.remove((Object)adminMenuItem);
            ((Component)((Object)adminMenuItem)).setEnabled(false);
            adminMenuItem.setLabel(this.getName(adminMenuItem));
            return;
        }
        this._mapCmdToMenuItem.put(iAdminProp, adminMenuItem);
        this._mapCmdToMenuItem.put(adminMenuItem, iAdminProp);
        try {
            ((Component)((Object)adminMenuItem)).setEnabled((Boolean)iAdminProp.getProp(8978948));
            adminMenuItem.setLabel((String)iAdminProp.getProp(0x110001));
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public void mapIdToMenuItem(int n, AdminMenuItem adminMenuItem) {
        if (this._mapIdToMenuItem == null) {
            this._mapIdToMenuItem = new Hashtable();
        }
        this._mapIdToMenuItem.put(new Integer(n), adminMenuItem);
        this._mapIdToMenuItem.put(adminMenuItem, new Integer(n));
    }

    public AdminMenuItem getMenuItem(Integer n) {
        return (AdminMenuItem)((Object)this._mapIdToMenuItem.get(n));
    }

    public AdminMenuItem getMenuItem(IAdminProp iAdminProp) {
        return (AdminMenuItem)((Object)this._mapCmdToMenuItem.get(iAdminProp));
    }

    public AdminMenuItem getMenuItem(int n) {
        return (AdminMenuItem)((Object)this._mapIdToMenuItem.get(new Integer(n)));
    }

    public AdminMenuItem getMenuItem(String string) {
        return this.getMenuItem(this.getId(string));
    }

    public int getId(IAdminProp iAdminProp) {
        if (iAdminProp == null) {
            return 0;
        }
        return this.getId(this.getMenuItem(iAdminProp));
    }

    public int getId(AdminMenuItem adminMenuItem) {
        if (adminMenuItem == null) {
            return 0;
        }
        Integer n = (Integer)this._mapIdToMenuItem.get((Object)adminMenuItem);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public int getId(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)this._mapIdToName.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void mapIdToImage(int n, String string) {
        if (this._mapIdToImage == null) {
            this._mapIdToImage = new Hashtable();
        }
        Integer n2 = new Integer(n);
        this._mapIdToImage.put(n2, string);
    }

    public String getImageName(int n) {
        Integer n2 = new Integer(n);
        return (String)this._mapIdToImage.get(n2);
    }

    public void mapIdToName(int n, String string, boolean bl) {
        if (this._mapIdToName == null) {
            this._mapIdToName = new Hashtable();
        }
        Integer n2 = new Integer(n);
        this._mapIdToName.put(n2, string);
        this._mapIdToName.put(string, n2);
        if (this._mapIdToEnabled == null) {
            this._mapIdToEnabled = new Hashtable();
        }
        if (!bl) {
            this._mapIdToEnabled.put(n2, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getEnabled(int n) {
        Boolean bl;
        if (this._mapIdToEnabled == null) {
            this._mapIdToEnabled = new Hashtable();
        }
        if ((bl = (Boolean)this._mapIdToEnabled.get(new Integer(n))) == null) {
            return true;
        }
        return bl;
    }

    public String getName(int n) {
        return (String)this._mapIdToName.get(new Integer(n));
    }

    public String getName(IAdminProp iAdminProp) {
        if (iAdminProp == null) {
            return null;
        }
        return this.getName(this.getMenuItem(iAdminProp));
    }

    public String getName(AdminMenuItem adminMenuItem) {
        return (String)this._mapIdToName.get(new Integer(this.getId(adminMenuItem)));
    }

    public IAdminProp getCmd(int n) {
        return (IAdminProp)this._mapCmdToMenuItem.get((Object)this.getMenuItem(n));
    }

    public IAdminProp getCmd(AdminMenuItem adminMenuItem) {
        if (adminMenuItem == null) {
            return null;
        }
        return (IAdminProp)this._mapCmdToMenuItem.get((Object)adminMenuItem);
    }

    public IAdminProp getCmd(String string) {
        if (string == null) {
            return null;
        }
        return (IAdminProp)this._mapCmdToMenuItem.get((Object)this.getMenuItem(string));
    }

    public void init() {
        this.mapIdToName(-1, ClientLang.getStrChangeDatabaseConnection(), false);
        this.mapIdToName(-4, ClientLang.getStrConnect(), false);
        this.mapIdToName(-2, ClientLang.getStrConnect(), false);
        this.mapIdToName(-3, ClientLang.getStrDisconnect(), false);
        this.mapIdToName(-11, ClientLang.getStrExit(), true);
        this.mapIdToName(-12, "Undo", false);
        this.mapIdToName(-13, "Redo", false);
        this.mapIdToName(-14, "Cut", false);
        this.mapIdToName(-15, "Copy", false);
        this.mapIdToName(-16, "Paste", false);
        this.mapIdToName(-51, ClientLang.getStrEdit(), false);
        this.mapIdToName(-52, "Debug", true);
        this.mapIdToName(-9, ClientLang.getStrDelete(), false);
        this.mapIdToName(-17, "Select All", false);
        this.mapIdToName(-18, ClientLang.getStrFindObjects(), true);
        this.mapIdToName(-19, "Find Again", true);
        this.mapIdToName(-20, "Preferences...", true);
        this.mapIdToName(-5, ClientLang.getStrRefresh(), false);
        this.mapIdToName(-21, ClientLang.getStrTearOff(), true);
        this.mapIdToName(-22, "Relationships", false);
        this.mapIdToName(-23, "Code", false);
        this.mapIdToName(-24, "Properties", true);
        this.mapIdToName(-25, "Table", false);
        this.mapIdToName(-26, "List", false);
        this.mapIdToName(-27, "Navigator Control", false);
        this.mapIdToName(-28, "Toolbar", false);
        this.mapIdToName(-29, "Status bar", false);
        this.mapIdToName(-6, "Filter", false);
        this.mapIdToName(-31, "Sort", false);
        this.mapIdToName(-32, "Query", false);
        this.mapIdToName(-33, "Split Navigator control", false);
        this.mapIdToName(-34, "Expand One Level", false);
        this.mapIdToName(-35, "Collapse Branch", false);
        this.mapIdToName(-36, "Collapse All", false);
        this.mapIdToName(-7, ClientLang.getStrAdvancedMode(), false);
        this.mapIdToName(-8, ClientLang.getStrCreate(), false);
        this.mapIdToName(-10, ClientLang.getStrCreateLike(), false);
        this.mapIdToName(-38, "Record", false);
        this.mapIdToName(-39, "Stop", false);
        this.mapIdToName(-41, "Pause", false);
        this.mapIdToName(-42, ClientLang.getStrContents(), true);
        this.mapIdToName(-43, ClientLang.getStrSearchForHelpOn(), true);
        this.mapIdToName(-44, "Context Sensitive Help", true);
        this.mapIdToName(-45, ClientLang.getStrHowToUseHelp(), true);
        this.mapIdToName(-46, ClientLang.getStrQuickTour(), true);
        this.mapIdToName(-47, "Cue Cards", true);
        this.mapIdToName(-48, NavigatorFrame._aboutMenuLabel, true);
        this.mapIdToImage(-1, "images/reconnect.gif");
        this.mapIdToImage(-4, "images/connect.gif");
        this.mapIdToImage(-2, "images/connect.gif");
        this.mapIdToImage(-3, "images/disconnect.gif");
        this.mapIdToImage(-11, "images/exit.gif");
        this.mapIdToImage(-12, "images/undo.gif");
        this.mapIdToImage(-13, "images/redo.gif");
        this.mapIdToImage(-14, "images/cut.gif");
        this.mapIdToImage(-15, "images/copy.gif");
        this.mapIdToImage(-16, "images/paste.gif");
        this.mapIdToImage(-9, "images/delete.gif");
        this.mapIdToImage(-17, "images/selectAll.gif");
        this.mapIdToImage(-18, "images/findObject.gif");
        this.mapIdToImage(-19, "images/findAgain.gif");
        this.mapIdToImage(-20, "images/preference.gif");
        this.mapIdToImage(-5, "images/refresh.gif");
        this.mapIdToImage(-21, "images/tearOff.gif");
        this.mapIdToImage(-22, "images/relationships.gif");
        this.mapIdToImage(-23, "images/code.gif");
        this.mapIdToImage(-24, "images/properties.gif");
        this.mapIdToImage(-25, "images/table.gif");
        this.mapIdToImage(-26, "images/list.gif");
        this.mapIdToImage(-27, "images/navigator.gif");
        this.mapIdToImage(-28, "images/toolbar.gif");
        this.mapIdToImage(-29, "images/statusBar.gif");
        this.mapIdToImage(-6, "images/filter.gif");
        this.mapIdToImage(-31, "images/sort.gif");
        this.mapIdToImage(-32, "images/query.gif");
        this.mapIdToImage(-33, "images/split.gif");
        this.mapIdToImage(-34, "images/expandOne.gif");
        this.mapIdToImage(-35, "images/collapseOne.gif");
        this.mapIdToImage(-36, "images/collapseAll.gif");
        this.mapIdToImage(-8, "images/create.gif");
        this.mapIdToImage(-10, "images/createlike.gif");
        this.mapIdToImage(-38, "images/record.gif");
        this.mapIdToImage(-39, "images/stop.gif");
        this.mapIdToImage(-41, "images/pause.gif");
        this.mapIdToImage(-42, "images/contents.gif");
        this.mapIdToImage(-43, "images/help.gif");
        this.mapIdToImage(-44, "images/help.gif");
        this.mapIdToImage(-45, "images/help.gif");
        this.mapIdToImage(-46, "images/quickTour.gif");
        this.mapIdToImage(-47, "images/curCards.gif");
        this.mapIdToImage(-48, "images/about.gif");
    }

    public boolean CreateMenu() {
        this.init();
        this._ma = new MenuAction((Frame)((Object)this._frame), this);
        if (this._fInitialized || this._frame == null) {
            return false;
        }
        this._mb = new AdminMenuBar();
        this.createFileMenu(this._mb, this._ma);
        this.createEditMenu(this._mb, this._ma);
        this.createViewMenu(this._mb, this._ma);
        this.createObjectMenu(this._mb, this._ma);
        this.createSpecialMenu(this._mb, this._ma);
        this.createHelpMenu(this._mb, this._ma);
        this._fInitialized = true;
        this._lastCmdMenuOwner = null;
        this._cmdMenuInstalled = false;
        this._frame.setAdminMenuBar(this._mb);
        return true;
    }

    protected void createFileMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        this._mFile = new AdminMenu(ClientLang.getStrFile());
        adminMenuBar.add(this._mFile);
        if (this.showMnemonic()) {
            this._mFile.setMnemonicChar('F');
        }
        AdminMenuItem adminMenuItem = this.createMenuItem(this._mFile, -8, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem.setMnemonicChar('C');
        }
        AdminMenuItem adminMenuItem2 = this.createMenuItem(this._mFile, -10, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem2.setMnemonicChar('L');
        }
        this._mFile.addSeparator();
        this._mFileConnect = this.createMenuItem(this._mFile, -1, menuAction);
        AdminMenuItem adminMenuItem3 = this.createMenuItem(this._mFile, -4, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem3.setMnemonicChar('n');
        }
        this._mFile.addSeparator();
        this._mFileExit = this.createMenuItem(this._mFile, -11, menuAction);
        if (this.showMnemonic()) {
            this._mFileExit.setMnemonicChar('x');
        }
    }

    protected void createEditMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        AdminMenu adminMenu = new AdminMenu(ClientLang.getStrEdit());
        adminMenuBar.add(adminMenu);
        if (this.showMnemonic()) {
            adminMenu.setMnemonicChar('E');
        }
        AdminMenuItem adminMenuItem = this.createMenuItem(adminMenu, -51, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem.setMnemonicChar('d');
        }
        AdminMenuItem adminMenuItem2 = this.createMenuItem(adminMenu, -9, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem2.setMnemonicChar('R');
        }
        adminMenu.addSeparator();
        AdminMenuItem adminMenuItem3 = this.createMenuItem(adminMenu, -18, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem3.setMnemonicChar('F');
        }
    }

    protected void createViewMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        this._mView = new AdminMenu(ClientLang.getStrView());
        adminMenuBar.add(this._mView);
        if (this.showMnemonic()) {
            this._mView.setMnemonicChar('V');
        }
        this._mViewRefresh = this.createMenuItem(this._mView, -5, menuAction);
        if (this.showMnemonic()) {
            this._mViewRefresh.setMnemonicChar('R');
        }
        this._mView.addSeparator();
        AdminMenuItem adminMenuItem = this.createMenuItem(this._mView, -21, menuAction);
        if (this.showMnemonic()) {
            adminMenuItem.setMnemonicChar('T');
        }
        if (NavigatorFrame.EDITOR_PROPERTIES) {
            this.createMenuItem(this._mView, -24, menuAction);
        }
        if (SHOW_DEBUG_MENU_ITEM) {
            this._mView.addSeparator();
            this._mViewAdvance = this.createMenuItem(this._mView, -52, menuAction);
            if (this.showMnemonic()) {
                this._mViewAdvance.setMnemonicChar('D');
            }
        }
    }

    protected void createObjectMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
    }

    protected void createSpecialMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        try {
            Object object;
            int n = 0;
            IAdminProp iAdminProp = ((IFrame)((Object)this._frame)).getRoot();
            if (iAdminProp == null) {
                return;
            }
            IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
            if (iAdminPropArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < iAdminPropArray.length) {
                try {
                    IAdminProp[] iAdminPropArray2;
                    object = (String)iAdminPropArray[n2].getProp(1114271);
                    if (object != null && (iAdminPropArray2 = (IAdminProp[])iAdminPropArray[n2].getProp(272695456)) != null && iAdminPropArray2.length != 0) {
                        ++n;
                    }
                }
                catch (Exception exception) {
                    AdminProp.sUnexpectedException(exception);
                }
                ++n2;
            }
            object = null;
            int n3 = 0;
            while (n3 < iAdminPropArray.length) {
                block24: {
                    try {
                        String string = (String)iAdminPropArray[n3].getProp(1114271);
                        if (string == null) break block24;
                        int n4 = 0;
                        AdminMenu adminMenu = null;
                        int n5 = 0;
                        while (n5 < 2) {
                            int n6 = n5 == 0 ? 272695456 : 272696468;
                            IAdminProp[] iAdminPropArray3 = (IAdminProp[])iAdminPropArray[n3].getProp(n6);
                            if (iAdminPropArray3 != null && iAdminPropArray3.length != 0) {
                                if (object == null && n > 1) {
                                    object = new AdminMenu("Application");
                                    this._specialMenu = object;
                                    adminMenuBar.add((AdminMenu)((Object)object));
                                }
                                if (adminMenu == null) {
                                    String string2;
                                    adminMenu = new AdminMenu(string);
                                    if (n > 1) {
                                        ((Container)object).add((Component)((Object)adminMenu));
                                    } else {
                                        this._specialMenu = adminMenu;
                                        adminMenuBar.add(adminMenu);
                                    }
                                    if (this.showMnemonic() && (string2 = (String)iAdminPropArray[n3].getProp(2032137)) != null) {
                                        adminMenu.setMnemonicChar(string2.charAt(0));
                                    }
                                }
                                if (n5 == 1 && n4 != 0) {
                                    adminMenu.addSeparator();
                                }
                                int n7 = 0;
                                while (n7 < iAdminPropArray3.length) {
                                    if (iAdminPropArray3[n7] != null) {
                                        try {
                                            String string3;
                                            AdminMenuItem adminMenuItem = this.createMenuItem(adminMenu, (String)iAdminPropArray3[n7].getProp(0x110001), menuAction);
                                            if (this.showMnemonic() && (string3 = (String)iAdminPropArray3[n7].getProp(2032137)) != null) {
                                                adminMenuItem.setMnemonicChar(string3.charAt(0));
                                            }
                                            menuAction.associateCommandProp(adminMenuItem, iAdminPropArray3[n7]);
                                            ++n4;
                                        }
                                        catch (Exception exception) {
                                            AdminProp.sUnexpectedException(exception);
                                        }
                                    }
                                    ++n7;
                                }
                            }
                            ++n5;
                        }
                    }
                    catch (Exception exception) {
                        AdminProp.sUnexpectedException(exception);
                    }
                }
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    protected void createLogMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        this._mLog = new AdminMenu("Log");
        adminMenuBar.add(this._mLog);
        this._mLogRecord = this.createMenuItem(this._mLog, -38, menuAction);
        this._mLogStop = this.createMenuItem(this._mLog, -39, menuAction);
        this._mLogPause = this.createMenuItem(this._mLog, -41, menuAction);
    }

    protected void createHelpMenu(AdminMenuBar adminMenuBar, MenuAction menuAction) {
        this._mHelp = new AdminMenu(ClientLang.getStrHelp());
        adminMenuBar.add(this._mHelp);
        if (this.showMnemonic()) {
            this._mHelp.setMnemonicChar('H');
        }
        adminMenuBar.setHelpMenu(this._mHelp);
        this._mHelpContents = this.createMenuItem(this._mHelp, -42, menuAction);
        if (this.showMnemonic()) {
            this._mHelpContents.setMnemonicChar('C');
        }
        this._mHelpSearch = this.createMenuItem(this._mHelp, -43, menuAction);
        if (this.showMnemonic()) {
            this._mHelpSearch.setMnemonicChar('S');
        }
        this._mHelp.addSeparator();
        this._mHelpAbout = this.createMenuItem(this._mHelp, -48, menuAction);
        if (this.showMnemonic()) {
            this._mHelpAbout.setMnemonicChar('A');
        }
    }

    protected void disableMenuItem(String string) {
        ((Component)((Object)this.getMenuItem(string))).setEnabled(false);
    }

    public void resetMenu(IAdminProp iAdminProp) {
        if (this._lastCmdMenuOwner == iAdminProp) {
            return;
        }
        this._lastCmdMenuOwner = iAdminProp;
        try {
            CommandProp[] commandPropArray = (CommandProp[])iAdminProp.getProp(273613322);
            this.replaceMenu(commandPropArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void replaceMenu(CommandProp[] commandPropArray) {
        if (commandPropArray == null) {
            if (!this._cmdMenuInstalled) {
                return;
            }
            this._mb = new AdminMenuBar();
            this.createFileMenu(this._mb, this._ma);
            this.createEditMenu(this._mb, this._ma);
            this.createViewMenu(this._mb, this._ma);
            this.createObjectMenu(this._mb, this._ma);
            this.createHelpMenu(this._mb, this._ma);
            this._frame.setAdminMenuBar(this._mb);
            this._cmdMenuInstalled = false;
            return;
        }
        try {
            int n = this._mb.getMenuCount() - 1;
            while (n > 3) {
                AdminMenu adminMenu = this._mb.getMenu(n);
                int n2 = adminMenu.getItemCount();
                int n3 = 0;
                while (n3 < n2) {
                    adminMenu.getItem(n3).removeActionListener(this._ma);
                    ++n3;
                }
                this._mb.remove(n);
                --n;
            }
            int n4 = 0;
            while (n4 < commandPropArray.length) {
                String string = (String)commandPropArray[n4].getProp(0x110001);
                AdminMenu adminMenu = new AdminMenu(string);
                this._mb.add(adminMenu);
                CommandProp[] commandPropArray2 = (CommandProp[])commandPropArray[n4].getProp(273613322);
                int n5 = 0;
                while (n5 < commandPropArray2.length) {
                    String string2 = (String)commandPropArray2[n5].getProp(0x110001);
                    this.createMenuItem(adminMenu, string2, this._ma);
                    ++n5;
                }
                ++n4;
            }
            this.createLogMenu(this._mb, this._ma);
            this.createHelpMenu(this._mb, this._ma);
            this._cmdMenuInstalled = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
            try {
                AdminMenuItem adminMenuItem = this.getMenuItem((Integer)iAdminProp.getProp(2687496));
                if (adminMenuItem != null) {
                    switch (adminPropertyChangeEvent.getPropId()) {
                        case 8978948: {
                            ((Component)((Object)adminMenuItem)).setEnabled((Boolean)iAdminProp.getProp(8978948));
                            return;
                        }
                        case 0x110001: {
                            adminMenuItem.setLabel((String)iAdminProp.getProp(0x110001));
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public void mergeIn(PropToolbar propToolbar) {
        Vector vector = propToolbar.getCmdList();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n2);
                AdminMenuItem adminMenuItem = this.getMenuItem((Integer)iAdminProp.getProp(2687496));
                if (adminMenuItem == null) {
                    if (propToolbar.isVisibleCmd(iAdminProp) && this._specialMenu != null && !propToolbar.isGlobal()) {
                        try {
                            adminMenuItem = this.createMenuItem(this._specialMenu, (String)iAdminProp.getProp(0x110001), this._ma);
                            this._ma.associateCommandProp(adminMenuItem, iAdminProp);
                        }
                        catch (Exception exception) {
                            AdminProp.sUnexpectedException(exception);
                        }
                    }
                } else if (this.getCommand(adminMenuItem) == null) {
                    iAdminProp.addAdminPropertyChangeListener(this);
                    this.setCommand(adminMenuItem, iAdminProp);
                }
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
            }
            ++n2;
        }
    }

    public void mergeOut(PropToolbar propToolbar) {
        Vector vector = propToolbar.getCmdList();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            block9: {
                try {
                    IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n2);
                    AdminMenuItem adminMenuItem = this.getMenuItem((Integer)iAdminProp.getProp(2687496));
                    if (adminMenuItem == null) {
                        if (!propToolbar.isVisibleCmd(iAdminProp) || this._specialMenu == null || propToolbar.isGlobal()) break block9;
                        try {
                            adminMenuItem = this._ma.getMenuItem(iAdminProp);
                            if (adminMenuItem != null) {
                                this._specialMenu.remove(adminMenuItem);
                                this._ma.disassociateCommandProp(adminMenuItem, iAdminProp);
                            }
                            break block9;
                        }
                        catch (Exception exception) {
                            AdminProp.sUnexpectedException(exception);
                        }
                        break block9;
                    }
                    if (this.getCommand(adminMenuItem) == iAdminProp) {
                        iAdminProp.removeAdminPropertyChangeListener(this);
                        this.setCommand(adminMenuItem, null);
                    }
                }
                catch (Exception exception) {
                    AdminProp.sUnexpectedException(exception);
                }
            }
            ++n2;
        }
    }

    public boolean showMnemonic() {
        return this._showmnemonic;
    }
}

