/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Vector;
import oracle.ldap.admin.appserver.AppServerRoot;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ConnectDialog;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.ICommandEditor;
import oracle.ldap.admin.client.IFrame;
import oracle.ldap.admin.client.ISelectionOwner;
import oracle.ldap.admin.client.MenuAction;
import oracle.ldap.admin.client.NavFolderItem;
import oracle.ldap.admin.client.NavHTree;
import oracle.ldap.admin.client.NavMenu;
import oracle.ldap.admin.client.NavRootItem;
import oracle.ldap.admin.client.NavStatusBar;
import oracle.ldap.admin.client.PropToolbar;
import oracle.ldap.admin.client.RightNavPanel;
import oracle.ldap.admin.client.SplashCanvas;
import oracle.ldap.admin.client.ToolBarPanel;
import oracle.ldap.admin.client.ToolbarParent;
import oracle.ldap.admin.client.allDebugFlags;
import oracle.ldap.admin.client.common.AdminBorderPanel;
import oracle.ldap.admin.client.common.AdminFrame;
import oracle.ldap.admin.client.common.AdminImageCanvas;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminScrollBox;
import oracle.ldap.admin.client.common.AdminScrollPane;
import oracle.ldap.admin.client.common.AdminSearchCriteria;
import oracle.ldap.admin.client.common.AdminSplitter;
import oracle.ldap.admin.client.propEditors.CriteriaView;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.SplitPanelView;
import oracle.ldap.admin.client.propEditors.TabPage;
import oracle.ldap.admin.client.propEditors.TabView;
import oracle.ldap.admin.client.propEditors.Table;
import oracle.ldap.admin.client.propEditors.WizardView;
import oracle.ldap.admin.common.AdminDirectory;
import oracle.ldap.admin.common.AdminLang;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.help.AdminHelp;
import oracle.ldap.admin.oemclient.TreeDetailApp;

public class NavigatorFrame
extends AdminFrame
implements AdminPropertyChangeListener,
ICommandEditor,
IFrame {
    String _title = "Oracle InterOffice Administration";
    public static String _aboutMenuLabel = "About Oracle InterOffice Administration";
    public static boolean DEBUG;
    public static boolean DEBUG_TRACE;
    public static boolean DEBUG_CURSOR;
    public static boolean EDITOR_PROPERTIES;
    static String corbaCltArg;
    private boolean _useCorbaClient = false;
    private boolean _useAppServer = false;
    String m_autoEditObject;
    Vector m_autoOpenObject;
    Vector m_autoStandaloneObject;
    static int m_windowCount;
    IAdminProp _root;
    TreeDetailApp m_emapp;
    static Vector m_helpBookInfo;
    int m_titleIndex;
    Vector m_titleHistory;
    boolean m_ignoreTitleUpdate = false;
    Component _editor;
    IAdminProp _prop;
    ISelectionOwner m_selectionOwner;
    static final int TB_CONNECT_INDX = 0;
    static final int TB_SEPARATOR_INDX = 1;
    static final int TB_REFRESH_INDX = 2;
    static final int TB_ADVANCED_INDX = 3;
    static final int TB_SEPARATOR2_INDX = 4;
    static final int TB_CREATE_INDX = 5;
    static final int TB_CREATELIKE_INDX = 6;
    static final int TB_REMOVE_INDX = 7;
    static final int TB_SEPARATOR3_INDX = 8;
    static final int TB_HELP_INDX = 9;
    public boolean m_disableHelpToolbar = false;
    NavMenu m_menuBar;
    PropToolbar _toolbar;
    PropToolbar _toolbar2;
    AdminBorderPanel m_toolbarHolder;
    private IAdminProp[] _toolbarCommandList;
    ToolbarParent _toolbarParent;
    ToolBarPanel m_toolBarPanel;
    AdminScrollBox m_leftSplitterPanel;
    RightNavPanel m_rightSplitterPanel;
    AdminScrollPane m_rightScrollPanel;
    NavHTree m_htree;
    NavStatusBar m_statusBar;
    SplashCanvas m_splashCanvas;
    GridBagLayout m_toolbarHolderGBL;
    Vector m_toolbars = new Vector();
    AdminBorderPanel m_toolbarHolderParent;
    RecessedPane m_leftPane;
    RecessedPane m_rightPane;
    NavFolderItem[] m_treeItems;
    AdminSplitter m_splitter;
    SplitPanelView m_splitter2;
    CommandProp m_historyForward;
    CommandProp m_historyBackward;
    CommandProp m_popPath;

    public static void main(String[] stringArray) {
        NavigatorFrame navigatorFrame = new NavigatorFrame(null, stringArray);
        navigatorFrame.init(stringArray);
    }

    public void parseArgs(String[] stringArray) {
        String string = System.getProperty(corbaCltArg);
        if (string != null && string.equalsIgnoreCase("true")) {
            this._useCorbaClient = true;
            System.out.println("use corba client");
        }
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-help")) {
                System.out.println("Help for Main Window Configuration:");
                System.out.println(" -NavigatorFrame:Start - denotes start of Main Window command line options.");
                System.out.println(" -NavigatorFrame:End - denotes end of Main Window command line options.");
                System.out.println(" -title <string> - set title of main window.");
                System.out.println(" -aboutMenuLabel <string> - set menu item label of \"Help/About...\"");
                System.out.println(" -edit <path> - opens 'path' in tree view and edits object in right hand panel.");
                System.out.println(" -open <path> - opens 'path' in tree view.");
                System.out.println(" -editStandalone <path>- edits object at given 'path' in standalone editor.");
                System.out.println(" -disallowTabsInTabs - disallows the use of tab pages inside of parent tab pages.");
                System.out.println(" -disableButtonDisabling - enable the feature to disable ok/apply buttons appropriately.");
                System.out.println("\nDEBUG FLAGS:");
                System.out.println(" -debugPropertyEditor - turn on debug code in property editor.");
                System.out.println(" -debugSplitPanelView - turn on debug code in split panel viewer.");
                System.out.println(" -debugTabView - turn on debug code in tab view.");
                System.out.println(" -debugTable - turn on debug code in Table viewer.");
                System.out.println(" -debugTree - turn on debug code in Tree viewer.");
                System.out.println(" -debugHelp - turn on debug code in Help package.");
                System.out.println(" -debugNavigatorFrame - turn on debug code in NavigatorFrame.");
                System.out.println(" -debugPropToolbar - turn on debug code in toolbar package.");
                System.out.println(" -debugDataTrace - turn on data access (set value, get value) tracing.");
                System.out.println(" -dumpWindows - cause the 'About' menu item to print out layout of main window and its subwindows.");
                System.out.println(" -dumpPrefSize - cause the 'About' menu item to print out preferred sizes of the main window and its subwindows.");
                System.out.println(" -debugNotifications - turn on debug messages for notications.");
                System.out.println(" -debugAdminDirectory - turn on debug messages for directory lookup.");
                System.out.println(" -debugMotifUI - make property editor layout items based on motif limitation.");
                System.out.println(" -debugLang - turn on debug messages in NLS lookup package.");
                System.out.println(" -debugCriteriaView - turn on debug messages in Criteria View.");
                System.out.println(" -debugGridViewLayout - turn on layout editor for Grid View.");
                System.out.println(" -debugWizardView - turn on debug messages for wizard view.");
            }
            if (stringArray[n].equalsIgnoreCase("-NavigatorFrame:Start")) {
                ++n;
                while (n < stringArray.length) {
                    if (stringArray[n].equalsIgnoreCase("-NavigatorFrame:End")) break;
                    if (stringArray[n].equalsIgnoreCase("-title") && n + 1 < stringArray.length) {
                        this._title = stringArray[++n].replace('_', ' ');
                    }
                    if (stringArray[n].equalsIgnoreCase("-aboutMenuLabel") && n + 1 < stringArray.length) {
                        _aboutMenuLabel = stringArray[++n].replace('_', ' ');
                    } else if (stringArray[n].equalsIgnoreCase("-" + corbaCltArg) && n + 1 < stringArray.length) {
                        String string2;
                        if ((string2 = stringArray[++n]).equalsIgnoreCase("true")) {
                            this._useCorbaClient = true;
                            System.out.println("use corba client");
                        }
                    } else if (stringArray[n].equalsIgnoreCase("-debug")) {
                        NavMenu.SHOW_DEBUG_MENU_ITEM = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugGridViewLayout")) {
                        EDITOR_PROPERTIES = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugWizardView")) {
                        WizardView.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-disableButtonDisabling")) {
                        RightNavPanel.ENABLE_BUTTON_DISABLING = false;
                    } else if (stringArray[n].equalsIgnoreCase("-disallowTabsInTabs")) {
                        TabPage.DISALLOW_SUBTAB_VIEW = true;
                    } else if (stringArray[n].equalsIgnoreCase("-AppServer")) {
                        this._useAppServer = true;
                        System.out.println("Using AppServer.");
                    } else if (stringArray[n].equalsIgnoreCase("-edit")) {
                        this.m_autoEditObject = stringArray[++n];
                    } else if (stringArray[n].equalsIgnoreCase("-open")) {
                        if (this.m_autoOpenObject == null) {
                            this.m_autoOpenObject = new Vector();
                        }
                        this.m_autoOpenObject.addElement(stringArray[++n]);
                    } else if (stringArray[n].equalsIgnoreCase("-editStandalone")) {
                        if (this.m_autoStandaloneObject == null) {
                            this.m_autoStandaloneObject = new Vector();
                        }
                        this.m_autoStandaloneObject.addElement(stringArray[++n]);
                    } else if (stringArray[n].equalsIgnoreCase("-debugTable")) {
                        Table.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugMotifUI")) {
                        GridView.ASSUME_SOLARIS = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugLang")) {
                        AdminLang.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugCriteriaView")) {
                        if (CriteriaView.DEBUG) {
                            AdminSearchCriteria.DEBUG = true;
                        }
                        CriteriaView.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugPropertyEditor") || stringArray[n].equalsIgnoreCase("-debugGridView")) {
                        GridView.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugSplitPanelView")) {
                        SplitPanelView.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugTabView")) {
                        TabView.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugNotifications")) {
                        AdminUtil.DEBUG_NOTIFICATIONS = true;
                        AdminProp.DEBUG_NOTIFICATIONS = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugAdminDirectory")) {
                        AdminDirectory.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugTree")) {
                        NavFolderItem.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugHelp")) {
                        AdminHelp.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-dumpPrefSize")) {
                        MenuAction.DUMP_PREF_SIZE = true;
                    } else if (stringArray[n].equalsIgnoreCase("-dumpWindows")) {
                        MenuAction.DUMP_WINDOWS = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugNavigatorFrame")) {
                        DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugPropToolbar")) {
                        PropToolbar.DEBUG = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugDataTrace")) {
                        DEBUG_TRACE = true;
                    } else if (stringArray[n].equalsIgnoreCase("-debugCursor")) {
                        DEBUG_CURSOR = true;
                    }
                    ++n;
                }
            }
            ++n;
        }
    }

    public void setTitle(IAdminProp iAdminProp) {
        if (iAdminProp == null) {
            return;
        }
        try {
            IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
            if (iAdminPropArray != null) {
                int n = 0;
                while (n < iAdminPropArray.length) {
                    String string;
                    String string2 = (String)iAdminPropArray[n].getProp(2032709);
                    if (string2 != null) {
                        this._title = string2;
                    }
                    if ((string = (String)iAdminPropArray[n].getProp(2032710)) != null) {
                        _aboutMenuLabel = string;
                    }
                    if (this._title != null) {
                        return;
                    }
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
    }

    public Vector getGlobalCmdItems() {
        IAdminProp iAdminProp = this.getRoot();
        Vector<IAdminProp> vector = new Vector<IAdminProp>();
        try {
            IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
            if (iAdminPropArray != null) {
                int n = 0;
                while (n < iAdminPropArray.length) {
                    IAdminProp[] iAdminPropArray2 = (IAdminProp[])iAdminPropArray[n].getProp(272696468);
                    if (iAdminPropArray2 != null) {
                        int n2 = 0;
                        while (n2 < iAdminPropArray2.length) {
                            vector.addElement(iAdminPropArray2[n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public void setIconImage(IAdminProp iAdminProp) {
        Object object;
        if (iAdminProp == null) {
            return;
        }
        try {
            object = (IAdminProp[])iAdminProp.getProp(273612805);
            if (object != null) {
                int n = 0;
                while (n < ((IAdminProp[])object).length) {
                    Image image;
                    String string = (String)object[n].getProp(1639544);
                    if (string != null && (image = AdminUtil.loadImage(string, (Component)((Object)this))) != null) {
                        ((Frame)((Object)this)).setIconImage(image);
                        return;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        if ((object = AdminUtil.loadImage("images/ldaplo.gif", (Component)((Object)this))) != null) {
            ((Frame)((Object)this)).setIconImage((Image)object);
        }
    }

    public NavigatorFrame() {
    }

    public NavigatorFrame(Applet applet, String[] stringArray) {
        ++m_windowCount;
        this.parseArgs(stringArray);
        this.setTitle(this.getRoot(stringArray));
        this.setIconImage(this.getRoot());
        ((Frame)((Object)this)).addNotify();
        int n = 0;
        String string = Locale.getDefault().toString();
        if (string.startsWith("fr")) {
            n = 250;
        }
        ((Component)((Object)this)).setSize(this.getInsets().left + this.getInsets().right + 900 + n, this.getInsets().top + this.getInsets().bottom + 600);
        ((Component)((Object)this)).setLocation(50, 50);
        ((Frame)((Object)this)).setTitle(this._title);
        AdminUtil.setNavigatorFrame(this);
        AdminUtil.setApplet(applet);
        ((Window)((Object)this)).addWindowListener(new WAdapter());
    }

    public void init(String[] stringArray) {
        this.init(stringArray, true);
    }

    public void init(String[] stringArray, boolean bl) {
        Object object;
        block14: {
            IAdminProp iAdminProp = this.getRoot(stringArray);
            if (iAdminProp instanceof AppServerRoot) {
                AdminUtil.editStandalone(iAdminProp, null, (Component)((Object)this));
                if (AdminUtil.isLogonObject(iAdminProp)) {
                    System.exit(0);
                }
            }
            this.initializeHelp();
            Window window = null;
            try {
                object = (IAdminProp[])iAdminProp.getProp(273612805);
                if (object == null) break block14;
                int n = 0;
                while (n < ((IAdminProp[])object).length) {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])object[n].getProp(273220679);
                    if (iAdminPropArray != null) {
                        if (window == null) {
                            window = new Window((Frame)((Object)this));
                            window.add("Center", (Component)((Object)new AdminImageCanvas(SplashCanvas.getBannerImage())));
                            window.pack();
                            ((Component)window).setSize(window.getPreferredSize());
                            ((Component)window).setLocation(200, 200);
                        }
                        new Thread((Runnable)new backgroundSplash(window), "Splash Screen Display").start();
                        int n2 = 0;
                        while (n2 < iAdminPropArray.length) {
                            try {
                                AdminUtil.editStandalone(iAdminPropArray[n2], null, (Component)((Object)this));
                                if (iAdminPropArray[n2].getProp(2163220) != null) {
                                    this.shutDown();
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                new ErrorAlert((Frame)((Object)this), exception);
                            }
                            ++n2;
                        }
                        ((Component)window).setVisible(false);
                    } else {
                        IAdminProp iAdminProp2 = (IAdminProp)object[n].getProp(4785223);
                        if (iAdminProp2 != null) {
                            if (window == null) {
                                window = new Window((Frame)((Object)this));
                                SplashCanvas splashCanvas = new SplashCanvas();
                                window.add("Center", (Component)((Object)splashCanvas));
                                splashCanvas.setLogonSplashScreen();
                                window.pack();
                                ((Component)window).setSize(window.getPreferredSize());
                                ((Component)window).setLocation(200, 200);
                            }
                            ((Component)window).setVisible(true);
                            AdminUtil.editStandalone(iAdminProp2, null, (Component)((Object)this));
                            ((Component)window).setVisible(false);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                new ErrorAlert((Frame)((Object)this), exception);
            }
        }
        object = new ConnectDialog(ClientLang.getStrLoadingSchema());
        ((ConnectDialog)object).run();
        this.buildUI();
        this.m_menuBar = new NavMenu(this);
        this.m_menuBar.CreateMenu();
        this.m_menuBar.mergeIn(this._toolbar);
        this.populateTree(this.m_htree, stringArray);
        ((ConnectDialog)object).stop();
        ((Component)((Object)this)).setVisible(bl);
        this.fixupToolbar(this._toolbar2);
    }

    public boolean filterOutMainCommands() {
        return false;
    }

    public boolean useNavigatorToolbar() {
        return false;
    }

    public TreeDetailApp getEMApp() {
        return this.m_emapp;
    }

    public void setEMApp(TreeDetailApp treeDetailApp) {
        this.m_emapp = treeDetailApp;
    }

    public void buildToolbar() {
        if (DEBUG) {
            System.out.println("\nNavigatorFrame.buildToolbar\n");
        }
        if (this._toolbarParent == null) {
            this._toolbarParent = new ToolbarParent((Frame)((Object)this));
        }
        if (this._toolbar == null) {
            this._toolbar = this.createToolBar(this._toolbarParent, this.filterOutMainCommands());
        }
        this._toolbar.setAuxillaryToolbar(null);
        this.addEditorToolbar(this._toolbar, 0);
        this._toolbar2 = new PropToolbar(new navigateBar());
        if (this.useNavigatorToolbar()) {
            this.addEditorToolbar(this._toolbar2, 1);
        }
        this._toolbar2.setGlobal(true);
        this._toolbar.setGlobal(true);
        ((Component)((Object)this._toolbar)).setEnabled(true);
        this.fixupToolbar(this._toolbar);
        this.fixupToolbar(this._toolbar2);
    }

    private void buildUI() {
        this.buildToolbar();
        this.m_htree = new NavHTree(new NavRootItem());
        AdminScrollBox adminScrollBox = new AdminScrollBox((Component)((Object)this.m_htree));
        adminScrollBox.setLoweredFrameBorder(2);
        this.m_leftSplitterPanel = adminScrollBox;
        this.m_rightSplitterPanel = new RightNavPanel();
        this.m_rightSplitterPanel.setIFrame(this);
        this.m_splashCanvas = new SplashCanvas();
        AdminPanel adminPanel = new AdminPanel();
        ((Container)((Object)adminPanel)).add("Center", (Component)((Object)this.m_splashCanvas));
        ((Container)((Object)this.m_rightSplitterPanel)).add("Center", (Component)((Object)adminPanel));
        this.m_leftPane = new RecessedPane((Component)((Object)this.m_leftSplitterPanel));
        this.m_rightPane = new RecessedPane((Component)((Object)this.m_rightSplitterPanel));
        this.m_leftPane.setTitle(ClientLang.getStrSystemObjects());
        this.m_rightPane.setTitle(" ");
        this.m_splitter2 = new SplitPanelView(new AdminProp(), (Component)((Object)this.m_leftPane), (Component)((Object)this.m_rightPane), false);
        this.addContentComponent("Center", (Component)((Object)this.m_splitter2));
        this.m_statusBar = new NavStatusBar(false);
        this.addContentComponent("South", (Component)((Object)this.m_statusBar));
        this.m_statusBar.init();
    }

    public static Vector getHelpBookInfo() {
        return m_helpBookInfo;
    }

    protected void initializeHelp() {
        try {
            IAdminProp[] iAdminPropArray;
            if (this._root == null) {
                this._root = this.getRoot();
            }
            if ((iAdminPropArray = (IAdminProp[])this._root.getProp(273612805)) == null) {
                return;
            }
            int n = 0;
            while (n < iAdminPropArray.length) {
                IAdminProp iAdminProp = iAdminPropArray[n];
                String string = (String)iAdminProp.getProp(1049119);
                String string2 = (String)iAdminProp.getProp(1049370);
                String string3 = (String)iAdminProp.getProp(1049371);
                if (string2 != null && string != null) {
                    AdminHelp.addBook(string, string2, string3);
                    if (!(m_helpBookInfo.contains(string) && m_helpBookInfo.contains(string2) && m_helpBookInfo.contains(string3))) {
                        m_helpBookInfo.addElement(string);
                        m_helpBookInfo.addElement(string2);
                        m_helpBookInfo.addElement(string3);
                    }
                }
                ++n;
            }
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void setEditorTitle(String string) {
        if (this.m_rightPane == null) {
            return;
        }
        this.m_rightPane.setTitle(string);
        if (string == null || string.trim().length() == 0 || this.m_ignoreTitleUpdate) {
            return;
        }
        if (this.m_titleHistory == null) {
            this.m_titleHistory = new Vector();
        }
        if (this.m_titleHistory.size() > this.m_titleIndex) {
            this.m_titleHistory.setElementAt(string, this.m_titleIndex);
            if (DEBUG) {
                System.out.println("NavigatorFrame.setEditorTitle: truncate idx=" + this.m_titleIndex + " title=" + string);
            }
            ++this.m_titleIndex;
            this.m_titleHistory.setSize(this.m_titleIndex);
        } else {
            this.m_titleHistory.addElement(string);
            if (DEBUG) {
                System.out.println("NavigatorFrame.setEditorTitle: addnew   idx=" + this.m_titleIndex + " title=" + string);
            }
            ++this.m_titleIndex;
        }
        try {
            if (this.m_titleHistory.size() > this.m_titleIndex) {
                this.m_historyForward.setProp(8978948, (Object)Boolean.TRUE);
            } else {
                this.m_historyForward.setProp(8978948, (Object)Boolean.FALSE);
            }
            if (this.m_titleIndex > 1) {
                this.m_historyBackward.setProp(8978948, (Object)Boolean.TRUE);
            } else {
                this.m_historyBackward.setProp(8978948, (Object)Boolean.FALSE);
            }
            if (string.lastIndexOf("/") > 0) {
                this.m_popPath.setProp(8978948, (Object)Boolean.TRUE);
                return;
            }
            this.m_popPath.setProp(8978948, (Object)Boolean.FALSE);
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void historyBack() throws PropertyException {
        if (this.m_titleIndex <= 1) {
            return;
        }
        if (DEBUG) {
            System.out.println("NavigatorFrame.historyBack: idx=" + this.m_titleIndex + " size=" + this.m_titleHistory.size());
        }
        --this.m_titleIndex;
        String string = (String)this.m_titleHistory.elementAt(this.m_titleIndex - 1);
        if (this.m_titleHistory.size() > 1) {
            this.m_historyForward.setProp(8978948, (Object)Boolean.TRUE);
        }
        if (this.m_titleIndex == 1) {
            this.m_historyBackward.setProp(8978948, (Object)Boolean.FALSE);
        }
        this.m_ignoreTitleUpdate = true;
        try {
            int n = 0;
            while (n < this.m_treeItems.length && !this.m_treeItems[n].edit(string)) {
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_ignoreTitleUpdate = false;
            throw throwable;
        }
        Object var3_3 = null;
        this.m_ignoreTitleUpdate = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void historyForward() throws PropertyException {
        if (this.m_titleIndex >= this.m_titleHistory.size()) {
            return;
        }
        if (DEBUG) {
            System.out.println("NavigatorFrame.historyForward: idx=" + this.m_titleIndex + " size=" + this.m_titleHistory.size());
        }
        String string = (String)this.m_titleHistory.elementAt(this.m_titleIndex);
        ++this.m_titleIndex;
        if (this.m_titleIndex == this.m_titleHistory.size()) {
            this.m_historyForward.setProp(8978948, (Object)Boolean.FALSE);
        }
        if (this.m_titleIndex > 1) {
            this.m_historyBackward.setProp(8978948, (Object)Boolean.TRUE);
        }
        this.m_ignoreTitleUpdate = true;
        try {
            int n = 0;
            while (n < this.m_treeItems.length && !this.m_treeItems[n].edit(string)) {
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_ignoreTitleUpdate = false;
            throw throwable;
        }
        Object var3_3 = null;
        this.m_ignoreTitleUpdate = false;
    }

    public void pathPop() throws PropertyException {
        String string = (String)this.m_titleHistory.elementAt(this.m_titleIndex - 1);
        int n = string.lastIndexOf("/");
        if (n <= 0) {
            return;
        }
        if ((string = string.substring(0, n)).lastIndexOf("/") <= 0) {
            this.m_popPath.setProp(8978948, (Object)Boolean.FALSE);
        }
        int n2 = 0;
        while (n2 < this.m_treeItems.length) {
            if (this.m_treeItems[n2].edit(string)) {
                return;
            }
            ++n2;
        }
    }

    public void shutDown() {
        --m_windowCount;
        if (this._root != null) {
            try {
                this._root.setProp(8454180, Boolean.TRUE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Unexpected Exception " + exception);
            }
        }
        this.dispose();
        TreeDetailApp treeDetailApp = this.getEMApp();
        if (treeDetailApp != null) {
            treeDetailApp.exit();
            return;
        }
        this.exit();
    }

    public void exit() {
        System.exit(0);
    }

    public IAdminProp getRoot() {
        return this.getRoot(null);
    }

    public IAdminProp getRoot(String[] stringArray) {
        if (this._root == null) {
            this._root = AdminUtil.getRoot(stringArray, this._useCorbaClient, this._useAppServer);
        }
        return this._root;
    }

    private void populateTree(NavHTree navHTree, String[] stringArray) {
        IAdminProp[] iAdminPropArray = null;
        IAdminProp iAdminProp = this._root;
        if (DEBUG_TRACE) {
            AdminPropView adminPropView = new AdminPropView(iAdminProp);
            adminPropView.setDebugTreeTrace(true);
            iAdminProp = adminPropView;
        }
        try {
            iAdminProp.setProp(0x10190099, stringArray);
            iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Unexpected Exception " + exception);
        }
        if (iAdminPropArray == null) {
            NavFolderItem navFolderItem = new NavFolderItem((Component)((Object)this), this._root);
            navHTree.addFolderItem(null, navFolderItem);
            navFolderItem.setExpanded(true);
            return;
        }
        this.m_treeItems = new NavFolderItem[iAdminPropArray.length];
        int n = 0;
        while (n < iAdminPropArray.length) {
            NavFolderItem navFolderItem;
            this.m_treeItems[n] = navFolderItem = new NavFolderItem((Component)((Object)this), iAdminPropArray[n]);
            navHTree.addFolderItem(null, navFolderItem);
            try {
                int n2 = (Integer)iAdminPropArray[n].getProp(3080204);
                if ((n2 & 0x6000) == 0) {
                    navFolderItem.setExpanded(true);
                    navFolderItem.expandChildren();
                } else {
                    navFolderItem.setExpanded(false);
                }
            }
            catch (Exception exception) {
                navFolderItem.setExpanded(false);
            }
            navFolderItem.init(this.m_autoEditObject, this.m_autoOpenObject, this.m_autoStandaloneObject);
            ++n;
        }
    }

    boolean warnUserAboutEditorChange(IEditor iEditor, String string) {
        return AdminUtil.warnUserAboutEditorChange((Frame)((Object)this), iEditor, string);
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            IAdminProp iAdminProp;
            Boolean bl;
            if (adminPropertyChangeEvent.getSource() == this._prop && adminPropertyChangeEvent.getPropId() == 8454179 && (bl = (Boolean)adminPropertyChangeEvent.getNewValue()) != null && !bl.booleanValue()) {
                this.showEditor(null, null);
                AdminUtil.removeAdminPropertyChangeListener(this._prop, this);
                return;
            }
            if (adminPropertyChangeEvent.getSource() == this._prop && adminPropertyChangeEvent.getPropId() == 4785227) {
                try {
                    iAdminProp = (IAdminProp)this._prop.getProp(4785227);
                    if (iAdminProp != null && this == AdminUtil.getNavigator()) {
                        AdminUtil.edit(iAdminProp);
                    }
                }
                catch (Exception exception) {
                    new ErrorAlert((Frame)((Object)this), exception);
                }
            } else if (adminPropertyChangeEvent.getSource() == this._prop && adminPropertyChangeEvent.getPropId() == 4785229) {
                try {
                    iAdminProp = (IAdminProp)this._prop.getProp(4785229);
                    if (iAdminProp != null) {
                        this.showEditor(EditorFactory.getEditor(iAdminProp, null, (Component)((Object)this)), iAdminProp);
                    }
                }
                catch (Exception exception) {
                    new ErrorAlert((Frame)((Object)this), exception);
                }
            } else if (adminPropertyChangeEvent.getSource() == this._prop && (adminPropertyChangeEvent.getPropId() == 2031768 || adminPropertyChangeEvent.getPropId() == 0x110001)) {
                this.setEditorTitle();
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public void setEditorTitle() {
    }

    public boolean displayObject(IAdminProp iAdminProp) {
        Component component;
        if (this._editor != null && (component = AdminUtil.removeScrollBox(this._editor)) instanceof IEditor) {
            if (DEBUG) {
                System.out.print("NavigatorFrame.displayObject: c = " + component);
            }
            if (DEBUG) {
                System.out.println(" prop = " + iAdminProp);
            }
            boolean bl = ((IEditor)((Object)component)).displayObject(iAdminProp);
            if (DEBUG) {
                System.out.println("NavigatorFrame.displayObject: results = " + bl);
            }
            return bl;
        }
        return false;
    }

    public Component getEditor() {
        return this._editor;
    }

    public void showEditor(Component component, IAdminProp iAdminProp) {
        if (this._editor == component) {
            if (this._prop != null && iAdminProp != this._prop) {
                AdminUtil.removeAdminPropertyChangeListener(this._prop, this);
                this._prop = iAdminProp;
                if (this._prop != null) {
                    AdminUtil.addAdminPropertyChangeListener(this._prop, this);
                }
            }
            Component component2 = this.m_rightSplitterPanel.getEditor();
            this.m_rightSplitterPanel.addEditor(component2, iAdminProp);
            this.invalidate();
            ((Container)((Object)this)).validate();
            return;
        }
        if (this._prop != null) {
            AdminUtil.removeAdminPropertyChangeListener(this._prop, this);
        }
        this._editor = component;
        if (component != null) {
            if (AdminUtil.usesPropertyEditor(iAdminProp)) {
                component = TabView.createTabView(iAdminProp, null, component);
            }
            this.m_rightSplitterPanel.addEditor(component, iAdminProp);
            if (component instanceof IEditor) {
                ((IEditor)((Object)component)).setupToolbar(0);
            }
            if (iAdminProp != null) {
                AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
            }
            this._prop = iAdminProp;
        } else {
            if (this.m_splashCanvas == null) {
                this.m_splashCanvas = new SplashCanvas();
            }
            this.m_rightSplitterPanel.addEditor((Component)((Object)this.m_splashCanvas), iAdminProp);
        }
        this.invalidate();
        ((Container)((Object)this)).validate();
    }

    public void showSBMessage(String string) {
        if (this.m_statusBar != null) {
            this.m_statusBar.addMessage(string);
        }
    }

    public void removeSBMessage(String string) {
        if (this.m_statusBar != null) {
            this.m_statusBar.removeMessage(string);
        }
    }

    public void showSBExecMessage(String string) {
        if (this.m_statusBar != null) {
            this.m_statusBar.addMessage(string, 1);
        }
    }

    public void removeSBExecMessage(String string) {
        if (this.m_statusBar != null) {
            this.m_statusBar.removeMessage(string, 1);
        }
    }

    public void showSBLogin(String string) {
        if (this.m_statusBar != null) {
            this.m_statusBar.showConnection("");
        }
    }

    public NavHTree getTree() {
        return this.m_htree;
    }

    public IAdminProp[] getCommandList() {
        return this._toolbarCommandList;
    }

    public NavMenu getNavMenu() {
        return this.m_menuBar;
    }

    public void resetMenu(IAdminProp iAdminProp) {
        if (this.m_menuBar != null) {
            this.m_menuBar.resetMenu(iAdminProp);
        }
    }

    public void removeSelectionOwner(ISelectionOwner iSelectionOwner) {
        if (this.m_selectionOwner == iSelectionOwner) {
            this.m_selectionOwner = null;
        }
    }

    public void setSelectionOwner(ISelectionOwner iSelectionOwner) {
        if (this.m_selectionOwner != null && this.m_selectionOwner != iSelectionOwner) {
            this.m_selectionOwner.clearSelection();
        }
        this.m_selectionOwner = iSelectionOwner;
    }

    public String getToolbarName(PropToolbar propToolbar) {
        if (propToolbar == null) {
            return "null";
        }
        IAdminProp iAdminProp = propToolbar.getProp();
        if (iAdminProp == null) {
            return "unnamed " + propToolbar;
        }
        return iAdminProp + " " + propToolbar;
    }

    public void setEditorToolbar(int n, PropToolbar propToolbar) {
        if (DEBUG) {
            System.out.println("\nNavigatorFrame.setEditorToolbar: level=" + n + " toolbar=" + this.getToolbarName(propToolbar));
        }
        if (this.m_toolbarHolder == null) {
            this.createToolbarHolder();
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = this.m_toolbars.size();
        while (n2 <= n) {
            this.m_toolbars.addElement(null);
            ++n2;
        }
        int n3 = n;
        while (n3 < n2) {
            PropToolbar propToolbar2 = (PropToolbar)this.m_toolbars.elementAt(n3);
            if (propToolbar2 != null) {
                if (DEBUG) {
                    System.out.println("NavigatorFrame.setEditorToolbar: Remove lower level toolbars : level=" + n3 + " toolbar=" + this.getToolbarName(propToolbar2));
                }
                try {
                    ((Container)((Object)this.m_toolbarHolder)).remove((Component)((Object)propToolbar2));
                    this.m_toolbarHolderGBL.removeLayoutComponent((Component)((Object)propToolbar2));
                }
                catch (Exception exception) {}
                if (this.m_menuBar != null) {
                    this.m_menuBar.mergeOut(propToolbar2);
                }
                if (this._toolbar != null) {
                    this._toolbar.mergeOut(propToolbar2);
                }
                this.m_toolbars.setElementAt(null, n3);
            }
            ++n3;
        }
        this.m_toolbars.setElementAt(propToolbar, n);
        if (propToolbar != null) {
            if (this.m_toolbarHolder == null) {
                this.createToolbarHolder();
            }
            if (this._toolbar == null) {
                this.buildToolbar();
                AdminUtil.fixup((Component)((Object)this));
            }
            if (this._toolbar != null) {
                this._toolbar.mergeIn(propToolbar);
            }
            this.addEditorToolbar(propToolbar, n + 3);
        }
        this.m_toolbarHolderParent.invalidate();
        ((Container)((Object)this.m_toolbarHolderParent)).validate();
        this.m_toolbarHolderParent.doLayout();
        this.fixupToolbar(this._toolbar);
        this.fixupToolbar(this._toolbar2);
    }

    public void createToolbarHolder() {
        if (DEBUG) {
            System.out.println("\nNavigatorFrame.createToolbarHolder\n");
        }
        AdminBorderPanel adminBorderPanel = this.m_toolbarHolderParent = new AdminBorderPanel();
        ((Container)((Object)adminBorderPanel)).setLayout(new BorderLayout());
        adminBorderPanel.setInsets(5, 5, 5, 5);
        this.m_toolbarHolder = new AdminBorderPanel();
        this.m_toolbarHolderGBL = new GridBagLayout();
        ((Container)((Object)this.m_toolbarHolder)).setLayout(this.m_toolbarHolderGBL);
        AdminUtil.setBackground((Component)((Object)adminBorderPanel));
        AdminUtil.setBackground((Component)((Object)this.m_toolbarHolder));
        ((Container)((Object)adminBorderPanel)).add("West", (Component)((Object)this.m_toolbarHolder));
        ((Container)((Object)adminBorderPanel)).add("East", (Component)((Object)new AdminImageCanvas(AdminUtil.loadImage("images/oracle.gif", (Component)((Object)adminBorderPanel)))));
        if (this.useToolbar()) {
            this.addContentComponent("North", (Component)((Object)adminBorderPanel));
        }
    }

    public boolean useToolbar() {
        return true;
    }

    public void addEditorToolbar(PropToolbar propToolbar) {
        this.addEditorToolbar(propToolbar, 2);
    }

    public void addEditorToolbar(PropToolbar propToolbar, int n) {
        if (DEBUG) {
            System.out.println("\nNavigatorFrame.addEditorToolbar: gridx=" + n + " toolbar=" + this.getToolbarName(propToolbar));
        }
        if (propToolbar != null) {
            this.fixupToolbar(propToolbar);
        }
        if (this.m_toolbarHolder == null) {
            this.createToolbarHolder();
        }
        if (this.m_menuBar != null) {
            this.m_menuBar.mergeIn(propToolbar);
        }
        if (this._toolbar == null) {
            this.buildToolbar();
            AdminUtil.fixup((Component)((Object)this));
        }
        if (n == 2) {
            this._toolbar.setAuxillaryToolbar(propToolbar);
        }
        if (!propToolbar.isPopulatedVisibly()) {
            if (DEBUG) {
                System.out.println("NavigatorFrame.addEditorToolbar: isPopulatedVisibly = false");
            }
            return;
        }
        if (DEBUG) {
            System.out.println("NavigatorFrame.addEditorToolbar: isPopulatedVisibly");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = n;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.m_toolbarHolderGBL.setConstraints((Component)((Object)propToolbar), gridBagConstraints);
        ((Container)((Object)this.m_toolbarHolder)).add((Component)((Object)propToolbar));
        ((Container)((Object)this.m_toolbarHolder)).validate();
        this.m_toolbarHolder.doLayout();
        if (propToolbar != null) {
            this.fixupToolbar(this._toolbar);
            this.fixupToolbar(this._toolbar2);
            this.fixupToolbar(propToolbar);
        }
        if (DEBUG) {
            System.out.println("NavigatorFrame.addEditorToolbar: Done\n");
        }
    }

    public void removeEditorToolbar(PropToolbar propToolbar) {
        if (DEBUG) {
            System.out.println("NavigatorFrame.removeEditorToolbar: called.");
        }
        if (this.m_menuBar != null) {
            this.m_menuBar.mergeOut(propToolbar);
        }
        if (this.m_toolbarHolder == null) {
            return;
        }
        this.setEditorToolbar(0, null);
        this._toolbar.setAuxillaryToolbar(null);
        if (!propToolbar.isPopulatedVisibly()) {
            return;
        }
        if (DEBUG) {
            System.out.println("NavigatorFrame.removeEditorToolbar: isPopulatedVisibly");
        }
        ((Container)((Object)this.m_toolbarHolder)).remove((Component)((Object)propToolbar));
        this.m_toolbarHolderGBL.removeLayoutComponent((Component)((Object)propToolbar));
    }

    public void fixupToolbar(PropToolbar propToolbar) {
        if (propToolbar != null) {
            propToolbar.fixupItems();
        }
    }

    public PropToolbar getToolBar() {
        return this._toolbar;
    }

    public PropToolbar createToolBar(ToolbarParent toolbarParent, boolean bl) {
        Vector<IAdminProp> vector = new Vector<IAdminProp>();
        CommandProp commandProp = new CommandProp((IAdminProp)toolbarParent, -1, "", "", 8);
        if (!bl) {
            vector.addElement(new CommandProp((IAdminProp)toolbarParent, -4, ClientLang.getStrConnect(), ClientLang.getStrConnect(), "images/connect.gif", AdminUtil.loadImage("images/connect.gif", (Component)((Object)this))));
        }
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -5, ClientLang.getStrRefresh(), ClientLang.getStrRefresh(), "images/refresh.gif", AdminUtil.loadImage("images/refresh.gif", (Component)((Object)this))));
        if (bl) {
            vector.addElement(new CommandProp((IAdminProp)toolbarParent, -7, ClientLang.getStrAdvancedMode(), ClientLang.getStrAdvancedMode(), "images/advanced.gif", AdminUtil.loadImage("images/advanced.gif", (Component)((Object)this))));
            vector.addElement(commandProp);
        }
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -8, ClientLang.getStrCreate(), ClientLang.getStrCreate(), "images/create.gif", AdminUtil.loadImage("images/create.gif", (Component)((Object)this))));
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -10, ClientLang.getStrCreateLike(), ClientLang.getStrCreateLike(), "images/createlike.gif", AdminUtil.loadImage("images/createlike.gif", (Component)((Object)this))));
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -51, ClientLang.getStrEdit(), ClientLang.getStrEdit(), "images/edit.gif", AdminUtil.loadImage("images/edit.gif", (Component)((Object)this))));
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -18, ClientLang.getStrFindObjects(), ClientLang.getStrFindObjects(), "images/find.gif", AdminUtil.loadImage("images/find.gif", (Component)((Object)this))));
        vector.addElement(new CommandProp((IAdminProp)toolbarParent, -9, ClientLang.getStrRemove(), ClientLang.getStrRemove(), "images/remove.gif", AdminUtil.loadImage("images/remove.gif", (Component)((Object)this))));
        Vector vector2 = this.getGlobalCmdItems();
        if (vector2 != null) {
            int n = vector2.size();
            if (n != 0) {
                vector.addElement(commandProp);
            }
            int n2 = 0;
            while (n2 < n) {
                IAdminProp iAdminProp = (IAdminProp)vector2.elementAt(n2);
                try {
                    String string = (String)iAdminProp.getProp(1638408);
                    if (string != null) {
                        iAdminProp.setProp(7929864, AdminUtil.loadImage(string, (Component)((Object)this)));
                    }
                }
                catch (Exception exception) {}
                vector.addElement(iAdminProp);
                ++n2;
            }
        }
        vector.addElement(commandProp);
        if (!this.m_disableHelpToolbar) {
            vector.addElement(new CommandProp((IAdminProp)toolbarParent, 9, ClientLang.getStrHelp(), ClientLang.getStrHelp(), "images/help.gif", AdminUtil.loadImage("images/help.gif", (Component)((Object)this))));
        }
        this._toolbarCommandList = (IAdminProp[])AdminProp.vectorToObjectArray(vector);
        PropToolbar propToolbar = new PropToolbar((Component)((Object)this));
        return propToolbar;
    }

    public void disableHelpToolbar(boolean bl) {
        this.m_disableHelpToolbar = bl;
    }

    public IAdminProp getProp() {
        return this._prop;
    }

    public void showDebugFlags() {
        AdminUtil.editStandalone(new allDebugFlags(this.getRoot()), null, (Component)((Object)this));
    }

    static {
        corbaCltArg = "corbaClient";
        m_helpBookInfo = new Vector();
    }

    class backgroundSplash
    implements Runnable {
        Component m_w;

        public backgroundSplash(Component component) {
            NavigatorFrame.this = NavigatorFrame.this;
            this.m_w = component;
        }

        public void run() {
            this.m_w.setVisible(true);
        }
    }

    class RecessedPane
    extends AdminBorderPanel {
        NavStatusBar m_status;

        public RecessedPane(Component component) {
            NavigatorFrame.this = NavigatorFrame.this;
            ((Container)((Object)this)).setLayout(new BorderLayout());
            this.m_status = new NavStatusBar(true);
            ((Container)((Object)this)).add("North", (Component)((Object)this.m_status));
            if (component instanceof AdminScrollBox) {
                ((Container)((Object)this)).add("Center", component);
            } else {
                AdminBorderPanel adminBorderPanel = new AdminBorderPanel();
                ((Container)((Object)adminBorderPanel)).setLayout(new BorderLayout());
                adminBorderPanel.setLoweredFrameBorder(2);
                ((Container)((Object)adminBorderPanel)).add("Center", component);
                ((Container)((Object)this)).add("Center", (Component)((Object)adminBorderPanel));
            }
            this.setTitle("");
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public void setTitle(String string) {
            this.m_status.addMessage(string);
        }

        public void clearTitle() {
            this.m_status.removeMessage(null);
        }
    }

    class navigateBar
    extends AdminProp
    implements ICommandParent {
        int CMD_BACK = 1;
        int CMD_FORE = 2;
        int CMD_UP = 3;
        IAdminProp[] cmdList = new IAdminProp[3];

        public navigateBar() {
            NavigatorFrame.this = NavigatorFrame.this;
            NavigatorFrame.this.m_historyBackward = new CommandProp((IAdminProp)this, this.CMD_BACK, ClientLang.getStrGotoPrevObj(), ClientLang.getStrGotoPrevObj(), 1, "images/navback.gif");
            this.cmdList[0] = NavigatorFrame.this.m_historyBackward;
            NavigatorFrame.this.m_historyForward = new CommandProp((IAdminProp)this, this.CMD_FORE, ClientLang.getStrGotoNextObj(), ClientLang.getStrGotoNextObj(), 1, "images/navfore.gif");
            this.cmdList[1] = NavigatorFrame.this.m_historyForward;
            NavigatorFrame.this.m_popPath = new CommandProp((IAdminProp)this, this.CMD_UP, ClientLang.getStrGotoPareObj(), ClientLang.getStrGotoPareObj(), 1, "images/navup.gif");
            this.cmdList[2] = NavigatorFrame.this.m_popPath;
            int n = 0;
            while (n < this.cmdList.length) {
                try {
                    this.cmdList[n].setProp(8978948, Boolean.FALSE);
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                }
                ++n;
            }
        }

        public Object getProp(int n) throws PropertyException {
            if (n == 273613313) {
                return this.cmdList;
            }
            return super.getProp(n);
        }

        public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
            try {
                int n = (Integer)iAdminProp.getProp(2687496);
                if (n == this.CMD_BACK) {
                    NavigatorFrame.this.historyBack();
                } else if (n == this.CMD_FORE) {
                    NavigatorFrame.this.historyForward();
                } else if (n == this.CMD_UP) {
                    NavigatorFrame.this.pathPop();
                }
            }
            catch (PropertyException propertyException) {
                throw propertyException;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
            return null;
        }
    }

    class WAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            NavigatorFrame.this.shutDown();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (NavigatorFrame.this.m_toolbarHolder != null) {
                AdminUtil.fixup((Component)((Object)NavigatorFrame.this.m_toolbarHolder));
            }
        }

        WAdapter() {
            NavigatorFrame.this = NavigatorFrame.this;
        }
    }
}

