/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.Hashtable;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.ImageWizardPage;
import oracle.ewt.wizard.ReentrantWizard;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.common.AdminPanel;

public class AdminWizard
extends AdminPanel
implements WizardListener,
WizardValidateListener,
HelpListener {
    public static final int RENTRANT_WIZARD = 1;
    public static final int NORMAL_WIZARD = 0;
    Hashtable m_map = new Hashtable();
    BaseWizard _wizard;

    public AdminWizard() {
        AdminUtil.setBackground((Component)((Object)this));
    }

    public void initWizard(int n, boolean bl, boolean bl2) {
        this._wizard = n == 1 ? new ReentrantWizard() : new Wizard();
        this._wizard.addWizardListener((WizardListener)this);
        this._wizard.setHelpAvailable(bl);
        this._wizard.setCanApply(bl2);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)this._wizard);
    }

    public int getIndex() {
        return this._wizard.getSelectedPage().getIndex();
    }

    public void selectPage(Object object) {
        WizardPage wizardPage = (WizardPage)this.m_map.get(object);
        if (wizardPage != null) {
            this._wizard.selectPage(wizardPage);
        }
    }

    public void refreshWizardPageContent(Container container, Image image, String string) {
        ImageWizardPage imageWizardPage = (ImageWizardPage)this._wizard.getPageAt(this._wizard.getPageCount() - 1);
        imageWizardPage.setImage(image);
        imageWizardPage.setLabel(string);
        imageWizardPage.setInteractiveArea((Component)container);
        this._wizard.repaint();
    }

    public void addPage(Container container, Image image, String string) {
        if (this._wizard == null) {
            return;
        }
        ImageWizardPage imageWizardPage = new ImageWizardPage((Component)container, image, string);
        imageWizardPage.addWizardValidateListener((WizardValidateListener)this);
        this._wizard.addPage((WizardPage)imageWizardPage);
        this.m_map.put(imageWizardPage, container);
        this.m_map.put(container, imageWizardPage);
    }

    public void removeAllPages() {
        if (this._wizard == null) {
            return;
        }
        this._wizard.removeAllPages();
        this.m_map = new Hashtable();
    }

    public void setMustFinish(boolean bl) {
        if (this._wizard instanceof Wizard) {
            Wizard wizard = (Wizard)this._wizard;
            wizard.setMustFinish(bl);
        }
    }

    public boolean getMustFinish() {
        if (this._wizard instanceof Wizard) {
            Wizard wizard = (Wizard)this._wizard;
            return wizard.getMustFinish();
        }
        return false;
    }

    public void restart() {
        if (this._wizard == null) {
            return;
        }
        this._wizard.restart();
    }

    public void wizardViewSelectionChanged(Object object) {
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        if (wizardEvent.getPage() == null) {
            return;
        }
        Object v = this.m_map.get(wizardEvent.getPage());
        if (v != null) {
            this.wizardViewSelectionChanged(v);
        }
    }

    public void wizardViewApplyState() {
    }

    public void wizardApplyState(WizardEvent wizardEvent) {
        this.wizardViewApplyState();
    }

    public void wizardViewCanceled() {
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        this.wizardViewCanceled();
    }

    public boolean wizardViewFinished2() {
        return true;
    }

    public boolean wizardViewFinished() {
        return this.wizardViewFinished2();
    }

    public void wizardFinished(WizardEvent wizardEvent) {
        if (!this.wizardViewFinished()) {
            ((Cancelable)wizardEvent).cancel();
            return;
        }
        this.removeAllPages();
        AdminUtil.getFrame((Component)((Object)this)).dispose();
    }

    public boolean wizardViewValidatePage() {
        return true;
    }

    public void wizardValidatePage(WizardEvent wizardEvent) {
        if (!this.wizardViewValidatePage()) {
            ((Cancelable)wizardEvent).cancel();
        }
    }

    public void wizardViewHelpRequested() {
    }

    public void helpRequested(HelpEvent helpEvent) {
        this.wizardViewHelpRequested();
    }

    public int getPageCount() {
        return this._wizard.getPageCount();
    }

    public void removePage(AdminPanel adminPanel) {
        WizardPage wizardPage = (WizardPage)this.m_map.get((Object)adminPanel);
        if (wizardPage != null) {
            this._wizard.removePage(wizardPage);
        }
    }
}

