/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminBorderPanel;
import oracle.ldap.admin.client.common.AdminCheckboxGroup;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminRadioButton;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class CardView
extends AdminBorderPanel
implements IEditor,
AdminPropertyChangeListener,
ItemListener {
    IAdminProp m_ap;
    AdminCheckboxGroup m_checkGroup;
    AdminRadioButton[] m_checkboxes;
    CardLayout m_cardLayout;
    AdminPanel m_radioPanel;
    AdminPanel m_cardPanel;
    IAdminProp[] m_objList;
    String[] m_labels;
    IEditor[] m_editors;
    EditorOwner m_owner;
    int m_level;

    public CardView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        this.init(editorOwner);
    }

    public static Component createCardView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        return new CardView(iAdminProp, editorOwner);
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 272696422: {
                    if (adminPropertyChangeEvent.getSource() != this.m_ap) break;
                    this.removeAll();
                    this.shutdown(false);
                    this.init(this.m_owner);
                    AdminUtil.fixup((Component)((Object)this));
                    break;
                }
                case 282001422: {
                    AdminUtil.fixup((Component)((Object)this));
                    break;
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    void init(EditorOwner editorOwner) {
        Object object;
        String string;
        this.m_owner = editorOwner;
        try {
            this.m_objList = (IAdminProp[])this.m_ap.getProp(272696422);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get object list " + propertyException);
            return;
        }
        if (this.m_objList == null) {
            this.debugMessageLn("No card object list!!");
            return;
        }
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.m_radioPanel = new AdminPanel();
        ((Container)((Object)this.m_radioPanel)).setLayout(new FlowLayout(0));
        try {
            string = (String)this.m_ap.getProp(1115239);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get PR_CARD_LABEL " + propertyException);
            string = "View As: ";
        }
        ((Container)((Object)this.m_radioPanel)).add((Component)((Object)new AdminLabel(string)));
        this.m_checkGroup = new AdminCheckboxGroup();
        this.m_cardPanel = new AdminPanel();
        this.m_cardLayout = new CardLayout();
        ((Container)((Object)this.m_cardPanel)).setLayout(this.m_cardLayout);
        this.m_checkboxes = new AdminRadioButton[this.m_objList.length];
        this.m_labels = new String[this.m_objList.length];
        this.m_editors = new IEditor[this.m_objList.length];
        int n = 0;
        while (n < this.m_objList.length) {
            block14: {
                try {
                    object = EditorFactory.getEditor(this.m_objList[n], editorOwner);
                    if (object == null) {
                    }
                }
                catch (Exception exception) {}
                break block14;
                try {
                    this.m_labels[n] = (String)this.m_objList[n].getProp(0x110001);
                }
                catch (PropertyException propertyException) {
                    this.debugMessageLn("Couldn't get PR_DISPLAY_NAME " + propertyException);
                    break block14;
                }
                ((Container)((Object)this.m_cardPanel)).add(this.m_labels[n], (Component)object);
                this.m_editors[n] = (IEditor)((Object)AdminUtil.removeScrollBox((Component)object));
                this.m_objList[n].addAdminPropertyChangeListener(this);
                this.m_checkboxes[n] = new AdminRadioButton(this.m_labels[n], this.m_checkGroup, n == 0);
                this.m_checkboxes[n].addItemListener(this);
                ((Container)((Object)this.m_radioPanel)).add((Component)((Object)this.m_checkboxes[n]));
            }
            ++n;
        }
        ((Container)((Object)this)).add("North", (Component)((Object)this.m_radioPanel));
        ((Container)((Object)this)).add("Center", (Component)((Object)this.m_cardPanel));
        try {
            object = (String)this.m_ap.getProp(1115240);
            if (object != null) {
                this.setGroupBoxBorder((String)object, 2);
                return;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        AdminRadioButton adminRadioButton = (AdminRadioButton)this.m_checkGroup.getSelectedCheckbox();
        int n = 0;
        while (n < this.m_checkboxes.length) {
            if (this.m_checkboxes[n] == adminRadioButton) {
                this.m_cardLayout.show((Container)((Object)this.m_cardPanel), this.m_labels[n]);
                this.m_editors[n].setupToolbar(this.m_level);
                return;
            }
            ++n;
        }
    }

    void debugMessageLn(String string) {
        System.out.println(string);
    }

    public boolean displayObject(Object object) {
        if (this.getObject() == object) {
            return true;
        }
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.displayObject(object)) {
                        int n2 = 0;
                        while (n2 < this.m_editors.length) {
                            if (this.m_editors[n2] == iEditor && !this.m_checkboxes[n2].getState()) {
                                this.m_cardLayout.show((Container)((Object)this.m_cardPanel), this.m_labels[n2]);
                                this.m_editors[n2].setupToolbar(this.m_level);
                                this.m_checkboxes[n2].setState(true);
                                this.m_checkGroup.setSelectedCheckbox(this.m_checkboxes[n2]);
                            }
                            ++n2;
                        }
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 0x400000;
    }

    public void setupToolbar(int n) {
        this.m_level = n;
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n2]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.setupToolbar(n);
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n2;
        }
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.isModified(stringBuffer)) {
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public void revert() {
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.revert();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public boolean commit() {
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        boolean bl = true;
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (!iEditor.commit()) {
                        bl = false;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return bl;
    }

    public void update() {
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.update();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public IAdminProp[] getCommandList() {
        IAdminProp[] iAdminPropArray = null;
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iAdminPropArray = AdminUtil.mergeCmdList(iAdminPropArray, iEditor.getCommandList());
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return iAdminPropArray;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean bl) {
        if (bl) {
            AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        }
        Component[] componentArray = ((Container)((Object)this.m_cardPanel)).getComponents();
        int n = 0;
        while (componentArray != null && n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.shutdown();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        this.shutdownObjList();
    }

    public void shutdownObjList() {
        if (this.m_objList == null) {
            return;
        }
        int n = 0;
        while (n < this.m_objList.length) {
            AdminUtil.removeAdminPropertyChangeListener(this.m_objList[n], this);
            ++n;
        }
    }

    public IAdminProp properties() {
        return null;
    }

    public static void main(String[] stringArray) {
        AdminUtil.editStandalone(new testCardView(), null, null);
    }

    static class testCardView
    extends AdminProp {
        public Object getProp(int n) throws PropertyException {
            switch (n) {
                case 2031768: {
                    return "Card View";
                }
                case 0x110001: {
                    return "Test Case";
                }
                case 3080204: {
                    return new Integer(0x400000);
                }
                case 1115239: {
                    return "View Editors As: ";
                }
                case 1115240: {
                    return "Test Card View";
                }
                case 272696422: {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{new testCard("One"), new testCard("Two"), new testCard("Three"), new testCard("Four")};
                    return iAdminPropArray;
                }
            }
            return super.getProp(n);
        }

        static class testCard
        extends AdminProp {
            String m_name;

            public testCard(String string) {
                this.m_name = string;
            }

            public void registerMessages() {
                super.registerMessages();
                this.registerProp(0x100001, "Name", "This is a name.");
            }

            public Object getProp(int n) throws PropertyException {
                switch (n) {
                    case 0x110001: {
                        return "Card " + this.m_name;
                    }
                    case 0x100001: {
                        return this.m_name;
                    }
                }
                return super.getProp(n);
            }
        }
    }
}

