/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CommandPopupMenu;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminPopupMenu;
import oracle.ldap.admin.client.propEditors.GraphLayout;
import oracle.ldap.admin.client.propEditors.GraphLine;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.GraphTitle;
import oracle.ldap.admin.client.propEditors.GraphView;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.NodeGauge;
import oracle.ldap.admin.client.propEditors.NodePort;
import oracle.ldap.admin.client.propEditors.Rubberband;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GraphCanvas
extends AdminPanel
implements MouseListener,
AdminPropertyChangeListener,
MouseMotionListener,
IEditor {
    GraphView m_parent;
    IAdminProp m_ap;
    GraphLayout m_layout;
    GraphTitle m_graphTitle;
    Rubberband m_rband;
    Vector m_nodes = new Vector();
    IAdminProp[] n_items;
    String m_title;
    GraphNode m_gNode;
    NodePort m_gPort;
    NodeGauge m_gGauge;
    Shape gShape;
    int startx;
    int starty;
    int objectx;
    int objecty;
    int parentx;
    int parenty;
    int height;
    int width;
    boolean m_mouseOnNode;
    boolean mouseOnGauge;
    boolean mouseOnPort = false;
    boolean isGaugeMovable = true;
    String m_image;
    Image m_bgImage;

    public GraphCanvas(IAdminProp iAdminProp, GraphView graphView) {
        this.m_ap = iAdminProp;
        this.m_parent = graphView;
        try {
            this.n_items = (IAdminProp[])this.m_ap.getProp(272630786);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
        }
        try {
            this.m_title = (String)this.m_ap.getProp(1049607);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
        }
        int n = 1;
        try {
            Integer n2 = (Integer)this.m_ap.getProp(2098184);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
        }
        this.m_layout = new GraphLayout(this, n);
        try {
            this.m_image = (String)this.m_ap.getProp(1049112);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
        }
        this.m_rband = new Rubberband((Component)((Object)this));
        this.createNodes();
        if (this.m_title != null) {
            this.m_graphTitle = new GraphTitle(this.m_title, this);
        }
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        super.setSize(680, 620);
        ((Component)((Object)this)).repaint();
    }

    private void createNodes() {
        if (this.m_nodes.size() > 0) {
            this.m_nodes.removeAllElements();
        }
        ((Component)((Object)this)).repaint();
        if (this.n_items != null) {
            int n = 0;
            while (n < this.n_items.length) {
                GraphNode graphNode = new GraphNode(this.n_items[n], this);
                this.m_nodes.addElement(graphNode);
                ++n;
            }
        }
        if (this.m_layout.getType() != 2) {
            this.createLines();
        }
    }

    private void createLines() {
        int n = 0;
        while (n < this.m_nodes.size()) {
            ((GraphNode)this.m_nodes.elementAt(n)).createLines();
            ++n;
        }
    }

    public GraphNode findNode(Object object) {
        int n = 0;
        while (n < this.m_nodes.size()) {
            if (object instanceof String ? ((GraphNode)this.m_nodes.elementAt(n)).getName() == (String)object : this.n_items[n].equals((IAdminProp)object)) {
                return (GraphNode)this.m_nodes.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public NodePort findPort(IAdminProp iAdminProp) {
        int n = 0;
        while (n < this.m_nodes.size()) {
            Vector vector = new Vector();
            vector = ((GraphNode)this.m_nodes.elementAt(n)).getPorts();
            int n2 = 0;
            while (n2 < vector.size()) {
                NodePort nodePort = ((NodePort)vector.elementAt(n2)).findNodePort(iAdminProp);
                if (nodePort != null) {
                    return nodePort;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public Vector getNodes() {
        return this.m_nodes;
    }

    public Vector getTopLevelNodes() {
        if (this.n_items == null) {
            return null;
        }
        Vector<GraphNode> vector = new Vector<GraphNode>();
        int n = 0;
        while (n < this.n_items.length) {
            int n2 = this.m_nodes.size();
            int n3 = 0;
            while (n3 < n2) {
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n3);
                if (graphNode.getObject() == this.n_items[n]) {
                    vector.addElement(graphNode);
                    break;
                }
                ++n3;
            }
            ++n;
        }
        return vector;
    }

    public Rubberband getRubberband() {
        return this.m_rband;
    }

    public int getLayoutType() {
        return this.m_layout.getType();
    }

    public Image getImage() {
        return this.m_bgImage;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.m_image != null && this.m_bgImage == null) {
            this.m_bgImage = AdminUtil.loadImage(this.m_image, (Component)((Object)this));
        }
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        if (this.m_bgImage != null) {
            graphics.drawImage(this.m_bgImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, (ImageObserver)((Object)this));
        }
        if (this.m_graphTitle != null) {
            this.m_graphTitle.paint(graphics);
        }
        int n = 0;
        while (n < this.m_nodes.size()) {
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n);
            graphNode.paint(graphics);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_nodes.size()) {
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n2);
            object = graphNode.getPorts();
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                NodePort nodePort = (NodePort)((Vector)object).elementAt(n3);
                nodePort.paint(graphics);
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.m_nodes.size()) {
            object = (GraphNode)this.m_nodes.elementAt(n4);
            Vector vector = ((GraphNode)object).getPorts();
            int n5 = 0;
            while (n5 < vector.size()) {
                NodePort nodePort = (NodePort)vector.elementAt(n5);
                Vector vector2 = nodePort.getLines();
                int n6 = 0;
                while (n6 < vector2.size()) {
                    GraphLine graphLine = (GraphLine)vector2.elementAt(n6);
                    graphLine.paint(graphics);
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void resizeToPreferredSize() {
        Dimension dimension = this.getPreferredSize();
        ((Component)((Object)this)).setSize(dimension.width, dimension.height);
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public Dimension getPreferredSize() {
        int n;
        Point point;
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.m_nodes.size()) {
            object = (GraphNode)this.m_nodes.elementAt(n6);
            point = ((GraphNode)object).getOrigin();
            Dimension dimension = ((GraphNode)object).getDimension();
            n = dimension.width;
            int n7 = dimension.height;
            int n8 = ((GraphNode)object).getLabelWidth();
            if (n < n8) {
                n = n8;
            }
            if (n2 > point.x) {
                n2 = point.x - 20;
            }
            if (n3 > point.y) {
                n3 = point.y - 20;
            }
            if (n4 < (n8 = point.x + n + 20)) {
                n4 = n8;
            }
            if (n5 < (n8 = point.y + n7 + 20)) {
                n5 = n8;
            }
            ++n6;
        }
        n5 -= n3;
        object = ((Component)((Object)this.m_parent)).getSize();
        if ((n4 -= n2) < ((Dimension)object).width) {
            n4 = ((Dimension)object).width;
        }
        if (n5 < ((Dimension)object).height) {
            n5 = ((Dimension)object).height;
        }
        if (n2 < 0 || n3 < 0) {
            n = 0;
            while (n < this.m_nodes.size()) {
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n);
                point = graphNode.getOrigin();
                graphNode.setOrigin(point.x - n2, point.y - n3);
                ++n;
            }
            Rectangle rectangle = ((Component)((Object)this)).getBounds();
            rectangle.x += n2;
            rectangle.y += n3;
            rectangle.width = n4;
            rectangle.height = n5;
            ((Component)((Object)this)).setBounds(rectangle);
        }
        return new Dimension(n4 + 40, n5 + 40);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startx = mouseEvent.getX();
        this.starty = mouseEvent.getY();
        int n = 0;
        while (n < this.m_nodes.size()) {
            int n2;
            Vector vector;
            Object object;
            this.m_gNode = (GraphNode)this.m_nodes.elementAt(n);
            IAdminProp iAdminProp = (IAdminProp)this.m_gNode.getObject();
            if (this.m_gNode.isMouseOn(this.startx, this.starty)) {
                if (mouseEvent.isMetaDown()) {
                    object = new CommandPopupMenu(iAdminProp);
                    if (((CommandPopupMenu)object).getItemCount() > 0) {
                        ((Container)((Object)this)).add((Component)object);
                        ((AdminPopupMenu)((Object)object)).show((Component)((Object)this), this.startx, this.starty);
                        return;
                    }
                } else {
                    if (mouseEvent.getClickCount() == 2 && this.m_gNode.getCanEdit()) {
                        object = null;
                        try {
                            object = (IAdminProp)iAdminProp.getProp(4195100);
                        }
                        catch (PropertyException propertyException) {}
                        if (object != null) {
                            AdminUtil.editStandalone((IAdminProp)object, null, (Component)((Object)this));
                            return;
                        }
                        AdminUtil.editStandalone(iAdminProp, null, (Component)((Object)this));
                        return;
                    }
                    this.m_mouseOnNode = true;
                    this.gShape = this.m_gNode.getShape();
                    this.objectx = this.m_gNode.getOrigin().x;
                    this.objecty = this.m_gNode.getOrigin().y;
                    this.m_rband.anchor(new Point(this.objectx, this.objecty), this.gShape);
                }
                return;
            }
            object = this.m_gNode.getPorts();
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                if (((NodePort)((Vector)object).elementAt(n3)).isMouseOn(this.startx, this.starty)) {
                    this.m_gPort = (NodePort)((Vector)object).elementAt(n3);
                    iAdminProp = (IAdminProp)this.m_gPort.getObject();
                    this.mouseOnPort = true;
                    if (this.m_layout.getType() == 2) {
                        this.m_gNode.drawChildren(iAdminProp, this.m_layout.getType(), this.m_gPort);
                        vector = this.m_gNode.getChildren();
                        n2 = 0;
                        while (n2 < vector.size()) {
                            GraphNode cfr_ignored_0 = (GraphNode)vector.elementAt(n2);
                            this.m_gPort.createLines();
                            ++n2;
                        }
                    }
                    return;
                }
                ++n3;
            }
            vector = this.m_gNode.getGauges();
            n2 = 0;
            while (n2 < vector.size()) {
                this.m_gGauge = (NodeGauge)vector.elementAt(n2);
                if (this.m_gGauge.isMouseOn(this.startx, this.starty)) {
                    this.mouseOnGauge = true;
                    this.objectx = this.m_gGauge.getOrigin().x;
                    this.objecty = this.m_gGauge.getOrigin().y;
                    this.m_rband.anchor(new Point(this.objectx, this.objecty), this.m_gGauge);
                    this.parentx = this.m_gGauge.getParent().getOrigin().x;
                    this.parenty = this.m_gGauge.getParent().getOrigin().y;
                    this.width = this.m_gGauge.getParent().getDimension().width;
                    this.height = this.m_gGauge.getParent().getDimension().height;
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_mouseOnNode || this.mouseOnGauge) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.mouseOnGauge) {
                if (this.parentx - n > 50) {
                    n = this.parentx - 50;
                }
                if (n - this.parentx - this.width > 50) {
                    n = this.parentx + this.width + 50;
                }
                if (this.parenty - n2 > 50) {
                    n2 = this.parenty - 50;
                }
                if (n2 - this.parenty - this.height > 50) {
                    n2 = this.parenty + this.height + 50;
                }
            }
            this.m_rband.end(new Point(this.objectx + n - this.startx, this.objecty + n2 - this.starty));
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("mouseReleased():  DEFAULT_CURSOR");
            }
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
        }
        Point point = this.m_rband.getAnchor();
        Point point2 = this.m_rband.getEnd();
        if (this.m_mouseOnNode) {
            if (point.x != point2.x || point.y != point2.y) {
                this.gShape.setOrigin(point2.x, point2.y);
            }
            this.gShape = null;
            this.m_gNode.recalcOrigin();
        }
        if (this.mouseOnGauge && this.isGaugeMovable) {
            if (point.x != point2.x || point.y != point2.y) {
                this.m_gGauge.setOrigin(point2.x, point2.y);
            }
            this.m_gGauge = null;
        }
        if (this.m_mouseOnNode || this.mouseOnGauge || this.mouseOnPort) {
            this.m_mouseOnNode = false;
            this.mouseOnGauge = false;
            this.mouseOnPort = false;
            this.resizeToPreferredSize();
            this.m_parent.invalidate();
            ((Container)((Object)this.m_parent)).validate();
            this.invalidate();
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_mouseOnNode || this.mouseOnGauge) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("mouseDragged():  HAND_CURSOR");
            }
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(12));
            if (this.mouseOnGauge) {
                if (this.parentx - n > 50) {
                    n = this.parentx - 50;
                }
                if (n - this.parentx - this.width > 50) {
                    n = this.parentx + this.width + 50;
                }
                if (this.parenty - n2 > 50) {
                    n2 = this.parenty - 50;
                }
                if (n2 - this.parenty - this.height > 50) {
                    n2 = this.parenty + this.height + 50;
                }
            }
            this.isGaugeMovable = true;
            if (this.isGaugeMovable) {
                this.m_rband.stretch(new Point(this.objectx + n - this.startx, this.objecty + n2 - this.starty));
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    /*
     * Exception decompiling
     */
    public void adminPropertyChange(AdminPropertyChangeEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void doLayout() {
        this.m_layout.doLayout();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 512;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return false;
    }

    public void revert() {
    }

    public boolean commit() {
        return true;
    }

    public void update() {
    }

    public void shutdown() {
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }
}

