/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.propEditors.GraphLineLabel;
import oracle.ldap.admin.client.propEditors.NodePort;
import oracle.ldap.admin.client.propEditors.Rubberband;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GraphLine
implements Shape {
    IAdminProp m_ap;
    NodePort m_source;
    NodePort m_dest;
    GraphLineLabel m_label;
    Point m_beginPoint;
    Point m_endPoint;
    Rubberband m_band;
    Color m_color;

    public GraphLine(NodePort nodePort) {
        this.m_source = nodePort;
    }

    public GraphLine(IAdminProp iAdminProp, NodePort nodePort) {
        IAdminProp iAdminProp2 = null;
        Object object = null;
        IAdminProp iAdminProp3 = null;
        this.m_ap = iAdminProp;
        this.m_source = nodePort;
        try {
            iAdminProp2 = (IAdminProp)this.m_ap.getProp(0x400422);
            iAdminProp3 = (IAdminProp)this.m_ap.getProp(4195361);
            object = this.m_ap.getProp(7341062);
            this.m_color = (Color)this.m_ap.getProp(12583954);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_source.getParent().getCanvas())), propertyException);
        }
        this.m_dest = this.m_source.getParent().getCanvas().getLayoutType() == 1 ? this.findPort(iAdminProp2) : this.findPort(iAdminProp3);
        if (object != null) {
            this.m_label = new GraphLineLabel(object, this);
        }
        this.m_band = this.m_source.getParent().getCanvas().getRubberband();
    }

    public Point getStartPoint() {
        return this.m_beginPoint;
    }

    public Point getEndPoint() {
        return this.m_endPoint;
    }

    public void setStartPort(NodePort nodePort) {
        this.m_source = nodePort;
    }

    public void setEndPort(NodePort nodePort) {
        this.m_dest = nodePort;
    }

    public NodePort getStartPort() {
        return this.m_source;
    }

    public NodePort getEndPort() {
        return this.m_dest;
    }

    public NodePort findPort(IAdminProp iAdminProp) {
        return this.m_source.findPort(iAdminProp);
    }

    public boolean isMouseOn(int n, int n2) {
        int n3 = this.m_beginPoint.x - this.m_endPoint.x;
        int n4 = this.m_beginPoint.y - n2;
        int n5 = this.m_beginPoint.x - n;
        int n6 = this.m_beginPoint.y - this.m_endPoint.y;
        int n7 = n3 * n4 - n5 * n6;
        if (n7 < 0) {
            n7 = -n7;
        }
        if (n7 < 9) {
            System.out.println("Mouse is online");
            return true;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        if (this.m_source == null || this.m_dest == null) {
            return;
        }
        this.m_beginPoint = this.m_source.getOrigin();
        this.m_endPoint = this.m_dest.getOrigin();
        Dimension dimension = this.m_source.getDimension();
        Dimension dimension2 = this.m_dest.getDimension();
        Color color = graphics.getColor();
        if (this.m_color != null) {
            graphics.setColor(this.m_color);
        }
        graphics.drawLine(this.m_beginPoint.x + dimension.width / 2, this.m_beginPoint.y + dimension.height / 2, this.m_endPoint.x + dimension2.width / 2, this.m_endPoint.y + dimension2.height / 2);
        if (this.m_color != null) {
            graphics.setColor(color);
        }
        if (this.m_label != null) {
            this.m_label.paint(graphics);
        }
    }

    public Point getOrigin() {
        return this.m_beginPoint;
    }

    public void setOrigin(Point point) {
        this.m_beginPoint.x = point.x;
        this.m_beginPoint.y = point.y;
    }

    public void setOrigin(int n, int n2) {
        this.m_beginPoint.x = n;
        this.m_beginPoint.y = n2;
    }

    public void setDimension(Dimension dimension) {
    }

    public void setDimension(int n, int n2) {
    }

    public Dimension getDimension() {
        return new Dimension(0, 0);
    }

    public boolean isDraggable() {
        return true;
    }

    public void drawLast(Graphics graphics) {
        Point point = this.m_band.lastBounds();
        graphics.drawLine(point.x, point.y, this.getEndPoint().x, this.getEndPoint().y);
    }

    public void drawNext(Graphics graphics) {
        Point point = this.m_band.bounds();
        graphics.drawLine(point.x, point.y, this.getEndPoint().x, this.getEndPoint().y);
    }
}

