/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.propEditors.GraphCanvas;
import oracle.ldap.admin.client.propEditors.NodeGauge;
import oracle.ldap.admin.client.propEditors.NodeLabel;
import oracle.ldap.admin.client.propEditors.NodePort;
import oracle.ldap.admin.client.propEditors.NodeShape;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GraphNode
implements AdminPropertyChangeListener,
Shape {
    IAdminProp m_prop;
    GraphCanvas m_parent;
    IAdminProp[] p_items;
    IAdminProp[] g_items;
    Vector m_ports = new Vector();
    Vector m_gauges = new Vector();
    NodeLabel m_label;
    NodeShape m_shape;
    Color n_color;
    String m_name;
    String m_imageName;
    int tshape;
    int display;
    Nodeflasher nf;
    Boolean f_state;
    boolean flashOn = false;
    Boolean is_editable;
    boolean m_edit = true;
    Vector m_childNodes = new Vector();

    public GraphNode(IAdminProp iAdminProp, GraphCanvas graphCanvas) {
        Object object = null;
        this.m_prop = iAdminProp;
        this.m_parent = graphCanvas;
        try {
            this.m_name = (String)iAdminProp.getProp(0x110001);
            Integer n = (Integer)iAdminProp.getProp(2098192);
            this.display = n != null ? n : 1;
            this.m_imageName = (String)iAdminProp.getProp(1049653);
            Integer n2 = (Integer)iAdminProp.getProp(0x200400);
            this.setShape(n2);
            object = iAdminProp.getProp(7341059);
            if (object == null) {
                System.out.println("node " + iAdminProp.getClass().getName() + " node label is null");
            }
            this.n_color = (Color)iAdminProp.getProp(12583945);
            this.f_state = (Boolean)iAdminProp.getProp(8389686);
            if (this.f_state != null) {
                this.flashOn = this.f_state;
                this.flashMe(this.flashOn);
            }
            this.is_editable = (Boolean)iAdminProp.getProp(8389687);
            if (this.is_editable != null) {
                this.m_edit = this.is_editable;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), propertyException);
        }
        if (object != null) {
            this.m_label = new NodeLabel(object, this);
        }
        this.createPorts();
        this.createGauges();
        AdminUtil.addAdminPropertyChangeListener(this.m_prop, this);
        this.doAutoExpand();
    }

    public void doAutoExpand() {
        try {
            Vector vector;
            Boolean bl = (Boolean)this.m_prop.getProp(8389738);
            if (bl != null && bl.booleanValue() && (vector = this.getPorts()) != null) {
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    NodePort nodePort = (NodePort)vector.elementAt(n2);
                    IAdminProp iAdminProp = (IAdminProp)nodePort.getObject();
                    this.drawChildren(iAdminProp, 0, nodePort);
                    nodePort.createLines();
                    ++n2;
                }
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void createLines() {
        int n = 0;
        while (n < this.m_ports.size()) {
            NodePort nodePort = (NodePort)this.m_ports.elementAt(n);
            nodePort.createLines();
            ++n;
        }
    }

    private void createPorts() {
        try {
            this.p_items = (IAdminProp[])this.m_prop.getProp(0x10400414);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), propertyException);
        }
        if (this.p_items != null) {
            int n = 0;
            while (n < this.p_items.length) {
                NodePort nodePort = new NodePort(this.p_items[n], this);
                this.m_ports.addElement(nodePort);
                ++n;
            }
        }
    }

    private void createGauges() {
        try {
            this.g_items = (IAdminProp[])this.m_prop.getProp(0x10400401);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), propertyException);
        }
        if (this.g_items != null) {
            int n = 0;
            while (n < this.g_items.length) {
                NodeGauge nodeGauge = new NodeGauge(this.g_items[n], this);
                this.m_gauges.addElement(nodeGauge);
                ++n;
            }
        }
    }

    public String getImage() {
        return this.m_imageName;
    }

    public Shape getShape() {
        return this.m_shape.getShape();
    }

    public GraphCanvas getCanvas() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public Vector getPorts() {
        return this.m_ports;
    }

    public Vector getGauges() {
        return this.m_gauges;
    }

    public Vector getPorts(int n) {
        Vector<NodePort> vector = new Vector<NodePort>();
        int n2 = 0;
        while (n2 < this.m_ports.size()) {
            NodePort nodePort = (NodePort)this.m_ports.elementAt(n2);
            int n3 = nodePort.getPlacement();
            if (n3 == n) {
                vector.addElement(nodePort);
            }
            ++n2;
        }
        return vector;
    }

    public NodePort findPort(IAdminProp iAdminProp) {
        return this.m_parent.findPort(iAdminProp);
    }

    public boolean isMouseOn(int n, int n2) {
        return this.m_shape.isMouseOn(n, n2) || this.m_label != null && this.m_label.isMouseOn(n, n2);
    }

    public void setColor(Color color) {
        this.n_color = color;
    }

    public void setShape(Integer n) {
        this.tshape = n != null ? n : 1;
        this.m_shape = new NodeShape(this.tshape, this.display, this);
    }

    public void recalcOrigin() {
        int n = 0;
        while (n < this.m_ports.size()) {
            int n2 = ((NodePort)this.m_ports.elementAt(n)).getPlacement();
            Vector vector = this.getPorts(n2);
            int n3 = vector.size() + 1;
            int n4 = 0;
            while (n4 < vector.size()) {
                int n5 = n4 + 1;
                NodePort nodePort = (NodePort)vector.elementAt(n4);
                nodePort.setOrigin(nodePort.recalcOrigin(nodePort.getOrigin(), n3, n5, this.m_label.getHeight()));
                ++n4;
            }
            ++n;
        }
    }

    public void flashMe(boolean bl) {
        if (this.nf == null && bl) {
            this.nf = new Nodeflasher();
            this.nf.start();
            return;
        }
        if (this.nf != null && bl) {
            this.nf.resume();
            return;
        }
        if (this.nf != null && !bl && this.nf.isAlive()) {
            this.nf.suspend();
        }
    }

    public boolean getCanEdit() {
        return this.m_edit;
    }

    public void repaint() {
        Graphics graphics = this.getCanvas().getGraphics();
        if (graphics != null && this.flashOn) {
            Color color = this.getCanvas().getBackground();
            graphics.setColor(color);
            if (graphics != null) {
                graphics.fillRect(this.getOrigin().x, this.getOrigin().y, this.getDimension().width, this.getDimension().height);
            }
        }
        if (graphics != null) {
            this.update(graphics);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.getColor();
        if (this.n_color != null) {
            graphics.setColor(this.n_color);
        }
        if (!this.flashOn) {
            this.m_shape.paint(graphics);
        } else if (this.m_parent.getImage() != null) {
            graphics.drawImage(this.m_parent.getImage(), this.getOrigin().x, this.getOrigin().y, this.getDimension().width + this.getOrigin().x, this.getDimension().height + this.getOrigin().y, this.getOrigin().x, this.getOrigin().y, this.getDimension().width + this.getOrigin().x, this.getDimension().height + this.getOrigin().y, (ImageObserver)((Object)this.m_parent));
        }
        graphics.setColor(Color.black);
        if (this.m_label != null) {
            this.m_label.paint(graphics);
        }
        this.recalcOrigin();
        int n = 0;
        while (n < this.m_gauges.size()) {
            NodeGauge nodeGauge = (NodeGauge)this.m_gauges.elementAt(n);
            nodeGauge.paint(graphics);
            ++n;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        Color color = null;
        Integer n = null;
        boolean bl = false;
        while (true) {
            block14: {
                IAdminProp iAdminProp;
                if ((iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource()) == null) break block14;
                try {
                    switch (adminPropertyChangeEvent.getPropId()) {
                        case 12583945: {
                            color = (Color)iAdminProp.getProp(12583945);
                            this.setColor(color);
                            bl = true;
                            break;
                        }
                        case 0x200400: {
                            n = (Integer)iAdminProp.getProp(0x200400);
                            this.setShape(n);
                            bl = true;
                            break;
                        }
                        case 8389686: {
                            this.f_state = (Boolean)iAdminProp.getProp(8389686);
                            this.flashOn = this.f_state;
                            this.flashMe(this.flashOn);
                            bl = true;
                            break;
                        }
                        case 8389687: {
                            this.is_editable = (Boolean)iAdminProp.getProp(8389687);
                            if (this.is_editable != null) {
                                this.m_edit = this.is_editable;
                            }
                            break;
                        }
                        default: {
                            if (!bl) break block14;
                        }
                    }
                }
                catch (PropertyException propertyException) {
                    new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), propertyException);
                }
                if (!bl) break block14;
                this.repaint();
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public Object getObject() {
        return this.m_prop;
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 512;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return false;
    }

    public void revert() {
    }

    public boolean commit() {
        return true;
    }

    public void update() {
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_prop, this);
        if (this.nf != null && this.nf.isAlive()) {
            this.nf.stopme();
        }
    }

    Vector getChildNodes() {
        return this.m_childNodes;
    }

    int getTotalWidth() {
        int n;
        Object object;
        int n2 = this.m_childNodes.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            object = (GraphNode)this.m_childNodes.elementAt(n4);
            n3 += ((GraphNode)object).getTotalWidth();
            if (n4 != 0) {
                n3 += 20;
            }
            ++n4;
        }
        object = this.getDimension();
        if (n3 < ((Dimension)object).width) {
            n3 = ((Dimension)object).width + 20;
        }
        if (n3 < (n = this.getLabelWidth())) {
            n3 = n + 20;
        }
        return n3;
    }

    int getNextLevelWidth() {
        int n = this.m_childNodes.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            GraphNode graphNode = (GraphNode)this.m_childNodes.elementAt(n3);
            if (n3 == 0 || n3 + 1 == n) {
                Dimension dimension = graphNode.getDimension();
                int n5 = dimension.width;
                int n6 = graphNode.getLabelWidth();
                if (n5 < n6) {
                    n5 = n6;
                }
                if (n == 1) {
                    return n5;
                }
                n4 = graphNode.getTotalWidth();
                if (n5 < n4) {
                    n4 -= (n4 - n5) / 2;
                }
            } else {
                n4 = graphNode.getTotalWidth();
            }
            n2 += n4;
            ++n3;
        }
        return n2;
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    public void drawChildren(IAdminProp iAdminProp, int n, NodePort nodePort) {
        IAdminProp[] iAdminPropArray = null;
        try {
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("drawChildren():  WAIT_CURSOR");
            }
            ((Component)((Object)this.m_parent)).setCursor(Cursor.getPredefinedCursor(3));
            AdminUtil.showSBMessage((Component)((Object)this.m_parent), ClientLang.getStrExpanding());
            iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273613880);
        }
        catch (PropertyException propertyException) {}
        if (NavigatorFrame.DEBUG_CURSOR) {
            System.out.println("drawChildren():  DEFAULT_CURSOR");
        }
        ((Component)((Object)this.m_parent)).setCursor(Cursor.getPredefinedCursor(0));
        if (iAdminPropArray == null || iAdminPropArray.length == 0) {
            nodePort.setColor(Color.blue);
            AdminUtil.showSBMessage((Component)((Object)this.m_parent), ClientLang.getStrNoChildren());
            return;
        }
        if (iAdminPropArray.length == 1) {
            AdminUtil.showSBMessage((Component)((Object)this.m_parent), ClientLang.getStr1Child());
        } else {
            AdminUtil.showSBMessage((Component)((Object)this.m_parent), iAdminPropArray.length + " " + ClientLang.getStrChildren());
        }
        Point point = this.getOrigin();
        Dimension dimension = this.getDimension();
        int n2 = 10;
        int n3 = 40;
        if (!nodePort.isExpanded()) {
            int n4;
            Object object;
            this.m_childNodes = new Vector();
            int n5 = point.x + dimension.width / 2;
            int n6 = point.y + dimension.height + n3;
            GraphNode[] graphNodeArray = new GraphNode[iAdminPropArray.length];
            int n7 = 0;
            while (n7 < iAdminPropArray.length) {
                graphNodeArray[n7] = new GraphNode(iAdminPropArray[n7], this.m_parent);
                GraphNode graphNode = graphNodeArray[n7];
                graphNode.setDimension(new Dimension(dimension.width, dimension.height));
                object = graphNode.getDimension();
                int n8 = ((Dimension)object).width;
                n4 = graphNode.getLabelWidth();
                if (n8 < n4) {
                    n8 = n4;
                }
                n5 = n7 + 1 == iAdminPropArray.length ? (n5 -= n8 / 2) : (n5 -= (n8 + n2) / 2);
                ++n7;
            }
            int n9 = 0;
            while (n9 < iAdminPropArray.length) {
                object = graphNodeArray[n9];
                Dimension dimension2 = ((GraphNode)object).getDimension();
                n4 = 0;
                int n10 = dimension2.width;
                int n11 = ((GraphNode)object).getLabelWidth();
                if (n10 < n11) {
                    n4 = (n11 - n10) / 2;
                    n10 = n11;
                }
                ((GraphNode)object).setOrigin(n5 + n4, n6);
                n5 += n10 + n2;
                this.m_parent.getNodes().addElement(object);
                this.m_childNodes.addElement(object);
                ++n9;
            }
            this.m_parent.doLayout();
        } else {
            int n12 = 0;
            while (n12 < this.m_childNodes.size()) {
                GraphNode graphNode = (GraphNode)this.m_childNodes.elementAt(n12);
                Vector vector = graphNode.getPorts();
                int n13 = 0;
                while (n13 < vector.size()) {
                    NodePort nodePort2 = (NodePort)vector.elementAt(n13);
                    if (nodePort2.getLines().size() != 0) {
                        graphNode.drawChildren(iAdminProp, n, nodePort2);
                    }
                    ++n13;
                }
                if (graphNode != null) {
                    this.m_parent.getNodes().removeElement(graphNode);
                }
                ++n12;
            }
            this.m_childNodes.removeAllElements();
            nodePort.removeLines();
        }
        nodePort.setState(!nodePort.isExpanded());
    }

    public Vector getChildren() {
        return this.m_childNodes;
    }

    int getLabelWidth() {
        if (this.m_label == null) {
            return 0;
        }
        return this.m_label.getWidth();
    }

    public NodeLabel getLabel() {
        return this.m_label;
    }

    public Object getProp(int n) {
        try {
            return this.m_prop.getProp(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point getOrigin() {
        return this.m_shape.getOrigin();
    }

    public Dimension getDimension() {
        return this.m_shape.getDimension();
    }

    public void setOrigin(Point point) {
        this.m_shape.setOrigin(point);
    }

    public void setDimension(Dimension dimension) {
        this.m_shape.setDimension(dimension);
    }

    public void setOrigin(int n, int n2) {
        this.m_shape.setOrigin(n, n2);
    }

    public void setDimension(int n, int n2) {
        this.m_shape.setDimension(n, n2);
    }

    public boolean isDraggable() {
        return this.m_shape.isDraggable();
    }

    public void drawLast(Graphics graphics) {
        this.m_shape.drawLast(graphics);
    }

    public void drawNext(Graphics graphics) {
        this.m_shape.drawNext(graphics);
    }

    class Nodeflasher
    extends Thread {
        boolean m_running = false;

        public Nodeflasher() {
            super("NodeFlasher");
            GraphNode.this = GraphNode.this;
        }

        public void start() {
            this.m_running = true;
            super.start();
        }

        public void stopme() {
            this.m_running = false;
            GraphNode.this.nf = null;
            super.stop();
        }

        public void run() {
            while (this.m_running) {
                GraphNode.this.flashOn = true;
                GraphNode.this.repaint();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                GraphNode.this.flashOn = false;
                GraphNode.this.repaint();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

