/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.ISetupToolbar;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;

class GridViewAdminProp
extends AdminPanel
implements GridViewItem,
ISetupToolbar,
AdminPropertyChangeListener {
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    Component m_comp;
    AdminButton m_button;
    GridViewItem m_gvi;
    Object m_initValue;
    Object m_rollbackValue;
    IEditor m_iEditor;
    IAdminProp m_subap;

    public GridViewAdminProp(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object) {
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        this.m_rollbackValue = this.m_initValue = object;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        Object object2 = null;
        if (object != null) {
            this.m_subap = (IAdminProp)object;
            object2 = EditorFactory.getEditor(this.m_subap, null, true);
            this.m_subap.addAdminPropertyChangeListener(this);
        }
        if (object2 != null) {
            ((Container)((Object)this)).add("Center", (Component)object2);
            object2 = AdminUtil.removeScrollBox(object2);
            if (object2 instanceof IEditor) {
                try {
                    this.m_iEditor = (IEditor)object2;
                }
                catch (Exception exception) {
                    AdminProp.sUnexpectedException(exception);
                }
            }
        } else {
            object2 = new AdminLabel("No editor. ServerObject=" + iAdminProp);
            ((Container)((Object)this)).add("Center", (Component)object2);
        }
        this.m_comp = object2;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (GridView.DEBUG) {
            System.out.println("m_comp = " + this.m_comp);
        }
        this.m_comp.setEnabled(bl);
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public Object getItemValue() {
        return this.m_initValue;
    }

    public void setItemValue(Object object) {
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        if (this.m_subap != null) {
            this.m_subap.removeAdminPropertyChangeListener(this);
            this.m_subap = null;
        }
        this.m_ap = (IAdminProp)object;
        Object object2 = null;
        try {
            object2 = this.m_ap.getProp(this.getPropId());
        }
        catch (Exception exception) {
            return false;
        }
        if (object2 != null) {
            this.m_subap = (IAdminProp)object2;
            this.m_subap.addAdminPropertyChangeListener(this);
        }
        if (this.m_iEditor != null && object2 != null && this.m_iEditor.setObject(object2)) {
            return true;
        }
        ((Container)((Object)this)).remove(this.m_comp);
        Object object3 = null;
        if (object2 != null) {
            object3 = EditorFactory.getEditor((IAdminProp)object2, null, true);
        }
        if (object3 != null) {
            ((Container)((Object)this)).add("Center", (Component)object3);
            object3 = AdminUtil.removeScrollBox(object3);
            if (object3 instanceof IEditor) {
                try {
                    this.m_iEditor = (IEditor)object3;
                }
                catch (Exception exception) {
                    AdminProp.sUnexpectedException(exception);
                }
            }
        } else {
            object3 = new AdminLabel("No editor");
            ((Container)((Object)this)).add("Center", (Component)object3);
        }
        this.m_comp = object3;
        return true;
    }

    public boolean isModified(StringBuffer stringBuffer) {
        if (this.m_iEditor != null) {
            return this.m_iEditor.isModified(stringBuffer);
        }
        return false;
    }

    public void setupToolbar(int n) {
        if (this.m_iEditor != null) {
            this.m_iEditor.setupToolbar(n);
        }
    }

    public void revert() {
        if (this.m_iEditor != null) {
            this.m_iEditor.revert();
        }
    }

    public void commit() {
        if (this.m_iEditor != null) {
            this.m_iEditor.commit();
        }
    }

    public void update() {
        if (this.m_iEditor != null) {
            this.m_iEditor.update();
        }
    }

    public void shutdown() {
        if (this.m_iEditor != null) {
            this.m_iEditor.shutdown();
        }
        if (this.m_subap != null) {
            this.m_subap.removeAdminPropertyChangeListener(this);
            this.m_subap = null;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            if (AdminProp.getPropNumber(adminPropertyChangeEvent.getPropId()) < 12288) {
                AdminUtil.fixup((Component)((Object)this.m_parent));
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }
}

