/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.ldap.admin.client.common.AdminDateEditor;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewDate
extends AdminDateEditor
implements GridViewItem,
ActionListener,
FocusListener {
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    Object m_initValue;
    Object m_rollbackValue;
    boolean m_isReadOnly;
    static DateFormat df = DateFormat.getDateTimeInstance(1, 1);

    public GridViewDate(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object) {
        super((Date)(object == null ? (object = new Date()) : ((Calendar)object).getTime()), Calendar.getInstance(), df);
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        this.m_isReadOnly = bl;
        this.setEnabled(!bl);
        this.m_rollbackValue = this.m_initValue = object;
        if (this.m_parent.isSyncProp(n)) {
            ((Component)((Object)this)).addFocusListener(this);
        }
    }

    public void setItemValue(Object object) {
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public Object getItemValue() {
        try {
            return this.getCalendar();
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return this.m_initValue;
        }
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public boolean isModified(StringBuffer stringBuffer) {
        if (this.m_isReadOnly) {
            return false;
        }
        Object object = this.m_initValue;
        if (this.m_parent.isSyncProp(this.m_propId)) {
            object = this.m_rollbackValue;
        }
        if (GridView.DEBUG) {
            System.out.println("Old Value is :" + this.m_initValue.toString() + ":");
            System.out.println("New Value is :" + this.getItemValue().toString() + ":");
        }
        if (object != null) {
            return !this.getItemValue().equals(object);
        }
        return false;
    }

    public void revert() {
        if (this.m_initValue != null) {
            this.setDate(((Calendar)this.m_initValue).getTime());
            return;
        }
        this.setDate(new Date());
    }

    public void update() {
        try {
            this.m_initValue = this.m_ap.getProp(this.getPropId());
            this.revert();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void commit() {
        this.m_rollbackValue = this.m_initValue = this.getItemValue();
    }

    public void shutdown() {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.isModified(null)) {
            try {
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.m_propId;
                objectArray[0] = this.getItemValue();
                this.m_parent.setModified(this.m_propId);
                this.m_ap.setProps(nArray, objectArray);
                return;
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_parent.actionPerformed(null);
    }
}

