/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import oracle.ldap.admin.client.propEditors.AWTList;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewList
extends AWTList
implements GridViewItem,
ItemListener {
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    Object m_initValue;
    Object m_rollbackValue;
    boolean m_noCacheProps = false;
    boolean m_minListHeight = false;

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public GridViewList(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object) {
        super(gridView.getPropHeight(n, 4));
        this.m_ap = iAdminProp;
        this.m_parent = gridView;
        this.m_propId = n;
        this.init(object);
        this.m_rollbackValue = this.m_initValue;
        int n2 = this.m_parent.getStatus();
        if (this.m_parent.isSyncProp(n)) {
            this.m_noCacheProps = true;
            this.addItemListener(this);
        }
        if ((n2 & 0x8000) != 0) {
            this.m_minListHeight = true;
            this.adjustToPrefectRows();
        }
        this.setEnabled(!bl);
    }

    public boolean adjustToPrefectRows() {
        int n = this.getItemCount();
        if (n < 4 || n == 4 && this.getRows() < 4) {
            int n2 = n = n == 0 ? 1 : n;
            if (n != this.getRows()) {
                this.setRows(n == 0 ? 1 : n);
                return true;
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (this.m_minListHeight) {
            if (keyEvent.getKeyCode() == 10) {
                if (this.adjustToPrefectRows() && this.getRows() > 0) {
                    super.keyPressed(keyEvent);
                    return;
                }
            } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                this.adjustToPrefectRows();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (GridView.DEBUG) {
            System.out.println("itemStateChanged =" + itemEvent);
        }
        if (this.isModified(null)) {
            try {
                if (this.m_noCacheProps) {
                    int[] nArray = new int[1];
                    Object[] objectArray = new Object[1];
                    nArray[0] = this.m_propId;
                    objectArray[0] = this.getItemValue();
                    if (GridView.DEBUG) {
                        Object[] objectArray2 = (Object[])objectArray[0];
                        if (objectArray2 == null) {
                            System.out.println("null value");
                        } else {
                            System.out.println("-----------------");
                            int n = 0;
                            while (n < objectArray2.length) {
                                System.out.println(objectArray2[n].toString());
                                ++n;
                            }
                            System.out.println("+++++++++++++++++");
                        }
                    }
                    this.m_parent.setModified(this.m_propId);
                    this.m_ap.setProps(nArray, objectArray);
                    return;
                }
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
                return;
            }
        }
    }

    void init(Object object) {
        block11: {
            this.m_initValue = object;
            try {
                Object object2 = this.m_ap.getProp(this.m_propId);
                if (AdminProp.getPropType(this.m_propId) == 0x10C00000) {
                    int[] nArray = (int[])object2;
                    if (nArray != null) {
                        int n = 0;
                        while (n < nArray.length) {
                            this.add(String.valueOf(nArray[n]));
                            ++n;
                        }
                        return;
                    }
                } else {
                    Object[] objectArray = (Object[])object2;
                    if (objectArray != null) {
                        int n = 0;
                        while (n < objectArray.length) {
                            if (objectArray[n] != null) {
                                this.add(objectArray[n].toString());
                            } else if (GridView.DEBUG) {
                                System.out.println("GridViewList.init() i=" + n + " objs[i]==null");
                                System.out.println("m_ap=" + this.m_ap.getClass().getName() + " propName=" + this.m_ap.getPropName(this.m_propId));
                            }
                            ++n;
                        }
                    }
                    break block11;
                }
                return;
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
        }
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public void setItemValue(Object object) {
    }

    public Object getItemValue() {
        String[] stringArray = this.getItems();
        switch (AdminProp.getPropType(this.m_propId)) {
            case 0x10C00000: {
                int[] nArray = new int[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                    ++n;
                }
                return nArray;
            }
            case 0x10200000: {
                Integer[] integerArray = new Integer[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    integerArray[n] = Integer.valueOf(stringArray[n]);
                    ++n;
                }
                return integerArray;
            }
            case 0x10500000: {
                Double[] doubleArray = new Double[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    doubleArray[n] = Double.valueOf(stringArray[n]);
                    ++n;
                }
                return doubleArray;
            }
            case 0x10100000: {
                if (stringArray != null) {
                    int n = 0;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2] != null) {
                            if (this.m_parent.isTrimMode()) {
                                stringArray[n2] = stringArray[n2].trim();
                            }
                            if (!stringArray[n2].trim().equals("")) {
                                ++n;
                            }
                        }
                        ++n2;
                    }
                    if (n != stringArray.length && this.m_parent.isRemoveBlankMode()) {
                        String[] stringArray2 = new String[n];
                        n = 0;
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            String string;
                            if (stringArray[n2] != null && !(string = stringArray[n2]).trim().equals("")) {
                                stringArray2[n++] = string;
                            }
                            ++n2;
                        }
                        stringArray = stringArray2;
                    }
                }
                return stringArray;
            }
        }
        System.out.println("Unsupported GridViewList::getItemValue");
        return this.m_initValue;
    }

    public void shutdown() {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Object object = this.m_initValue;
        if (this.m_parent.isSyncProp(this.m_propId)) {
            object = this.m_rollbackValue;
        }
        if (object == null) {
            if (GridView.DEBUG) {
                System.out.println("diff if (getItemCount = " + this.getItemCount() + " != 0)");
            }
            return this.getItemCount() != 0;
        }
        if (AdminProp.getPropType(this.m_propId) == 0x10C00000) {
            int[] nArray = (int[])object;
            int[] nArray2 = (int[])this.getItemValue();
            if (nArray.length != nArray2.length) {
                return true;
            }
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != nArray2[n]) {
                    return true;
                }
                ++n;
            }
        } else {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])this.getItemValue();
            if (objectArray == objectArray2) {
                return false;
            }
            if (objectArray.length != objectArray2.length) {
                if (GridView.DEBUG) {
                    System.out.println("diff objs.length =" + objectArray.length);
                }
                if (GridView.DEBUG) {
                    System.out.println("     nobjs.length =" + objectArray2.length);
                }
                return true;
            }
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (object2 == null) {
                    if (GridView.DEBUG) {
                        System.out.println("diff " + n + " objs =" + objectArray[n] + "/");
                    }
                    if (GridView.DEBUG) {
                        System.out.println("     " + n + " nobjs =" + objectArray2[n] + "/");
                    }
                    return true;
                }
                if (object2 instanceof String) {
                    object2 = ((String)object2).trim();
                }
                if (!object2.equals(objectArray2[n])) {
                    if (GridView.DEBUG) {
                        System.out.println("diff " + n + " objs =" + objectArray[n] + "/");
                    }
                    if (GridView.DEBUG) {
                        System.out.println("     " + n + " nobjs =" + objectArray2[n] + "/");
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void revert() {
        this.removeAllItems();
        this.init(this.m_initValue);
    }

    public void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exeception " + exception);
    }

    public void update() {
        try {
            Object object = this.m_ap.getProp(this.getPropId());
            Object object2 = this.getItemValue();
            if (object != null && object2 != null) {
                if (GridView.DEBUG) {
                    System.out.println("checking if value is new");
                }
                if (AdminProp.getPropType(this.getPropId()) == 0x10C00000) {
                    int[] nArray = (int[])object2;
                    int[] nArray2 = (int[])object;
                    if (nArray.length == nArray2.length) {
                        int n = 0;
                        while (n < nArray2.length) {
                            if (nArray[n] != nArray2[n]) break;
                            ++n;
                        }
                        if (n == nArray2.length) {
                            return;
                        }
                    }
                } else {
                    Object[] objectArray = (Object[])object2;
                    Object[] objectArray2 = (Object[])object;
                    if (objectArray.length == objectArray2.length) {
                        int n = 0;
                        while (n < objectArray2.length) {
                            if (GridView.DEBUG) {
                                System.out.println("old='" + objectArray[n] + "'");
                                System.out.println("new='" + objectArray2[n] + "'");
                            }
                            if (!objectArray[n].equals(objectArray2[n])) {
                                if (!GridView.DEBUG) break;
                                System.out.println("not equal");
                                break;
                            }
                            ++n;
                        }
                        if (n == objectArray2.length) {
                            return;
                        }
                    } else if (GridView.DEBUG) {
                        System.out.println("Lengths don't match");
                        System.out.println("old='" + objectArray.length + "'");
                        System.out.println("new='" + objectArray2.length + "'");
                    }
                }
            } else if (GridView.DEBUG) {
                System.out.println("One value is null");
                System.out.println("old='" + (object2 == null ? "null" : "not null") + "'");
                System.out.println("new='" + (object == null ? "null" : "not null") + "'");
            }
            this.m_initValue = object;
            this.revert();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void commit() {
        this.m_rollbackValue = this.m_initValue = this.getItemValue();
    }

    public void internalAdd(String string) {
        this.add(string);
        if (this.m_parent.isSyncProp(this.m_propId)) {
            this.itemStateChanged(null);
        }
    }
}

